REM CommandInterpreter: $(COMSPEC)
@echo off

rem ------------------------------
rem copy *.jars

if not exist ..\source\java\lib mkdir ..\source\java\lib

copy ..\..\mysql-gui-win-res\lib\java\*.jar ..\source\java\lib\
copy ..\res\java\*.jar ..\source\java\lib\

rem ------------------------------
rem create java code from GRT structs

echo Cleaning up previouse builds...
rmdir /s /q ..\source\java\com\mysql\grt\base
rmdir /s /q ..\source\java\com\mysql\grt\canvas
rmdir /s /q ..\source\java\com\mysql\grt\db
rmdir /s /q ..\source\java\com\mysql\grt\forms
rmdir /s /q ..\source\java\com\mysql\grt\model

echo Processing base ...
..\bin\windows\grtsh -j ..\res\grt\structs.base.xml ..\source\java\com\mysql\grt\base\
if errorlevel 1 goto errorOccured

echo Processing canvas ...
..\bin\windows\grtsh -j ..\res\grt\structs.canvas.xml ..\source\java\com\mysql\grt\canvas\
if errorlevel 1 goto errorOccured

echo Processing db ...
..\bin\windows\grtsh -j ..\res\grt\structs.db.xml ..\source\java\com\mysql\grt\db\
if errorlevel 1 goto errorOccured

echo Processing db.mysql ...
..\bin\windows\grtsh -j ..\res\grt\structs.db.mysql.xml ..\source\java\com\mysql\grt\db\mysql\
if errorlevel 1 goto errorOccured

echo Processing forms ...
..\bin\windows\grtsh -j ..\res\grt\structs.forms.xml ..\source\java\com\mysql\grt\forms\
if errorlevel 1 goto errorOccured

echo Processing db.mgmt ...
..\bin\windows\grtsh -j ..\res\grt\structs.db.mgmt.xml ..\source\java\com\mysql\grt\db\mgmt\
if errorlevel 1 goto errorOccured

echo Processing db.migration ...
..\bin\windows\grtsh -j ..\res\grt\structs.db.migration.xml ..\source\java\com\mysql\grt\db\migration\
if errorlevel 1 goto errorOccured

echo Processing db.oracle ...
..\bin\windows\grtsh -j ..\res\grt\structs.db.oracle.xml ..\source\java\com\mysql\grt\db\oracle\
if errorlevel 1 goto errorOccured

echo Processing db.mssql ...
..\bin\windows\grtsh -j ..\res\grt\structs.db.mssql.xml ..\source\java\com\mysql\grt\db\mssql\
if errorlevel 1 goto errorOccured

echo Processing db.maxdb ...
..\bin\windows\grtsh -j ..\res\grt\structs.db.maxdb.xml ..\source\java\com\mysql\grt\db\maxdb\
if errorlevel 1 goto errorOccured

echo Processing db.query ...
..\bin\windows\grtsh -j ..\res\grt\structs.db.query.xml ..\source\java\com\mysql\grt\db\query\
if errorlevel 1 goto errorOccured

echo Processing model ...
..\bin\windows\grtsh -j ..\res\grt\structs.model.xml ..\source\java\com\mysql\grt\model\
if errorlevel 1 goto errorOccured

echo Processing workbench ...
..\bin\windows\grtsh -j ..\res\grt\structs.db.workbench.xml ..\source\java\com\mysql\grt\db\workbench\
if errorlevel 1 goto errorOccured

goto endOfScript

:errorOccured
echo An Error occured!
pause

:endOfScript
echo .
