/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.PartNotFound;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.translators.ABAPStreamDescriptor;
import com.sap.dbtech.jdbc.translators.ABAPStreamTranslator;
import com.sap.dbtech.jdbc.translators.ConversionExceptionSapDB;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public abstract class AbstractABAPStreamGetval
extends ABAPStreamDescriptor {
    private Vector replyBuffers = new Vector();
    protected int elementCount = 0;
    protected StructuredBytes data;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public AbstractABAPStreamGetval(ABAPStreamTranslator aBAPStreamTranslator) {
        super(aBAPStreamTranslator);
    }

    public boolean addReplyData(ReplyPacket replyPacket) throws SQLException {
        try {
            replyPacket.findPart(5);
        }
        catch (PartNotFound partNotFound) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.nodata"));
        }
        int n = replyPacket.partArguments();
        if (n < 0) {
            int n2 = n & Short.MAX_VALUE;
            n = n2 += 32768;
        }
        this.elementCount += n;
        if (n != 0) {
            this.replyBuffers.add(replyPacket.getBytes(replyPacket.getPartDataPos(), replyPacket.partLength()));
        }
        return n == 0;
    }

    public void coalesceReply() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.replyBuffers.size(); ++n) {
            n2 += ((byte[])this.replyBuffers.elementAt(n)).length;
        }
        this.data = new StructuredBytes(n2);
        n = 0;
        for (int i = 0; i < this.replyBuffers.size(); ++i) {
            byte[] byArray = (byte[])this.replyBuffers.elementAt(i);
            System.arraycopy(byArray, 0, this.data.bytes(), n, byArray.length);
            n += byArray.length;
        }
        this.replyBuffers = null;
    }

    public int getColIndex() {
        return this.translator.getColIndex();
    }

    public void throwIllegalConversion(String string) throws SQLException {
        throw new ConversionExceptionSapDB(MessageTranslator.translate("error.conversion.sqljava", this.translator.getColumnTypeName(), string));
    }

    public String getString() throws SQLException {
        this.throwIllegalConversion((class$java$lang$String == null ? (class$java$lang$String = AbstractABAPStreamGetval.class$("java.lang.String")) : class$java$lang$String).getName());
        return null;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.throwIllegalConversion((class$java$io$InputStream == null ? (class$java$io$InputStream = AbstractABAPStreamGetval.class$("java.io.InputStream")) : class$java$io$InputStream).getName());
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.throwIllegalConversion((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = AbstractABAPStreamGetval.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName());
        return null;
    }

    public BigDecimal getBigDecimal() throws SQLException {
        this.throwIllegalConversion((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = AbstractABAPStreamGetval.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName());
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.throwIllegalConversion((class$java$io$InputStream == null ? (class$java$io$InputStream = AbstractABAPStreamGetval.class$("java.io.InputStream")) : class$java$io$InputStream).getName());
        return null;
    }

    public Blob getBlob() throws SQLException {
        this.throwIllegalConversion((class$java$sql$Blob == null ? (class$java$sql$Blob = AbstractABAPStreamGetval.class$("java.sql.Blob")) : class$java$sql$Blob).getName());
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.throwIllegalConversion("boolean");
        return false;
    }

    public byte getByte() throws SQLException {
        this.throwIllegalConversion("byte");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        this.throwIllegalConversion("byte[]");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        this.throwIllegalConversion((class$java$sql$Date == null ? (class$java$sql$Date = AbstractABAPStreamGetval.class$("java.sql.Date")) : class$java$sql$Date).getName());
        return null;
    }

    public double getDouble() throws SQLException {
        this.throwIllegalConversion("double");
        return 0.0;
    }

    public Reader getCharacterStream() throws SQLException {
        this.throwIllegalConversion((class$java$io$Reader == null ? (class$java$io$Reader = AbstractABAPStreamGetval.class$("java.io.Reader")) : class$java$io$Reader).getName());
        return null;
    }

    public Clob getClob() throws SQLException {
        this.throwIllegalConversion((class$java$sql$Clob == null ? (class$java$sql$Clob = AbstractABAPStreamGetval.class$("java.sql.Clob")) : class$java$sql$Clob).getName());
        return null;
    }

    public float getFloat() throws SQLException {
        this.throwIllegalConversion("float");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        this.throwIllegalConversion("int");
        return 0;
    }

    public long getLong() throws SQLException {
        this.throwIllegalConversion("long");
        return 0L;
    }

    public Object getObject() throws SQLException {
        this.throwIllegalConversion((class$java$lang$Object == null ? (class$java$lang$Object = AbstractABAPStreamGetval.class$("java.lang.Object")) : class$java$lang$Object).getName());
        return null;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        this.throwIllegalConversion((class$java$sql$Time == null ? (class$java$sql$Time = AbstractABAPStreamGetval.class$("java.sql.Time")) : class$java$sql$Time).getName());
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.throwIllegalConversion((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = AbstractABAPStreamGetval.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName());
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

