//
//  MWSynchronizeDB.h
//  MySQL Workbench
//
//  Created by Alfredo Kojima on 05/8/30.
//  Copyright 2005, 2006 MySQL AB. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MySQLGRT/MGRT.h>
#import <MySQLGRT/MGRTConnectionPanel.h>
#import <MySQLToolsCommon/MSourceTextEditor.h>

@class MVerticalBox;

@interface MWSynchronizeDB : NSWindowController
{
  IBOutlet NSButton *nextButton;
  IBOutlet NSButton *backButton;
  IBOutlet NSButton *cancelButton;
  IBOutlet NSButton *detailsButton;
  IBOutlet NSTabView *tabView;
  IBOutlet NSTextField *caption;
  IBOutlet NSTextField *description;
  IBOutlet NSImageView *sakila;
  
  IBOutlet NSBox *rdbmsBox;
  IBOutlet NSBox *paramBox;
  IBOutlet NSBox *advParamBox;
  
  IBOutlet NSTextView *logText;
  
  IBOutlet NSImageView *connImage;
  IBOutlet NSImageView *schemaListImage;
  IBOutlet NSTextField *fetchSchemaResult;
  IBOutlet NSBox *fetchSchemaAdvBox;
  
  IBOutlet NSTableView *schemaSelectionList;
  
  IBOutlet NSImageView *revEngImage;
  IBOutlet NSImageView *getChangesImage;
  IBOutlet NSTextField *revEngResult;
  IBOutlet NSBox *revEngAdvBox;
  
  IBOutlet NSOutlineView *syncTree;
  
  IBOutlet MSourceTextEditor *scriptEditor;
  
  IBOutlet NSImageView *finRevEngImage;
  IBOutlet NSImageView *finAddImage;
  IBOutlet NSImageView *finPlaceImage;
  IBOutlet NSTextField *finResult;
  IBOutlet NSBox *finAdvBox;
  
  NSImage *_taskUnchecked;
  NSImage *_taskChecked;
  NSImage *_taskError;
  NSImage *_taskDisabled;
  
  NSImage *_tableIcon;
  NSImage *_viewIcon;
  NSImage *_schemaIcon;
  NSImage *_routineIcon;
 
  MGRT *_grt;
  MGRTConnectionPanel *_connPanel;
  
  MGRTValue *_schemaList;
  MGRTValue *_catalog;
  MGRTValue *_changesTree;
  
  NSMutableArray *_schemaListObjects;
  
  NSMutableDictionary *_syncObjects;

  int _section;
  
  BOOL _advancedShown;
  
  BOOL _backWasEnabled;
  BOOL _nextWasEnabled;
}


- (IBAction)goBack:(id)sender;
- (IBAction)goNext:(id)sender;
- (IBAction)cancel:(id)sender;
- (IBAction)showDetails:(id)sender;


- (id)initWithMGRT:(MGRT*)grt;

- (BOOL)run;

@end
