/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.ObjectIsClosedException;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;

abstract class ConnectionItem {
    protected ConnectionSapDB connection;
    protected SQLWarning warningList;

    public ConnectionItem(ConnectionSapDB connectionSapDB) {
        this.connection = connectionSapDB;
        this.warningList = null;
    }

    public final void addWarning(SQLWarning sQLWarning) {
        if (this.warningList == null) {
            this.warningList = sQLWarning;
        } else {
            this.warningList.setNextWarning(sQLWarning);
        }
    }

    protected final void assertOpen() throws SQLExceptionSapDB {
        if (this.connection == null || this.connection.session == null) {
            throw new ObjectIsClosedException(this);
        }
    }

    public final void clearWarnings() throws SQLException {
        this.warningList = null;
    }

    public final void closeDummy() throws SQLException {
    }

    public final Connection getConnection() throws SQLException {
        return this.connection;
    }

    public final ConnectionSapDB getConnectionSapDB() {
        return this.connection;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.warningList;
    }

    protected final void throwNotSupported(String string) throws JDBCDriverException {
        throw new JDBCDriverException(string, this);
    }
}

