unit ReverseEngineering;

interface

uses
  GnuGetText, Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs,  TntForms, ExtCtrls, StdCtrls, TntStdCtrls,
  ComCtrls, TntComCtrls, TntExtCtrls,
  myx_public_interface, myx_grt_public_interface,
  MyxBaseForm, MyxConnectionDialog,
  PngImage, PngTools, Grt, ImgList, AdvancedEdit,
  MigrationObjSelFilter, MigrationObjMapDetail, AuxFuncs;

type
  TReverseEngineeringForm = class(TMyxBaseForm)
    MainPageControl: TTntPageControl;
    ConnectionSheet: TTntTabSheet;
    ConnParamGBox: TTntGroupBox;
    JdbcDriverDescLbl: TTntLabel;
    DriverParamHeaderLbl: TTntLabel;
    SourceTargetDBConnImg: TTntImage;
    ParamSBox: TTntScrollBox;
    DBConnAdvancedSettingsGBox: TTntGroupBox;
    AdvParamSBox: TTntScrollBox;
    SchemataSheet: TTntTabSheet;
    FinalizeSheet: TTntTabSheet;
    BottomPnl: TTntPanel;
    NextBtn: TTntButton;
    BackBtn: TTntButton;
    CancelBtn: TTntButton;
    HeaderPanel: TTntPanel;
    TntShape1: TTntShape;
    PageTitleLbl: TTntLabel;
    PageDescLbl: TTntLabel;
    GetSchemataSheet: TTntTabSheet;
    TntGroupBox1: TTntGroupBox;
    TntBevel1: TTntBevel;
    TntLabel3: TTntLabel;
    TntLabel7: TTntLabel;
    ConnImg: TTntImage;
    TntLabel8: TTntLabel;
    SchemaListImg: TTntImage;
    TntLabel4: TTntLabel;
    ResultLbl: TTntLabel;
    ProgressLbl: TTntLabel;
    AdvancedBtn: TTntButton;
    MessageLogGBox: TTntGroupBox;
    GRTMessageMemo: TTntMemo;
    RdbmsDriverGBox: TTntGroupBox;
    TntBevel2: TTntBevel;
    AnimPnl: TTntPanel;
    AnimStillImg: TTntImage;
    BusyAnimate: TAnimate;
    Shape1: TTntShape;
    TntGroupBox5: TTntGroupBox;
    SchemaSelectionCountLbl: TTntLabel;
    SchemaListView: TTntListView;
    SchemaSearchEd: TAdvancedEditFrame;
    ShowSchemataAsListCBox: TTntCheckBox;
    SmallSchemaListViewImgList: TImageList;
    SchemaListViewImgList: TImageList;
    RevEngSheet: TTntTabSheet;
    TntGroupBox2: TTntGroupBox;
    TntLabel5: TTntLabel;
    TntLabel6: TTntLabel;
    RevEngImg: TTntImage;
    TntLabel9: TTntLabel;
    CheckResImg: TTntImage;
    TntLabel10: TTntLabel;
    Result2Lbl: TTntLabel;
    Progress2Lbl: TTntLabel;
    RevEngMsgLogGBox: TTntGroupBox;
    GRTMessage2Memo: TTntMemo;
    IgnoreListSheet: TTntTabSheet;
    ObjSelScrollBox: TTntScrollBox;
    TntGroupBox4: TTntGroupBox;
    TntLabel15: TTntLabel;
    TntLabel16: TTntLabel;
    MigrationObjMappingSheet: TTntTabSheet;
    DefaultFramesScrollBox: TTntScrollBox;
    TntLabel11: TTntLabel;
    TntImage2: TTntImage;
    PlaceObjectsLbl: TTntLabel;
    PlaceObjectsImg: TTntImage;
    TntImage4: TTntImage;
    TntLabel1: TTntLabel;
    MigrationImg: TTntImage;
    MigrationLbl: TTntLabel;
    AddObjectsImg: TTntImage;
    AddObjectsLbl: TTntLabel;
    MessageLogFinalizeGBox: TTntGroupBox;
    GRTMessage3Memo: TTntMemo;
    ResultFinalizeLbl: TTntLabel;
    Progress3Lbl: TTntLabel;
    PlacementSheet: TTntTabSheet;
    TntGroupBox3: TTntGroupBox;
    TntLabel2: TTntLabel;
    TntLabel12: TTntLabel;
    PlaceAlgoComboBox: TTntComboBox;
    PlaceAlgoLbl: TTntLabel;
    PlaceAreaLbl: TTntLabel;
    PlaceAreaComboBox: TTntComboBox;
    PlaceSpaceLbl: TTntLabel;
    PlaceSpaceComboBox: TTntComboBox;
    MigrationSelectionSheet: TTntTabSheet;
    TntGroupBox6: TTntGroupBox;
    TntLabel13: TTntLabel;
    TntLabel14: TTntLabel;
    MigrationDetailsRBtn: TTntRadioButton;
    MigrationSwitchRBtn: TTntRadioButton;
    GetMigMethodsImg: TTntImage;
    ObjectsLbl: TTntLabel;
    MigrationSheet: TTntTabSheet;
    MigGBox: TTntGroupBox;
    MigTaskHeaderLbl: TTntLabel;
    MigTaskLbl: TTntLabel;
    MigrateImg: TTntImage;
    MigExecLbl: TTntLabel;
    Progress4Lbl: TTntLabel;
    GrtProgressLbl: TTntLabel;
    Result4Lbl: TTntLabel;
    GrtProgressBar: TTntProgressBar;
    MigrationGBox: TTntGroupBox;
    GRTMessage4Memo: TTntMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

    procedure NextBtnClick(Sender: TObject);
    procedure BackBtnClick(Sender: TObject);
    procedure AdvancedBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure SchemaSearchEdSearchEdChange(Sender: TObject);
    procedure ShowSchemataAsListCBoxClick(Sender: TObject);
    procedure SchemaListViewClick(Sender: TObject);
    procedure SchemaListViewSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure FormResize(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PlaceAlgoComboBoxCloseUp(Sender: TObject);
    procedure SchemaListViewDblClick(Sender: TObject);
  private
    FMyxConnDlgForm: TMyxConnectionDialogForm;

    FCancelOperation: Boolean;

    FConnection,
    FSchemaList,
    FCatalog: Pointer;

    FBackBtnEnabled,
    FNextBtnEnabled: Boolean;

    FTaskUncheckedPNGImg,
    FTaskCheckedPNGImg,
    FTaskErrorPNGImg,
    FTaskDisabledPNGImg: TPngObject;

    FNormalHeight,
    FAdvancedHeight: Integer;

    FFilterFrames: TList;

    // Task management
    FFetchSchemaTask: IGrtTask;
    FReverseEngineerTask: IGrtTask;
    FGetMigrationMethodsTask: IGrtTask;
    FSelectedSchemaList: Pointer;
    FProcessCatalogsTask: IGrtTask;
    FArrangeTask: IGrtTask;
    FMigrationTask: IGrtTask;

    DefaultFrames: TList;

    FMigration: Boolean;
  protected
    procedure UpdateAdvancedBtnState;
    procedure UpdateSchemaSelectionCountLbl;
    procedure UpdatePageHeader;

    procedure DoFetchSchemaNames;
    procedure DoDisplaySchemata;
    procedure DoRevEng;
    procedure DoBuildObjectSelection;
    procedure DoFinalizeRevEng;
    procedure DoDisplayObjMappingDefaults;
    procedure DoBuildObjMapping;
    procedure DoMigration;

    procedure ProcessGrtOutput(Text: WideString);
    procedure ProcessGrtMessages(Messages: TMYX_GRT_MSGS);
    function ProcessStatusQuery: Integer;

    procedure RefreshSchemaListView(SearchStr: WideString = '');

    procedure DoProcessStart;
    procedure DoProcessEnd;

    function AdvancedSectionsVisible: Boolean;

    function PerformGrtInput(Description: WideString): WideString;

    procedure TaskFinished(Task: IGrtGenericTask);
    function TaskHandleError(Task: IGrtGenericTask): Boolean;
  public
  end;

implementation

{$R *.dfm}

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.FormCreate(Sender: TObject);

var
  Migration: Pointer;

begin
  FSchemaList := nil;
  FCatalog := nil;

  FormStyle := fsStayOnTop;

  FNormalHeight := 512 + 80;
  FAdvancedHeight := 686 + 80;

  LoadPNGImageFromResource('sakila', AnimStillImg, True);
  BusyAnimate.ResName:='dolphin_loop';

  LoadPNGImageFromResource('source_dbconn', SourceTargetDBConnImg, True);

  FTaskUncheckedPNGImg := LoadPNGImageFromResource('task_unchecked');
  FTaskCheckedPNGImg := LoadPNGImageFromResource('task_checked');
  FTaskErrorPNGImg := LoadPNGImageFromResource('task_error');
  FTaskDisabledPNGImg := LoadPNGImageFromResource('task_disabled');

  FCancelOperation := False;

  FFilterFrames := TList.Create;

  MainPageControl.ActivePage := ConnectionSheet;

  // Dock connection form
  FMyxConnDlgForm := TMyxConnectionDialogForm.Create(nil);

  FMyxConnDlgForm.ConnInfoPath := '/rdbmsMgmt';
  FMyxConnDlgForm.ConnTargetPath :='/workbench/connection';

  FMyxConnDlgForm.DisplayRdbmsSelection := True;
  FMyxConnDlgForm.DisplaySchemaSelection := False;
  FMyxConnDlgForm.DisplayDescriptions := True;

  FMyxConnDlgForm.ConnTypePnl.Parent := RdbmsDriverGBox;
  FMyxConnDlgForm.ConnTypePnl.Left := 28;
  FMyxConnDlgForm.ConnTypePnl.Width := RdbmsDriverGBox.Width - 40;

  FMyxConnDlgForm.StoredConnPnl.Parent := ParamSBox;
  FMyxConnDlgForm.StoredConnPnl.Top := 0;

  FMyxConnDlgForm.ParamsPnl.Parent := ParamSBox;
  FMyxConnDlgForm.ParamsPnl.Top := FMyxConnDlgForm.StoredConnPnl.Height;
  FMyxConnDlgForm.ParamsPnl.Width := ParamSBox.Width - 20;

  FMyxConnDlgForm.AdvParamPnl.Parent := AdvParamSBox;
  FMyxConnDlgForm.AdvParamPnl.Top := 0;
  FMyxConnDlgForm.AdvParamPnl.Width := AdvParamSBox.Width - 30;

  FMyxConnDlgForm.DriverNotInstalledPnl.Parent := ParamSBox;
  FMyxConnDlgForm.DriverNotInstalledPnl.Top := 0;

  FMyxConnDlgForm.OkButton := NextBtn;

  FMyxConnDlgForm.RefreshConnInfo;

  FMyxConnDlgForm.SelectedRdbms := 'Mysql';

  Height := FNormalHeight;

  // Create migration object and add it to the globals tree
  Migration := Grt.ObjectNew('db.migration.Migration',
    'Migration', '', '');
  Grt.Global['/migration'] := Migration;
  Grt.ValueRelease(Migration);

  PlaceAlgoComboBox.ItemIndex := 1;
  PlaceAreaComboBox.ItemIndex := 1;
  PlaceSpaceComboBox.ItemIndex := 1;

  DefaultFrames := TList.Create;

  FMigration := False;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.FormDestroy(Sender: TObject);

begin
  FTaskUncheckedPNGImg.Free;
  FTaskCheckedPNGImg.Free;
  FTaskErrorPNGImg.Free;
  FTaskDisabledPNGImg.Free;

  FFilterFrames.Free;

  DefaultFrames.Free;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Grt.GlobalDel('/', 'migration');

  if (FSchemaList <> nil) then
    Grt.ValueRelease(FSchemaList);

  if (FCatalog <> nil) then
    Grt.ValueRelease(FCatalog);
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.NextBtnClick(Sender: TObject);

begin
  BackBtn.Enabled := True;

  if (MainPageControl.ActivePage = ConnectionSheet) then
    DoFetchSchemaNames
  else
    if (MainPageControl.ActivePage = GetSchemataSheet) then
      DoDisplaySchemata
    else
      if (MainPageControl.ActivePage = SchemataSheet) then
        DoRevEng
      else
        if (MainPageControl.ActivePage = RevEngSheet) then
          MainPageControl.ActivePage := IgnoreListSheet
        else
          if (MainPageControl.ActivePage = IgnoreListSheet) then
          begin
            // check if the reverse engineered catalog
            // is the same as the wb catalog
            // if not, migrate
            if (Grt.StructIsOrInheritsFrom(
                Grt.DictStructName[
                  Grt.Global['/migration/sourceCatalog']],
                Grt.DictStructName[
                  Grt.Global['/workbench/catalog']])) then
              MainPageControl.ActivePage := PlacementSheet
            else
            begin
              FMigration := True;
              //MainPageControl.ActivePage := MigrationSelectionSheet;
              DoDisplayObjMappingDefaults;
            end;
          end
          else
            if (MainPageControl.ActivePage = MigrationSelectionSheet) then
            begin
              if (MigrationDetailsRBtn.Checked) then
                DoDisplayObjMappingDefaults;
            end
            else
              if (MainPageControl.ActivePage = MigrationObjMappingSheet) then
                DoBuildObjMapping
              else
                if (MainPageControl.ActivePage = MigrationSheet) then
                  MainPageControl.ActivePage := PlacementSheet
                else
                  if (MainPageControl.ActivePage = PlacementSheet) then
                    DoFinalizeRevEng
                  else
                    if (MainPageControl.ActivePage = FinalizeSheet) then
                      Close;

  UpdatePageHeader;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.BackBtnClick(Sender: TObject);

begin
  if (MainPageControl.ActivePageIndex > 0) then
    MainPageControl.ActivePageIndex :=
      MainPageControl.ActivePageIndex - 1;

  if (MainPageControl.ActivePageIndex = 0) then
    BackBtn.Enabled := False;

  NextBtn.Enabled := True;

  UpdateAdvancedBtnState;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.CancelBtnClick(Sender: TObject);

begin
  FCancelOperation := True;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.AdvancedBtnClick(Sender: TObject);

begin
  if (MainPageControl.ActivePage = ConnectionSheet) then
    DBConnAdvancedSettingsGBox.Visible :=
      Not(DBConnAdvancedSettingsGBox.Visible)
  else
    if (MainPageControl.ActivePage = GetSchemataSheet) then
      MessageLogGBox.Visible :=
        Not(MessageLogGBox.Visible)
    else
      if (MainPageControl.ActivePage = RevEngSheet) then
        RevEngMsgLogGBox.Visible :=
          Not(RevEngMsgLogGBox.Visible)
      else
        if (MainPageControl.ActivePage = MigrationSheet) then
          MigrationGBox.Visible :=
            Not(MigrationGBox.Visible)
        else
          if (MainPageControl.ActivePage = FinalizeSheet) then
            MessageLogFinalizeGBox.Visible :=
              Not(MessageLogFinalizeGBox.Visible);

  UpdateAdvancedBtnState;
end;

// -----------------------------------------------------------------------------

function TReverseEngineeringForm.AdvancedSectionsVisible: Boolean;

begin
  case MainPageControl.ActivePageIndex of
    0:
      Result := DBConnAdvancedSettingsGBox.Visible;
    1:
      Result := MessageLogGBox.Visible;
    3:
      Result := RevEngMsgLogGBox.Visible;
    8:
      Result := MigrationGBox.Visible;
  else
    Result := False;
  end;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.UpdateAdvancedBtnState;

begin
  AdvancedBtn.Enabled := (MainPageControl.ActivePage <> SchemataSheet);

  if (AdvancedSectionsVisible) then
  begin
    AdvancedBtn.Caption := _('<< Advanced');

    Height := FAdvancedHeight;

    DBConnAdvancedSettingsGBox.Height := Height - (686 - 161);
    DBConnAdvancedSettingsGBox.Anchors :=
      [akLeft, akTop, akRight, akBottom];
  end
  else
  begin
    AdvancedBtn.Caption := _('Advanced >>');

    Height := FNormalHeight;
  end;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.UpdatePageHeader;

begin
  if (MainPageControl.ActivePage = ConnectionSheet) then
  begin
    PageTitleLbl.Caption := _('Source Connection');
    PageDescLbl.Caption := _('Please specify the source connection.');
  end
  else
    if (MainPageControl.ActivePage = GetSchemataSheet) then
    begin
      PageTitleLbl.Caption := _('Source Schemata');
      PageDescLbl.Caption := _('The list of available schemata is fetched.');
    end
    else
      if (MainPageControl.ActivePage = SchemataSheet) then
      begin
        PageTitleLbl.Caption := _('Schema Selection');
        PageDescLbl.Caption := _('Please select the schema(ta) to reverse engineer.');
      end
      else
        if (MainPageControl.ActivePage = RevEngSheet) then
        begin
          PageTitleLbl.Caption := _('Reverse Engineering');
          PageDescLbl.Caption := _('The selected schema(ta) are reverse engineered.');
        end
        else
          if (MainPageControl.ActivePage = IgnoreListSheet) then
          begin
            PageTitleLbl.Caption := _('Object Selection');
            PageDescLbl.Caption := _('Add objects to the ignore list.');
          end
          else
            if (MainPageControl.ActivePage = MigrationSelectionSheet) then
            begin
              PageTitleLbl.Caption := _('Object Migration');
              PageDescLbl.Caption := _('Please choose how to migrate the objects.');
            end
            else
              if (MainPageControl.ActivePage = MigrationObjMappingSheet) then
              begin
                PageTitleLbl.Caption := _('Migration Mappings');
                PageDescLbl.Caption := _('Please select the methods that will be used to migrate the source objects.');
              end
              else
                if (MainPageControl.ActivePage = MigrationSheet) then
                begin
                  PageTitleLbl.Caption := _('Migration');
                  PageDescLbl.Caption := _('The migration process is performed.');
                end
                else
                  if (MainPageControl.ActivePage = FinalizeSheet) then
                  begin
                    PageTitleLbl.Caption := _('Finalization');
                    PageDescLbl.Caption := _('Finalizing the reverse engineering process.');
                  end;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.ProcessGrtOutput(Text: WideString);

begin
  if (MainPageControl.ActivePage = GetSchemataSheet) then
    GRTMessageMemo.Lines.Add(Text)
  else
    if (MainPageControl.ActivePage = RevEngSheet) then
      GRTMessage2Memo.Lines.Add(Text)
    else
      if (MainPageControl.ActivePage = FinalizeSheet) then
        GRTMessage3Memo.Lines.Add(Text)
      else
        if (MainPageControl.ActivePage = MigrationSheet) then
          GRTMessage4Memo.Lines.Add(Text)
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.ProcessGrtMessages(
  Messages: TMYX_GRT_MSGS);

var
  Msg: TMYX_GRT_MSG;

begin
  // display last message in ResultLbl
  if (Messages.msgs.Count > 0) then
  begin
    Msg := Messages.msgs[Messages.msgs.Count - 1];

    if (MainPageControl.ActivePage = GetSchemataSheet) then
    begin
      ProgressLbl.Caption := Msg.msg;
      ProgressLbl.Update;

      GRTMessageMemo.Text := GRTMessageMemo.Text +
        FormatGrtMessagesAsString(Messages);
      GRTMessageMemo.Update;
    end
    else
      if (MainPageControl.ActivePage = RevEngSheet) then
      begin
        Progress2Lbl.Caption := Msg.msg;
        Progress2Lbl.Update;

        GRTMessage2Memo.Text := GRTMessage2Memo.Text +
          FormatGrtMessagesAsString(Messages);
        GRTMessage2Memo.Update;
      end
      else
        if (MainPageControl.ActivePage = FinalizeSheet) then
        begin
          Progress3Lbl.Caption := Msg.msg;
          Progress3Lbl.Update;

          GRTMessage3Memo.Text := GRTMessage3Memo.Text +
            FormatGrtMessagesAsString(Messages);
          GRTMessage3Memo.Update;
        end
        else
          if (MainPageControl.ActivePage = MigrationSheet) then
          begin
            if (Msg.msg_type = 2) then
            begin
              GrtProgressLbl.Caption := Msg.msg;
              GrtProgressLbl.Update;

              if (Msg.progress = -1) then
              begin
                GrtProgressBar.Hide;
                GrtProgressLbl.Hide;
              end
              else
              begin
                GrtProgressBar.Position := Msg.progress;

                if (Not(GrtProgressBar.Visible)) then
                begin
                  GrtProgressBar.Show;
                  GrtProgressLbl.Show;
                end;
              end;
            end
            else
            begin
              Progress4Lbl.Caption := Msg.msg;
              Progress4Lbl.Update;
            end;

            GRTMessage4Memo.Text := GRTMessage4Memo.Text +
              FormatGrtMessagesAsString(Messages);
            GRTMessage4Memo.Update;
          end;
  end;
end;

// -----------------------------------------------------------------------------

function TReverseEngineeringForm.ProcessStatusQuery: Integer;

begin
  Result := Ord(FCancelOperation);
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.SchemaSearchEdSearchEdChange(
  Sender: TObject);

begin
  SchemaSearchEd.SearchEdChange(Sender);

  RefreshSchemaListView(SchemaSearchEd.SearchEd.Text);
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.ShowSchemataAsListCBoxClick(
  Sender: TObject);
begin
  if (ShowSchemataAsListCBox.Checked) then
    SchemaListView.ViewStyle:=vsList
  else
    SchemaListView.ViewStyle:=vsIcon;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.SchemaListViewClick(Sender: TObject);

begin
  UpdateSchemaSelectionCountLbl;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.UpdateSchemaSelectionCountLbl;

begin
  if (SchemaListView.SelCount = 0) then
  begin
    SchemaSelectionCountLbl.Caption :=
      _('No schemata selected.');

    NextBtn.Enabled := False;
  end
  else
  begin
    if(SchemaListView.SelCount=1)then
      SchemaSelectionCountLbl.Caption :=
        _('1 schema selected.')
    else
      SchemaSelectionCountLbl.Caption :=
        Format(_('%d schemata selected.'), [SchemaListView.SelCount]);

    NextBtn.Enabled := True;
  end;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.RefreshSchemaListView(SearchStr: WideString);

var
  I: integer;
  ListItem: TTntListItem;
  S: WideString;

begin
  SchemaListView.Items.Clear;

  if (FSchemaList <> nil) then
  begin
    for I:=0 to Grt.ListCount(FSchemaList) - 1 do
    begin
      S := Grt.ListString[FSchemaList, I];

      if (SearchStr = '') or
        (myx_match_pattern(S, SearchStr + '*', 0, 1) = 1) then
      begin
        ListItem := SchemaListView.Items.Add;
        ListItem.Caption := S;
      end;
    end;
  end;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.SchemaListViewSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);

begin
  UpdateSchemaSelectionCountLbl;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.DoProcessStart;

begin
  BusyAnimate.Show;
  BusyAnimate.Play(1, 74, -1);
  BusyAnimate.Active:=True;

  FBackBtnEnabled := BackBtn.Enabled;
  FNextBtnEnabled := NextBtn.Enabled;

  FCancelOperation := False;

  //WizardBottomFrame.DetailsBtn.Enabled := False;
  BackBtn.Enabled := False;
  NextBtn.Enabled := False;
  CancelBtn.Enabled := True;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.DoProcessEnd;

begin
  BusyAnimate.Hide;
  BusyAnimate.Stop;

  //WizardBottomFrame.DetailsBtn.Enabled := FDetailsBtnEnabled;
  BackBtn.Enabled := FBackBtnEnabled;
  NextBtn.Enabled := FNextBtnEnabled;
  CancelBtn.Enabled := False;

  FCancelOperation := False;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.FormResize(Sender: TObject);

begin
  if (AdvancedSectionsVisible) then
    FAdvancedHeight := Height
  else
    FNormalHeight := Height;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.DoFetchSchemaNames;

var
  RevEngModuleName: WideString;

begin
  FConnection := FMyxConnDlgForm.WriteConnectionToTarget;

  RevEngModuleName := Grt.DictString[Grt.DictItem[FConnection, 'modules'], 'ReverseEngineeringModule'];

  ConnImg.Picture.Assign(FTaskUncheckedPNGImg);
  SchemaListImg.Picture.Assign(FTaskUncheckedPNGImg);

  ResultLbl.Hide;
  GRTMessageMemo.Clear;
  ProgressLbl.Caption := '';
  ProgressLbl.Show;

  // Flip page
  MainPageControl.ActivePage := GetSchemataSheet;
  UpdateAdvancedBtnState;

  DoProcessStart;

  Application.ProcessMessages;
  // if there already is a FSchemaList, release it
  if (FSchemaList <> nil) then
    Grt.ValueRelease(FSchemaList);

  FFetchSchemaTask := Grt.CreateStandardTask('Getting schemata list', RevEngModuleName, 'getSchemata',
    [Grt.GetGlobalAsParam('/workbench/connection')], ProcessGrtOutput, ProcessGrtMessages, False, True, -1, nil,
    ProcessStatusQuery, TaskFinished);
  Grt.AddTask(FFetchSchemaTask);
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.DoDisplaySchemata;

begin
  RefreshSchemaListView;

  NextBtn.Enabled := False;

  // Flip page
  MainPageControl.ActivePage := SchemataSheet;
  UpdateAdvancedBtnState;

  try
    if(SchemaListView.CanFocus)then
      SchemaListView.SetFocus;
  except
  end;
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.DoRevEng;

var
  ModuleName: WideString;
  I: Integer;

begin
  RevEngImg.Picture.Assign(FTaskUncheckedPNGImg);
  CheckResImg.Picture.Assign(FTaskUncheckedPNGImg);
  GetMigMethodsImg.Picture.Assign(FTaskUncheckedPNGImg);

  Result2Lbl.Hide;
  GRTMessageMemo.Clear;
  Progress2Lbl.Caption := '';
  Progress2Lbl.Show;

  // Flip page
  MainPageControl.ActivePage := RevEngSheet;
  UpdateAdvancedBtnState;

  DoProcessStart;

  Application.ProcessMessages;

  FSelectedSchemaList := Grt.ListNew(GrtStringValue);
  for I := 0 to SchemaListView.Items.Count - 1 do
    if (SchemaListView.Items[I].Selected) then
      Grt.ListAdd(FSelectedSchemaList, Grt.ValueFromString(SchemaListView.Items[I].Caption), False);

  if (FCatalog <> nil) then
    Grt.ValueRelease(FCatalog);

  // create rev-eng task
  ModuleName := Grt.DictString[
      Grt.DictItem[FConnection, 'modules'], 'ReverseEngineeringModule'];

  FReverseEngineerTask := Grt.CreateStandardTask(
    'Reverse engineering schema(ta)', ModuleName, 'reverseEngineer',
    [Grt.GetGlobalAsParam('/workbench/connection'), FSelectedSchemaList],
    ProcessGrtOutput, ProcessGrtMessages, False,
    True, -1, nil, ProcessStatusQuery, TaskFinished
  );
  Grt.AddTask(FReverseEngineerTask);

  // create migrationMethods tasks
  ModuleName := Grt.DictString[
      Grt.DictItem[FConnection, 'modules'], 'MigrationModule'];

  FGetMigrationMethodsTask := Grt.CreateStandardTask(
    'Getting migration methods list', ModuleName, 'migrationMethods',
    [],
    ProcessGrtOutput, ProcessGrtMessages, False,
    True, -1, nil, ProcessStatusQuery, TaskFinished
  );
  Grt.AddTask(FGetMigrationMethodsTask);
end;

// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.DoBuildObjectSelection;

var
  I, J, K: Integer;
  PSchemata, PSchema: Pointer;
  PSchemaStruct, PSchemaStructMember: Pointer;
  PSchemaItemList,
    PSchemaItem: Pointer;
  MemberName,
    ContentStructName: WideString;
  FilterFrame: TMigrationObjSelFilterFrame;
  PSourceObjects: Pointer;
  C: Integer;

begin
  //Clear Filter Frames if there are some already
  for I:=0 to FFilterFrames.Count-1 do
    TMigrationObjSelFilterFrame(FFilterFrames[I]).Free;
  FFilterFrames.Clear;

  PSchemata := Grt.DictItem[FCatalog, 'schemata'];

  //Get the struct type of the schemata
  PSchema := myx_grt_list_item_get(PSchemata, 0);
  PSchemaStruct := myx_grt_dict_struct_get(Grt.NativeGrt, PSchema);

  //Clear the Mig.SourceObjects list
  PSourceObjects := Grt.Global['/migration/sourceObjects'];
  myx_grt_list_clear(PSourceObjects);

  //Create a filter frame for each member deriving from db.DatabaseObject
  for I:=myx_grt_struct_get_member_count_total(Grt.NativeGrt, PSchemaStruct)-1 downto 0 do
  begin
    PSchemaStructMember :=
      myx_grt_struct_get_member_by_index_total(Grt.NativeGrt, PSchemaStruct, I);

    // if the member is not a list, continue
    if (Grt.GetStructMemberType(PSchemaStructMember) <> GrtListValue) then
      Continue;

    MemberName :=
      UTF8Decode(_myx_grt_struct_get_member_name(PSchemaStructMember));

    ContentStructName :=
      UTF8Decode(_myx_grt_struct_member_get_content_struct_name(PSchemaStructMember));

    //Only consider structs that derive from db.DatabaseObject
    if (myx_grt_struct_inherits_from(Grt.NativeGrt,
      ContentStructName, 'db.DatabaseObject')=1) then
    begin
      C := 0;

      //Collect all objects for the sourceObject list
      //Loop over all schemata
      for J:=0 to myx_grt_list_item_count(PSchemata)-1 do
      begin
        PSchema := myx_grt_list_item_get(PSchemata, J);

        PSchemaItemList :=
          myx_grt_dict_item_get_value(PSchema, MemberName);

        if (PSchemaItemList<>nil)then
        begin
          //Add objects to sourceObject list
          for K:=0 to myx_grt_list_item_count(PSchemaItemList)-1 do
          begin
            PSchemaItem := myx_grt_list_item_get(PSchemaItemList, K);

            myx_grt_list_item_add_as_string(PSourceObjects,
              myx_grt_dict_id_item_as_string(
                PSchemaItem));

            inc(C);
          end;
        end;
      end;

      //Create FilterFrame
      if (C > 0) then
      begin
        FilterFrame := TMigrationObjSelFilterFrame.Create(self, Grt);
        FFilterFrames.Add(FilterFrame);
        FilterFrame.Name := 'FilterFrame' + IntToStr(FFilterFrames.Count);
        FilterFrame.Parent := ObjSelScrollBox;

        FilterFrame.StructName := ContentStructName;
      end;
    end;
  end;

  for I:=0 to FFilterFrames.Count-1 do
    TMigrationObjSelFilterFrame(FFilterFrames[I]).RefreshLists;

  {MainPageControl.ActivePage := IgnoreListSheet;

  NextBtn.Enabled := True;
  if NextBtn.CanFocus then
    NextBtn.SetFocus;}
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TReverseEngineeringForm.DoFinalizeRevEng;

var
  I, Space, Cols: Integer;
  SchemaList, Schema,
  Model: Pointer;
  CurrentView: Pointer;
  ViewElementList: Pointer;
  Task: IGrtTask;
  CatalogGlobalPath: WideString;

begin
  MigrationImg.Picture.Assign(FTaskUncheckedPNGImg);
  AddObjectsImg.Picture.Assign(FTaskUncheckedPNGImg);
  PlaceObjectsImg.Picture.Assign(FTaskUncheckedPNGImg);

  // hide migration if it is not needed
  MigrationLbl.Visible := False;
  MigrationImg.Visible := False;


  ResultFinalizeLbl.Caption := '';
  ResultFinalizeLbl.Visible := True;

  // Flip page
  MainPageControl.ActivePage := FinalizeSheet;
  UpdateAdvancedBtnState;

  DoProcessStart;
  ResultFinalizeLbl.Caption := _('Removing ignored object from catalog');

  Application.ProcessMessages;

  if (FMigration) then
    CatalogGlobalPath := '/migration/targetCatalog'
  else
    CatalogGlobalPath := '/migration/sourceCatalog';

  //Filter out objects from ignore list
  Task := Grt.CreateStandardTask(
    ResultFinalizeLbl.Caption,
    'DbUtils',
    'removeIgnoredObjectsFromCatalog',
    [Grt.Global[CatalogGlobalPath],
      Grt.Global['/migration/ignoreList']],
    ProcessGrtOutput,
    ProcessGrtMessages,
    True,
    False,
    -1,
    PerformGrtInput, nil, TaskFinished);
  Grt.AddTask(Task);

  // remove empty catalogs
  Task := Grt.CreateStandardTask(
    _('Removing empty schemata'),
    'DbUtils',
    'removeEmptySchemataFromCatalog',
    [Grt.Global['/workbench/catalog']],
    ProcessGrtOutput,
    ProcessGrtMessages,
    True,
    False,
    -1,
    PerformGrtInput, nil, TaskFinished);
  Grt.AddTask(Task);

  // Merge catalogs
  FProcessCatalogsTask := Grt.CreateStandardTask(
    _('Merging catalogs'), 'DbUtils', 'mergeCatalogs',
    [Grt.Global[CatalogGlobalPath],
      Grt.Global['/workbench/catalog']],
    ProcessGrtOutput, ProcessGrtMessages, True, False, -1, PerformGrtInput,
    nil, TaskFinished
  );
  Grt.AddTask(FProcessCatalogsTask);

  // Finally place the objects on the canvas.
  if PlaceAlgoComboBox.ItemIndex > 0 then
  begin
    ResultFinalizeLbl.Caption := _('Place objects on the canvas');
    ResultFinalizeLbl.Update;

    Model := Grt.Global['/workbench/model'];
    SchemaList := Grt.Global[CatalogGlobalPath + '/schemata'];
    for I := 0 to Grt.ListCount(SchemaList) - 1 do
    begin
      Schema := Grt.ListItem[SchemaList, I];

      // Check if the current view is empty.
      CurrentView := Grt.DictRef[Model, 'currentView'];
      ViewElementList := Grt.DictItem[CurrentView, 'elements'];
      if (Grt.ListCount(ViewElementList) > 0) then
      begin
        // if not, add a new view
        Task := Grt.CreateStandardTask(
          _('Adding new view'),
          'Workbench',
          'addView',
          [Model, Grt.DictString[Schema, 'name']],
          ProcessGrtOutput,
          ProcessGrtMessages,
          True,
          False,
          -1,
          PerformGrtInput
        );
        Grt.AddTask(Task);  
      end;

      case PlaceAlgoComboBox.ItemIndex of
        1: // Automatic arrangement.
          begin
            FArrangeTask := Grt.CreateStandardTask(
              _('Arranging schema objects on current view'), 'Workbench', 'loadAndAutoArrange',
              [Schema, CurrentView], ProcessGrtOutput, ProcessGrtMessages, True, False, -1,
              PerformGrtInput, nil, TaskFinished);
            Grt.AddTask(FArrangeTask);
          end;
        2: // Grid arrangement.
          begin
            case PlaceAreaComboBox.ItemIndex of
              0:
                Cols := 5;
              1:
                Cols := 7;
              2:
                Cols := 10;
              3:
                Cols := 15;
              4:
                Cols := 20;
              5:
                Cols := 25;
            else
              Cols := 70;
            end;


            case PlaceSpaceComboBox.ItemIndex of
              0:
                Space := 40;
              1:
                Space := 70;
              2:
                Space := 100;
            else
              Space := 70;
            end;

            FArrangeTask := Grt.CreateStandardTask(
              _('Arranging schema objects on current view'), 'Workbench', 'arrangeSchemaOnCurrentView',
              [Schema, 100, 100, Cols, Space], ProcessGrtOutput, ProcessGrtMessages, True, False, -1,
              PerformGrtInput, nil, TaskFinished);
            Grt.AddTask(FArrangeTask);
          end;
      end;
    end;
  end;
end;

// -----------------------------------------------------------------------------

function TReverseEngineeringForm.PerformGrtInput(Description: WideString): WideString;

var
  InputText: WideString;

begin
  InputText := '';

  ShowModalEditDialog(_('Input'),
    Description, myx_mtEdit,
    _('Ok'), True, '', InputText);

  Result := InputText;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TReverseEngineeringForm.PlaceAlgoComboBoxCloseUp(Sender: TObject);

begin
  PlaceAreaLbl.Enabled := (PlaceAlgoComboBox.ItemIndex > 1);
  PlaceAreaComboBox.Enabled := PlaceAreaLbl.Enabled;

  PlaceSpaceLbl.Enabled := PlaceAreaLbl.Enabled;
  PlaceSpaceComboBox.Enabled := PlaceAreaLbl.Enabled;
end;

//----------------------------------------------------------------------------------------------------------------------

// Called when an asynchronous task has been finished.
procedure TReverseEngineeringForm.TaskFinished(Task: IGrtGenericTask);

begin
  if Task = FFetchSchemaTask then
  begin
    if not TaskHandleError(Task) then
    begin
      FSchemaList := FFetchSchemaTask.Result;
      ConnImg.Picture.Assign(FTaskCheckedPNGImg);
      SchemaListImg.Picture.Assign(FTaskCheckedPNGImg);
    end
    else
      GRTMessageMemo.Text := GRTMessageMemo.Text + #13#10 +
        Task.ErrorString + #13#10;

    ResultLbl.Hide;
    ProgressLbl.Hide;
    FFetchSchemaTask := nil;
    DoProcessEnd;
  end
  else
    if Task = FReverseEngineerTask then
    begin
      if not TaskHandleError(Task) then
      begin
        FCatalog := FReverseEngineerTask.Result;
        Grt.Global['/migration/sourceCatalog'] := FCatalog;
        RevEngImg.Picture.Assign(FTaskCheckedPNGImg);
        DoBuildObjectSelection;
        CheckResImg.Picture.Assign(FTaskCheckedPNGImg);
      end
      else
      begin
        DoProcessEnd;
        Progress2Lbl.Hide;

        GRTMessage2Memo.Text := GRTMessage2Memo.Text + #13#10 +
          Task.ErrorString + #13#10;
      end;

      Grt.ValueRelease(FSelectedSchemaList);
      FSelectedSchemaList := nil;

      FReverseEngineerTask := nil;
    end
    else
      if Task = FGetMigrationMethodsTask then
      begin
        if not TaskHandleError(Task) then
        begin
          Grt.Global['/migration/migrationMethods'] := FGetMigrationMethodsTask.Result;
          Grt.ValueRelease(FGetMigrationMethodsTask.Result);
        end
        else
          GRTMessage2Memo.Text := GRTMessage2Memo.Text + #13#10 +
            Task.ErrorString + #13#10;

        FGetMigrationMethodsTask := nil;

        DoProcessEnd;
        GetMigMethodsImg.Picture.Assign(FTaskCheckedPNGImg);

        Progress2Lbl.Hide;
      end
      else
        if Task = FMigrationTask then
        begin
          if not TaskHandleError(Task) then
          begin
            MigrateImg.Picture.Assign(FTaskCheckedPNGImg);
            Progress4Lbl.Hide;
          end
          else
          begin
            MigrateImg.Picture.Assign(FTaskErrorPNGImg);

            GRTMessage4Memo.Text := GRTMessage4Memo.Text + #13#10 +
              Task.ErrorString + #13#10;
          end;

          GrtProgressBar.Hide;
          GrtProgressLbl.Hide;

          DoProcessEnd;
        end
        else
          if Task = FProcessCatalogsTask then
          begin
            // Just show some feedback about the finished task.
            if not TaskHandleError(Task) then
              AddObjectsImg.Picture.Assign(FTaskCheckedPNGImg)
            else
              GRTMessage3Memo.Text := GRTMessage3Memo.Text + #13#10 +
                Task.ErrorString + #13#10;

            FProcessCatalogsTask := nil;
          end
          else
            if Task = FArrangeTask then
            begin
              if not TaskHandleError(Task) then
              begin
                PlaceObjectsImg.Picture.Assign(FTaskCheckedPNGImg);
                PlaceObjectsLbl.Caption := _('Reverse engineering completed successfully.');
                NextBtn.Caption := _('Finish');
                BackBtn.Enabled := False;
                CancelBtn.Enabled := False;
              end
              else
                begin
                GRTMessage3Memo.Text := GRTMessage3Memo.Text + #13#10 +
                  Task.ErrorString + #13#10;

                NextBtn.Enabled := False;
                BackBtn.Enabled := True;
                CancelBtn.Enabled := True;
              end;
              DoProcessEnd;
            end
            else
              TaskHandleError(Task);
end;

//----------------------------------------------------------------------------------------------------------------------

function TReverseEngineeringForm.TaskHandleError(Task: IGrtGenericTask): Boolean;

// Checks if the task has returned an error. If so the error message is shown, the error images are set and
// True is returned. Otherwise False is the result.

var
  StandardTask: IGrtTask;
  Memo: TTntMemo;

begin
  Result := False;

  if (Task.ErrorCode <> MYX_GRT_NO_ERROR) or (Task.ErrorString <> '') then
  begin
    Result := True;

    if (MainPageControl.ActivePage = GetSchemataSheet) then
      Memo := GRTMessageMemo
    else
      if (MainPageControl.ActivePage = RevEngSheet) then
        Memo := GRTMessage2Memo
      else
        if (MainPageControl.ActivePage = FinalizeSheet) then
          Memo := GRTMessage3Memo
        else
          Memo := nil;

    if Assigned(Memo) then
    begin
      if Supports(Task, IGrtTask, StandardTask) then
        Memo.Lines.Add(Format(
          _('A problem occured while executing task: %s. '#1310'The error occured in %s.%s and is: %s (code: %d).'),
          [StandardTask.Description, StandardTask.ModuleName, StandardTask.FunctionName, Task.ErrorString, Ord(Task.ErrorCode)]))
      else
        Memo.Lines.Add(Format(
          _('A problem occured while executing a shell task. '#1310'The error is: %s (code: %d).'),
          [Task.ErrorString, Ord(Task.ErrorCode)]));
    end;
    
    ConnImg.Picture.Assign(FTaskErrorPNGImg);
    SchemaListImg.Picture.Assign(FTaskErrorPNGImg);
    NextBtn.Enabled := False;
    BackBtn.Enabled := True;
    CancelBtn.Enabled := True;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TReverseEngineeringForm.SchemaListViewDblClick(Sender: TObject);

begin
  UpdateSchemaSelectionCountLbl;

  if SchemaListView.SelCount > 0 then
    DoRevEng;
end;

// -----------------------------------------------------------------------------
// ObjMapping page implemetation
// -----------------------------------------------------------------------------

procedure TReverseEngineeringForm.DoDisplayObjMappingDefaults;

var
  I, J, K, C: Integer;
  PSchemata, PSchema: Pointer;
  PSchemaStruct, PSchemaStructMember, PSchemaItemList,
    PSchemaItem: Pointer;
  MemberName,
    ContentStructName: WideString;
  DefaultFrame: TMigrationObjMapDetailFrame;
  PSourceObjects: Pointer;

begin
  MainPageControl.ActivePage := MigrationObjMappingSheet;

  try
    DefaultFramesScrollBox.Visible := False;

    //Get schemata list from GRT Migration object
    PSchemata := myx_grt_dict_item_get_value(Grt.Global['/migration/sourceCatalog'],
      'schemata');

    PSourceObjects := Grt.Global['/migration/sourceObjects'];

    //Clear Filter Frames if there are some already
    for I:=0 to DefaultFrames.Count-1 do
      TMigrationObjMapDetailFrame(DefaultFrames[I]).Free;
    DefaultFrames.Clear;

    //Check if there is at lease one schema
    if (myx_grt_list_item_count(PSchemata)>0) then
    begin

      //Get the struct type of the schemata
      PSchema := myx_grt_list_item_get(PSchemata, 0);
      PSchemaStruct := myx_grt_dict_struct_get(Grt.NativeGrt, PSchema);

      //Create a filter frame for each member deriving from db.DatabaseObject
      for I:=myx_grt_struct_get_member_count(PSchemaStruct)-1 downto 0 do
      begin
        PSchemaStructMember :=
          myx_grt_struct_get_member_by_index(PSchemaStruct, I);

        MemberName :=
          UTF8Decode(_myx_grt_struct_get_member_name(PSchemaStructMember));

        ContentStructName :=
          UTF8Decode(_myx_grt_struct_member_get_content_struct_name(PSchemaStructMember));

        //Only consider structs that derive from db.DatabaseObject
        if (myx_grt_struct_inherits_from(Grt.NativeGrt,
          ContentStructName, 'db.DatabaseObject')=1) then
        begin
          C := 0;

          //Collect all objects for the sourceObject list
          //Loop over all schemata
          for J:=0 to myx_grt_list_item_count(PSchemata)-1 do
          begin
            PSchema := myx_grt_list_item_get(PSchemata, J);

            PSchemaItemList :=
              myx_grt_dict_item_get_value(PSchema, MemberName);

            if (PSchemaItemList<>nil)then
            begin
              //Add objects to sourceObject list
              for K:=0 to myx_grt_list_item_count(PSchemaItemList)-1 do
              begin
                PSchemaItem := myx_grt_list_item_get(PSchemaItemList, K);

                myx_grt_list_item_add_as_string(PSourceObjects,
                  myx_grt_dict_id_item_as_string(
                    PSchemaItem));

                inc(C);
              end;
            end;
          end;


          //Create DefaultFrame
          if (C > 0) then
          begin
            DefaultFrame := TMigrationObjMapDetailFrame.Create(self, Grt);
            DefaultFrames.Add(DefaultFrame);
            DefaultFrame.Name := 'DefaultFrame' + IntToStr(DefaultFrames.Count);
            DefaultFrame.Parent := DefaultFramesScrollBox;

            DefaultFrame.TargetDatabaseObjectPackage :=
              Grt.GlobalAsString['/workbench/rdbms/databaseObjectPackage'];
            DefaultFrame.StructName := ContentStructName;
          end;
        end;
      end;

      //Create DefaultFrame for schema
      DefaultFrame := TMigrationObjMapDetailFrame.Create(self, Grt);
      DefaultFrames.Add(DefaultFrame);
      DefaultFrame.Name := 'DefaultFrame' + IntToStr(DefaultFrames.Count);
      DefaultFrame.Parent := DefaultFramesScrollBox;

      DefaultFrame.TargetDatabaseObjectPackage :=
        Grt.GlobalAsString['/workbench/rdbms/databaseObjectPackage'];
      DefaultFrame.StructName := UTF8Decode(
        _myx_grt_dict_struct_get_name(PSchema));
    end
  finally
    DefaultFramesScrollBox.Visible := True;
  end;

  // Refresh scrollbar
  DefaultFramesScrollBox.Align := alNone;
  DefaultFramesScrollBox.Align := alClient;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TReverseEngineeringForm.DoBuildObjMapping;

var
  I: Integer;
  PMappingDefauts,
    PParams: Pointer;
  DefaultFrame: TMigrationObjMapDetailFrame;
  PMappingDefault: Pointer;
  ParamGroupName: WideString;

begin
  //build defaults mapping list
  PMappingDefauts := Grt.Global['/migration/mappingDefaults'];

  myx_grt_list_clear(PMappingDefauts);

  for I:=0 to DefaultFrames.Count-1 do
  begin
    DefaultFrame := TMigrationObjMapDetailFrame(
      DefaultFrames[I]);

    if (DefaultFrame.SelectedMethod <> nil) then
    begin
      // Create new mapping
      PMappingDefault := myx_grt_dict_new(
        nil, 'db.migration.Mapping');
      Grt.DictString[PMappingDefault, '_id'] := myx_grt_get_guid();

      Grt.DictString[PMappingDefault, 'methodName'] :=
        DefaultFrame.MigMethodName;
      Grt.DictString[PMappingDefault, 'moduleName'] :=
        DefaultFrame.MigModuleName;
      Grt.DictString[PMappingDefault, 'sourceStructName'] :=
        DefaultFrame.MigSourceStructName;

      // Store reference to method
      Grt.DictRef[PMappingDefault, 'method'] :=
        DefaultFrame.SelectedMethod;

      ParamGroupName := DefaultFrame.ParamGroupName;
      if (ParamGroupName<>'')then
      begin
        Grt.DictString[PMappingDefault, 'paramGroupName'] :=
          ParamGroupName;

        PParams := DefaultFrame.ParamGroupParams;
      end
      else
        PParams := DefaultFrame.UserDefinedParams;

      if (PParams<>nil) then
      begin
        Grt.DictItem[PMappingDefault, 'params'] := PParams;

        //release PParams one time, since it is referenced
        //by the PMappingDefault now
        myx_grt_value_release(PParams);
      end;

      //Add to mapping defaults list
      Grt.ListAdd(PMappingDefauts, PMappingDefault);
    end;
  end;

  DoMigration;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TReverseEngineeringForm.DoMigration;

var ModuleName: WideString;
  TargetRdbms,
  TargetRdbmsGlobalPath: WideString;
  RdbmsList: Pointer;
  I: Integer;

begin
  // Show migration page
  MigrateImg.Picture.Assign(FTaskUncheckedPNGImg);

  // initialize progress widgets
  Result4Lbl.Caption := _('Executing ...');
  Result4Lbl.Show;
  Result4Lbl.Font.Color := clBlack;
  Progress4Lbl.Caption := '';
  Progress4Lbl.Show;
  GRTMessage4Memo.Text := '';
  GrtProgressBar.Visible := False;
  GrtProgressLbl.Visible := False;

  MainPageControl.ActivePage := MigrationSheet;

  //Start animation
  DoProcessStart;

  Application.ProcessMessages;

  myx_grt_list_clear(Grt.Global['/migration/migrationLog']);

  TargetRdbms := Grt.GlobalAsString['/workbench/rdbms'];

  TargetRdbmsGlobalPath := '';
  RdbmsList := Grt.Global['/rdbmsMgmt/rdbms'];
  for I := 0 to Grt.ListCount(RdbmsList) do
    if (Grt.DictString[Grt.ListItem[RdbmsList, I], '_id'] = TargetRdbms) then
    begin
      TargetRdbmsGlobalPath := '/rdbmsMgmt/rdbms/' + IntToStr(I);
      break;
    end;

  //Do migration
  ModuleName := Grt.DictString[
      Grt.DictItem[FConnection, 'modules'], 'MigrationModule'];

  FMigrationTask := Grt.CreateStandardTask(
    _('Starting migration'),
    ModuleName,
    'migrate',
    [Grt.GetGlobalAsParam('/migration'),
      Grt.GetGlobalAsParam(TargetRdbmsGlobalPath),
      Grt.GetGlobalAsParam('/workbench/catalog/version')],
    ProcessGrtOutput,
    ProcessGrtMessages,
    True,
    False,
    -1,
    nil,
    ProcessStatusQuery, TaskFinished);
  Grt.AddTask(FMigrationTask);
end;

//----------------------------------------------------------------------------------------------------------------------

end.
