package com.mysql.grt.modules;

import java.util.Vector;

import com.mysql.grt.*;

/**
 * @author Mike
 * 
 * Java base module
 */
public class BaseJava {

	/**
	 * Static function to return information about this class to the GRT
	 * environment
	 * 
	 * @return returns a GRT XML string containing the infos about this class
	 */
	public static String getModuleInfo() {
		return Grt.getModuleInfoXml(BaseJava.class, "");
	}

	public static String engineVersion() {
		return "Java " + System.getProperty("java.version") + " "
				+ System.getProperty("java.vendor");
	}

	public static GrtList getMessages() {
		GrtList msgList = new GrtList("GrtMessage");
		Vector msgs = Grt.getInstance().getMessages();

		for (int i = 0; i < msgs.size(); i++) {
			msgList.addObject(msgs.get(i));
		}

		msgs.clear();

		return msgList;
	}
	
	public static int javaClassExists(String className) {
		int res = 0;

		try {
			if (Class.forName(className) != null)
				res = 1;
		} catch (ClassNotFoundException e) {
			// ignore exception
		}

		return res;
	}
}