//
//  MQScriptController.m
//  MySQL QueryBrowser
//
//  Created by Alfredo Kojima on 5/31/05.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import "MQScriptController.h"
#import "MQueryBrowser.h"
#import "MQScriptTab.h"
#import "MQScriptExecutionHelper.h"
#import <MySQLToolsCommon/MMenuButton.h>

@implementation MQScriptController

- (void)awakeFromNib
{
  NSRect wrect= [[owner window] contentRectForFrameRect:[[owner window] frame]];
  NSRect trect;
  trect= [toolbar frame];
  [toolbar setFrameOrigin:NSMakePoint(-1,NSHeight(wrect)-NSHeight(trect))];

  trect= [bigToolbar frame];
  [bigToolbar setFrameOrigin:NSMakePoint(-1,NSHeight(wrect)-NSHeight(trect))];
  
  _idleImage= [[NSImage imageNamed:@"sakila.png"] retain];
  _busyImage= [[NSImage imageNamed:@"dolphin_anim.gif"] retain];
  
  [[NSNotificationCenter defaultCenter] addObserver:self
                                           selector:@selector(scriptEditChanged:)
                                               name:MQScriptEditStatusChangedNotification
                                             object:nil];
}


- (void)dealloc
{
  [[NSNotificationCenter defaultCenter] removeObserver:self];
  [_idleImage release];
  [_busyImage release];
  
  [super dealloc];
}


- (MQScriptTab*)createPage
{
  MQScriptTab *page= [[MQScriptTab alloc] initWithIdentifier:@"bb" 
                                            withConnectionTo:[owner serverInfo]];
  if (page)
  {
    [page setIcon:[NSImage imageNamed:@"tabsheet_icon_script.png"]];
    [page setLabel:@"Script"];
    [(id)[[page scriptEditor] textView] setHelper:[owner schemaHelper]];

    [[page scriptHelper] setDelegate:self];
  }
  return [page autorelease];
}



- (void)switchToolbar:(BOOL)small
{
  if ([[owner currentTab] isKindOfClass:[MQScriptTab class]])
  {
    [bigToolbar setHidden:small?YES:NO];
    [toolbar setHidden:small?NO:YES];
  }
}


- (void)resizeToolbar:(float)height
{
  [bigToolbar setFrameSize:NSMakeSize(NSWidth([bigToolbar frame]), height)];
}


- (void)updateToolbarState
{
  MQScriptTab *page= [owner currentTab];
  MQScriptState state= [[page scriptHelper] state];

  switch (state)
  {
    case ScriptBreakpoint:
    case ScriptWaiting:
      switch (state)
      {
        case ScriptBreakpoint:
          [page setStatusText:@"Breakpoint reached." icon:nil];
          break;
        default:      
          [page setStatusText:@"Press Step or Continue." icon:nil];
          break;
      }
      [executeButton setEnabled:NO];
      [[toolbar viewWithTag:24] setEnabled:NO];
      [stopButton setEnabled:YES];
      [[toolbar viewWithTag:25] setEnabled:YES];
      [pauseButton setEnabled:NO];
      [[toolbar viewWithTag:26] setEnabled:NO];
      [continueButton setEnabled:YES];
      [[toolbar viewWithTag:27] setEnabled:YES];
      [stepButton setEnabled:YES];
      [[toolbar viewWithTag:28] setEnabled:YES];
      [animbox setImage:_idleImage];
      break;
    case ScriptError:
      [executeButton setEnabled:NO];
      [[toolbar viewWithTag:24] setEnabled:NO];
      [stopButton setEnabled:YES];
      [[toolbar viewWithTag:25] setEnabled:YES];
      [pauseButton setEnabled:NO];
      [[toolbar viewWithTag:26] setEnabled:NO];
      [continueButton setEnabled:YES];
      [[toolbar viewWithTag:27] setEnabled:YES];
      [stepButton setEnabled:YES];
      [[toolbar viewWithTag:28] setEnabled:YES];
      [animbox setImage:_idleImage];
      break;      
    case ScriptExecuting:
      [executeButton setEnabled:NO];
      [[toolbar viewWithTag:24] setEnabled:NO];
      [stopButton setEnabled:YES];
      [[toolbar viewWithTag:25] setEnabled:YES];
      [pauseButton setEnabled:YES];
      [[toolbar viewWithTag:26] setEnabled:YES];
      [continueButton setEnabled:NO];
      [[toolbar viewWithTag:27] setEnabled:NO];
      [stepButton setEnabled:NO];
      [[toolbar viewWithTag:28] setEnabled:NO];
      [animbox setImage:_busyImage];
      [page setStatusText:@"Executing..." icon:nil];
      break;
    case ScriptFinished:
    case ScriptStopped:
      if (state == ScriptFinished)
        [page setStatusText:@"Script executed." icon:nil];
      else
        [page setStatusText:@"Script stopped." icon:nil];
    default:
      [executeButton setEnabled:YES];
      [[toolbar viewWithTag:24] setEnabled:YES];
      [stopButton setEnabled:NO];
      [[toolbar viewWithTag:25] setEnabled:NO];
      [pauseButton setEnabled:NO];
      [[toolbar viewWithTag:26] setEnabled:NO];
      [continueButton setEnabled:NO];
      [[toolbar viewWithTag:27] setEnabled:NO];
      [stepButton setEnabled:NO];
      [[toolbar viewWithTag:28] setEnabled:NO];
      [animbox setImage:_idleImage];
      break;
  }
}


- (IBAction)saveScript:(id)sender
{
  [[owner currentTab] saveScript:sender];
}


- (IBAction)openScript:(id)sender
{
  [[owner currentTab] openScript:sender];
}



- (IBAction)executeScript:(id)sender
{
  [[(MQScriptTab*)[owner currentTab] scriptHelper] executeScript:sender];
}

- (IBAction)stopScript:(id)sender
{
  [[(MQScriptTab*)[owner currentTab] scriptHelper] stopScript:sender];
}

- (IBAction)continueScript:(id)sender
{
  [[(MQScriptTab*)[owner currentTab] scriptHelper] continueScript:sender];
}

- (IBAction)pauseScript:(id)sender
{
  [[(MQScriptTab*)[owner currentTab] scriptHelper] pauseScript:sender];
}

- (IBAction)stepNextScript:(id)sender
{
  [[(MQScriptTab*)[owner currentTab] scriptHelper] stepScript:sender];
}

- (void)willShowPage:(id)page
{
  [animbox setImage:_idleImage];

  [bigToolbar setHidden:[owner smallToolbar]?YES:NO];
  [toolbar setHidden:[owner smallToolbar]?NO:YES];
  
  [owner setDocumentEdited:[page isDocumentEdited]];
  [owner setTitleForDocumentName:[NSString stringWithFormat:[NSString stringWithUTF8String:"%@ — %@"],
                                       [page documentName]?:@"Untitled", [page defaultSchema]]];
  
  [self updateToolbarState];

  // somehow, the dragged types is being lost when tabs are switched
  if ([[owner currentTab] isKindOfClass:[MQScriptTab class]])
    [[[[owner currentTab] scriptEditor] textView] registerForDraggedTypes:[NSArray arrayWithObject:MSchemaItemPboardType]];
}

- (void)didHidePage
{
  [toolbar setHidden:YES];
  [bigToolbar setHidden:YES];
}


- (void)scriptEditChanged:(NSNotification*)notif
{
  MQScriptTab *tab= [notif object];
  if (tab == [owner currentTab])
  {
    [owner setDocumentEdited:[tab isDocumentEdited]];
    
    [owner setTitleForDocumentName:[NSString stringWithFormat:[NSString stringWithUTF8String:"%@ — %@"],
                                          [tab documentName]?:@"Untitled", [tab defaultSchema]]];
  }
}


- (void)scriptChangedState:(MQScriptExecutionHelper*)script state:(MQScriptState)state
{
  if ([[owner currentTab] scriptHelper] == script)
    [self updateToolbarState];
}

@end
