/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _NET_IRC_CLIENT_H_
#define _NET_IRC_CLIENT_H_

#ifdef __cplusplus
extern "C" {
#endif

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
#define MYX_PUBLIC_FUNC __declspec(dllexport)
#else
#define MYX_PUBLIC_FUNC
#endif

#include "net_line_client.h"


/*
 * PUBLIC INTERFACE definition for MYSQLLibInterfaceMapper
 */

// PUBLIC_INTERFACE "libmysqlxnet"
#define libmysqlxnet_PUBLIC_INTERFACE_VERSION 1


/*
 * Enums
 */

typedef enum {
  MISDisconnected,
  MISRegistering,
  MISConnected
} MIRCState;


typedef enum {
  MIMChannel,
  MIMPrivate,
  MIMNotice,
  MIMOther
} MIRCMessageType;
  

typedef enum {
  MIUIsMyself=(1<<0),
  MIUOperator=(1<<1),
  MIUVoice=(1<<2)
} MIRCUserFlag;

/*
 * Structs
 */


// LibInterfachMapper generates classes for MIRCUser
typedef struct {
  char *nick;
  int flags;
  /* these are retrieved through WHOIS */
  char *user_name;
  char *real_name;
  
  int refcount;
} MIRCUser;


// LibInterfachMapper generates classes for MIRCChannel
typedef struct {
  char *name;
  char *topic;

  unsigned int users_num;
  MIRCUser **users;
} MIRCChannel;


typedef struct _MIRCCallbacks MIRCCallbacks;

// LibInterfachMapper generates classes for MNetIRCClient
typedef struct {
  MNetLineClient *client;
  MIRCState state;

  char *my_real_name;
  char *my_net_name;
  char *my_nick;
  char *my_user_name;
  char *my_password;

  unsigned int channels_num;
  MIRCChannel **channels;

  MIRCCallbacks *callbacks;

  void *user_data;
} MNetIRCClient;


/*
 * Functions
 */

MYX_PUBLIC_FUNC int mnet_get_public_interface_version();

MYX_PUBLIC_FUNC int nick_equal(const char *nick1, const char *nick2);

MYX_PUBLIC_FUNC MIRCUser *mnet_irc_find_user(MNetIRCClient *cli, const char *channel, const char *nick);
  
MYX_PUBLIC_FUNC MNetIRCClient * mnet_init_irc(int use_ssl);

MYX_PUBLIC_FUNC void mnet_irc_user_retain(MIRCUser *user);
MYX_PUBLIC_FUNC void mnet_irc_user_release(MIRCUser *user);
  
MYX_PUBLIC_FUNC void mnet_irc_set_my_name(MNetIRCClient *cli, const char *nick, const char *username, const char *realname);

MYX_PUBLIC_FUNC void mnet_irc_set_my_name_password(MNetIRCClient *cli, const char *nick, const char *username, const char *realname, const char *password);

MYX_PUBLIC_FUNC int mnet_irc_connect(MNetIRCClient *cli, const char *host, int port);

MYX_PUBLIC_FUNC int mnet_irc_process(MNetIRCClient *cli);

MYX_PUBLIC_FUNC int mnet_irc_set_callbacks(MNetIRCClient *client,
                           void (*notify_connected)(MNetIRCClient *sender),
                           void (*notify_join)(MNetIRCClient *sender, const char *channel, MIRCUser *user),
                           void (*notify_name_list_ready)(MNetIRCClient *sender, const char *channel),
                           void (*notify_leave)(MNetIRCClient *sender, const char *channel, MIRCUser *user),
                           void (*notify_message)(MNetIRCClient *sender, MIRCMessageType message_type, const char *channel, MIRCUser *user, const char *msg),
                           void (*notify_topic)(MNetIRCClient *sender, const char *channel, const char *topic),
                           void (*notify_kick)(MNetIRCClient *sender, MIRCUser *kicker, MIRCUser *kicked, const char *channel, const char *comment),
                           void (*notify_invite)(MNetIRCClient *sender, const char *inviter, const char *invitee, const char *channel),
                           void (*notify_quit)(MNetIRCClient *sender, const char *nick, const char *comment),
                           void (*notify_rename)(MNetIRCClient *sender, const char *old_nick, const char *new_nick),
                           int (*notify_error)(MNetIRCClient *sender, int error));

MYX_PUBLIC_FUNC int mnet_irc_get_fd(MNetIRCClient *cli);

#ifdef __cplusplus
}
#endif

#endif /* _NET_IRC_CLIENT_H_ */
