//
//  NSView_extras.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on Tue Aug 17 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import "NSView_extras.h"
#import <AppKit/NSTabView.h>

@implementation NSView(NSView_MExtras)

- (void)setEnabledRecursive:(BOOL)flag
{
  NSArray *children= [self subviews];
  unsigned int i, c= [children count];
  for (i= 0; i < c; i++)
  {
    id sv= [children objectAtIndex:i];
    [sv setEnabledRecursive:flag];
  }
  if ([self isKindOfClass:[NSTabView class]])
  {
    NSTabView *tview= (NSTabView*)self;
    c= [tview numberOfTabViewItems];
    for (i= 0; i < c; i++)
    {
      id page= [tview tabViewItemAtIndex:i];
      [[page view] setEnabledRecursive:flag];
    }
  }
  else if ([self respondsToSelector:@selector(setEnabled:)])
    [(id)self setEnabled:flag];
  else if ([self respondsToSelector:@selector(setEditable:)])
    [(id)self setEditable:flag];
}

@end
