
#include "myxutil.h"
#include <glib.h>

MYX_USER_CONNECTION *myx_copy_user_connection(MYX_USER_CONNECTION *info)
{
  MYX_USER_CONNECTION *copy;
  
  copy= g_malloc0(sizeof(MYX_USER_CONNECTION));
  copy->connection_name= g_strdup(info->connection_name);
  copy->username= g_strdup(info->username);
  copy->password= g_strdup(info->password);
  copy->hostname= g_strdup(info->hostname);
  copy->port= info->port;
  copy->schema= g_strdup(info->schema);
  copy->storage_path= g_strdup(info->storage_path);
  if (info->advanced_options_num > 0)
  {
    unsigned int i;
    copy->advanced_options= g_malloc0(sizeof(char*)*info->advanced_options_num);
    for (i= 0; i < info->advanced_options_num; i++)
      copy->advanced_options[i]= g_strdup(info->advanced_options[i]);
    copy->advanced_options_num= info->advanced_options_num;
  }
  copy->notes= g_strdup(info->notes);
  copy->connection_type= info->connection_type;
  copy->storage_type= info->storage_type;
  
  return copy;
}


NSString *myx_get_available_filename(NSString *directory, NSString *base, NSString *suffix)
{
  NSFileManager *fman= [NSFileManager defaultManager];
  NSString *fname;
  int i= 1;
  
  fname= [base stringByAppendingString:suffix?suffix:@""];
  while ([fman fileExistsAtPath:[directory stringByAppendingFormat:@"/%@",fname]])
    fname= [NSString stringWithFormat:@"%@ %i%@",base,i++,suffix?suffix:@""];

  return fname;
}
