unit UCEShared;

//----------------------------------------------------------------------------------------------------------------------
//
// UniCodeEditor, a Unicode Source Code Editor for Delphi.
//
// Created by Mike Lischke (www.soft-gems.net), 1999-2004.
//
// UniCodeEditor is fully in the public domain. There are no legal rights reserved to it. You may freely use it in
// any software, including commercial software and may do whatever you like to do with the source code.
//
// However you are asked to give the author(s) the due credit. This means that you acknowledge the work of the author(s)
// in the product documentation, about box, help or wherever a prominent place is. Additionally, if you modify and/or
// distribute the source code to any third party then you must not veil the original author(s).
//
//----------------------------------------------------------------------------------------------------------------------
//
// The UCEShared unit provides commonly used data types and interfaces. This allows descentants to implement their own
// classes without to link in the whole UniCodeEditor class and/or to implement several functionality in one class.
//----------------------------------------------------------------------------------------------------------------------

interface

uses
  Windows, Graphics;
  
type
  // Defines the interface for a line marker. That is, an entry in the gutter of the edit.
  IUCELineMarker = interface
    procedure Draw(Index: Integer; Canvas: TCanvas; X, Y: Integer);
    function GetSize(Index: Integer): TSize;
  end;

  // Defines the inteface for a custom line style.
  IUCELineStyle = interface
    function GetBackground: TColor;
    function GetFontStyles: TFontStyles;
    function GetForceFontStyles: Boolean;
    function GetForeground: TColor;

    property Background: TColor read GetBackground;
    property Foreground: TColor read GetForeground;
    property FontStyles: TFontStyles read GetFontStyles;
    property ForceFontStyles: Boolean read GetForceFontStyles;
  end;

//----------------------------------------------------------------------------------------------------------------------

implementation

//----------------------------------------------------------------------------------------------------------------------

end.
 
