#ifndef _WB_LAYER_TREE_H_
#define _WB_LAYER_TREE_H_

#include "grt/grt_value_tree.h"
#include <set>

#include "grts/structs.model.h"

namespace wb 
{
  class WBContext;

  class LayerTreeBE : public bec::ValueTreeBE
  {
  public:
    enum LayerColumns
    {
      Color= 10,
      Selected,
      IsLayer
    };

  private:
    struct sortnode 
    {
      bool operator ()(Node *a, Node *b) const
      {
        return a->name < b->name;
      }
    };

    class FigureNode : public bec::ValueTreeBE::Node
    {
    public:
      std::string color;
      std::string id;
      int selected:3;
      int is_layer:1;
    };

    WBContext *_wb;
    std::multimap<std::string, size_t> _figure_connections;
    std::set<std::string> _selected;

    virtual void rescan_node(const bec::NodeId &node_id, bec::ValueTreeBE::Node *node, const std::string &path, const grt::ObjectRef &value);

    int refresh_children_selection(std::vector<bec::ValueTreeBE::Node*> &children, const std::set<std::string> &selected);

    void rename_figure(const GrtObjectRef &object, const std::string &name);

    void select_object(const grt::ValueRef &value);
    
  public:
    LayerTreeBE(WBContext *wb);

    virtual bool get_field(const bec::NodeId &node_id, int column, std::string &value);
    virtual bool get_field(const bec::NodeId &node_id, int column, int &value);
    virtual bool set_field(const bec::NodeId &node_id, int column, const std::string &value);

    virtual void refresh();
    virtual void refresh_node(const bec::NodeId &node);

    virtual bool activate_node(const bec::NodeId &node_id);
    
    virtual bec::MenuItemList get_popup_items_for_nodes(const std::vector<bec::NodeId> &nodes);
    virtual bool activate_popup_item_for_nodes(const std::string &name, const std::vector<bec::NodeId>& nodes);

    void refresh_selection_status();
  };
};

#endif
