/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#include "stdafx.h"

#include "mforms/mforms.h"

using namespace mforms;

//------------------------------------------------------------------------------

void GridPath::next()
{
  size_t i = _indices.size();
  if (i > 0)
    ++(_indices[i - 1]);
}

//------------------------------------------------------------------------------
void GridPath::prev()
{
  size_t i = _indices.size();
  if (i > 0 && _indices[i - 1] > 0)
    --(_indices[i - 1]);
}

//------------------------------------------------------------------------------
Grid::Grid()
           : _impl(&ControlFactory::get_instance()->_grid_impl)
{
  _impl->create(this);
}

//------------------------------------------------------------------------------
int Grid::add_column(const std::string& name)
{
  return _impl->add_column(this, name);
}

//------------------------------------------------------------------------------
void Grid::clear()
{
  _impl->clear(this);
}

//------------------------------------------------------------------------------
int Grid::get_children_count(const GridPath& path)
{
  return _impl->get_children_count(this, path);
}

//------------------------------------------------------------------------------
bool Grid::is_node_expanded(const GridPath& path)
{
  return _impl->is_node_expanded(this, path);
}

//------------------------------------------------------------------------------
void Grid::set_node_expanded(const GridPath& path, const bool expanded)
{
  _impl->set_node_expanded(this, path, expanded);
}

//------------------------------------------------------------------------------
void Grid::set_column_width(const int column, const int width)
{
  _impl->set_column_width(this, column, width);
}

//------------------------------------------------------------------------------
GridPath Grid::append_header(const std::string& group_name)
{
  return _impl->append_header(this, group_name);
}

//------------------------------------------------------------------------------
GridPath Grid::append_row(const GridPath& path)
{
  return _impl->append_row(this, path);
}

//------------------------------------------------------------------------------
GridPath Grid::insert_row(const GridPath& path)
{
  return _impl->insert_row(this, path);
}

//------------------------------------------------------------------------------
void Grid::remove_row(const GridPath& path)
{
  _impl->remove_row(this, path);
}

//------------------------------------------------------------------------------
bool Grid::set_str_value(const Path& rid, const int col_id, const std::string& cv, const bool editable)
{
  return _impl->set_str_value(this, rid, col_id, cv, editable);
}

//------------------------------------------------------------------------------
bool Grid::set_bool_value(const Path& rid, const int col_id, bool cv, const bool editable)
{
  return _impl->set_bool_value(this, rid, col_id, cv, editable);
}

//------------------------------------------------------------------------------
std::string Grid::get_value(const Path& rid, const int col_id, mforms::CellType* type)
{
  return _impl->get_value(this, rid, col_id, type);
}

//------------------------------------------------------------------------------
std::string Grid::get_cell_value(const Path& rid, const int col_id)
{
  mforms::CellType cell_type = mforms::CellInvalid;
  return _impl->get_value(this, rid, col_id, &cell_type);
}

//------------------------------------------------------------------------------
mforms::CellType Grid::get_cell_type(const Path& rid, const int col_id)
{
  mforms::CellType cell_type = mforms::CellInvalid;
  _impl->get_value(this, rid, col_id, &cell_type);
  return cell_type;
}

//------------------------------------------------------------------------------
void Grid::set_cell_type(const Path& path, const int col_id, const mforms::CellType type)
{
  _impl->set_cell_type(this, path, col_id, type);
}

//------------------------------------------------------------------------------
void Grid::set_cell_attr(const GridPath& path, const int col_id, const int attr)
{
  _impl->set_cell_attr(this, path, col_id, attr);
}

//------------------------------------------------------------------------------
bool Grid::set_fg(const Path& rid, const int col_id, const double r, const double g, const double b)
{
  return _impl->set_fg(this, rid, col_id, r, g, b);
}

//------------------------------------------------------------------------------
bool Grid::set_bg(const Path& rid, const int col_id, const double r, const double g, const double b)
{
  return _impl->set_bg(this, rid, col_id, r, g, b);
}

//------------------------------------------------------------------------------
bool Grid::set_enum_def(const Path& rid, const int col_id, std::vector<std::string>* list)
{
  return _impl->set_enum_def(this, rid, col_id, list);
}

//------------------------------------------------------------------------------
bool Grid::set_enum(const Path& rid, const int col_id, const std::vector<std::string> &list)
{
  return _impl->set_enum_def(this, rid, col_id, new std::vector<std::string>(list));
}

//------------------------------------------------------------------------------
bool Grid::set_enum_def_c(const Path& rid, const int col_id, const char** const list)
{
  return _impl->set_enum_def_c(this, rid, col_id, list);
}

//------------------------------------------------------------------------------
void Grid::shade(const Path& rid, const Shade shade, const int col_id)
{
  _impl->shade(this, rid, shade, col_id);
}

//------------------------------------------------------------------------------
void Grid::unshade(const Path& rid, const Shade shade, const int col_id)
{
  _impl->unshade(this, rid, shade, col_id);
}

//------------------------------------------------------------------------------
bool Grid::has_shade(const Path& rid, const int col_id, const Shade s)
{
  return _impl->has_shade(this, rid, col_id, s);
}

//------------------------------------------------------------------------------
void Grid::scroll_to_row(const Path& rid)
{
  _impl->scroll_to_row(this, rid);
}

//------------------------------------------------------------------------------
void Grid::set_row_tag(const Path& path, const std::string& tag)
{
  _impl->set_row_tag(this, path, tag);
}

//------------------------------------------------------------------------------
std::string Grid::get_row_tag(const Path& path)
{
  return _impl->get_row_tag(this, path);
}

//------------------------------------------------------------------------------
void Grid::set_row_caption(const Path& path, const std::string& caption)
{
  _impl->set_row_caption(this, path, caption);
}

//------------------------------------------------------------------------------
std::string Grid::get_row_caption(const Path& path)
{
  return _impl->get_row_caption(this, path);
}

//------------------------------------------------------------------------------
void Grid::set_action_icon(const Path& rid, const int col, const std::string& iconpath, const IconVisibility visible, const IconPos pos)
{
  return _impl->set_action_icon(this, rid, col, iconpath, visible, pos);
}

//------------------------------------------------------------------------------
void Grid::popup_context_menu()
{
  _impl->popup_context_menu(this);
}
