ropts = [ { 'caption': 'group_replication_group_name',
    'description': 'The name of the group.',
    'name': 'group_replication_group_name',
    'optype': { 'format': 'group_replication_group_name=value'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_start_on_boot',
    'description': 'Whether the server should start Group Replication or not during server start.',
    'name': 'group_replication_start_on_boot',
    'optype': { 'format': 'group_replication_start_on_boot=value'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_local_address',
    'description': 'The local address in host:port formatted string.',
    'name': 'group_replication_local_address',
    'optype': { 'format': 'group_replication_local_address=value'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_group_seeds',
    'description': 'A list of peer addresses, comma separated list such as host1:port1,host2:port2.',
    'name': 'group_replication_group_seeds',
    'optype': { 'format': 'group_replication_group_seeds=value'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_force_members',
    'description': 'A comma separated list of peer addresses, such as host1:port1,host2:port2.',
    'name': 'group_replication_force_members',
    'optype': { 'format': 'group_replication_force_members=value'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_bootstrap_group',
    'description': 'Configure this server to bootstrap the group.',
    'name': 'group_replication_bootstrap_group',
    'optype': { 'format': 'group_replication_bootstrap_group=value'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_poll_spin_loops',
    'description': 'The number of times the group communication thread waits',
    'name': 'group_replication_poll_spin_loops',
    'optype': { 'format': 'group_replication_poll_spin_loops=value'},
    'values': [ { 'bitsize': '32',
                  'default': '33060',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '33060',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_retry_count',
    'description': 'The number of times that a joining member tries to connect to the available donors before giving up.',
    'name': 'group_replication_recovery_retry_count',
    'optype': { 'format': 'group_replication_recovery_retry_count=value'},
    'values': [ { 'default': '33060',
                  'maximum': '31536000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_reconnect_interval',
    'description': 'The sleep time, in seconds, between reconnection attempts when no donor was found in the group.',
    'name': 'group_replication_recovery_reconnect_interval',
    'optype': { 'format': 'group_replication_recovery_reconnect_interval=value'},
    'values': [ { 'default': '60',
                  'maximum': '0',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_use_ssl',
    'description': 'Whether Group Replication recovery connection should use SSL or not.',
    'name': 'group_replication_recovery_use_ssl',
    'optype': { 'format': 'group_replication_recovery_use_ssl=value'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_ssl_ca',
    'description': 'The path to a file that contains a list of trusted SSL certificate authorities.',
    'name': 'group_replication_recovery_ssl_ca',
    'optype': { 'format': 'group_replication_recovery_ssl_ca=value'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_ssl_capath',
    'description': 'The path to a directory that contains trusted SSL certificate authority certificates.',
    'name': 'group_replication_recovery_ssl_capath',
    'optype': { 'format': 'group_replication_recovery_ssl_capath=value'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_ssl_cert',
    'description': 'The name of the SSL certificate file to use for establishing a secure connection.',
    'name': 'group_replication_recovery_ssl_cert',
    'optype': { 'format': 'group_replication_recovery_ssl_cert=value'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_ssl_key',
    'description': 'The name of the SSL key file to use for establishing a secure connection.',
    'name': 'group_replication_recovery_ssl_key',
    'optype': { 'format': 'group_replication_recovery_ssl_key=value'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_ssl_crl',
    'description': 'The path to a directory that contains files containing certificate revocation lists.',
    'name': 'group_replication_recovery_ssl_crl',
    'optype': { 'format': 'group_replication_recovery_ssl_crl=value'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_ssl_crlpath',
    'description': 'The path to a directory that contains files containing certificate revocation lists.',
    'name': 'group_replication_recovery_ssl_crlpath',
    'optype': { 'format': 'group_replication_recovery_ssl_crlpath=value'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_ssl_verify_server_cert',
    'description': "Make the recovery process check the server's Common Name value in the donor sent certificate.",
    'name': 'group_replication_recovery_ssl_verify_server_cert',
    'optype': { 'format': 'group_replication_recovery_ssl_verify_server_cert=value'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_recovery_complete_at',
    'description': 'Recovery policies when handling cached transactions after state transfer. This option specifies whether a member is marked online after it has received all transactions that it missed before it joined the group (TRANSACTIONS_CERTIFIED) or after it has received and applied them (TRANSACTIONS_APPLIED).',
    'name': 'group_replication_recovery_complete_at',
    'optype': { 'format': 'group_replication_recovery_complete_at=value'},
    'values': [ { 'choice': [ 'TRANSACTIONS_CERTIFIED',
                              'TRANSACTIONS_APPLIED'],
                  'default': 'OFF',
                  'type': 'enum'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_components_stop_timeout',
    'description': 'Timeout, in seconds, that the plugin waits for each of the components when shutting down.',
    'name': 'group_replication_components_stop_timeout',
    'optype': { 'format': 'group_replication_components_stop_timeout=value'},
    'values': [{ 'type': 'integer'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_allow_local_lower_version_join',
    'description': 'Allow the current server to join the group even if it has a lower plugin version than the group.',
    'name': 'group_replication_allow_local_lower_version_join',
    'optype': { 'format': 'group_replication_allow_local_lower_version_join=value'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_allow_local_disjoint_gtids_join',
    'description': 'Allow the current server to join the group even if it has transactions not present in the group.',
    'name': 'group_replication_allow_local_disjoint_gtids_join',
    'optype': { 'format': 'group_replication_allow_local_disjoint_gtids_join=value'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_auto_increment_increment',
    'description': 'Determines the interval between successive column values for transactions that execute on this server.',
    'name': 'group_replication_auto_increment_increment',
    'optype': { 'format': 'group_replication_auto_increment_increment=value'},
    'values': [ { 'default': '7',
                  'maximum': '65535',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_compression_threshold',
    'description': 'The value in bytes above which (LZ4) compression is enforced. When set to zero, deactivates compression.',
    'name': 'group_replication_compression_threshold',
    'optype': { 'format': 'group_replication_compression_threshold=value'},
    'values': [ { 'default': '1000000',
                  'maximum': '4294967296',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_gtid_assignment_block_size',
    'description': 'The number of consecutive GTIDs that are reserved for each member. Each member consumes its blocks and reserve more when needed.',
    'name': 'group_replication_gtid_assignment_block_size',
    'optype': { 'format': 'group_replication_gtid_assignment_block_size=value'},
    'values': [ { 'bitsize': '32',
                  'default': '1000000',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1000000',
                  'maximum': '18446744073709547520',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_ssl_mode',
    'description': 'Specifies the security state of the connection between Group Replication members.',
    'name': 'group_replication_ssl_mode',
    'optype': { 'format': 'group_replication_ssl_mode=value'},
    'values': [ { 'choice': [ 'DISABLED',
                              'REQUIRED',
                              'VERIFY_CA',
                              'VERIFY_IDENTITY'],
                  'default': 'OFF',
                  'type': 'enum'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_single_primary_mode',
    'description': 'Instructs the group to use a single server for the read/write workload.',
    'name': 'group_replication_single_primary_mode',
    'optype': { 'format': 'group_replication_single_primary_mode=value'},
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_enforce_update_everywhere_checks',
    'description': 'Enable or disable strict consistency checks for multi-master update everywhere.',
    'name': 'group_replication_enforce_update_everywhere_checks',
    'optype': { 'format': 'group_replication_enforce_update_everywhere_checks=value'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_flow_control_mode',
    'description': 'Specifies the mode used for flow control.',
    'name': 'group_replication_flow_control_mode',
    'optype': { 'format': 'group_replication_flow_control_mode=value'},
    'values': [ { 'choice': ['DISABLED', 'QUOTA'],
                  'default': 'QUOTA',
                  'type': 'enum'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_flow_control_certifier_threshold',
    'description': 'Specifies the number of waiting transactions in the certifier queue that trigger flow control.',
    'name': 'group_replication_flow_control_certifier_threshold',
    'optype': { 'format': 'group_replication_flow_control_certifier_threshold=value'},
    'values': [ { 'default': '25000',
                  'maximum': '2147483648',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_flow_control_applier_threshold',
    'description': 'Specifies the number of waiting transactions in the applier queue that trigger flow control.',
    'name': 'group_replication_flow_control_applier_threshold',
    'optype': { 'format': 'group_replication_flow_control_applier_threshold=value'},
    'values': [ { 'default': '25000',
                  'maximum': '2147483648',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'group_replication_ip_whitelist',
    'description': 'The list of hosts permitted to connect to the group.',
    'name': 'group_replication_ip_whitelist',
    'optype': { 'format': 'group_replication_ip_whitelist=value'},
    'values': [{ 'default': 'AUTOMATIC', 'type': 'string'}],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'mysqlx_port',
    'description': 'Port on which the X Plugin accepts connections',
    'name': 'mysqlx_port',
    'values': [ { 'default': '33060',
                  'maximum': '65535',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_max_connections',
    'description': 'Maximum number of concurrent client connections the can accept',
    'name': 'mysqlx_max_connections',
    'values': [ { 'default': '100',
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_min_worker_threads',
    'description': 'Minimum number of worker threads.',
    'name': 'mysqlx_min_worker_threads',
    'values': [ { 'default': '2',
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_idle_worker_thread_timeout',
    'description': 'Time in seconds after which an idle worker thread is terminated',
    'name': 'mysqlx_idle_worker_thread_timeout',
    'values': [ { 'default': '60',
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_max_allowed_packet',
    'description': 'Size of largest message that a client is going to process',
    'name': 'mysqlx_max_allowed_packet',
    'values': [ { 'default': '1048576',
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_connect_timeout',
    'description': 'Maximum permitted waiting time in seconds for a connection to set up a session',
    'name': 'mysqlx_connect_timeout',
    'values': [ { 'default': '30',
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_ssl',
    'description': 'Enabled when using SSL with',
    'name': 'mysqlx_ssl',
    'values': [{ 'type': 'integer'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_ssl_key',
    'description': 'Path to X509 key in PEM format.',
    'name': 'mysqlx_ssl_key',
    'values': [{ 'type': 'filename'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_ssl_ca',
    'description': 'Path to SSL CA file in PEM format',
    'name': 'mysqlx_ssl_ca',
    'values': [{ 'type': 'filename'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_ssl_capath',
    'description': 'SSL CA file directory',
    'name': 'mysqlx_ssl_capath',
    'values': [{ 'type': 'dirname'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_ssl_cert',
    'description': 'Path to X509 certficate in PEM format',
    'name': 'mysqlx_ssl_cert',
    'values': [{ 'type': 'filename'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_ssl_cipher',
    'description': 'SSL cipher to use',
    'name': 'mysqlx_ssl_cipher',
    'values': [{ 'type': 'string'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_ssl_crl',
    'description': 'Certificate revocation list',
    'name': 'mysqlx_ssl_crl',
    'values': [{ 'type': 'filename'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysqlx_ssl_crlpath',
    'description': 'Certificate revocation list path',
    'name': 'mysqlx_ssl_crlpath',
    'values': [{ 'type': 'dirname'}],
    'versions': [(), ((5, 7), (8, 0)), ()]},
  { 'caption': 'abort-slave-event-count',
    'description': 'Option used by mysql-test for debugging and testing of replication',
    'name': 'abort-slave-event-count',
    'values': [{ 'default': '0', 'minimum': '0', 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'allow-suspicious-udfs',
    'description': 'Allows use of UDFs consisting of only one symbol xxx() without corresponding xxx_init() or xxx_deinit()',
    'name': 'allow-suspicious-udfs',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 10), (5, 0, 3)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ansi',
    'description': 'Use ANSI SQL syntax instead of MySQL syntax',
    'name': 'ansi',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'audit-log',
    'description': 'Whether to activate the audit log plugin',
    'name': 'audit-log',
    'optype': { 'format': 'audit-log[=value]'},
    'values': [ { 'choice': ['ON', 'OFF', 'FORCE', 'FORCE_PLUS_PERMANENT'],
                  'default': 'ON',
                  'type': 'enum'}],
    'versions': [ ((5, 5, 28), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'audit_log_buffer_size',
    'description': 'The size of the audit log buffer',
    'name': 'audit_log_buffer_size',
    'optype': { 'format': 'audit_log_buffer_size=value'},
    'values': [ { 'bitsize': '32',
                  'default': '1048576',
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1048576',
                  'maximum': '18446744073709547520',
                  'minimum': '4096',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 28), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'audit_log_connection_policy',
    'description': 'Audit logging policy for connection-related events',
    'name': 'audit_log_connection_policy',
    'optype': { 'format': 'audit_log_connection_policy=value'},
    'values': [ { 'choice': ['ALL', 'ERRORS', 'NONE'],
                  'default': 'ALL',
                  'type': 'enum'}],
    'versions': [((5, 6, 20), (5, 7, 9)), ((5, 6), (5, 7)), ()]},
  { 'caption': 'audit_log_exclude_accounts',
    'description': 'Accounts not to audit',
    'name': 'audit_log_exclude_accounts',
    'optype': { 'format': 'audit_log_exclude_accounts=value'},
    'values': [{ 'default': 'NULL', 'type': 'string'}],
    'versions': [((5, 6, 20), (5, 7, 9)), ((5, 6), (5, 7)), ()]},
  { 'caption': 'audit_log_file',
    'description': 'The name of the audit log file',
    'name': 'audit_log_file',
    'optype': { 'format': 'audit_log_file=file_name'},
    'values': [{ 'default': 'audit.log', 'type': 'filename'}],
    'versions': [ ((5, 5, 28), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'audit_log_format',
    'description': 'The audit log file format',
    'name': 'audit_log_format',
    'optype': { 'format': 'audit_log_format=value'},
    'values': [ { 'choice': ['OLD', 'NEW'],
                  'default': 'OLD',
                  'inversion': (5, 5, 34),
                  'outversion': (5, 5, 99),
                  'type': 'enum'},
                { 'choice': ['OLD', 'NEW'],
                  'default': 'OLD',
                  'inversion': (5, 6, 14),
                  'outversion': (5, 6, 99),
                  'type': 'enum'},
                { 'choice': ['OLD', 'NEW'],
                  'default': 'NEW',
                  'inversion': (5, 7, 9),
                  'type': 'enum'}],
    'versions': [ ((5, 5, 34), (5, 6, 14), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'audit_log_include_accounts',
    'description': 'Accounts to audit',
    'name': 'audit_log_include_accounts',
    'optype': { 'format': 'audit_log_include_accounts=value'},
    'values': [{ 'default': 'NULL', 'type': 'string'}],
    'versions': [((5, 6, 20), (5, 7, 9)), ((5, 6), (5, 7)), ()]},
  { 'caption': 'audit_log_policy',
    'description': 'Audit logging policy',
    'name': 'audit_log_policy',
    'optype': { 'format': 'audit_log_policy=value'},
    'values': [ { 'choice': ['ALL', 'LOGINS', 'QUERIES', 'NONE'],
                  'default': 'ALL',
                  'type': 'enum'}],
    'versions': [ ((5, 5, 28), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'audit_log_rotate_on_size',
    'description': 'Close and reopen the audit log file at a certain size',
    'name': 'audit_log_rotate_on_size',
    'optype': { 'format': 'audit_log_rotate_on_size=N'},
    'values': [{ 'default': '0', 'type': 'integer'}],
    'versions': [ ((5, 5, 28), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'audit_log_statement_policy',
    'description': 'Audit logging policy for statement-related events',
    'name': 'audit_log_statement_policy',
    'optype': { 'format': 'audit_log_statement_policy=value'},
    'values': [ { 'choice': ['ALL', 'ERRORS', 'NONE'],
                  'default': 'ALL',
                  'type': 'enum'}],
    'versions': [((5, 6, 20), (5, 7, 9)), ((5, 6), (5, 7)), ()]},
  { 'caption': 'audit_log_strategy',
    'description': 'The audit logging strategy',
    'name': 'audit_log_strategy',
    'optype': { 'format': 'audit_log_strategy=value'},
    'values': [ { 'choice': [ 'ASYNCHRONOUS',
                              'PERFORMANCE',
                              'SEMISYNCHRONOUS',
                              'SYNCHRONOUS'],
                  'default': 'ASYNCHRONOUS',
                  'type': 'enum'}],
    'versions': [ ((5, 5, 28), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'authentication_windows_log_level',
    'description': 'Windows authentication plugin logging level',
    'name': 'authentication_windows_log_level',
    'values': [ { 'default': '0',
                  'maximum': '4',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 16), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'authentication_windows_use_principal_name',
    'description': 'Whether to use Windows authentication plugin principal name',
    'name': 'authentication_windows_use_principal_name',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 5, 16), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'auto_generate_certs',
    'description': 'Whether to autogenerate SSL key and certificate files',
    'name': 'auto_generate_certs',
    'optype': { 'format': 'auto_generate_certs[={OFF|ON}]'},
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'autocommit',
    'description': 'Sets the autocommit mode',
    'name': 'autocommit',
    'optype': { 'inversion': '5.5.8'},
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'avoid_temporal_upgrade',
    'description': 'Whether ALTER TABLE should upgrade pre-5.6.4 temporal columns',
    'name': 'avoid_temporal_upgrade',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 24), (5, 7, 6)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'backup_elevation',
    'description': 'Enable or disable BACKUP DATABASE privilege elevation',
    'name': 'backup_elevation',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((6, 0, 14),), ((6, 0),), ()]},
  { 'caption': 'backup_history_log',
    'description': 'Enable or disable MySQL Backup history log',
    'name': 'backup_history_log',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((6, 0, 8),), ((6, 0),), ()]},
  { 'caption': 'backup_history_log_file',
    'description': 'Name of the MySQL Backup history log file',
    'name': 'backup_history_log_file',
    'values': [{ 'default': 'backup_history.log', 'type': 'filename'}],
    'versions': [((6, 0, 8),), ((6, 0),), ()]},
  { 'caption': 'backup_progress_log',
    'description': 'Enable or disable MySQL Backup progress log',
    'name': 'backup_progress_log',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((6, 0, 8),), ((6, 0),), ()]},
  { 'caption': 'backup_progress_log_file',
    'description': 'Name of the MySQL Backup progress log file',
    'name': 'backup_progress_log_file',
    'values': [{ 'default': 'backup_progress.log', 'type': 'filename'}],
    'versions': [((6, 0, 8),), ((6, 0),), ()]},
  { 'caption': 'backupdir',
    'description': 'Default backup image file directory',
    'name': 'backupdir',
    'values': [{ 'type': 'dirname'}],
    'versions': [((6, 0, 7),), ((6, 0),), ()]},
  { 'caption': 'basedir',
    'description': 'Path of installation directory',
    'name': 'basedir',
    'values': [{ 'type': 'dirname'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'big-tables',
    'description': 'Allow big result sets by saving all temporary sets on file',
    'name': 'big-tables',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'bind-address',
    'description': 'IP address or host name to bind to',
    'name': 'bind-address',
    'values': [ { 'default': '0.0.0.0',
                  'outversion': (5, 6, 5),
                  'type': 'string'},
                { 'default': '*', 'inversion': (5, 6, 6), 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'binlog-checksum',
    'description': 'Enable/disable binary log checksums',
    'name': 'binlog-checksum',
    'values': [ { 'choice': ['NONE', 'CRC32'],
                  'default': 'NONE',
                  'outversion': (5, 6, 5),
                  'type': 'string'},
                { 'choice': ['NONE', 'CRC32'],
                  'default': 'CRC32',
                  'inversion': (5, 6, 6),
                  'type': 'string'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'binlog-do-db',
    'description': 'Limits binary logging to specific databases',
    'name': 'binlog-do-db',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'binlog-format',
    'description': 'Specifies the format of the binary log',
    'name': 'binlog-format',
    'values': [ { 'choice': ['ROW', 'STATEMENT'],
                  'default': 'STATEMENT',
                  'inversion': (5, 1, 5),
                  'outversion': (5, 1, 7),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'STATEMENT',
                  'inversion': (5, 1, 8),
                  'outversion': (5, 1, 11),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'MIXED',
                  'inversion': (5, 1, 12),
                  'outversion': (5, 1, 28),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'STATEMENT',
                  'inversion': (5, 1, 29),
                  'outversion': (5, 7, 6),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'ROW',
                  'inversion': (5, 7, 7),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'MIXED',
                  'inversion': (5, 1, 14),
                  'outversion': (5, 1, 15),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'MIXED',
                  'inversion': (5, 1, 16),
                  'outversion': (5, 1, 34),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'MIXED',
                  'inversion': (5, 1, 19),
                  'outversion': (5, 1, 73),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'MIXED',
                  'inversion': (5, 1, 32),
                  'outversion': (5, 1, 73),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'MIXED',
                  'inversion': (5, 1, 39),
                  'outversion': (5, 1, 51),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'STATEMENT',
                  'inversion': (5, 5, 15),
                  'outversion': (5, 5, 30),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'MIXED',
                  'inversion': (5, 5, 31),
                  'outversion': (5, 5, 99),
                  'type': 'enum'},
                { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                  'default': 'MIXED',
                  'inversion': (5, 6, 10),
                  'outversion': (5, 6, 99),
                  'type': 'enum'}],
    'versions': [ ((5, 1, 5),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'binlog-ignore-db',
    'description': 'Tells the master that updates to the given database should not be logged to the binary log',
    'name': 'binlog-ignore-db',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'binlog-row-event-max-size',
    'description': 'Binary log max event size',
    'name': 'binlog-row-event-max-size',
    'values': [ { 'bitsize': '32',
                  'default': '1024',
                  'maximum': '4294967295',
                  'minimum': '256',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '8192',
                  'inversion': (5, 6, 6),
                  'maximum': '4294967295',
                  'minimum': '256',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1024',
                  'maximum': '18446744073709547520',
                  'minimum': '256',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1024',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '256',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '8192',
                  'inversion': (5, 6, 6),
                  'maximum': '18446744073709551615',
                  'minimum': '256',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 5),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'binlog-rows-query-log-events',
    'description': 'Enables logging of rows query log events when using row-based logging. Disabled by default. Do not enable when producing logs for pre-5.6.2 slaves/readers.',
    'name': 'binlog-rows-query-log-events',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'binlog_cache_size',
    'description': 'Size of the cache to hold the SQL statements for the binary log during a transaction',
    'name': 'binlog_cache_size',
    'values': [ { 'bitsize': '32',
                  'default': '32768',
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '32768',
                  'maximum': '18446744073709547520',
                  'minimum': '4096',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '32768',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '4096',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'binlog_direct_non_transactional_updates',
    'description': 'Causes updates using statement format to nontransactional engines to be written directly to binary log. See documentation before using.',
    'name': 'binlog_direct_non_transactional_updates',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 44), (5, 5, 2), (6, 0, 14)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'binlog_error_action',
    'description': 'Controls what happens when the server cannot write to the binary log.',
    'name': 'binlog_error_action',
    'values': [ { 'choice': ['IGNORE_ERROR', 'ABORT_SERVER'],
                  'default': 'IGNORE_ERROR',
                  'type': 'enum'},
                { 'choice': ['IGNORE_ERROR', 'ABORT_SERVER'],
                  'default': 'ABORT_SERVER',
                  'inversion': (5, 7, 7),
                  'type': 'enum'}],
    'versions': [((5, 6, 22), (5, 7, 6)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'binlog_group_commit_sync_delay',
    'description': 'Sets the number of microseconds to wait before synchronizing transactions to disk.',
    'name': 'binlog_group_commit_sync_delay',
    'values': [ { 'default': '0',
                  'maximum': '1000000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'binlog_group_commit_sync_no_delay_count',
    'description': 'Sets the maximum number of transactions to wait for before aborting the current delay specified by binlog_group_commit_sync_delay.',
    'name': 'binlog_group_commit_sync_no_delay_count',
    'values': [ { 'default': '0',
                  'maximum': '1000000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'binlog_gtid_simple_recovery',
    'description': 'Controls how binary logs are iterated during GTID recovery',
    'name': 'binlog_gtid_simple_recovery',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'},
                { 'default': 'true',
                  'inversion': (5, 7, 7),
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [((5, 7, 6), (5, 6, 23)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'binlog_row_image',
    'description': 'Use full or minimal images when logging row changes. Allowed values are full, minimal, and noblob.',
    'name': 'binlog_row_image',
    'values': [ { 'choice': ['full', 'minimal', 'noblob'],
                  'default': 'full',
                  'type': 'enum'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'binlog_stmt_cache_size',
    'description': 'Size of the cache to hold nontransactional statements for the binary log during a transaction',
    'name': 'binlog_stmt_cache_size',
    'values': [ { 'bitsize': '32',
                  'default': '32768',
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '32768',
                  'maximum': '18446744073709551615',
                  'minimum': '4096',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 9), (5, 6, 1)),
                  ((5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'binlogging_impossible_mode',
    'description': 'Deprecated and will be removed in a future version. Use the renamed binlog_error_action instead.',
    'name': 'binlogging_impossible_mode',
    'values': [ { 'choice': ['IGNORE_ERROR', 'ABORT_SERVER'],
                  'default': 'IGNORE_ERROR',
                  'type': 'enum'}],
    'versions': [((5, 6, 20), (5, 7, 5)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'block_encryption_mode',
    'description': 'Mode for block-based encryption algorithms',
    'name': 'block_encryption_mode',
    'optype': { 'format': 'block_encryption_mode=#'},
    'values': [{ 'default': 'aes-128-ecb', 'type': 'string'}],
    'versions': [((5, 6, 17), (5, 7, 4)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'bootstrap',
    'description': 'Used by mysql installation scripts',
    'name': 'bootstrap',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0)),
                  ((8, 0, 0),)]},
  { 'caption': 'bulk_insert_buffer_size',
    'description': 'Size of tree cache used in bulk insert optimization',
    'name': 'bulk_insert_buffer_size',
    'values': [ { 'bitsize': '32',
                  'default': '8388608',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '8388608',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '8388608',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'character-set-filesystem',
    'description': 'Set the file system character set',
    'name': 'character-set-filesystem',
    'values': [{ 'default': 'binary', 'type': 'string'}],
    'versions': [ ((5, 0, 19), (5, 1, 6)),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'character-set-server',
    'description': 'Specify default character set',
    'name': 'character-set-server',
    'values': [{ 'default': 'latin1', 'type': 'string'}],
    'versions': [ ((4, 1, 3),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'character-sets-dir',
    'description': 'Directory where character sets are installed',
    'name': 'character-sets-dir',
    'values': [{ 'type': 'dirname'}],
    'versions': [ ((4, 1, 2),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'check_proxy_users',
    'description': 'Whether built-in authentication plugins do proxying',
    'name': 'check_proxy_users',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 7),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'chroot',
    'description': 'Chroot mysqld daemon during startup',
    'name': 'chroot',
    'values': [{ 'type': 'dirname'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'collation-server',
    'description': 'Specify default collation',
    'name': 'collation-server',
    'values': [{ 'default': 'latin1_swedish_ci', 'type': 'string'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'completion_type',
    'description': 'Default completion type',
    'name': 'completion_type',
    'values': [ { 'choice': ['0', '1', '2'],
                  'default': '0',
                  'inversion': (5, 0, 3),
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'choice': ['NO_CHAIN', 'CHAIN', 'RELEASE', '0', '1', '2'],
                  'default': 'NO_CHAIN',
                  'inversion': (5, 5, 3),
                  'type': 'enum'},
                { 'choice': ['0', '1', '2'],
                  'default': '0',
                  'inversion': (6, 0, 0),
                  'outversion': (6, 0, 14),
                  'type': 'integer'},
                { 'choice': ['NO_CHAIN', 'CHAIN', 'RELEASE', '0', '1', '2'],
                  'default': 'NO_CHAIN',
                  'inversion': (6, 0, 14),
                  'type': 'enum'}],
    'versions': [ ((5, 0, 3),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'concurrent_insert',
    'description': 'Use concurrent insert with MyISAM',
    'disabledby': 'skip-concurrent-insert',
    'name': 'concurrent_insert',
    'values': [ { 'default': 'true',
                  'off': 'false',
                  'on': 'true',
                  'outversion': (5, 0, 5),
                  'type': 'boolean'},
                { 'choice': ['0', '1', '2'],
                  'default': '1',
                  'inversion': (5, 0, 6),
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'choice': ['NEVER', 'AUTO', 'ALWAYS', '0', '1', '2'],
                  'default': 'AUTO',
                  'inversion': (5, 5, 3),
                  'type': 'enum'},
                { 'choice': ['0', '1', '2'],
                  'default': '1',
                  'inversion': (6, 0, 0),
                  'outversion': (6, 0, 14),
                  'type': 'integer'},
                { 'choice': ['NEVER', 'AUTO', 'ALWAYS', '0', '1', '2'],
                  'default': 'AUTO',
                  'inversion': (6, 0, 14),
                  'type': 'enum'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'connection_control_failed_connections_threshold',
    'description': 'Consecutive failed connection attempts before delays occur',
    'name': 'connection_control_failed_connections_threshold',
    'values': [ { 'default': '3',
                  'maximum': '2147483647',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 6, 35), (5, 7, 17), (8, 0, 1)),
                  ((5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'connection_control_max_connection_delay',
    'description': 'Maximum delay (milliseconds) for server response to failed connection attempts',
    'name': 'connection_control_max_connection_delay',
    'values': [ { 'default': '2147483647',
                  'maximum': '2147483647',
                  'minimum': '1000',
                  'type': 'integer'}],
    'versions': [ ((5, 6, 35), (5, 7, 17), (8, 0, 1)),
                  ((5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'connection_control_min_connection_delay',
    'description': 'Minimum delay (milliseconds) for server response to failed connection attempts',
    'name': 'connection_control_min_connection_delay',
    'values': [ { 'default': '1000',
                  'maximum': '2147483647',
                  'minimum': '1000',
                  'type': 'integer'}],
    'versions': [ ((5, 6, 35), (5, 7, 17), (8, 0, 1)),
                  ((5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'connect_timeout',
    'description': "Number of seconds the mysqld server waits for a connect packet before responding with 'Bad handshake'",
    'name': 'connect_timeout',
    'values': [ { 'default': '5',
                  'maximum': '31536000',
                  'minimum': '2',
                  'outversion': (5, 0, 51),
                  'type': 'integer'},
                { 'default': '10',
                  'inversion': (5, 0, 52),
                  'maximum': '31536000',
                  'minimum': '2',
                  'outversion': (5, 0, 99),
                  'type': 'integer'},
                { 'default': '5',
                  'inversion': (5, 1, 0),
                  'maximum': '31536000',
                  'minimum': '2',
                  'outversion': (5, 1, 22),
                  'type': 'integer'},
                { 'default': '10',
                  'inversion': (5, 1, 23),
                  'maximum': '31536000',
                  'minimum': '2',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'console',
    'description': 'Write error output on screen; do not remove the console window on Windows',
    'name': 'console',
    'values': [ { 'off': '0',
                  'on': '1',
                  'platform': 'windows',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'core-file',
    'description': 'Write core file on server crashes',
    'name': 'core-file',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'create_old_temporals',
    'description': 'Use pre-5.6.4 storage format for temporal types when creating tables. Intended for use in replication and upgrades/downgrades between NDB 7.2 and NDB 7.3/7.4.',
    'name': 'create_old_temporals',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'outversion': (5, 6, 99),
                  'type': 'boolean'}],
    'versions': [((5, 6, 25), (5, 6, 25)), ((5, 6),), ((5, 7),)]},
  { 'caption': 'daemon_memcached_enable_binlog',
    'description': '',
    'name': 'daemon_memcached_enable_binlog',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'daemon_memcached_engine_lib_name',
    'description': 'Specifies the shared library that implements the InnoDB memcached plugin',
    'name': 'daemon_memcached_engine_lib_name',
    'values': [{ 'default': 'innodb_engine.so', 'type': 'filename'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'daemon_memcached_engine_lib_path',
    'description': 'Path of directory that contains the shared library that implements the InnoDB memcached plugin',
    'name': 'daemon_memcached_engine_lib_path',
    'values': [{ 'default': 'NULL', 'type': 'dirname'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'daemon_memcached_option',
    'description': 'Space-separated options that are passed to the underlying memcached daemon on startup',
    'name': 'daemon_memcached_option',
    'values': [{ 'default': '', 'type': 'string'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'daemon_memcached_r_batch_size',
    'description': 'Specifies how many memcached read operations to perform before doing a COMMIT to start a new transaction',
    'name': 'daemon_memcached_r_batch_size',
    'values': [{ 'default': '1', 'type': 'integer'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'daemon_memcached_w_batch_size',
    'description': 'Specifies how many memcached write operations to perform before doing a COMMIT to start a new transaction',
    'name': 'daemon_memcached_w_batch_size',
    'values': [{ 'default': '1', 'type': 'integer'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'daemonize',
    'description': 'Run as System V daemon',
    'name': 'daemonize',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'datadir',
    'description': 'Path of data directory',
    'name': 'datadir',
    'values': [{ 'type': 'dirname'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'debug',
    'description': 'Output debug log; supported only if MySQL was built with debugging support',
    'name': 'debug',
    'values': [ { 'default': 'd:t:i:o,/tmp/mysqld.trace',
                  'platform': 'unix',
                  'type': 'string'},
                { 'default': 'd:t:i:O,\\mysqld.trace',
                  'platform': 'windows',
                  'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'debug-sync-timeout',
    'description': 'Timeout for Debug Sync synchronization points',
    'name': 'debug-sync-timeout',
    'values': [{ 'type': 'integer'}],
    'versions': [ ((5, 1, 41), (6, 0, 6)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'default-character-set',
    'description': 'Specify default character set',
    'name': 'default-character-set',
    'values': [{ 'type': 'string'}],
    'versions': [ ((4, 1, 3),),
                  ((4, 1), (5, 0), (5, 1), (5, 5)),
                  ((5, 5, 3),)]},
  { 'caption': 'default-collation',
    'description': 'Specify default collation',
    'name': 'default-collation',
    'values': [{ 'type': 'string'}],
    'versions': [(), ((4, 1),), ()]},
  { 'caption': 'default-storage-engine',
    'description': 'The default storage engine (table type) for tables',
    'name': 'default-storage-engine',
    'values': [ { 'default': 'MyISAM',
                  'outversion': (5, 5, 4),
                  'type': 'enum'},
                { 'default': 'InnoDB',
                  'inversion': (5, 5, 5),
                  'type': 'enum'},
                { 'default': 'MyISAM',
                  'inversion': (6, 0, 0),
                  'type': 'enum'}],
    'versions': [ ((4, 1, 2),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'default-table-type',
    'description': 'This option is a synonym for --default-storage-engine',
    'name': 'default-table-type',
    'values': [{ 'type': 'string'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)), ((6, 0, 8),)]},
  { 'caption': 'default-time-zone',
    'description': 'Specify default time zone',
    'name': 'default-time-zone',
    'values': [{ 'type': 'string'}],
    'versions': [ ((4, 1, 3),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'default_authentication_plugin',
    'description': 'The default authentication plugin',
    'name': 'default_authentication_plugin',
    'optype': { 'format': 'default-authentication-plugin=plugin_name'},
    'values': [ { 'choice': ['mysql_native_password', 'sha256_password'],
                  'default': 'mysql_native_password',
                  'type': 'enum'}],
    'versions': [((5, 7, 2),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'default_password_lifetime',
    'description': 'Age in days when passwords effectively expire',
    'name': 'default_password_lifetime',
    'optype': { 'format': 'default_password_lifetime=#'},
    'values': [ { 'default': '360',
                  'maximum': '65535',
                  'minimum': '0',
                  'outversion': (5, 7, 10),
                  'type': 'integer'},
                { 'default': '0',
                  'inversion': (5, 7, 11),
                  'maximum': '65535',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 4),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'default_tmp_storage_engine',
    'description': 'The default storage engine (table type) for TEMPORARY tables',
    'name': 'default_tmp_storage_engine',
    'values': [{ 'default': 'InnoDB', 'type': 'enum'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'default_week_format',
    'description': 'The default week format used by WEEK() functions',
    'name': 'default_week_format',
    'values': [ { 'default': '0',
                  'maximum': '7',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'delay-key-write',
    'description': 'Type of DELAY_KEY_WRITE',
    'name': 'delay-key-write',
    'values': [ { 'choice': ['ON', 'OFF', 'ALL'],
                  'default': 'ON',
                  'type': 'enum'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'delayed_insert_limit',
    'description': 'After inserting delayed_insert_limit rows, the INSERT DELAYED handler will check if there are any SELECT statements pending. If so, it allows these to execute before continuing',
    'name': 'delayed_insert_limit',
    'values': [ { 'bitsize': '32',
                  'default': '100',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '100',
                  'maximum': '18446744073709547520',
                  'minimum': '1',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '100',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'delayed_insert_timeout',
    'description': 'How many seconds an INSERT DELAYED thread should wait for INSERT statements before terminating',
    'name': 'delayed_insert_timeout',
    'values': [{ 'default': '300', 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'delayed_queue_size',
    'description': 'What size queue (in rows) should be allocated for handling INSERT DELAYED',
    'name': 'delayed_queue_size',
    'values': [ { 'bitsize': '32',
                  'default': '1000',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1000',
                  'maximum': '18446744073709547520',
                  'minimum': '1',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1000',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'des-key-file',
    'description': 'Load keys for des_encrypt() and des_encrypt from given file',
    'name': 'des-key-file',
    'values': [],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'disable_gtid_unsafe_statements',
    'description': 'Obsolete: Replaced by enforce_gtid_consistency in MySQL 5.6.9.',
    'name': 'disable_gtid_unsafe_statements',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [((5, 6, 5),), ((5, 6),), ((5, 6, 9),)]},
  { 'caption': 'disable-partition-engine-check',
    'description': 'Whether to disable the startup check for tables with nonnative partitioning',
    'name': 'disable-partition-engine-check',
    'values': [],
    'versions': [((5, 7, 17),), ((5, 7),), ()]},
  { 'caption': 'disabled_storage_engines',
    'description': 'Storage engines that cannot be used to create tables',
    'name': 'disabled_storage_engines',
    'values': [{ 'default': 'empty string', 'type': 'string'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'disconnect-slave-event-count',
    'description': 'Option used by mysql-test for debugging and testing of replication',
    'name': 'disconnect-slave-event-count',
    'values': [{ 'default': '0', 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'disconnect_on_expired_password',
    'description': 'Whether the server disconnects clients with expired passwords if clients cannot handle such accounts',
    'name': 'disconnect_on_expired_password',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 10), (5, 7, 1)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'div_precision_increment',
    'description': "Scale of the result of '/' operator will be increased by this many digits",
    'name': 'div_precision_increment',
    'values': [ { 'default': '4',
                  'maximum': '30',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 6),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'early-plugin-load',
    'description': 'Specify plugins to load before loading mandatory built-in plugins and before storage engine initialization',
    'name': 'early-plugin-load',
    'values': [ { 'default': 'keyring_file plugin library file name',
                  'inversion': (5, 7, 11),
                  'outversion': (5, 7, 11),
                  'type': 'string'},
                { 'default': 'empty string',
                  'inversion': (5, 7, 12),
                  'type': 'string'}],
    'versions': [((5, 7, 11), (8, 0, 0)), ((5, 7), (8, 0)), ()]},
  { 'caption': 'enable-locking',
    'description': 'Deprecated option, use --external-locking instead',
    'name': 'enable-locking',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                  ((5, 5, 3),)]},
  { 'caption': 'enable-named-pipe',
    'description': 'Enable support for named pipes.',
    'name': 'enable-named-pipe',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'enable-pstack',
    'description': 'Print a symbolic stack trace on failure',
    'name': 'enable-pstack',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                  ((5, 5, 7),)]},
  { 'caption': 'enforce_gtid_consistency',
    'description': 'Prevents execution of statements that cannot be logged in a transactionally safe manner',
    'name': 'enforce_gtid_consistency',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'outversion': (5, 7, 5),
                  'type': 'boolean'},
                { 'choice': ['OFF', 'ON', 'WARN'],
                  'default': 'OFF',
                  'inversion': (5, 7, 6),
                  'type': 'enum'}],
    'versions': [((5, 6, 9),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'engine-condition-pushdown',
    'description': 'Push supported query conditions to the storage engine',
    'name': 'engine-condition-pushdown',
    'values': [ { 'default': 'off',
                  'inversion': (5, 0, 3),
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 0, 99),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (5, 1, 0),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 3),),
                  ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                  ((5, 6, 1),)]},
  { 'caption': 'event-scheduler',
    'description': 'Enable/disable and start/stop the event scheduler. Note that this variable underwent significant changes in behavior and permitted values in MySQL 5.1.11 and 5.1.12',
    'name': 'event-scheduler',
    'values': [ { 'choice': ['ON', 'OFF', 'DISABLED'],
                  'default': 'OFF',
                  'type': 'enum'}],
    'versions': [ ((5, 1, 6),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'executed-gtids-compression-period',
    'description': 'Deprecated and will be removed in a future version. Use the renamed gtid-executed-compression-period instead.',
    'name': 'executed-gtids-compression-period',
    'values': [ { 'default': '1000',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'exit-info',
    'description': 'Used for debugging; Use at your own risk!',
    'name': 'exit-info',
    'values': [{ 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'expire_logs_days',
    'description': 'If nonzero, binary logs will be purged after expire_logs_days days; possible purges happen at startup and at binary log rotation',
    'name': 'expire_logs_days',
    'values': [ { 'default': '0',
                  'maximum': '99',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'explicit_defaults_for_timestamp',
    'description': 'Whether TIMESTAMP columns are nullable and have DEFAULT NULL',
    'name': 'explicit_defaults_for_timestamp',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'external-locking',
    'description': 'Use system (external) locking',
    'name': 'external-locking',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'federated',
    'description': 'Enables the FEDERATED storage engine',
    'name': 'federated',
    'values': [{ 'type': 'integer'}],
    'versions': [ ((5, 1, 26), (6, 0, 7)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'flush',
    'description': 'Flush tables to disk between SQL statements',
    'name': 'flush',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'flush_time',
    'description': 'A dedicated thread is created to flush all tables at the given interval',
    'name': 'flush_time',
    'values': [ { 'default': '0', 'minimum': '0', 'type': 'integer'},
                { 'default': '1800',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'default': '0',
                  'inversion': (5, 6, 6),
                  'minimum': '0',
                  'platform': 'windows',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ft_boolean_syntax',
    'description': 'List of operators for MATCH ... AGAINST ( ... IN BOOLEAN MODE)',
    'name': 'ft_boolean_syntax',
    'values': [{ 'default': '+ -><()~*:""&|', 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ft_max_word_len',
    'description': 'The maximum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable',
    'name': 'ft_max_word_len',
    'values': [{ 'minimum': '10', 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ft_min_word_len',
    'description': 'The minimum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable',
    'name': 'ft_min_word_len',
    'values': [{ 'default': '4', 'minimum': '1', 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ft_query_expansion_limit',
    'description': 'Number of best matches to use for query expansion',
    'name': 'ft_query_expansion_limit',
    'values': [ { 'default': '20',
                  'maximum': '1000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ft_stopword_file',
    'description': 'Use stopwords from this file instead of built-in list',
    'name': 'ft_stopword_file',
    'values': [{ 'type': 'filename'}],
    'versions': [ ((4, 1, 10),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'gdb',
    'description': 'Set up signals usable for debugging',
    'name': 'gdb',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'general-log',
    'description': 'Enable|disable general log',
    'name': 'general-log',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 12),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'general_log_file',
    'description': 'Name of the general query log file',
    'name': 'general_log_file',
    'optype': { 'inversion': '5.1.29'},
    'values': [{ 'default': 'host_name.log', 'type': 'filename'}],
    'versions': [ ((5, 1, 12),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'group_concat_max_len',
    'description': 'The maximum length of the result of function group_concat',
    'name': 'group_concat_max_len',
    'values': [ { 'bitsize': '32',
                  'default': '1024',
                  'maximum': '4294967295',
                  'minimum': '4',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1024',
                  'maximum': '18446744073709547520',
                  'minimum': '4',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1024',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '4',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 10),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'gtid-executed-compression-period',
    'description': 'Compress gtid_executed table each time this many transactions have occurred. 0 means never compress this table. Applies only when binary logging is disabled.',
    'name': 'gtid-executed-compression-period',
    'values': [ { 'default': '1000',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'gtid-mode',
    'description': 'Controls whether GTID based logging is enabled and what type of transactions the logs can contain',
    'name': 'gtid-mode',
    'values': [ { 'choice': [ 'OFF',
                              'UPGRADE_STEP_1',
                              'UPGRADE_STEP_2',
                              'ON'],
                  'default': 'OFF',
                  'outversion': (5, 7, 5),
                  'type': 'enum'},
                { 'choice': [ 'OFF',
                              'OFF_PERMISSIVE',
                              'ON_PERMISSIVE',
                              'ON'],
                  'default': 'OFF',
                  'inversion': (5, 7, 6),
                  'type': 'enum'}],
    'versions': [((5, 6, 5),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ignore-builtin-innodb',
    'description': 'Ignore the built-in InnoDB',
    'name': 'ignore-builtin-innodb',
    'values': [{ 'off': '0', 'on': '1', 'type': 'boolean'}],
    'versions': [ ((5, 1, 33),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ignore-db-dir',
    'description': 'Treat directory as nondatabase directory',
    'name': 'ignore-db-dir',
    'values': [{ 'type': 'dirname'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ((8, 0, 0),)]},
  { 'caption': 'information_schema_stats',
    'description': 'Which table statistics source to use',
    'name': 'information_schema_stats',
    'values': [ { 'choice': ['CACHED', 'LATEST'],
                  'default': 'CACHED',
                  'type': 'enum'}],
    'versions': [((8, 0, 0),), ((8, 0),), ()]},
  { 'caption': 'init-file',
    'description': 'Read SQL statements from this file at startup',
    'name': 'init-file',
    'values': [{ 'type': 'filename'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'init-rpl-role',
    'description': 'Set the replication role (not used)',
    'name': 'init-rpl-role',
    'values': [{ 'type': 'string'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ()]},
  { 'caption': 'init_connect',
    'description': 'Statements that are executed for each new connection',
    'name': 'init_connect',
    'values': [{ 'type': 'string'}],
    'versions': [ ((4, 1, 2),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'init_slave',
    'description': 'Statements that are executed when a slave connects to a master',
    'name': 'init_slave',
    'values': [{ 'type': 'string'}],
    'versions': [ ((4, 1, 2),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'initialize',
    'description': 'Whether to run in initialization mode (secure)',
    'name': 'initialize',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'initialize-insecure',
    'description': 'Whether to run in initialization mode (insecure)',
    'name': 'initialize-insecure',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb-safe-binlog',
    'description': 'Truncates the binary log after last nonrolled-back transaction after InnoDB crash recovery',
    'name': 'innodb-safe-binlog',
    'values': [{ 'off': '0', 'on': '1', 'type': 'boolean'}],
    'versions': [((4, 1, 3),), ((4, 1), (5, 0)), ((5, 0, 3),)]},
  { 'caption': 'innodb-status-file',
    'description': 'Enable SHOW ENGINE INNODB STATUS output in the innodb_status.[pid] file',
    'name': 'innodb-status-file',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_adaptive_flushing',
    'description': 'Control InnoDB adaptive flushing of dirty pages',
    'name': 'innodb_adaptive_flushing',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 38), (5, 4, 2)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_adaptive_flushing_lwm',
    'description': 'Low water mark representing percentage of redo log capacity at which adaptive flushing is enabled.',
    'name': 'innodb_adaptive_flushing_lwm',
    'values': [ { 'default': '10',
                  'maximum': '70',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_adaptive_hash_index',
    'description': 'Enable or disable InnoDB adaptive hash indexes',
    'name': 'innodb_adaptive_hash_index',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 52), (5, 1, 24), (6, 0, 5)),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_adaptive_hash_index_parts',
    'description': 'Partitions the adaptive hash index search system into n partitions, with each partition protected by a separate latch. Each index is bound to a specific partition based on space ID and index ID attributes.',
    'name': 'innodb_adaptive_hash_index_parts',
    'values': [ { 'default': '8',
                  'maximum': '512',
                  'minimum': '1',
                  'type': 'numeric'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_adaptive_max_sleep_delay',
    'description': 'Allows InnoDB to automatically adjust the value of innodb_thread_sleep_delay up or down according to the current workload',
    'name': 'innodb_adaptive_max_sleep_delay',
    'values': [ { 'default': '150000',
                  'maximum': '1000000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_api_bk_commit_interval',
    'description': 'How often to auto-commit idle connections that use the InnoDB memcached interface, in seconds.',
    'name': 'innodb_api_bk_commit_interval',
    'values': [ { 'default': '5',
                  'maximum': '1073741824 ',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 6, 7),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_api_disable_rowlock',
    'description': '',
    'name': 'innodb_api_disable_rowlock',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_api_enable_binlog',
    'description': 'Lets you use the InnoDB memcached plugin with the MySQL binary log',
    'name': 'innodb_api_enable_binlog',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_api_enable_mdl',
    'description': 'Locks the table used by the InnoDB memcached plugin, so that it cannot be dropped or altered by DDL through the SQL interface',
    'name': 'innodb_api_enable_mdl',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_api_trx_level',
    'description': 'Lets you control the transaction isolation level on queries processed by the memcached interface',
    'name': 'innodb_api_trx_level',
    'values': [{ 'default': '0', 'type': 'integer'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_autoextend_increment',
    'description': 'Data file autoextend increment in megabytes',
    'name': 'innodb_autoextend_increment',
    'values': [ { 'default': '8',
                  'maximum': '1000',
                  'minimum': '1',
                  'outversion': (5, 1, 99),
                  'type': 'integer'},
                { 'default': '64',
                  'inversion': (5, 4, 0),
                  'maximum': '1000',
                  'minimum': '1',
                  'outversion': (5, 4, 2),
                  'type': 'integer'},
                { 'default': '8',
                  'inversion': (5, 4, 3),
                  'maximum': '1000',
                  'minimum': '1',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '64',
                  'inversion': (5, 6, 6),
                  'maximum': '1000',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 5),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_autoinc_lock_mode',
    'description': 'Set InnoDB auto-increment lock mode',
    'name': 'innodb_autoinc_lock_mode',
    'values': [ { 'choice': ['0', '1', '2'],
                  'default': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 22),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'innodb_background_drop_list_empty',
    'description': 'This debug option delays table creation until the background drop list is empty.',
    'name': 'innodb_background_drop_list_empty',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 10),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_buffer_pool_awe_mem_mb',
    'description': 'If Windows AWE is used, size in Megabytes of InnoDB buffer pool allocated from the AWE memory',
    'name': 'innodb_buffer_pool_awe_mem_mb',
    'values': [ { 'default': '0',
                  'maximum': '63000',
                  'minimum': '0',
                  'platform': 'windows',
                  'type': 'integer'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1)), ((5, 1, 13),)]},
  { 'caption': 'innodb_buffer_pool_chunk_size',
    'description': 'Defines the chunk size that is used when resizing the buffer pool',
    'name': 'innodb_buffer_pool_chunk_size',
    'values': [ { 'default': '134217728',
                  'maximum': 'innodb_buffer_pool_size / innodb_buffer_pool_instances',
                  'minimum': '1048576',
                  'type': 'integer'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_buffer_pool_debug',
    'description': 'Permits multiple buffer pool instances when the buffer pool is less than 1GB in size',
    'name': 'innodb_buffer_pool_debug',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((8, 0, 0),), ((8, 0),), ()]},
  { 'caption': 'innodb_buffer_pool_dump_at_shutdown',
    'description': 'Specifies whether to record the pages cached in the InnoDB buffer pool when the MySQL server is shut down, to shorten the warmup process at the next restart',
    'name': 'innodb_buffer_pool_dump_at_shutdown',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 7, 6),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (5, 7, 7),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_buffer_pool_dump_now',
    'description': 'Immediately records the pages cached in the InnoDB buffer pool',
    'name': 'innodb_buffer_pool_dump_now',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_buffer_pool_dump_pct',
    'description': 'Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.',
    'name': 'innodb_buffer_pool_dump_pct',
    'values': [ { 'default': '100',
                  'maximum': '100',
                  'minimum': '1',
                  'outversion': (5, 7, 6),
                  'type': 'integer'},
                { 'default': '25',
                  'inversion': (5, 7, 7),
                  'maximum': '100',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 7, 2),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_buffer_pool_filename',
    'description': 'Specifies the file that holds the list of page numbers produced by innodb_buffer_pool_dump_at_shutdown or innodb_buffer_pool_dump_now',
    'name': 'innodb_buffer_pool_filename',
    'values': [{ 'default': 'ib_buffer_pool', 'type': 'filename'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_buffer_pool_instances',
    'description': 'Specifies how many parts the InnoDB buffer pool is divided into',
    'name': 'innodb_buffer_pool_instances',
    'values': [ { 'default': '1',
                  'maximum': '64',
                  'minimum': '1',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '(autosized)',
                  'inversion': (5, 6, 6),
                  'maximum': '64',
                  'minimum': '1',
                  'platform': 'windows',
                  'type': 'integer'},
                { 'default': '8 (or 1 if innodb_buffer_pool_size < 1GB',
                  'inversion': (5, 6, 6),
                  'maximum': '64',
                  'minimum': '1',
                  'platform': 'other',
                  'type': 'integer'}],
    'versions': [((5, 5, 4),), ((5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_buffer_pool_load_abort',
    'description': 'Interrupts process of restoring InnoDB buffer pool contents triggered by innodb_buffer_pool_load_at_startup or innodb_buffer_pool_load_now',
    'name': 'innodb_buffer_pool_load_abort',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_buffer_pool_load_at_startup',
    'description': 'Specifies that, on MySQL server startup, the InnoDB buffer pool is automatically "warmed up" by loading the same pages it held at an earlier time',
    'name': 'innodb_buffer_pool_load_at_startup',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 7, 6),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (5, 7, 7),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_buffer_pool_load_now',
    'description': 'Immediately "warms up" the InnoDB buffer pool by loading a set of data pages, without waiting for a server restart',
    'name': 'innodb_buffer_pool_load_now',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_buffer_pool_size',
    'description': 'Size of the memory buffer InnoDB uses to cache data and indexes of its tables',
    'name': 'innodb_buffer_pool_size',
    'values': [ { 'default': '8388608',
                  'inversion': (5, 0, 0),
                  'minimum': '1048576',
                  'outversion': (5, 1, 27),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '134217728',
                  'inversion': (5, 1, 28),
                  'maximum': '2**32-1',
                  'minimum': '1048576',
                  'outversion': (5, 1, 99),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '134217728',
                  'inversion': (5, 1, 28),
                  'maximum': '2**64-1',
                  'minimum': '1048576',
                  'outversion': (5, 1, 99),
                  'type': 'integer'},
                { 'default': '1073741824',
                  'inversion': (5, 4, 0),
                  'minimum': '67108864',
                  'outversion': (5, 4, 1),
                  'type': 'integer'},
                { 'default': '1073741824',
                  'inversion': (5, 4, 2),
                  'minimum': '5242880',
                  'outversion': (5, 4, 2),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '134217728',
                  'inversion': (5, 4, 3),
                  'maximum': '2**32-1',
                  'minimum': '5242880',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '134217728',
                  'inversion': (5, 4, 3),
                  'maximum': '2**64-1',
                  'minimum': '5242880',
                  'type': 'integer'},
                { 'default': '8388608',
                  'inversion': (6, 0, 0),
                  'minimum': '1048576',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_change_buffer_max_size',
    'description': 'Maximum size for the InnoDB change buffer, as a percentage of the total size of buffer pool',
    'name': 'innodb_change_buffer_max_size',
    'values': [ { 'default': '25',
                  'maximum': '50',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_change_buffering',
    'description': 'Whether InnoDB performs insert buffering.',
    'name': 'innodb_change_buffering',
    'values': [ { 'choice': ['inserts', 'none'],
                  'default': 'inserts',
                  'outversion': (5, 5, 3),
                  'type': 'enum'},
                { 'choice': [ 'none',
                              'inserts',
                              'deletes',
                              'changes',
                              'purges',
                              'all'],
                  'default': 'all',
                  'inversion': (5, 5, 4),
                  'type': 'enum'}],
    'versions': [ ((5, 1, 38), (5, 4, 2)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_change_buffering_debug',
    'description': 'Sets a debug flag for InnoDB change buffering',
    'name': 'innodb_change_buffering_debug',
    'values': [{ 'default': '0', 'maximum': '2', 'type': 'integer'}],
    'versions': [((5, 1, 53),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_checksum_algorithm',
    'description': 'Specifies how to generate and verify the checksum stored in each disk block of each InnoDB tablespace',
    'name': 'innodb_checksum_algorithm',
    'values': [ { 'choice': [ 'innodb',
                              'crc32',
                              'none',
                              'strict_innodb',
                              'strict_crc32',
                              'strict_none'],
                  'default': 'innodb',
                  'outversion': (5, 6, 5),
                  'type': 'enum'},
                { 'choice': [ 'innodb',
                              'crc32',
                              'none',
                              'strict_innodb',
                              'strict_crc32',
                              'strict_none'],
                  'default': 'crc32',
                  'inversion': (5, 6, 6),
                  'outversion': (5, 6, 6),
                  'type': 'enum'},
                { 'choice': [ 'innodb',
                              'crc32',
                              'none',
                              'strict_innodb',
                              'strict_crc32',
                              'strict_none'],
                  'default': 'innodb',
                  'inversion': (5, 6, 7),
                  'outversion': (5, 7, 6),
                  'type': 'enum'},
                { 'choice': [ 'innodb',
                              'crc32',
                              'none',
                              'strict_innodb',
                              'strict_crc32',
                              'strict_none'],
                  'default': 'crc32',
                  'inversion': (5, 7, 7),
                  'type': 'enum'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_checksums',
    'description': 'Enable InnoDB checksums validation',
    'name': 'innodb_checksums',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 3),),
                  ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)),
                  ((8, 0, 0),)]},
  { 'caption': 'innodb_cmp_per_index_enabled',
    'description': 'Enables per-index compression-related statistics in the INFORMATION_SCHEMA.INNODB_CMP_PER_INDEX table',
    'name': 'innodb_cmp_per_index_enabled',
    'values': [ { 'choice': ['off', 'on'],
                  'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 7),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_commit_concurrency',
    'description': 'Helps in performance tuning in heavily concurrent environments',
    'name': 'innodb_commit_concurrency',
    'values': [ { 'default': '0',
                  'maximum': '1000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 12),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_compress_debug',
    'description': 'Compresses all tables using a specified compression algorithm',
    'name': 'innodb_compress_debug',
    'values': [ { 'choice': ['none', 'zlib', 'lz4', 'lz4hc'],
                  'default': 'none',
                  'type': 'enum'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_compression_failure_threshold_pct',
    'description': 'Sets the cutoff point at which MySQL begins adding padding within compressed pages to avoid expensive compression failures',
    'name': 'innodb_compression_failure_threshold_pct',
    'values': [ { 'default': '5',
                  'maximum': '100',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 7),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_compression_level',
    'description': 'Specifies the level of zlib compression to use for InnoDB compressed tables and indexes',
    'name': 'innodb_compression_level',
    'values': [ { 'default': '6',
                  'maximum': '9',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 7),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_compression_pad_pct_max',
    'description': 'Specifies the maximum percentage that can be reserved as free space within each compressed page, to avoid compression failures when tightly packed data is recompressed',
    'name': 'innodb_compression_pad_pct_max',
    'values': [ { 'default': '50',
                  'maximum': '75',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 7),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_concurrency_tickets',
    'description': 'Number of times a thread is allowed to enter InnoDB within the same SQL query after it has once got the ticket',
    'name': 'innodb_concurrency_tickets',
    'values': [ { 'default': '500',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '5000',
                  'inversion': (5, 6, 6),
                  'maximum': '4294967295',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 3),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_create_intrinsic',
    'description': 'Enable this option to create performance-optimized temporary tables using CREATE TEMPORY TABLE syntax',
    'name': 'innodb_create_intrinsic',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 5),), ((5, 7),), ((5, 7, 6),)]},
  { 'caption': 'innodb_data_file_path',
    'description': 'Path to individual files and their sizes',
    'name': 'innodb_data_file_path',
    'values': [ { 'default': 'ibdata1:10M:autoextend',
                  'outversion': (5, 6, 6),
                  'type': 'string'},
                { 'default': 'ibdata1:12M:autoextend',
                  'inversion': (5, 6, 7),
                  'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_data_home_dir',
    'description': 'The common part for InnoDB table spaces',
    'name': 'innodb_data_home_dir',
    'values': [{ 'type': 'dirname'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_deadlock_detect',
    'description': 'Enables or disables deadlock detection',
    'name': 'innodb_deadlock_detect',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 15), (8, 0, 0)), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_default_row_format',
    'description': 'Defines the default row format (ROW_FORMAT) for InnoDB tables.',
    'name': 'innodb_default_row_format',
    'values': [ { 'choice': ['DYNAMIC', 'COMPACT', 'REDUNDANT'],
                  'default': 'DYNAMIC',
                  'type': 'enum'}],
    'versions': [((5, 7, 9),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_disable_sort_file_cache',
    'description': 'Disable OS file system cache for merge-sort temporary files',
    'name': 'innodb_disable_sort_file_cache',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_disable_resize_buffer_pool_debug',
    'description': 'Disables resizing of the InnoDB buffer pool',
    'name': 'innodb_disable_resize_buffer_pool_debug',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 6),), ((5, 7),), ((8, 0, 0),)]},
  { 'caption': 'innodb_doublewrite',
    'description': 'Enable InnoDB doublewrite buffer',
    'name': 'innodb_doublewrite',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 3),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_extra_dirty_writes',
    'description': 'Whether to flush dirty buffer pages when the percentage of dirty pages is less than the maximum dirty percent',
    'name': 'innodb_extra_dirty_writes',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [(), ((5, 4),), ((5, 4, 2),)]},
  { 'caption': 'innodb_fast_shutdown',
    'description': 'Speeds up the shutdown process of the InnoDB storage engine',
    'name': 'innodb_fast_shutdown',
    'values': [ { 'choice': ['0', '1', '2'],
                  'default': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_fil_make_page_dirty_debug',
    'description': 'Dirties the first page of the specified tablespace',
    'name': 'innodb_fil_make_page_dirty_debug',
    'values': [{ 'default': '0', 'maximum': '2**32-1', 'type': 'integer'}],
    'versions': [((5, 6, 17),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_file_format',
    'description': 'The format for new InnoDB tables',
    'name': 'innodb_file_format',
    'values': [ { 'choice': ['Antelope', 'Barracuda'],
                  'default': 'Antelope',
                  'inversion': (5, 1, 38),
                  'outversion': (5, 1, 99),
                  'type': 'string'},
                { 'choice': ['Antelope', 'Barracuda'],
                  'default': 'Barracuda',
                  'inversion': (5, 5, 0),
                  'outversion': (5, 5, 6),
                  'type': 'string'},
                { 'choice': ['Antelope', 'Barracuda'],
                  'default': 'Antelope',
                  'inversion': (5, 5, 7),
                  'outversion': (5, 7, 6),
                  'type': 'string'},
                { 'choice': ['Antelope', 'Barracuda'],
                  'default': 'Barracuda',
                  'inversion': (5, 7, 7),
                  'type': 'string'}],
    'versions': [ ((5, 1, 38), (5, 4, 2)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)),
                  ((8, 0, 0),)]},
  { 'caption': 'innodb_file_format_check',
    'description': 'Whether InnoDB performs file format compatibility checking',
    'name': 'innodb_file_format_check',
    'values': [ { 'default': 'Antelope',
                  'outversion': (5, 1, 41),
                  'type': 'string'},
                { 'default': 'Barracuda',
                  'inversion': (5, 1, 42),
                  'outversion': (5, 1, 99),
                  'type': 'string'},
                { 'default': 'Antelope',
                  'inversion': (5, 5, 0),
                  'outversion': (5, 5, 0),
                  'type': 'string'},
                { 'default': 'Barracuda',
                  'inversion': (5, 5, 1),
                  'outversion': (5, 5, 4),
                  'type': 'string'},
                { 'default': 'on',
                  'inversion': (5, 5, 5),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 38), (5, 4, 2)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)),
                  ((8, 0, 0),)]},
  { 'caption': 'innodb_file_format_max',
    'description': 'The file format tag in the shared tablespace',
    'name': 'innodb_file_format_max',
    'values': [ { 'choice': ['Antelope', 'Barracuda'],
                  'default': 'Antelope',
                  'outversion': (5, 7, 8),
                  'type': 'string'},
                { 'choice': ['Antelope', 'Barracuda'],
                  'default': 'Barracuda',
                  'inversion': (5, 7, 9),
                  'type': 'string'}],
    'versions': [((5, 5, 5),), ((5, 5), (5, 6), (5, 7)), ((8, 0, 0),)]},
  { 'caption': 'innodb_file_io_threads',
    'description': 'Number of file I/O threads in InnoDB',
    'name': 'innodb_file_io_threads',
    'values': [ { 'default': '4',
                  'maximum': '64',
                  'minimum': '4',
                  'type': 'integer'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (6, 0)), ((5, 5, 0),)]},
  { 'caption': 'innodb_file_per_table',
    'description': 'Stores each InnoDB table and its indexes in a separate .ibd file in the database directory',
    'name': 'innodb_file_per_table',
    'values': [ { 'default': 'off',
                  'inversion': (4, 1, 1),
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 4, 99),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (5, 5, 0),
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 5, 6),
                  'type': 'boolean'},
                { 'default': 'off',
                  'inversion': (5, 5, 7),
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 6, 5),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (5, 6, 6),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_fill_factor',
    'description': 'Defines the percentage B-tree leaf and non-leaf page space that is to be filled with data. The remaining space is reserved for future growth.',
    'name': 'innodb_fill_factor',
    'values': [ { 'default': '100',
                  'maximum': '100',
                  'minimum': '10',
                  'type': 'integer'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_flush_log_at_trx_commit',
    'description': 'Set to 0 (write and flush once per second), 1 (write and flush at each commit) or 2 (write at commit, flush once per second)',
    'name': 'innodb_flush_log_at_trx_commit',
    'values': [{ 'choice': ['0', '1', '2'], 'default': '1', 'type': 'enum'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_flush_method',
    'description': 'Specifies to flush data',
    'name': 'innodb_flush_method',
    'values': [ { 'choice': ['async_unbuffered', 'normal', 'unbuffered'],
                  'default': 'NULL',
                  'inversion': (5, 0, 0),
                  'outversion': (5, 7, 99),
                  'platform': 'windows',
                  'type': 'string'},
                { 'choice': [ 'fdatasync',
                              'O_DSYNC',
                              'littlesync',
                              'nosync',
                              'O_DIRECT'],
                  'default': 'NULL',
                  'inversion': (5, 0, 0),
                  'outversion': (5, 1, 23),
                  'platform': 'unix',
                  'type': 'string'},
                { 'choice': [ 'fsync',
                              'littlesync',
                              'nosync',
                              'O_DSYNC',
                              'O_DIRECT'],
                  'default': 'NULL',
                  'inversion': (5, 1, 24),
                  'outversion': (5, 6, 6),
                  'platform': 'unix',
                  'type': 'string'},
                { 'choice': [ 'fsync',
                              'O_DSYNC',
                              'littlesync',
                              'nosync',
                              'O_DIRECT',
                              'O_DIRECT_NO_FSYNC'],
                  'default': 'NULL',
                  'inversion': (5, 6, 7),
                  'outversion': (5, 7, 99),
                  'platform': 'unix',
                  'type': 'string'},
                { 'choice': ['unbuffered', 'normal'],
                  'default': 'unbuffered',
                  'inversion': (8, 0, 0),
                  'platform': 'windows',
                  'type': 'string'},
                { 'choice': [ 'fsync',
                              'O_DSYNC',
                              'littlesync',
                              'nosync',
                              'O_DIRECT',
                              'O_DIRECT_NO_FSYNC'],
                  'default': 'fsync',
                  'inversion': (8, 0, 0),
                  'platform': 'unix',
                  'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_flush_neighbors',
    'description': 'Specifies whether or not flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent',
    'name': 'innodb_flush_neighbors',
    'values': [{ 'choice': ['0', '1', '2'], 'default': '1', 'type': 'enum'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_flush_sync',
    'description': 'Enable innodb_flush_sync to ignore the innodb_io_capacity setting for bursts of I/O activity that occur at checkpoints. Disable innodb_flush_sync to adhere to the limit on I/O activity defined by the innodb_io_capacity setting.',
    'name': 'innodb_flush_sync',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_flushing_avg_loops',
    'description': 'Number of iterations for which InnoDB keeps the previously calculated snapshot of the flushing state, controlling how quickly adaptive flushing responds to changing workloads',
    'name': 'innodb_flushing_avg_loops',
    'values': [ { 'default': '30',
                  'maximum': '1000',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_force_load_corrupted',
    'description': 'Lets InnoDB load tables at startup that are marked as corrupted; use only during troubleshooting',
    'name': 'innodb_force_load_corrupted',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 5, 18), (5, 6, 3)),
                  ((5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_force_recovery',
    'description': 'Helps to save your data in case the disk image of the database becomes corrupt',
    'name': 'innodb_force_recovery',
    'values': [ { 'default': '0',
                  'maximum': '6',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_ft_aux_table',
    'description': 'Specifies which InnoDB table with a FULLTEXT index to examine by querying several innodb_ft_* tables in the information_schema',
    'name': 'innodb_ft_aux_table',
    'optype': { 'inversion': '5.7.2'},
    'values': [{ 'type': 'string'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_cache_size',
    'description': 'Size of the cache that holds a parsed document in memory while creating an InnoDB FULLTEXT index',
    'name': 'innodb_ft_cache_size',
    'values': [ { 'default': '32000000',
                  'inversion': (5, 6, 4),
                  'outversion': (5, 6, 9),
                  'type': 'integer'},
                { 'default': '8000000',
                  'inversion': (5, 6, 10),
                  'maximum': '80000000',
                  'minimum': '1600000',
                  'type': 'integer'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_enable_diag_print',
    'description': 'Whether to enable additional full-text search diagnostic output',
    'name': 'innodb_ft_enable_diag_print',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 6, 6),
                  'type': 'boolean'},
                { 'default': 'off',
                  'inversion': (5, 6, 7),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_enable_stopword',
    'description': 'During creation of an InnoDB FULLTEXT index, omits stopwords from the search index',
    'name': 'innodb_ft_enable_stopword',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_max_token_size',
    'description': 'Maximum length of words that are stored in an InnoDB FULLTEXT index',
    'name': 'innodb_ft_max_token_size',
    'values': [ { 'default': '84',
                  'inversion': (5, 6, 4),
                  'maximum': '252',
                  'minimum': '10',
                  'outversion': (5, 6, 13),
                  'type': 'integer'},
                { 'default': '84',
                  'inversion': (5, 6, 14),
                  'maximum': '84',
                  'minimum': '10',
                  'type': 'integer'},
                { 'default': '84',
                  'inversion': (5, 7, 0),
                  'maximum': '252',
                  'minimum': '10',
                  'outversion': (5, 7, 2),
                  'type': 'integer'},
                { 'default': '84',
                  'inversion': (5, 7, 3),
                  'maximum': '84',
                  'minimum': '10',
                  'type': 'integer'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_min_token_size',
    'description': 'Minimum length of words that are stored in an InnoDB FULLTEXT index',
    'name': 'innodb_ft_min_token_size',
    'values': [ { 'default': '3',
                  'maximum': '16',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_num_word_optimize',
    'description': 'Number of words to process during each OPTIMIZE TABLE operation on an InnoDB FULLTEXT index',
    'name': 'innodb_ft_num_word_optimize',
    'values': [{ 'default': '2000', 'type': 'integer'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_result_cache_limit',
    'description': 'The InnoDB FULLTEXT search query result cache limit.',
    'name': 'innodb_ft_result_cache_limit',
    'values': [ { 'default': '2000000000',
                  'inversion': (5, 6, 13),
                  'maximum': '2**32-1',
                  'minimum': '1000000',
                  'outversion': (5, 6, 16),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '2000000000',
                  'inversion': (5, 6, 13),
                  'maximum': '2**32-1',
                  'minimum': '1000000',
                  'outversion': (5, 6, 16),
                  'platform': 'unix',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '2000000000',
                  'inversion': (5, 6, 13),
                  'maximum': '2**64-1',
                  'minimum': '1000000',
                  'outversion': (5, 6, 16),
                  'platform': 'unix',
                  'type': 'integer'},
                { 'default': '2000000000',
                  'inversion': (5, 6, 17),
                  'maximum': '2**32-1',
                  'minimum': '1000000',
                  'outversion': (5, 6, 99),
                  'type': 'integer'},
                { 'default': '2000000000',
                  'inversion': (5, 7, 2),
                  'maximum': '2**32-1',
                  'minimum': '1000000',
                  'outversion': (5, 7, 3),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '2000000000',
                  'inversion': (5, 7, 2),
                  'maximum': '2**32-1',
                  'minimum': '1000000',
                  'outversion': (5, 7, 3),
                  'platform': 'unix',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '2000000000',
                  'inversion': (5, 7, 2),
                  'maximum': '2**64-1',
                  'minimum': '1000000',
                  'outversion': (5, 7, 3),
                  'platform': 'unix',
                  'type': 'integer'},
                { 'default': '2000000000',
                  'inversion': (5, 7, 4),
                  'maximum': '2**32-1',
                  'minimum': '1000000',
                  'type': 'integer'}],
    'versions': [((5, 6, 13), (5, 7, 2)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_server_stopword_table',
    'description': 'Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and can be overridden by innodb_ft_user_stopword_table',
    'name': 'innodb_ft_server_stopword_table',
    'values': [{ 'default': 'NULL', 'type': 'string'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_sort_pll_degree',
    'description': 'Number of threads used to create an InnoDB FULLTEXT index in parallel, when building a search index for a large table',
    'name': 'innodb_ft_sort_pll_degree',
    'values': [ { 'default': '2',
                  'maximum': '32',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_total_cache_size',
    'description': 'The total memory allocated for the InnoDB FULLTEXT search index cache.',
    'name': 'innodb_ft_total_cache_size',
    'values': [ { 'default': '640000000',
                  'maximum': '1600000000',
                  'minimum': '32000000',
                  'type': 'integer'}],
    'versions': [((5, 6, 13), (5, 7, 2)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_ft_user_stopword_table',
    'description': 'Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and also innodb_ft_server_stopword_table',
    'name': 'innodb_ft_user_stopword_table',
    'values': [{ 'default': 'NULL', 'type': 'string'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_io_capacity',
    'description': 'The limit on the maximum number of I/O operations per second',
    'name': 'innodb_io_capacity',
    'values': [ { 'bitsize': '32',
                  'default': '200',
                  'maximum': '2**32-1',
                  'minimum': '100',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '200',
                  'maximum': '2**64-1',
                  'minimum': '100',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 38),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_io_capacity_max',
    'description': 'The limit up to which InnoDB is allowed to extend the innodb_io_capacity setting in case of emergency',
    'name': 'innodb_io_capacity_max',
    'values': [ { 'bitsize': '32',
                  'default': 'see description',
                  'maximum': '2**32-1',
                  'minimum': '100',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': 'see description',
                  'maximum': '2**32-1',
                  'minimum': '100',
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': 'see description',
                  'maximum': '2**64-1',
                  'minimum': '100',
                  'platform': 'unix',
                  'type': 'integer'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_large_prefix',
    'description': 'Enables longer keys for column prefix indexes',
    'name': 'innodb_large_prefix',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 7, 6),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (5, 7, 7),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 5, 14), (5, 6, 3)),
                  ((5, 5), (5, 6), (5, 7)),
                  ((8, 0, 0),)]},
  { 'caption': 'innodb_limit_optimistic_insert_debug',
    'description': 'Limits the number of records per B-tree page',
    'name': 'innodb_limit_optimistic_insert_debug',
    'values': [ { 'default': '0',
                  'maximum': '2**32-1',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 1, 68),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_lock_wait_timeout',
    'description': 'Timeout in seconds an InnoDB transaction may wait for a lock before a rollback occurs',
    'name': 'innodb_lock_wait_timeout',
    'values': [ { 'default': '50',
                  'maximum': '1073741824',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_locks_unsafe_for_binlog',
    'description': 'Force InnoDB not to use next-key locking. Instead use only row-level locking',
    'name': 'innodb_locks_unsafe_for_binlog',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 4),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0)),
                  ((8, 0, 0),)]},
  { 'caption': 'innodb_log_arch_dir',
    'description': 'Where full logs should be archived',
    'name': 'innodb_log_arch_dir',
    'values': [{ 'type': 'dirname'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1)), ((5, 1, 21),)]},
  { 'caption': 'innodb_log_archive',
    'description': 'Unused',
    'name': 'innodb_log_archive',
    'values': [{ 'default': '0', 'type': 'integer'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1)), ((5, 1, 18),)]},
  { 'caption': 'innodb_log_buffer_size',
    'description': 'Size of buffer which InnoDB uses to write log to the log files on disk',
    'name': 'innodb_log_buffer_size',
    'values': [ { 'default': '1048576',
                  'maximum': '4294967295',
                  'minimum': '1048576',
                  'outversion': (5, 1, 99),
                  'type': 'integer'},
                { 'default': '16777216',
                  'inversion': (5, 4, 0),
                  'maximum': '4294967295',
                  'minimum': '2097152',
                  'outversion': (5, 4, 1),
                  'type': 'integer'},
                { 'default': '16777216',
                  'inversion': (5, 4, 2),
                  'maximum': '4294967295',
                  'minimum': '262144',
                  'outversion': (5, 4, 2),
                  'type': 'integer'},
                { 'default': '8388608',
                  'inversion': (5, 4, 3),
                  'maximum': '4294967295',
                  'minimum': '262144',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '1048576',
                  'inversion': (6, 0, 0),
                  'maximum': '4294967295',
                  'minimum': '1048576',
                  'type': 'integer'},
                { 'default': '16777216',
                  'inversion': (5, 7, 6),
                  'maximum': '4294967295',
                  'minimum': '1048576',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_log_checksum_algorithm',
    'description': 'Specifies how to generate and verify the checksum stored in each redo log disk block',
    'name': 'innodb_log_checksum_algorithm',
    'values': [ { 'choice': [ 'innodb',
                              'crc32',
                              'none',
                              'strict_innodb',
                              'strict_crc32',
                              'strict_none'],
                  'default': 'innodb',
                  'inversion': (5, 7, 8),
                  'type': 'enum'}],
    'versions': [((5, 7, 8),), ((5, 7),), ((5, 7, 9),)]},
  { 'caption': 'innodb_log_checksums',
    'description': 'Enables or disables checksums for redo log pages.',
    'name': 'innodb_log_checksums',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 9),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_log_compressed_pages',
    'description': 'Specifies whether images of re-compressed pages are stored in InnoDB redo logs',
    'name': 'innodb_log_compressed_pages',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 11),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_log_file_size',
    'description': 'Size of each log file in a log group',
    'name': 'innodb_log_file_size',
    'values': [ { 'default': '5242880',
                  'maximum': '4GB / innodb_log_files_in_group',
                  'minimum': '1048576',
                  'outversion': (5, 1, 99),
                  'type': 'integer'},
                { 'default': '134217728',
                  'inversion': (5, 4, 0),
                  'maximum': '4GB / innodb_log_files_in_group',
                  'minimum': '33554432',
                  'outversion': (5, 4, 1),
                  'type': 'integer'},
                { 'default': '134217728',
                  'inversion': (5, 4, 2),
                  'maximum': '4GB / innodb_log_files_in_group',
                  'minimum': '1048576',
                  'outversion': (5, 4, 2),
                  'type': 'integer'},
                { 'default': '5242880',
                  'inversion': (5, 4, 3),
                  'maximum': '4GB / innodb_log_files_in_group',
                  'minimum': '1048576',
                  'outversion': (5, 6, 2),
                  'type': 'integer'},
                { 'default': '5242880',
                  'inversion': (5, 6, 3),
                  'maximum': '512GB / innodb_log_files_in_group',
                  'minimum': '1048576',
                  'outversion': (5, 6, 7),
                  'type': 'integer'},
                { 'default': '50331648',
                  'inversion': (5, 6, 8),
                  'maximum': '512GB / innodb_log_files_in_group',
                  'minimum': '1048576',
                  'outversion': (5, 7, 10),
                  'type': 'integer'},
                { 'default': '50331648',
                  'inversion': (5, 7, 11),
                  'maximum': '512GB / innodb_log_files_in_group',
                  'minimum': '4194304',
                  'type': 'integer'},
                { 'default': '5242880',
                  'inversion': (6, 0, 0),
                  'maximum': '4294967295',
                  'minimum': '1048576',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_log_files_in_group',
    'description': 'Number of InnoDB log files in the log group',
    'name': 'innodb_log_files_in_group',
    'values': [ { 'default': '2',
                  'maximum': '100',
                  'minimum': '2',
                  'outversion': (5, 1, 99),
                  'type': 'integer'},
                { 'default': '3',
                  'inversion': (5, 4, 0),
                  'maximum': '100',
                  'minimum': '3',
                  'outversion': (5, 4, 2),
                  'type': 'integer'},
                { 'default': '2',
                  'inversion': (5, 4, 3),
                  'maximum': '100',
                  'minimum': '2',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_log_group_home_dir',
    'description': 'Path to InnoDB log files',
    'name': 'innodb_log_group_home_dir',
    'values': [{ 'type': 'dirname'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_log_write_ahead_size',
    'description': 'The write-ahead block size for the redo log.',
    'name': 'innodb_log_write_ahead_size',
    'values': [ { 'default': '8192',
                  'maximum': 'Equal to innodb_page_size',
                  'minimum': '512 (log file block size)',
                  'type': 'integer'}],
    'versions': [((5, 7, 4),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_lru_scan_depth',
    'description': 'Influences the algorithms and heuristics for the flush operation for the InnoDB buffer pool',
    'name': 'innodb_lru_scan_depth',
    'values': [ { 'bitsize': '32',
                  'default': '1024',
                  'maximum': '2**32-1',
                  'minimum': '100',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1024',
                  'maximum': '2**64-1',
                  'minimum': '100',
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_max_dirty_pages_pct',
    'description': 'Percentage of dirty pages allowed in buffer pool',
    'name': 'innodb_max_dirty_pages_pct',
    'values': [ { 'default': '90',
                  'maximum': '100',
                  'minimum': '0',
                  'outversion': (5, 1, 99),
                  'type': 'numeric'},
                { 'default': '75',
                  'inversion': (5, 4, 0),
                  'maximum': '99',
                  'minimum': '0',
                  'outversion': (5, 7, 4),
                  'type': 'numeric'},
                { 'default': '75',
                  'inversion': (5, 7, 5),
                  'maximum': '99.99',
                  'minimum': '0',
                  'type': 'numeric'},
                { 'default': '90',
                  'inversion': (6, 0, 0),
                  'maximum': '100',
                  'minimum': '0',
                  'type': 'numeric'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_max_dirty_pages_pct_lwm',
    'description': 'Low water mark representing percentage of dirty pages where preflushing is enabled to control the dirty page ratio',
    'name': 'innodb_max_dirty_pages_pct_lwm',
    'values': [ { 'default': '0',
                  'maximum': '99',
                  'minimum': '0',
                  'outversion': (5, 7, 4),
                  'type': 'numeric'},
                { 'default': '0',
                  'inversion': (5, 7, 5),
                  'maximum': '99.99',
                  'minimum': '0',
                  'type': 'numeric'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_max_merged_io',
    'description': 'The maximum number of background I/O requests to merge to issue a larger I/O request',
    'name': 'innodb_max_merged_io',
    'values': [{ 'default': '64', 'type': 'integer'}],
    'versions': [(), ((5, 4),), ((5, 4, 2),)]},
  { 'caption': 'innodb_max_purge_lag',
    'description': 'Desired maximum length of the purge queue (0 = no limit)',
    'name': 'innodb_max_purge_lag',
    'values': [ { 'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 6),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_max_purge_lag_delay',
    'description': 'Specifies the maximum delay in milliseconds for the formula calculated using the innodb_max_purge_lag configuration option',
    'name': 'innodb_max_purge_lag_delay',
    'values': [{ 'default': '0', 'minimum': '0', 'type': 'integer'}],
    'versions': [((5, 6, 5),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_max_undo_log_size',
    'description': 'Sets the threshold for truncating the InnoDB undo log',
    'name': 'innodb_max_undo_log_size',
    'values': [ { 'default': '1073741824',
                  'maximum': '2**64-1',
                  'minimum': '10485760',
                  'type': 'integer'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_additional_mem_pool_size',
    'description': 'Size of a memory pool InnoDB uses to store data dictionary information and other internal data structures',
    'name': 'innodb_additional_mem_pool_size',
    'values': [ { 'default': '1048576',
                  'maximum': '4294967295',
                  'minimum': '524288',
                  'outversion': (5, 1, 99),
                  'type': 'integer'},
                { 'default': '8388608',
                  'inversion': (5, 4, 0),
                  'maximum': '4294967295',
                  'minimum': '2097152',
                  'type': 'integer'},
                { 'default': '1048576',
                  'inversion': (6, 0, 0),
                  'maximum': '4294967295',
                  'minimum': '524288',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0)),
                  ((5, 7, 4),)]},
  { 'caption': 'innodb_merge_threshold_set_all_debug',
    'description': 'Overrides the current MERGE_THRESHOLD setting with the specified value for all indexes that are currently in the dictionary cache',
    'name': 'innodb_merge_threshold_set_all_debug',
    'values': [ { 'default': '50',
                  'maximum': '50',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_mirrored_log_groups',
    'description': 'Obsolete setting; do not use',
    'name': 'innodb_mirrored_log_groups',
    'values': [ { 'default': '1',
                  'maximum': '10',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                  ()]},
  { 'caption': 'innodb_monitor_disable',
    'description': 'Turns off one or more counters in the information_schema.innodb_metrics table',
    'name': 'innodb_monitor_disable',
    'values': [{ 'type': 'string'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_monitor_enable',
    'description': 'Turns on one or more counters in the information_schema.innodb_metrics table',
    'name': 'innodb_monitor_enable',
    'values': [{ 'type': 'string'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_monitor_reset',
    'description': 'Resets to zero the count value for one or more counters in the information_schema.innodb_metrics table',
    'name': 'innodb_monitor_reset',
    'values': [{ 'type': 'string'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_monitor_reset_all',
    'description': 'Resets all values (minimum, maximum, and so on) for one or more counters in the information_schema.innodb_metrics table',
    'name': 'innodb_monitor_reset_all',
    'values': [{ 'type': 'string'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_numa_interleave',
    'description': 'Enables the NUMA MPOL_INTERLEAVE memory policy for allocation of the InnoDB buffer pool',
    'name': 'innodb_numa_interleave',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 27), (5, 7, 9)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_old_blocks_pct',
    'description': 'Percentage of the InnoDB buffer pool to reserve for old blocks',
    'name': 'innodb_old_blocks_pct',
    'values': [ { 'default': '37',
                  'maximum': '95',
                  'minimum': '5',
                  'type': 'integer'}],
    'versions': [((5, 1, 41),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_old_blocks_time',
    'description': 'How long (in ms) blocks must remain in old end of InnoDB buffer pool before moving to new end',
    'name': 'innodb_old_blocks_time',
    'values': [ { 'default': '0',
                  'maximum': '2**32-1',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '1000',
                  'inversion': (5, 6, 6),
                  'maximum': '2**32-1',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 1, 41),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_online_alter_log_max_size',
    'description': 'Specifies an upper limit on size of the temporary log files used during online DDL operations for InnoDB tables.',
    'name': 'innodb_online_alter_log_max_size',
    'values': [ { 'default': '134217728',
                  'maximum': '2**64-1',
                  'minimum': '65536',
                  'type': 'integer'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_open_files',
    'description': 'The maximum number of files that InnoDB keeps open at the same time',
    'name': 'innodb_open_files',
    'values': [ { 'default': '300',
                  'maximum': '4294967295',
                  'minimum': '10',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'maximum': '4294967295',
                  'minimum': '10',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_optimize_fulltext_only',
    'description': 'Makes the OPTIMIZE TABLE statement for an InnoDB table process the newly added, deleted, and updated token data for a FULLTEXT index, rather than reorganizing the data in the clustered index of the table',
    'name': 'innodb_optimize_fulltext_only',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_optimize_point_storage',
    'description': 'Enable this option to store POINT data as fixed-length data rather than a variable-length data.',
    'name': 'innodb_optimize_point_storage',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 5),), ((5, 7),), ((5, 7, 6),)]},
  { 'caption': 'innodb_page_cleaners',
    'description': 'Number of page cleaner threads.',
    'name': 'innodb_page_cleaners',
    'values': [ { 'default': '1',
                  'maximum': '64',
                  'minimum': '1',
                  'outversion': (5, 7, 7),
                  'type': 'integer'},
                { 'default': '4',
                  'inversion': (5, 7, 8),
                  'maximum': '64',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 7, 4),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_page_size',
    'description': 'Specifies the page size for all InnoDB tablespaces in an instance',
    'name': 'innodb_page_size',
    'values': [ { 'choice': ['4k', '8k', '16k', '4096', '8192', '16384'],
                  'default': '16384',
                  'inversion': (5, 6, 4),
                  'outversion': (5, 7, 5),
                  'type': 'enum'},
                { 'choice': [ '4k',
                              '8k',
                              '16k',
                              '32k',
                              '64k',
                              '4096',
                              '8192',
                              '16384',
                              '32768',
                              '65536'],
                  'default': '16384',
                  'inversion': (5, 7, 6),
                  'type': 'enum'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_print_all_deadlocks',
    'description': 'During shutdown, prints information about all InnoDB deadlocks to the server error log',
    'name': 'innodb_print_all_deadlocks',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 5, 30), (5, 6, 2)),
                  ((5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_purge_batch_size',
    'description': 'Specifies the number of InnoDB redo logs that trigger a purge operation.',
    'name': 'innodb_purge_batch_size',
    'values': [ { 'default': '20',
                  'inversion': (5, 5, 4),
                  'maximum': '5000',
                  'minimum': '1',
                  'outversion': (5, 6, 2),
                  'type': 'integer'},
                { 'default': '300',
                  'inversion': (5, 6, 3),
                  'maximum': '5000',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 5, 4),), ((5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_purge_rseg_truncate_frequency',
    'description': 'The rate at which undo log purge should be invoked as part of the purge action. A value of n invokes undo log purge on every nth iteration of purge invocation.',
    'name': 'innodb_purge_rseg_truncate_frequency',
    'values': [ { 'default': '128',
                  'maximum': '128',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_purge_threads',
    'description': 'Specifies whether the InnoDB purge operation should be performed in one or more separate threads. By default, this operation is part of the InnoDB master thread.',
    'name': 'innodb_purge_threads',
    'values': [ { 'default': '0',
                  'inversion': (5, 5, 4),
                  'maximum': '1',
                  'minimum': '0',
                  'outversion': (5, 6, 1),
                  'type': 'integer'},
                { 'default': '0',
                  'inversion': (5, 6, 2),
                  'maximum': '32',
                  'minimum': '0',
                  'outversion': (5, 6, 4),
                  'type': 'integer'},
                { 'default': '1',
                  'inversion': (5, 6, 5),
                  'maximum': '32',
                  'minimum': '1',
                  'outversion': (5, 7, 7),
                  'type': 'integer'},
                { 'default': '4',
                  'inversion': (5, 7, 8),
                  'maximum': '32',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 5, 4),), ((5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_random_read_ahead',
    'description': 'Enables the random read-ahead technique for optimizing InnoDB I/O',
    'name': 'innodb_random_read_ahead',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 59), (5, 5, 16), (5, 6, 3)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_read_ahead_threshold',
    'description': 'The sensitivity of InnoDB linear read-ahead',
    'name': 'innodb_read_ahead_threshold',
    'values': [ { 'default': '56',
                  'maximum': '64',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 38), (5, 4, 2)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_read_io_threads',
    'description': 'Number of background I/O threads for read prefetch requests',
    'name': 'innodb_read_io_threads',
    'values': [ { 'default': '4',
                  'maximum': '64',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 38),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_read_only',
    'description': 'Starts the server in read-only mode',
    'name': 'innodb_read_only',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 7),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_replication_delay',
    'description': 'The slave server replication thread delay',
    'name': 'innodb_replication_delay',
    'values': [ { 'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 38), (5, 4, 2)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_rollback_on_timeout',
    'description': 'Roll back entire transaction on transaction timeout, not just last statement',
    'name': 'innodb_rollback_on_timeout',
    'values': [],
    'versions': [ ((5, 0, 32), (5, 1, 15)),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_rollback_segments',
    'description': 'Defines how many of the rollback segments in the system tablespace that InnoDB uses within a transaction',
    'name': 'innodb_rollback_segments',
    'values': [ { 'default': '128',
                  'maximum': '128',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 11), (5, 6, 2)),
                  ((5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_saved_page_number_debug',
    'description': 'Saves a page number',
    'name': 'innodb_saved_page_number_debug',
    'values': [{ 'default': '0', 'maximum': '2**23-1', 'type': 'integer'}],
    'versions': [((5, 6, 17),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_sort_buffer_size',
    'description': 'Specifies size of a buffer used for sorting data during creation of an InnoDB index',
    'name': 'innodb_sort_buffer_size',
    'values': [ { 'default': '1048576',
                  'inversion': (5, 6, 4),
                  'maximum': '67108864',
                  'minimum': '524288',
                  'outversion': (5, 6, 4),
                  'type': 'integer'},
                { 'default': '1048576',
                  'inversion': (5, 6, 5),
                  'maximum': '67108864',
                  'minimum': '65536',
                  'type': 'integer'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_spin_wait_delay',
    'description': 'The maximum delay between polls for a spin lock',
    'name': 'innodb_spin_wait_delay',
    'values': [ { 'bitsize': '32',
                  'default': '6',
                  'maximum': '2**32-1',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '6',
                  'maximum': '2**64-1',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 38), (5, 4, 2)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_stats_auto_recalc',
    'description': 'Causes InnoDB to automatically recalculate persistent statistics after the data in a table is changed substantially',
    'name': 'innodb_stats_auto_recalc',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_stats_include_delete_marked',
    'description': 'Include delete-marked records when calculating persistent InnoDB statistics',
    'name': 'innodb_stats_include_delete_marked',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 6, 35), (5, 7, 17), (8, 0, 1)),
                  ((5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_stats_method',
    'description': 'Specifies how InnoDB index statistics collection code should treat NULLs',
    'name': 'innodb_stats_method',
    'values': [ { 'choice': [ 'nulls_equal',
                              'nulls_unequal',
                              'nulls_ignored'],
                  'default': 'nulls_equal',
                  'type': 'enum'}],
    'versions': [ ((5, 1, 56), (5, 5, 10), (5, 6, 2)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_stats_on_metadata',
    'description': 'Enable or disable InnoDB table statistics updates for metadata statements',
    'name': 'innodb_stats_on_metadata',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 6, 5),
                  'type': 'boolean'},
                { 'default': 'off',
                  'inversion': (5, 6, 6),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 17), (5, 5, 4)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'innodb_stats_persistent',
    'description': 'Turns on the InnoDB persistent statistics feature',
    'name': 'innodb_stats_persistent',
    'values': [ { 'choice': ['off', 'on', '0', '1'],
                  'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_stats_persistent_sample_pages',
    'description': 'Number of pages to sample in each InnoDB index, when the persistent statistics feature is also enabled',
    'name': 'innodb_stats_persistent_sample_pages',
    'values': [{ 'default': '20', 'type': 'integer'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_stats_sample_pages',
    'description': 'Number of index pages to sample for index distribution statistics',
    'name': 'innodb_stats_sample_pages',
    'values': [ { 'default': '8',
                  'maximum': '2**64-1',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 38), (5, 4, 2)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)),
                  ((8, 0, 0),)]},
  { 'caption': 'innodb_stats_transient_sample_pages',
    'description': 'Number of pages to sample in each InnoDB index, when the persistent statistics feature is turned off (the default setting)',
    'name': 'innodb_stats_transient_sample_pages',
    'values': [{ 'default': '8', 'type': 'integer'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_status_output',
    'description': 'Used to enable or disable periodic output for the standard InnoDB Monitor. Also used in combination with innodb_status_output_locks to enable and disable periodic output for the InnoDB Lock Monitor.',
    'name': 'innodb_status_output',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 16), (5, 7, 4)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_status_output_locks',
    'description': 'Used to enable or disable periodic output for the standard InnoDB Lock Monitor. innodb_status_output must also be enabled to produce periodic output for the InnoDB Lock Monitor.',
    'name': 'innodb_status_output_locks',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 16), (5, 7, 4)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_strict_mode',
    'description': 'Whether InnoDB returns errors rather than warnings for exceptional conditions',
    'name': 'innodb_strict_mode',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 7, 6),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (5, 7, 7),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 38), (5, 4, 2)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_support_xa',
    'description': 'Enable InnoDB support for the XA two-phase commit',
    'name': 'innodb_support_xa',
    'values': [ { 'default': 'true',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 3),),
                  ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)),
                  ((8, 0, 0),)]},
  { 'caption': 'innodb_sync_array_size',
    'description': 'Splits an internal data structure used to coordinate threads, for higher concurrency in workloads with large numbers of waiting threads',
    'name': 'innodb_sync_array_size',
    'values': [ { 'default': '1',
                  'maximum': '1024',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_sync_spin_loops',
    'description': 'Count of spin-loop rounds in InnoDB mutexes',
    'name': 'innodb_sync_spin_loops',
    'values': [ { 'default': '20',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'outversion': (5, 4, 1),
                  'type': 'integer'},
                { 'default': '30',
                  'inversion': (5, 4, 2),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 3),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_sync_debug',
    'description': 'Enables InnoDB sync debug checking',
    'name': 'innodb_sync_debug',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_table_locks',
    'description': 'Enable InnoDB locking in LOCK TABLES',
    'name': 'innodb_table_locks',
    'values': [ { 'default': 'true',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 2),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_temp_data_file_path',
    'description': 'Defines the path to temporary tablespace data files and their sizes.',
    'name': 'innodb_temp_data_file_path',
    'values': [{ 'default': 'ibtmp1:12M:autoextend', 'type': 'string'}],
    'versions': [((5, 7, 1),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_tmpdir',
    'description': 'Defines a directory location for the temporary table files created during online ALTER TABLE operations.',
    'name': 'innodb_tmpdir',
    'values': [{ 'default': 'NULL', 'type': 'dirname'}],
    'versions': [ ((5, 6, 29), (5, 7, 11), (8, 0, 0)),
                  ((5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'innodb_thread_concurrency',
    'description': 'Sets the maximum number of threads allowed inside InnoDB. Value 0 will disable the thread throttling',
    'name': 'innodb_thread_concurrency',
    'values': [ { 'default': '8',
                  'maximum': '1000',
                  'minimum': '1',
                  'outversion': (5, 0, 7),
                  'type': 'integer'},
                { 'default': '20',
                  'inversion': (5, 0, 8),
                  'maximum': '1000',
                  'minimum': '1',
                  'outversion': (5, 0, 18),
                  'type': 'integer'},
                { 'default': '0',
                  'inversion': (5, 0, 19),
                  'maximum': '1000',
                  'minimum': '0',
                  'outversion': (5, 0, 20),
                  'type': 'integer'},
                { 'default': '8',
                  'inversion': (5, 0, 21),
                  'maximum': '1000',
                  'minimum': '0',
                  'outversion': (5, 1, 99),
                  'type': 'integer'},
                { 'default': '0',
                  'inversion': (5, 4, 0),
                  'maximum': '1000',
                  'minimum': '0',
                  'type': 'integer'},
                { 'default': '8',
                  'inversion': (6, 0, 0),
                  'maximum': '1000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_thread_concurrency_timer_based',
    'description': 'Whether to use the lock-free method of handling thread concurrency',
    'name': 'innodb_thread_concurrency_timer_based',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [(), ((5, 4),), ((5, 4, 2),)]},
  { 'caption': 'innodb_thread_sleep_delay',
    'description': 'Time, in microseconds, that an InnoDB thread sleeps before joining InnoDB queue. Value 0 disables the sleep behavior',
    'name': 'innodb_thread_sleep_delay',
    'values': [ { 'default': '0',
                  'inversion': (5, 0, 8),
                  'maximum': '4294967295',
                  'minimum': '1000',
                  'outversion': (5, 0, 18),
                  'type': 'integer'},
                { 'default': '0',
                  'inversion': (5, 0, 19),
                  'maximum': '4294967295',
                  'minimum': '1000',
                  'outversion': (5, 0, 20),
                  'type': 'integer'},
                { 'default': '8',
                  'inversion': (5, 0, 21),
                  'maximum': '4294967295',
                  'minimum': '1000',
                  'outversion': (5, 0, 99),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '10000',
                  'inversion': (5, 1, 0),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'outversion': (5, 1, 99),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '10000',
                  'inversion': (5, 5, 0),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'outversion': (5, 5, 36),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10000',
                  'inversion': (5, 1, 0),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'outversion': (5, 5, 36),
                  'type': 'integer'},
                { 'default': '10000',
                  'inversion': (5, 5, 37),
                  'maximum': '1000000',
                  'minimum': '0',
                  'outversion': (5, 5, 99),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '10000',
                  'inversion': (5, 6, 0),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'outversion': (5, 6, 16),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10000',
                  'inversion': (5, 6, 0),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'outversion': (5, 6, 16),
                  'type': 'integer'},
                { 'default': '10000',
                  'inversion': (5, 6, 17),
                  'maximum': '1000000',
                  'minimum': '0',
                  'outversion': (5, 6, 99),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '10000',
                  'inversion': (5, 7, 0),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'outversion': (5, 7, 3),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10000',
                  'inversion': (5, 7, 0),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'outversion': (5, 7, 3),
                  'type': 'integer'},
                { 'default': '10000',
                  'inversion': (5, 7, 4),
                  'maximum': '1000000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 3),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'innodb_trx_purge_view_update_only_debug',
    'description': 'Pauses purging of delete-marked records while allowing the purge view to be updated',
    'name': 'innodb_trx_purge_view_update_only_debug',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 1, 68),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_trx_rseg_n_slots_debug',
    'description': 'Sets a debug flag that limits TRX_RSEG_N_SLOTS to a given value for the trx_rsegf_undo_find_free function',
    'name': 'innodb_trx_rseg_n_slots_debug',
    'values': [{ 'default': '0', 'maximum': '1024', 'type': 'integer'}],
    'versions': [((5, 1, 62),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_undo_directory',
    'description': 'The relative or absolute directory path where InnoDB creates separate tablespaces for the undo logs; typically used to place those logs on a different storage device',
    'name': 'innodb_undo_directory',
    'values': [ { 'default': '.', 'outversion': (5, 7, 7), 'type': 'dirname'},
                { 'inversion': (5, 7, 8), 'type': 'dirname'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_undo_log_truncate',
    'description': 'Enable this option to mark the InnoDB undo tablespace for truncation',
    'name': 'innodb_undo_log_truncate',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_undo_logs',
    'description': 'Defines the number of undo logs (rollback segments) used by InnoDB; replaces the innodb_rollback_segments setting',
    'name': 'innodb_undo_logs',
    'values': [ { 'default': '128',
                  'maximum': '128',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_undo_tablespaces',
    'description': 'Number of undo logs to place in each tablespace created by a non-zero innodb_undo_logs setting',
    'name': 'innodb_undo_tablespaces',
    'values': [ { 'default': '0',
                  'maximum': '126',
                  'minimum': '0',
                  'outversion': (5, 7, 7),
                  'type': 'integer'},
                { 'default': '0',
                  'inversion': (5, 7, 8),
                  'maximum': '95',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_use_legacy_cardinality_algorithm',
    'description': 'Whether to use legacy InnoDB index cardinality calculation algorithm',
    'name': 'innodb_use_legacy_cardinality_algorithm',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 0, 82), (5, 1, 35)), ((5, 0), (5, 1)), ()]},
  { 'caption': 'innodb_use_native_aio',
    'description': 'Specifies whether to use the Linux asynchronous I/O subsystem',
    'name': 'innodb_use_native_aio',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 5, 4),), ((5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'innodb_use_sys_malloc',
    'description': 'Whether InnoDB uses the OS or its own memory allocator',
    'name': 'innodb_use_sys_malloc',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 38), (5, 4, 2)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)),
                  ((5, 7, 4),)]},
  { 'caption': 'innodb_write_io_threads',
    'description': 'Number of background I/O threads for writing dirty pages from the buffer cache to disk',
    'name': 'innodb_write_io_threads',
    'values': [ { 'default': '4',
                  'maximum': '64',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 38),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'interactive_timeout',
    'description': 'Number of seconds the server waits for activity on an interactive connection before closing it',
    'name': 'interactive_timeout',
    'values': [{ 'default': '28800', 'minimum': '1', 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'internal_tmp_disk_storage_engine',
    'description': 'Storage engine for internal temporary tables',
    'name': 'internal_tmp_disk_storage_engine',
    'values': [ { 'choice': ['MYISAM', 'INNODB'],
                  'default': 'MYISAM',
                  'inversion': (5, 7, 5),
                  'outversion': (5, 7, 5),
                  'type': 'enum'},
                { 'choice': ['MYISAM', 'INNODB'],
                  'default': 'INNODB',
                  'inversion': (5, 7, 6),
                  'type': 'enum'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'isam',
    'description': 'Obsolete. ISAM storage engine is no longer supported',
    'name': 'isam',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [(), ((4, 1),), ()]},
  { 'caption': 'join_buffer_size',
    'description': 'Size of buffer that is used for full joins',
    'name': 'join_buffer_size',
    'values': [ { 'default': '131072',
                  'maximum': '4294967295',
                  'minimum': '8200',
                  'outversion': (5, 1, 22),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '131072',
                  'inversion': (5, 1, 23),
                  'maximum': '4294967295',
                  'minimum': '8200',
                  'outversion': (5, 5, 2),
                  'platform': 'other',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '131072',
                  'inversion': (5, 1, 23),
                  'maximum': '18446744073709547520',
                  'minimum': '8228',
                  'outversion': (5, 5, 2),
                  'platform': 'other',
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '131072',
                  'inversion': (5, 1, 23),
                  'maximum': '4294967295',
                  'minimum': '8200',
                  'outversion': (5, 5, 2),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '131072',
                  'inversion': (5, 1, 23),
                  'maximum': '4294967295',
                  'minimum': '8228',
                  'outversion': (5, 5, 2),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '131072',
                  'inversion': (5, 5, 3),
                  'maximum': '4294967295',
                  'minimum': '128',
                  'outversion': (5, 6, 5),
                  'platform': 'other',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '131072',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709547520',
                  'minimum': '128',
                  'outversion': (5, 6, 5),
                  'platform': 'other',
                  'type': 'integer'},
                { 'default': '131072',
                  'inversion': (5, 5, 3),
                  'maximum': '4294967295',
                  'minimum': '128',
                  'outversion': (5, 6, 5),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '262144',
                  'inversion': (5, 6, 6),
                  'maximum': '4294967295',
                  'minimum': '128',
                  'platform': 'other',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '262144',
                  'inversion': (5, 6, 6),
                  'maximum': '18446744073709547520',
                  'minimum': '128',
                  'platform': 'other',
                  'type': 'integer'},
                { 'default': '262144',
                  'inversion': (5, 6, 6),
                  'maximum': '4294967295',
                  'minimum': '128',
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '131072',
                  'inversion': (6, 0, 0),
                  'maximum': '4294967295',
                  'minimum': '8200',
                  'outversion': (6, 0, 8),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '131072',
                  'inversion': (6, 0, 9),
                  'maximum': '4294967295',
                  'minimum': '128',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '131072',
                  'inversion': (6, 0, 0),
                  'maximum': '18446744073709547520',
                  'minimum': '8200',
                  'outversion': (6, 0, 8),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '131072',
                  'inversion': (6, 0, 9),
                  'maximum': '18446744073709547520',
                  'minimum': '128',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'join_cache_level',
    'description': 'How join buffers are used',
    'name': 'join_cache_level',
    'values': [ { 'default': '1',
                  'maximum': '8',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((6, 0, 9),), ((6, 0),), ((6, 0, 14),)]},
  { 'caption': 'keep_files_on_create',
    'description': 'Do not overwrite existing .MYD/.MYI files in default database directory',
    'name': 'keep_files_on_create',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 48), (5, 1, 21)),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'key_buffer_size',
    'description': 'Size of buffer used for index blocks for MyISAM tables',
    'name': 'key_buffer_size',
    'values': [ { 'default': '8388608',
                  'maximum': '4294967295',
                  'minimum': '8',
                  'outversion': (5, 1, 22),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '8388608',
                  'inversion': (5, 1, 23),
                  'maximum': '4294967295',
                  'minimum': '8',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '8388608',
                  'inversion': (5, 1, 23),
                  'maximum': 'OS_PER_PROCESS_LIMIT',
                  'minimum': '8',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'key_cache_age_threshold',
    'description': 'This characterizes the number of hits a hot block has to be untouched until it is considered aged enough to be downgraded to a warm block. This specifies the percentage ratio of that number of hits to the total number of blocks in key cache',
    'name': 'key_cache_age_threshold',
    'values': [ { 'bitsize': '32',
                  'default': '300',
                  'maximum': '4294967295',
                  'minimum': '100',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '300',
                  'maximum': '18446744073709547520',
                  'minimum': '100',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '300',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '100',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'key_cache_block_size',
    'description': 'The default size of key cache blocks',
    'name': 'key_cache_block_size',
    'values': [ { 'default': '1024',
                  'maximum': '16384',
                  'minimum': '512',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'key_cache_division_limit',
    'description': 'The minimum percentage of warm blocks in key cache',
    'name': 'key_cache_division_limit',
    'values': [ { 'default': '100',
                  'maximum': '100',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'keyring_file_data',
    'description': 'Keyring plugin data file',
    'name': 'keyring_file_data',
    'values': [{ 'default': 'platform specific', 'type': 'filename'}],
    'versions': [((5, 7, 11),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'keyring_okv_conf_dir',
    'description': 'Oracle Key Vault keyring plugin configuration directory',
    'name': 'keyring_okv_conf_dir',
    'values': [{ 'default': 'empty string', 'type': 'dirname'}],
    'versions': [((5, 7, 12),), ((5, 7),), ()]},
  { 'caption': 'language',
    'description': 'Client error messages in given language. May be given as a full path',
    'name': 'language',
    'values': [ { 'default': '/usr/local/mysql/share/mysql/english/',
                  'type': 'dirname'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'large-pages',
    'description': 'Enable support for large pages',
    'name': 'large-pages',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'platform': 'linux',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 3),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'lc-messages',
    'description': 'Locale for error messages',
    'name': 'lc-messages',
    'values': [{ 'default': 'en_US', 'type': 'string'}],
    'versions': [((6, 0, 14),), ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)), ()]},
  { 'caption': 'lc-messages-dir',
    'description': 'Directory where error messages are installed',
    'name': 'lc-messages-dir',
    'values': [{ 'type': 'dirname'}],
    'versions': [((6, 0, 14),), ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)), ()]},
  { 'caption': 'lock_wait_timeout',
    'description': 'Timeout for metadata locks',
    'name': 'lock_wait_timeout',
    'values': [ { 'default': '31536000',
                  'maximum': '31536000',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'log',
    'description': 'Log connections and queries to file',
    'name': 'log',
    'values': [{ 'type': 'filename'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                  ((5, 6, 1),)]},
  { 'caption': 'log-backup-output',
    'description': 'The destination for MySQL Backup history and progress log output. Syntax: log-backup-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE',
    'name': 'log-backup-output',
    'values': [ { 'choice': ['TABLE', 'FILE', 'NONE'],
                  'default': 'TABLE',
                  'type': 'set'}],
    'versions': [((6, 0, 8),), ((6, 0),), ()]},
  { 'caption': 'log-bin',
    'description': 'Specifies binary log file name',
    'name': 'log-bin',
    'values': [{ 'type': 'filename'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log-bin-index',
    'description': 'File that holds the names for last binary log files',
    'name': 'log-bin-index',
    'values': [{ 'type': 'filename'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log-bin-trust-function-creators',
    'description': 'If equal to 0 (the default), then when --log-bin is used, creation of a stored function is allowed only to users having the SUPER privilege and only if the function created does not break binary logging',
    'name': 'log-bin-trust-function-creators',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 16),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log-bin-trust-routine-creators',
    'description': '(deprecated) Use log-bin-trust-function-creators',
    'name': 'log-bin-trust-routine-creators',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 6),),
                  ((5, 0), (5, 1), (5, 2), (5, 4), (5, 5)),
                  ((5, 2, 5), (5, 5, 3))]},
  { 'caption': 'log-error',
    'description': 'Error log file',
    'name': 'log-error',
    'values': [{ 'type': 'filename'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log-isam',
    'description': 'Log all MyISAM changes to file',
    'name': 'log-isam',
    'values': [{ 'type': 'filename'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log-long-format',
    'description': 'Log some extra information to update log. Please note that this option is deprecated; see --log-short-format option',
    'name': 'log-long-format',
    'values': [],
    'versions': [(), ((4, 1),), ()]},
  { 'caption': 'log-output',
    'description': 'The destination for general query log and slow query log output',
    'name': 'log-output',
    'values': [ { 'choice': ['TABLE', 'FILE', 'NONE'],
                  'default': 'FILE',
                  'type': 'set'}],
    'versions': [ ((5, 1, 6),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'log-queries-not-using-indexes',
    'description': 'Log queries that are executed without benefit of any index to the slow query log if it is open',
    'name': 'log-queries-not-using-indexes',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log-raw',
    'description': 'Whether to log queries without rewriting',
    'name': 'log-raw',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'log-short-format',
    'description': 'Do not log extra information to slow-query log',
    'name': 'log-short-format',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log-slow-admin-statements',
    'description': 'Log slow OPTIMIZE, ANALYZE, ALTER and other administrative statements to the slow query log if it is open',
    'name': 'log-slow-admin-statements',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 13),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0)),
                  ((5, 6, 11), (5, 7, 1))]},
  { 'caption': 'log-slow-queries',
    'description': 'Whether to log slow queries. Logging defaults to hostname-slow.log file. Must be enabled to activate other slow query log options',
    'name': 'log-slow-queries',
    'values': [{ 'off': '0', 'on': '1', 'type': 'boolean'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                  ((5, 6, 1),)]},
  { 'caption': 'log-slow-slave-statements',
    'description': 'Cause slow statements as executed by the slave to be written to the slow query log',
    'name': 'log-slow-slave-statements',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 21), (6, 0, 4)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)),
                  ((5, 6, 11), (5, 7, 1))]},
  { 'caption': 'log-tc',
    'description': 'Path of transaction coordinator log file (used for transactions that affect more than one storage engine, when binary log is disabled)',
    'name': 'log-tc',
    'values': [{ 'default': 'tc.log', 'type': 'filename'}],
    'versions': [ ((5, 0, 3),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log-tc-size',
    'description': 'Size in KB of transaction coordinator log',
    'name': 'log-tc-size',
    'values': [ { 'bitsize': '32',
                  'default': '24576',
                  'maximum': '4294967295',
                  'outversion': (5, 7, 99),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '24576',
                  'maximum': '18446744073709547520',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '24576',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'outversion': (5, 7, 99),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '6 * page size',
                  'inversion': (8, 0, 0),
                  'maximum': '4294967295',
                  'minimum': '6 * page size',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '6 * page size',
                  'inversion': (8, 0, 0),
                  'maximum': '18446744073709551615',
                  'minimum': '6 * page size',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 3),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log-warnings',
    'description': 'Log some noncritical warnings to the log file',
    'name': 'log-warnings',
    'optype': { 'format': 'log-warnings[=#]'},
    'values': [ { 'bitsize': '32',
                  'default': '1',
                  'inversion': (4, 1, 3),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'outversion': (5, 7, 1),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1',
                  'inversion': (4, 1, 3),
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'outversion': (5, 7, 1),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '2',
                  'inversion': (5, 7, 2),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '2',
                  'inversion': (5, 7, 2),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log_backward_compatible_user_definitions',
    'description': 'Whether to log CREATE/ALTER USER, GRANT in backward-compatible fashion',
    'name': 'log_backward_compatible_user_definitions',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 6),), ((5, 7),), ((5, 7, 9),)]},
  { 'caption': 'log_bin_use_v1_row_events',
    'description': 'Shows whether server is using version 1 binary log row events',
    'name': 'log_bin_use_v1_row_events',
    'values': [ { 'default': '1',
                  'inversion': (5, 1, 56),
                  'off': '0',
                  'on': '1',
                  'outversion': (5, 1, 99),
                  'type': 'boolean'},
                { 'default': '1',
                  'inversion': (5, 1, 56),
                  'off': '0',
                  'on': '1',
                  'outversion': (5, 1, 99),
                  'type': 'boolean'},
                { 'default': '0',
                  'inversion': (5, 5, 15),
                  'off': '0',
                  'on': '1',
                  'outversion': (5, 5, 99),
                  'type': 'boolean'},
                { 'default': '0',
                  'inversion': (5, 6, 6),
                  'off': '0',
                  'on': '1',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 56), (5, 1, 56), (5, 5, 15), (5, 6, 6)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'log_builtin_as_identified_by_password',
    'description': 'Whether to log CREATE/ALTER USER, GRANT in backward-compatible fashion',
    'name': 'log_builtin_as_identified_by_password',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 9),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'log_error_verbosity',
    'description': 'Error logging verbosity level',
    'name': 'log_error_verbosity',
    'optype': { 'format': 'log_error_verbosity=#'},
    'values': [ { 'default': '3',
                  'maximum': '3',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 7, 2),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'log_slave_updates',
    'description': 'Whether the slave should log the updates performed by its SQL thread to its own binary log. Read-only; set using the --log-slave-updates server option.',
    'name': 'log_slave_updates',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'log_syslog',
    'description': 'Whether to write error log to syslog',
    'name': 'log_syslog',
    'optype': { 'format': 'log_syslog[={0|1}]'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'platform': 'unix',
                  'type': 'boolean'},
                { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'platform': 'windows',
                  'type': 'boolean'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'log_syslog_facility',
    'description': 'Facility for syslog messages',
    'name': 'log_syslog_facility',
    'optype': { 'format': 'log_syslog_facility=value'},
    'values': [{ 'default': 'daemon', 'type': 'string'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'log_syslog_include_pid',
    'description': 'Whether to include server PID in syslog messages',
    'name': 'log_syslog_include_pid',
    'optype': { 'format': 'log_syslog_include_pid[={0|1}]'},
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'log_syslog_tag',
    'description': 'Tag for server identifier in syslog messages',
    'name': 'log_syslog_tag',
    'optype': { 'format': 'log_syslog_tag=value'},
    'values': [{ 'default': 'empty string', 'type': 'string'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'log_timestamps',
    'description': 'Log timestamp format',
    'name': 'log_timestamps',
    'optype': { 'format': 'log_timestamps=#'},
    'values': [ { 'choice': ['UTC', 'SYSTEM'],
                  'default': 'UTC',
                  'type': 'enum'}],
    'versions': [((5, 7, 2),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'long_query_time',
    'description': 'Log all queries that have taken more than long_query_time seconds to execute to file',
    'name': 'long_query_time',
    'values': [ { 'default': '10',
                  'minimum': '1',
                  'outversion': (5, 0, 20),
                  'type': 'integer'},
                { 'default': '10',
                  'inversion': (5, 0, 21),
                  'minimum': '0',
                  'type': 'numeric'},
                { 'default': '10',
                  'inversion': (6, 0, 0),
                  'minimum': '1',
                  'outversion': (6, 0, 3),
                  'type': 'numeric'},
                { 'default': '10',
                  'inversion': (6, 0, 4),
                  'minimum': '0',
                  'type': 'numeric'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'low-priority-updates',
    'description': 'INSERT/DELETE/UPDATE has lower priority than selects',
    'name': 'low-priority-updates',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'lower_case_table_names',
    'description': 'If set to 1, table names are stored in lowercase on disk and table names will be case insensitive. Should be set to 2 if you are using a case-insensitive file system.',
    'name': 'lower_case_table_names',
    'values': [ { 'default': '0',
                  'maximum': '2',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'master-connect-retry',
    'description': 'Number of seconds the slave thread will sleep before retrying to connect to the master in case the master goes down or the connection is lost',
    'name': 'master-connect-retry',
    'values': [{ 'default': '60', 'type': 'integer'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-host',
    'description': 'Master host name or IP address for replication',
    'name': 'master-host',
    'values': [{ 'type': 'string'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-info-file',
    'description': "The location and name of the file that remembers the master and where the I/O replication thread is in the master's binary logs",
    'name': 'master-info-file',
    'values': [{ 'default': 'master.info', 'type': 'filename'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'master-password',
    'description': 'The password the slave thread will authenticate with when connecting to master',
    'name': 'master-password',
    'values': [{ 'type': 'string'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-port',
    'description': 'The port the master is listening on',
    'name': 'master-port',
    'values': [{ 'default': '3306', 'type': 'integer'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-retry-count',
    'description': 'Number of tries the slave makes to connect to the master before giving up',
    'name': 'master-retry-count',
    'values': [ { 'bitsize': '32',
                  'default': '86400',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '86400',
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'master-ssl',
    'description': 'Enable the slave to connect to the master using SSL',
    'name': 'master-ssl',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-ssl-ca',
    'description': 'Master SSL CA file; applies only if master-ssl is enabled',
    'name': 'master-ssl-ca',
    'values': [{ 'type': 'filename'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-ssl-capath',
    'description': 'Master SSL CA path; applies only if master-ssl is enabled',
    'name': 'master-ssl-capath',
    'values': [{ 'type': 'dirname'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-ssl-cert',
    'description': 'Master SSL certificate file name; applies only if master-ssl is enabled',
    'name': 'master-ssl-cert',
    'values': [{ 'type': 'filename'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-ssl-cipher',
    'description': 'Master SSL cipher; applies only if master-ssl is enabled',
    'name': 'master-ssl-cipher',
    'values': [{ 'type': 'string'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-ssl-key',
    'description': 'Master SSL key file name; applies only if master-ssl is enabled',
    'name': 'master-ssl-key',
    'values': [{ 'type': 'filename'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-user',
    'description': 'The user name the slave thread will use for authentication when connecting to master. The user must have FILE privilege. If the master user is not set, user test is assumed. The value in master.info will take precedence if it can be read',
    'name': 'master-user',
    'values': [{ 'default': 'test', 'type': 'string'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'master-verify-checksum',
    'description': 'Cause master to examine checksums when reading from the binary log',
    'name': 'master-verify-checksum',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'master_info_repository',
    'description': "Whether to write master status information and replication I/O thread location in the master's binary logs to a file or table",
    'name': 'master_info_repository',
    'values': [ { 'choice': ['FILE', 'TABLE'],
                  'default': 'FILE',
                  'type': 'string'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'max-binlog-dump-events',
    'description': 'Option used by mysql-test for debugging and testing of replication',
    'name': 'max-binlog-dump-events',
    'values': [{ 'default': '0', 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_allowed_packet',
    'description': 'Max packet length to send to/receive from server',
    'name': 'max_allowed_packet',
    'values': [ { 'default': '1048576',
                  'maximum': '1073741824',
                  'minimum': '1024',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '4194304',
                  'inversion': (5, 6, 6),
                  'maximum': '1073741824',
                  'minimum': '1024',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_binlog_cache_size',
    'description': 'Can be used to restrict the total size used to cache a multi-statement transaction',
    'name': 'max_binlog_cache_size',
    'values': [ { 'bitsize': '32',
                  'default': '4294967295',
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'outversion': (5, 1, 35),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '18446744073709547520',
                  'maximum': '18446744073709547520',
                  'minimum': '4096',
                  'outversion': (5, 1, 35),
                  'type': 'integer'},
                { 'default': '18446744073709547520',
                  'inversion': (5, 1, 36),
                  'maximum': '18446744073709547520',
                  'minimum': '4096',
                  'outversion': (5, 1, 99),
                  'type': 'integer'},
                { 'default': '4294967295',
                  'inversion': (5, 4, 0),
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'outversion': (5, 4, 1),
                  'type': 'integer'},
                { 'default': '18446744073709547520',
                  'inversion': (5, 4, 2),
                  'maximum': '18446744073709547520',
                  'minimum': '4096',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'default': '18446744073709551615',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '4096',
                  'type': 'integer'},
                { 'default': '4294967295',
                  'inversion': (6, 0, 0),
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_binlog_size',
    'description': 'Binary log will be rotated automatically when size exceeds this value',
    'name': 'max_binlog_size',
    'values': [ { 'default': '1073741824',
                  'maximum': '1073741824',
                  'minimum': '4096',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_binlog_stmt_cache_size',
    'description': 'Can be used to restrict the total size used to cache all nontransactional statements during a transaction',
    'name': 'max_binlog_stmt_cache_size',
    'values': [ { 'default': '18446744073709547520',
                  'maximum': '18446744073709547520',
                  'minimum': '4096',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 9), (5, 6, 1)),
                  ((5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'max_connect_errors',
    'description': 'Number of interrupted connections from a host before this host is blocked from further connections',
    'name': 'max_connect_errors',
    'values': [ { 'bitsize': '32',
                  'default': '10',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '100',
                  'inversion': (5, 6, 6),
                  'maximum': '4294967295',
                  'minimum': '1',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10',
                  'maximum': '18446744073709547520',
                  'minimum': '1',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '100',
                  'inversion': (5, 6, 6),
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_connections',
    'description': 'Number of simultaneous clients allowed',
    'name': 'max_connections',
    'values': [ { 'default': '100',
                  'maximum': '16384',
                  'minimum': '1',
                  'outversion': (5, 1, 14),
                  'type': 'integer'},
                { 'default': '151',
                  'inversion': (5, 1, 15),
                  'maximum': '16384',
                  'minimum': '1',
                  'outversion': (5, 1, 16),
                  'type': 'integer'},
                { 'default': '151',
                  'inversion': (5, 1, 17),
                  'maximum': '100000',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_delayed_threads',
    'description': 'Do not start more than this number of threads to handle INSERT DELAYED statements. If set to zero, which means INSERT DELAYED is not used',
    'name': 'max_delayed_threads',
    'values': [ { 'default': '20',
                  'maximum': '16384',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_digest_length',
    'description': 'The maximum digest size in bytes',
    'name': 'max_digest_length',
    'values': [ { 'default': '1024',
                  'maximum': '1048576',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 24), (5, 7, 6)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'max_error_count',
    'description': 'Max number of errors/warnings to store for a statement',
    'name': 'max_error_count',
    'values': [ { 'default': '64',
                  'maximum': '65535',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_execution_time',
    'description': 'Statement execution timeout value',
    'name': 'max_execution_time',
    'optype': { 'format': 'max_execution_time=#'},
    'values': [{ 'default': '0', 'type': 'integer'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'max_heap_table_size',
    'description': 'Do not allow creation of heap tables bigger than this',
    'name': 'max_heap_table_size',
    'values': [ { 'bitsize': '32',
                  'default': '16777216',
                  'maximum': '4294967295',
                  'minimum': '16384',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '16777216',
                  'maximum': '1844674407370954752',
                  'minimum': '16384',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_join_size',
    'description': 'Joins that are probably going to read more than max_join_size records return an error',
    'name': 'max_join_size',
    'values': [ { 'default': '4294967295',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'outversion': (5, 4, 99),
                  'type': 'integer'},
                { 'default': '18446744073709551615',
                  'inversion': (5, 5, 0),
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_length_for_sort_data',
    'description': 'Max number of bytes in sorted records',
    'name': 'max_length_for_sort_data',
    'values': [ { 'default': '1024',
                  'maximum': '8388608',
                  'minimum': '4',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_long_data_size',
    'description': 'Max size of parameter values that mysql_stmt_send_long_data() can send',
    'name': 'max_long_data_size',
    'values': [ { 'default': '1048576',
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'type': 'integer'}],
    'versions': [((5, 1, 57), (5, 5, 11)), ((5, 1), (5, 5)), ()]},
  { 'caption': 'max_points_in_geometry',
    'description': 'Maximum number of points in geometry values for ST_Buffer_Strategy()',
    'name': 'max_points_in_geometry',
    'values': [ { 'default': '65536',
                  'maximum': '1048576',
                  'minimum': '3',
                  'type': 'integer'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'max_prepared_stmt_count',
    'description': 'Maximum number of prepared statements in the server',
    'name': 'max_prepared_stmt_count',
    'optype': { 'inversion': '5.0.21'},
    'values': [ { 'default': '16382',
                  'maximum': '1048576',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 19), (5, 0, 21), (5, 1, 10)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_relay_log_size',
    'description': 'If nonzero, relay log is rotated automatically when its size exceeds this value. If zero, size at which rotation occurs is determined by the value of max_binlog_size.',
    'name': 'max_relay_log_size',
    'values': [ { 'default': '0',
                  'maximum': '1073741824',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_seeks_for_key',
    'description': 'Limit assumed max number of seeks when looking up rows based on a key',
    'name': 'max_seeks_for_key',
    'values': [ { 'bitsize': '32',
                  'default': '4294967295',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '18446744073709547520',
                  'maximum': '18446744073709547520',
                  'minimum': '1',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '18446744073709551615',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_sort_length',
    'description': 'Number of bytes to use when sorting data values',
    'name': 'max_sort_length',
    'values': [ { 'default': '1024',
                  'maximum': '8388608',
                  'minimum': '4',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_sp_recursion_depth',
    'description': 'Maximum stored procedure recursion depth',
    'name': 'max_sp_recursion_depth',
    'values': [{ 'default': '0', 'maximum': '255', 'type': 'integer'}],
    'versions': [ ((5, 0, 17),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_user_connections',
    'description': 'The maximum number of active connections for a single user (0 = no limit)',
    'name': 'max_user_connections',
    'values': [ { 'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'max_write_lock_count',
    'description': 'After this many write locks, allow some read locks to run in between',
    'name': 'max_write_lock_count',
    'values': [ { 'bitsize': '32',
                  'default': '4294967295',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '18446744073709547520',
                  'maximum': '18446744073709547520',
                  'minimum': '1',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '18446744073709551615',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'mecab_rc_file',
    'description': 'Defines the path to the mecabrc configuration file for the MeCab parser for InnoDB Full-Text Search.',
    'name': 'mecab_rc_file',
    'values': [{ 'type': 'dirname'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'memlock',
    'description': 'Lock the mysqld process in memory',
    'name': 'memlock',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'min-examined-row-limit',
    'description': 'Queries examining fewer than this number of rows are not logged to slow query log',
    'name': 'min-examined-row-limit',
    'values': [ { 'bitsize': '32',
                  'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 21), (6, 0, 4)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'multi_range_count',
    'description': 'The maximum number of ranges to send to a table handler at once during range selects',
    'name': 'multi_range_count',
    'values': [ { 'default': '256',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 3),),
                  ((5, 0), (5, 1), (5, 2), (5, 4), (5, 5), (5, 6), (5, 7)),
                  ((5, 2, 4), (6, 0, 3))]},
  { 'caption': 'mutex-deadlock-detector',
    'description': 'Enable detection of incorrect mutex usage',
    'name': 'mutex-deadlock-detector',
    'values': [ { 'default': 'true',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [((6, 0, 9),), ((6, 0),), ()]},
  { 'caption': 'myisam-block-size',
    'description': 'Block size to be used for MyISAM index pages',
    'name': 'myisam-block-size',
    'values': [ { 'default': '1024',
                  'maximum': '16384',
                  'minimum': '1024',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'myisam-recover',
    'description': 'Set the mode for automatic MyISAM recovery',
    'name': 'myisam-recover',
    'values': [ { 'choice': ['OFF', 'DEFAULT', 'BACKUP', 'FORCE', 'QUICK'],
                  'default': 'OFF',
                  'type': 'enum'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                  ((5, 5, 3), (6, 0, 14))]},
  { 'caption': 'myisam-recover-options',
    'description': 'Set the mode for automatic MyISAM recovery',
    'name': 'myisam-recover-options',
    'values': [ { 'choice': ['OFF', 'DEFAULT', 'BACKUP', 'FORCE', 'QUICK'],
                  'default': 'OFF',
                  'type': 'enum'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'myisam_data_pointer_size',
    'description': 'Default pointer size to be used for MyISAM tables',
    'name': 'myisam_data_pointer_size',
    'values': [ { 'default': '4',
                  'maximum': '8',
                  'minimum': '2',
                  'outversion': (5, 0, 5),
                  'type': 'integer'},
                { 'default': '6',
                  'inversion': (5, 0, 6),
                  'maximum': '7',
                  'minimum': '2',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 2),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'myisam_max_extra_sort_file_size',
    'description': 'Deprecated option',
    'name': 'myisam_max_extra_sort_file_size',
    'optype': { 'outversion': '5.0.6'},
    'values': [ { 'default': '2147483648',
                  'outversion': (5, 0, 6),
                  'type': 'integer'}],
    'versions': [(), ((4, 1), (5, 0)), ()]},
  { 'caption': 'myisam_max_sort_file_size',
    'description': 'Do not use the fast sort index method to create index if the temporary file would get bigger than this',
    'name': 'myisam_max_sort_file_size',
    'values': [ { 'bitsize': '32',
                  'default': '2147483648',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '9223372036854775807',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'myisam_mmap_size',
    'description': 'The maximum amount of memory to use for memory mapping compressed MyISAM files.',
    'name': 'myisam_mmap_size',
    'values': [ { 'bitsize': '32',
                  'default': '4294967295',
                  'maximum': '4294967295',
                  'minimum': '7',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '18446744073709547520',
                  'maximum': '18446744073709547520',
                  'minimum': '7',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '18446744073709551615',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '7',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 90), (5, 1, 43), (5, 5, 1), (6, 0, 14)),
                  ((5, 0), (5, 1), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'myisam_repair_threads',
    'description': 'Number of threads to use when repairing MyISAM tables. The value of 1 disables parallel repair',
    'name': 'myisam_repair_threads',
    'values': [ { 'bitsize': '32',
                  'default': '1',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1',
                  'maximum': '18446744073709547520',
                  'minimum': '1',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'myisam_sort_buffer_size',
    'description': 'The buffer allocated when sorting the index for a REPAIR TABLE or when creating indexes for CREATE INDEX or ALTER TABLE',
    'name': 'myisam_sort_buffer_size',
    'values': [ { 'bitsize': '32',
                  'default': '8388608',
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'platform': 'other',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '8388608',
                  'maximum': '18446744073709547520',
                  'minimum': '4096',
                  'outversion': (5, 5, 2),
                  'platform': 'other',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '8388608',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '4096',
                  'platform': 'other',
                  'type': 'integer'},
                { 'default': '8388608',
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'outversion': (5, 1, 99),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '8388608',
                  'inversion': (5, 5, 0),
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '8388608',
                  'inversion': (5, 5, 0),
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'outversion': (5, 5, 21),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '8388608',
                  'inversion': (5, 5, 22),
                  'maximum': '18446744073709551615',
                  'minimum': '4096',
                  'outversion': (5, 5, 99),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '8388608',
                  'inversion': (5, 6, 0),
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'outversion': (5, 6, 4),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '8388608',
                  'inversion': (5, 6, 5),
                  'maximum': '18446744073709551615',
                  'minimum': '4096',
                  'platform': 'windows',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'myisam_stats_method',
    'description': 'Specifies how MyISAM index statistics collection code should treat NULLs',
    'name': 'myisam_stats_method',
    'values': [ { 'default': 'nulls_unequal',
                  'inversion': (4, 1, 15),
                  'outversion': (4, 1, 99),
                  'type': 'enum'},
                { 'choice': [ 'nulls_equal',
                              'nulls_unequal',
                              'nulls_ignored'],
                  'default': 'nulls_unequal',
                  'inversion': (5, 0, 14),
                  'type': 'enum'}],
    'versions': [ ((4, 1, 15), (5, 0, 14)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'myisam_use_mmap',
    'description': 'Use memory mapping for reading and writing MyISAM tables',
    'name': 'myisam_use_mmap',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 4),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'mysql-backup',
    'description': 'Enable MySQL Backup features',
    'name': 'mysql-backup',
    'values': [],
    'versions': [((6, 0, 14),), ((6, 0),), ()]},
  { 'caption': 'mysql_native_password_proxy_users',
    'description': 'Whether the mysql_native_password authentication plugin does proxying',
    'name': 'mysql_native_password_proxy_users',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 7),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'mysql_firewall_max_query_size',
    'description': 'Maximum size of recorded statements',
    'name': 'mysql_firewall_max_query_size',
    'values': [ { 'default': '4096',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 24),), ((5, 6),), ((5, 6, 26),)]},
  { 'caption': 'mysql_firewall_mode',
    'description': 'Whether MySQL Enterprise Firewall is operational',
    'name': 'mysql_firewall_mode',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 24), (5, 7, 9)), ((5, 6), (5, 7)), ()]},
  { 'caption': 'mysql_firewall_trace',
    'description': 'Whether to enable firewall trace',
    'name': 'mysql_firewall_trace',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 24), (5, 7, 9)), ((5, 6), (5, 7)), ()]},
  { 'caption': 'ndb-batch-size',
    'description': 'Size (in bytes) to use for NDB transaction batches',
    'name': 'ndb-batch-size',
    'values': [ { 'default': '32768',
                  'maximum': '31536000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 1, 23),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ndb-blob-read-batch-bytes',
    'description': 'Specifies size in bytes that large BLOB reads should be batched into. 0 = no limit.',
    'name': 'ndb-blob-read-batch-bytes',
    'values': [ { 'default': '65536',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 51), (5, 1, 51)),
                  ((5, 1), (5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'ndb-blob-write-batch-bytes',
    'description': 'Specifies size in bytes that large BLOB writes should be batched into. 0 = no limit.',
    'name': 'ndb-blob-write-batch-bytes',
    'values': [ { 'default': '65536',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 51), (5, 1, 51)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ndb-cluster-connection-pool',
    'description': 'Number of connections to the cluster used by MySQL',
    'name': 'ndb-cluster-connection-pool',
    'values': [ { 'default': '1',
                  'maximum': '63',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 1, 19),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ndb-cluster-connection-pool-nodeids',
    'description': 'Comma-separated list of node IDs for connections to the cluster used by MySQL; the number of nodes in the list must be the same as the value set for --ndb-cluster-connection-pool',
    'name': 'ndb-cluster-connection-pool-nodeids',
    'values': [{ 'default': '', 'type': 'set'}],
    'versions': [((5, 7, 10),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'ndb-connectstring',
    'description': 'Point to the management server that distributes the cluster configuration',
    'name': 'ndb-connectstring',
    'values': [{ 'type': 'string'}],
    'versions': [(), ((5, 0), (5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ndb-log-transaction-id',
    'description': 'Write NDB transaction IDs in the binary log. Requires --log-bin-v1-events=OFF.',
    'name': 'ndb-log-transaction-id',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 56), (5, 5, 15)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ndb-log-update-as-write',
    'description': 'Toggles logging of updates on the master between updates (OFF) and writes (ON)',
    'name': 'ndb-log-update-as-write',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 1, 19), (5, 1, 22)), ((5, 1), (5, 5), (5, 6)), ()]},
  { 'caption': 'ndb-mgmd-host',
    'description': 'Set the host (and port, if desired) for connecting to management server',
    'name': 'ndb-mgmd-host',
    'values': [{ 'default': 'localhost:1186', 'type': 'string'}],
    'versions': [(), ((5, 0), (5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ndb-nodeid',
    'description': 'MySQL Cluster node ID for this MySQL server',
    'name': 'ndb-nodeid',
    'values': [ { 'inversion': (5, 0, 45),
                  'maximum': '63',
                  'minimum': '1',
                  'type': 'integer'},
                { 'inversion': (5, 1, 5),
                  'maximum': '255',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 45), (5, 1, 15)),
                  ((5, 0), (5, 1), (5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'ndb-recv-thread-activation-threshold',
    'description': 'Activation threshold when receive thread takes over the polling of the cluster connection (measured in concurrently active threads)',
    'name': 'ndb-recv-thread-activation-threshold',
    'values': [ { 'default': '8',
                  'inversion': (5, 6, 10),
                  'maximum': '16 (MAX_ACTIVATION_THRESHOLD)',
                  'minimum': '0 (MIN_ACTIVATION_THRESHOLD)',
                  'type': 'integer'}],
    'versions': [((5, 6, 10),), ((5, 6), (5, 7)), ()]},
  { 'caption': 'ndb-recv-thread-cpu-mask',
    'description': 'CPU mask for locking receiver threads to specific CPUs; specified as hexadecimal. See documentation for details.',
    'name': 'ndb-recv-thread-cpu-mask',
    'values': [{ 'type': 'bitmap'}],
    'versions': [((5, 6, 10),), ((5, 6), (5, 7)), ()]},
  { 'caption': 'ndb-wait-connected',
    'description': 'Time (in seconds) for the MySQL server to wait for connection to cluster management and data nodes before accepting MySQL client connections.',
    'name': 'ndb-wait-connected',
    'values': [ { 'default': '0',
                  'maximum': '31536000',
                  'minimum': '0',
                  'outversion': (5, 1, 56),
                  'type': 'integer'},
                { 'default': '30',
                  'inversion': (5, 1, 56),
                  'maximum': '31536000',
                  'minimum': '0',
                  'type': 'integer'},
                { 'default': '0',
                  'maximum': '31536000',
                  'minimum': '0',
                  'outversion': (5, 1, 56),
                  'type': 'integer'},
                { 'default': '30',
                  'inversion': (5, 1, 56),
                  'maximum': '31536000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 1, 16),), ((5, 1), (5, 5), (5, 6), (5, 7)), ()]},
  { 'caption': 'ndb-wait-setup',
    'description': 'Time (in seconds) for the MySQL server to wait for NDB engine setup to complete.',
    'name': 'ndb-wait-setup',
    'values': [ { 'default': '15',
                  'inversion': (5, 1, 39),
                  'maximum': '31536000',
                  'minimum': '0',
                  'type': 'integer'},
                { 'default': '15',
                  'inversion': (5, 1, 39),
                  'maximum': '31536000',
                  'minimum': '0',
                  'type': 'integer'},
                { 'default': '15',
                  'inversion': (5, 1, 39),
                  'maximum': '31536000',
                  'minimum': '0',
                  'outversion': (5, 1, 56),
                  'type': 'integer'},
                { 'default': '30',
                  'inversion': (5, 1, 56),
                  'maximum': '31536000',
                  'minimum': '0',
                  'type': 'integer'},
                { 'default': '15',
                  'inversion': (5, 1, 39),
                  'maximum': '31536000',
                  'minimum': '0',
                  'outversion': (5, 1, 56),
                  'type': 'integer'},
                { 'default': '30',
                  'inversion': (5, 1, 56),
                  'maximum': '31536000',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 39), (5, 1, 39), (5, 1, 39)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ndb-allow-copying-alter-table',
    'description': 'Set to OFF to keep ALTER TABLE from using copying operations on NDB tables',
    'name': 'ndb-allow-copying-alter-table',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 10),), ((5, 7),), ()]},
  { 'caption': 'ndb_autoincrement_prefetch_sz',
    'description': 'NDB auto-increment prefetch size',
    'name': 'ndb_autoincrement_prefetch_sz',
    'values': [ { 'default': '32',
                  'maximum': '256',
                  'minimum': '1',
                  'outversion': (5, 0, 55),
                  'type': 'integer'},
                { 'default': '1',
                  'inversion': (5, 0, 56),
                  'maximum': '256',
                  'minimum': '1',
                  'type': 'integer'},
                { 'default': '32',
                  'inversion': (5, 1, 1),
                  'maximum': '256',
                  'minimum': '1',
                  'outversion': (5, 1, 22),
                  'type': 'integer'},
                { 'default': '1',
                  'inversion': (5, 1, 23),
                  'maximum': '256',
                  'minimum': '1',
                  'outversion': (5, 1, 24),
                  'type': 'integer'},
                { 'default': '32',
                  'inversion': (5, 1, 16),
                  'maximum': '256',
                  'minimum': '1',
                  'outversion': (5, 1, 22),
                  'type': 'integer'},
                { 'default': '1',
                  'inversion': (5, 1, 23),
                  'maximum': '256',
                  'minimum': '1',
                  'type': 'integer'},
                { 'default': '32',
                  'inversion': (5, 1, 19),
                  'maximum': '256',
                  'minimum': '1',
                  'outversion': (5, 1, 22),
                  'type': 'integer'},
                { 'default': '1',
                  'inversion': (5, 1, 23),
                  'maximum': '256',
                  'minimum': '1',
                  'outversion': (5, 1, 39),
                  'type': 'integer'},
                { 'default': '1',
                  'inversion': (5, 1, 41),
                  'maximum': '65536',
                  'minimum': '1',
                  'type': 'integer'},
                { 'default': '32',
                  'inversion': (5, 1, 30),
                  'maximum': '256',
                  'minimum': '1',
                  'outversion': (5, 1, 39),
                  'type': 'integer'},
                { 'default': '1',
                  'inversion': (5, 1, 41),
                  'maximum': '65536',
                  'minimum': '1',
                  'type': 'integer'},
                { 'default': '1',
                  'inversion': (5, 5, 15),
                  'maximum': '65536',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 8),),
                  ((4, 1), (5, 0), (5, 1), (5, 5), (5, 6), (5, 7), (6, 0)),
                  ()]},
  { 'caption': 'ndb_cache_check_time',
    'description': 'Number of milliseconds between checks of cluster SQL nodes made by the MySQL query cache',
    'name': 'ndb_cache_check_time',
    'values': [{ 'default': '0', 'type': 'integer'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 5), (5, 6), (5, 7)), ()]},
  { 'caption': 'ndb_data_node_neighbour',
    'description': 'Specifies cluster data node "closest" to this MySQL Server, for transaction hinting and fully replicated tables',
    'name': 'ndb_data_node_neighbour',
    'values': [ { 'default': '0',
                  'inversion': (5, 7, 12),
                  'maximum': '255',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 12),), ((5, 7),), ()]},
  { 'caption': 'ndb_default_column_format',
    'description': 'Sets default row format and column format (FIXED or DYNAMIC) used for new NDB tables.',
    'name': 'ndb_default_column_format',
    'values': [ { 'choice': ['FIXED', 'DYNAMIC'],
                  'default': 'DYNAMIC',
                  'inversion': (5, 7, 11),
                  'outversion': (5, 7, 13),
                  'type': 'enum'},
                { 'choice': ['FIXED', 'DYNAMIC'],
                  'default': 'FIXED',
                  'inversion': (5, 7, 16),
                  'type': 'enum'}],
    'versions': [((5, 7, 11),), ((5, 7),), ()]},
  { 'caption': 'ndb_deferred_constraints',
    'description': 'Specifies that constraint checks should be deferred (where these are supported). Not normally needed or used; for testing purposes only.',
    'name': 'ndb_deferred_constraints',
    'values': [ { 'default': '0',
                  'maximum': '1',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 56), (5, 1, 56)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ndb_distribution',
    'description': 'Default distribution for new tables in NDBCLUSTER (KEYHASH or LINHASH, default is KEYHASH)',
    'name': 'ndb_distribution',
    'values': [ { 'choice': ['LINHASH', 'KEYHASH'],
                  'default': 'KEYHASH',
                  'type': 'enum'}],
    'versions': [((5, 1, 32),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ndb_eventbuffer_free_percent',
    'description': 'Percentage of free memory that should be available in event buffer before resumption of buffering, after reaching limit set by ndb_eventbuffer_max_alloc.',
    'name': 'ndb_eventbuffer_free_percent',
    'values': [ { 'default': '20',
                  'maximum': '99',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 6, 22),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ndb_eventbuffer_max_alloc',
    'description': 'Maximum memory that can be allocated for buffering events by the NDB API. Defaults to 0 (no limit).',
    'name': 'ndb_eventbuffer_max_alloc',
    'values': [ { 'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 72), (5, 5, 34), (5, 6, 14)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ndb_extra_logging',
    'description': 'Controls logging of MySQL Cluster schema, connection, and data distribution events in the MySQL error log',
    'name': 'ndb_extra_logging',
    'values': [ { 'default': '0',
                  'outversion': (5, 1, 18),
                  'type': 'integer'},
                { 'default': '1', 'inversion': (5, 1, 19), 'type': 'integer'}],
    'versions': [((5, 1, 6),), ((5, 1), (5, 5), (5, 6), (5, 7)), ()]},
  { 'caption': 'ndb_force_send',
    'description': 'Forces sending of buffers to NDB immediately, without waiting for other threads',
    'name': 'ndb_force_send',
    'values': [ { 'default': 'true',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 8),),
                  ((4, 1), (5, 0), (5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ndb_fully_replicated',
    'description': 'Whether new NDB tables are fully replicated',
    'name': 'ndb_fully_replicated',
    'values': [ { 'default': 'off',
                  'inversion': (5, 7, 12),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 12),), ((5, 7),), ()]},
  { 'caption': 'ndb_index_stat_cache_entries',
    'description': 'Sets the granularity of the statistics by determining the number of starting and ending keys',
    'name': 'ndb_index_stat_cache_entries',
    'values': [ { 'default': '32',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 5), (5, 6)),
                  ((5, 1, 73), (5, 5, 36), (5, 6, 16))]},
  { 'caption': 'ndb_index_stat_enable',
    'description': 'Use NDB index statistics in query optimization',
    'name': 'ndb_index_stat_enable',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 1, 51),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (5, 5, 15),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ndb_index_stat_option',
    'description': 'Comma-separated list of tunable options for NDB index statistics; the list should contain no spaces',
    'name': 'ndb_index_stat_option',
    'values': [ { 'default': 'loop_enable=1000ms,loop_idle=1000ms,loop_busy=100ms,         update_batch=1,read_batch=4,idle_batch=32,check_batch=8,          check_delay=10m,delete_batch=8, clean_delay=1m,error_batch=4,          error_delay=1m,evict_batch=8,evict_delay=1m,cache_limit=32M,          cache_lowpct=90,zero_total=0',
                  'outversion': (5, 1, 56),
                  'type': 'string'},
                { 'default': 'loop_checkon=1000ms,loop_idle=1000ms,loop_busy=100ms,         update_batch=1,read_batch=4,idle_batch=32,check_batch=32,         check_delay=1m,delete_batch=8,clean_delay=0,error_batch=4,         error_delay=1m,evict_batch=8,evict_delay=1m,cache_limit=32M,         cache_lowpct=90',
                  'inversion': (5, 1, 56),
                  'type': 'string'}],
    'versions': [ ((5, 1, 1), (5, 5, 15)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ndb_index_stat_update_freq',
    'description': 'How often to query data nodes instead of the statistics cache',
    'name': 'ndb_index_stat_update_freq',
    'values': [ { 'default': '20',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 5), (5, 6)),
                  ((5, 1, 73), (5, 5, 36), (5, 6, 16))]},
  { 'caption': 'ndb_log_apply_status',
    'description': 'Whether or not a MySQL server acting as a slave logs mysql.ndb_apply_status updates received from its immediate master in its own binary log, using its own server ID.',
    'name': 'ndb_log_apply_status',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 51), (5, 1, 51)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ndb_log_empty_epochs',
    'description': 'When enabled, epochs in which there were no changes are written to the ndb_apply_status and ndb_binlog_index tables, even when log_slave_updates is enabled.',
    'name': 'ndb_log_empty_epochs',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 31), (5, 1, 31)),
                  ((5, 1), (5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'ndb_log_empty_update',
    'description': 'When enabled, updates which produce no changes are written to the ndb_apply_status and ndb_binlog_index tables, even when log_slave_updates is enabled.',
    'name': 'ndb_log_empty_update',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 31), (5, 1, 31)),
                  ((5, 1), (5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'ndb_log_exclusive_reads',
    'description': 'Log primary key reads with exclusive locks; allow conflict resolution based on read conflicts.',
    'name': 'ndb_log_exclusive_reads',
    'values': [{ 'default': '0', 'off': '0', 'on': '1', 'type': 'boolean'}],
    'versions': [((5, 6, 20),), ((5, 6), (5, 7)), ()]},
  { 'caption': 'ndb_log_orig',
    'description': 'Whether the id and epoch of the originating server are recorded in the mysql.ndb_binlog_index table. Set using the --ndb-log-orig option when starting mysqld.',
    'name': 'ndb_log_orig',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 1, 22),), ((5, 1), (5, 5), (5, 6), (5, 7)), ()]},
  { 'caption': 'ndb_log_updated_only',
    'description': 'Log complete rows (ON) or updates only (OFF)',
    'name': 'ndb_log_updated_only',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 1, 19),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ndb_optimized_node_selection',
    'description': 'Determines how an SQL node chooses a cluster data node to use as transaction coordinator',
    'name': 'ndb_optimized_node_selection',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 1, 22),
                  'type': 'boolean'},
                { 'default': '3',
                  'inversion': (5, 1, 22),
                  'maximum': '3',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 9),),
                  ((4, 1), (5, 0), (5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'ndb_read_backup',
    'description': 'Enable read from any replica',
    'name': 'ndb_read_backup',
    'values': [ { 'default': 'off',
                  'inversion': (5, 7, 12),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 12),), ((5, 7),), ()]},
  { 'caption': 'ndb_report_thresh_binlog_epoch_slip',
    'description': 'NDB 7.5.4 and later: Threshold for number of epochs completely buffered, but not yet consumed by binlog injector thread which when exceeded generates BUFFERED_EPOCHS_OVER_THRESHOLD event buffer status message; prior to NDB 7.5.4: Threshold for number of epochs to lag behind before reporting binary log status',
    'name': 'ndb_report_thresh_binlog_epoch_slip',
    'values': [ { 'default': '3',
                  'maximum': '256',
                  'minimum': '0',
                  'outversion': (5, 7, 13),
                  'type': 'integer'},
                { 'default': '10',
                  'inversion': (5, 7, 16),
                  'maximum': '256',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ndb_report_thresh_binlog_mem_usage',
    'description': 'This is a threshold on the percentage of free memory remaining before reporting binary log status',
    'name': 'ndb_report_thresh_binlog_mem_usage',
    'values': [ { 'default': '10',
                  'maximum': '10',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ndb_show_foreign_key_mock_tables',
    'description': 'Show the mock tables used to support foreign_key_checks=0.',
    'name': 'ndb_show_foreign_key_mock_tables',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 11),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ndb_slave_conflict_role',
    'description': 'Role for slave to play in conflict detection and resolution. Value is one of PRIMARY, SECONDARY, PASS, or NONE (default). Can be changed only when slave SQL thread is stopped. See documentation for further information.',
    'name': 'ndb_slave_conflict_role',
    'values': [ { 'choice': ['NONE', 'PRIMARY', 'SECONDARY', 'PASS'],
                  'default': 'NONE',
                  'type': 'enum'}],
    'versions': [((5, 6, 20),), ((5, 6), (5, 7)), ()]},
  { 'caption': 'ndb_use_transactions',
    'description': 'Forces NDB to use a count of records during SELECT COUNT(*) query planning to speed up this type of query',
    'name': 'ndb_use_transactions',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 18),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ndbcluster',
    'description': 'Enable NDB Cluster (if this version of MySQL supports it)',
    'disabledby': 'skip-ndbcluster',
    'name': 'ndbcluster',
    'values': [ { 'default': 'false',
                  'off': 'disabledby',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 5), (5, 6), (5, 7)), ()]},
  { 'caption': 'net_buffer_length',
    'description': 'Buffer length for TCP/IP and socket communication',
    'name': 'net_buffer_length',
    'values': [ { 'default': '16384',
                  'maximum': '1048576',
                  'minimum': '1024',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'net_read_timeout',
    'description': 'Number of seconds to wait for more data from a connection before aborting the read',
    'name': 'net_read_timeout',
    'values': [{ 'default': '30', 'minimum': '1', 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'net_retry_count',
    'description': 'Number of times to retry an interrupted read or write on a communication port before giving up',
    'name': 'net_retry_count',
    'values': [ { 'bitsize': '32',
                  'default': '10',
                  'maximum': '4294967295',
                  'minimum': '1',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10',
                  'maximum': '18446744073709547520',
                  'minimum': '1',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'net_write_timeout',
    'description': 'Number of seconds to wait for a block to be written to a connection before aborting the write',
    'name': 'net_write_timeout',
    'values': [{ 'default': '60', 'minimum': '1', 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'new',
    'description': "Use very new, possibly 'unsafe' functions",
    'disabledby': 'skip-new',
    'name': 'new',
    'values': [ { 'default': 'false',
                  'off': 'disabledby',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ngram_token_size',
    'description': 'Defines the n-gram token size for the InnoDB Full-Text Search n-gram parser.',
    'name': 'ngram_token_size',
    'values': [ { 'default': '2',
                  'maximum': '10',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'offline_mode',
    'description': 'Whether server is offline',
    'name': 'offline_mode',
    'optype': { 'format': 'offline_mode=val'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'old',
    'description': 'Cause the server to revert to certain behaviors present in older versions',
    'name': 'old',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ ((5, 1, 18),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'old-alter-table',
    'description': 'Use old, nonoptimized alter table',
    'name': 'old-alter-table',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'old-protocol',
    'description': 'Use old server behaviors',
    'name': 'old-protocol',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [(), ((4, 1),), ((4, 1, 1),)]},
  { 'caption': 'old-style-user-limits',
    'description': 'Enable old-style user limits (before 5.0.3, user resources were counted per each user+host vs. per account)',
    'name': 'old-style-user-limits',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 3),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'one-thread',
    'description': 'Only use one thread (for debugging under Linux)',
    'name': 'one-thread',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                  ((5, 6, 1),)]},
  { 'caption': 'open-files-limit',
    'description': 'If this is not 0, then mysqld will use this value to reserve file descriptors to use with setrlimit()',
    'name': 'open-files-limit',
    'values': [ { 'default': '0',
                  'maximum': 'platform dependent',
                  'minimum': '0',
                  'outversion': (5, 6, 7),
                  'type': 'integer'},
                { 'default': '5000, with possible adjustment',
                  'inversion': (5, 6, 8),
                  'maximum': 'platform dependent',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'optimizer_join_cache_level',
    'description': 'How join buffers are used',
    'name': 'optimizer_join_cache_level',
    'values': [ { 'default': '4',
                  'maximum': '4',
                  'minimum': '0',
                  'type': 'integer'},
                { 'default': '1',
                  'inversion': (6, 0, 14),
                  'maximum': '8',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 1), (6, 0, 14)), ((5, 6), (6, 0)), ((5, 6, 3),)]},
  { 'caption': 'optimizer_prune_level',
    'description': 'Controls the heuristic(s) applied during query optimization to prune less-promising partial plans from the optimizer search space',
    'name': 'optimizer_prune_level',
    'values': [{ 'default': '1', 'off': '0', 'on': '1', 'type': 'boolean'}],
    'versions': [ ((5, 0, 1),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'optimizer_search_depth',
    'description': 'Maximum depth of search performed by the query optimizer',
    'name': 'optimizer_search_depth',
    'values': [ { 'default': '62',
                  'maximum': '63',
                  'minimum': '0',
                  'outversion': (5, 5, 99),
                  'type': 'integer'},
                { 'default': '62',
                  'inversion': (5, 6, 0),
                  'maximum': '62',
                  'minimum': '0',
                  'type': 'integer'},
                { 'default': '62',
                  'inversion': (6, 0, 0),
                  'maximum': '63',
                  'minimum': '0',
                  'outversion': (6, 0, 13),
                  'type': 'integer'},
                { 'default': '62',
                  'inversion': (6, 0, 14),
                  'maximum': '62',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 1),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'optimizer_switch',
    'description': 'Enable control over which optimizations to use',
    'name': 'optimizer_switch',
    'optype': { 'outversion': '5.1.99'},
    'values': [ { 'choice': [ 'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}'],
                  'outversion': (5, 2, 3),
                  'type': 'set'},
                { 'choice': ['no_semijoin', 'no_materialization'],
                  'default': "''",
                  'inversion': (5, 2, 4),
                  'outversion': (5, 4, 1),
                  'type': 'set'},
                { 'choice': [ 'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}'],
                  'inversion': (5, 4, 2),
                  'outversion': (5, 5, 2),
                  'type': 'set'},
                { 'choice': [ 'engine_condition_pushdown={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}'],
                  'inversion': (5, 5, 3),
                  'outversion': (5, 6, 0),
                  'type': 'set'},
                { 'choice': [ 'engine_condition_pushdown={on|off}',
                              'index_condition_pushdown={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}',
                              'mrr={on|off}',
                              'mrr_cost_based={on|off}'],
                  'inversion': (5, 6, 1),
                  'outversion': (5, 6, 2),
                  'type': 'set'},
                { 'choice': [ 'batched_key_access={on|off}',
                              'block_nested_loop={on|off}',
                              'engine_condition_pushdown={on|off}',
                              'index_condition_pushdown={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}',
                              'mrr={on|off}',
                              'mrr_cost_based={on|off}'],
                  'inversion': (5, 6, 3),
                  'outversion': (5, 6, 4),
                  'type': 'set'},
                { 'choice': [ 'batched_key_access={on|off}',
                              'block_nested_loop={on|off}',
                              'engine_condition_pushdown={on|off}',
                              'firstmatch={on|off}',
                              'index_condition_pushdown={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}',
                              'loosescan={on|off}',
                              'materialization={on|off}',
                              'mrr={on|off}',
                              'mrr_cost_based={on|off}',
                              'semijoin={on|off}'],
                  'inversion': (5, 6, 5),
                  'outversion': (5, 6, 6),
                  'type': 'set'},
                { 'choice': [ 'batched_key_access={on|off}',
                              'block_nested_loop={on|off}',
                              'engine_condition_pushdown={on|off}',
                              'firstmatch={on|off}',
                              'index_condition_pushdown={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}',
                              'loosescan={on|off}',
                              'materialization={on|off}',
                              'mrr={on|off}',
                              'mrr_cost_based={on|off}',
                              'semijoin={on|off}',
                              'subquery_materialization_cost_based={on|off}'],
                  'inversion': (5, 6, 7),
                  'outversion': (5, 6, 8),
                  'type': 'set'},
                { 'choice': [ 'batched_key_access={on|off}',
                              'block_nested_loop={on|off}',
                              'engine_condition_pushdown={on|off}',
                              'firstmatch={on|off}',
                              'index_condition_pushdown={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}',
                              'loosescan={on|off}',
                              'materialization={on|off}',
                              'mrr={on|off}',
                              'mrr_cost_based={on|off}',
                              'semijoin={on|off}',
                              'subquery_materialization_cost_based={on|off}',
                              'use_index_extensions={on|off}'],
                  'inversion': (5, 6, 9),
                  'outversion': (5, 7, 4),
                  'type': 'set'},
                { 'choice': [ 'batched_key_access={on|off}',
                              'block_nested_loop={on|off}',
                              'condition_fanout_filter={on|off}',
                              'engine_condition_pushdown={on|off}',
                              'firstmatch={on|off}',
                              'index_condition_pushdown={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}',
                              'loosescan={on|off}',
                              'materialization={on|off}',
                              'mrr={on|off}',
                              'mrr_cost_based={on|off}',
                              'semijoin={on|off}',
                              'subquery_materialization_cost_based={on|off}',
                              'use_index_extensions={on|off}'],
                  'inversion': (5, 7, 5),
                  'outversion': (5, 7, 5),
                  'type': 'set'},
                { 'choice': [ 'batched_key_access={on|off}',
                              'block_nested_loop={on|off}',
                              'condition_fanout_filter={on|off}',
                              'derived_merge={on|off}',
                              'engine_condition_pushdown={on|off}',
                              'firstmatch={on|off}',
                              'index_condition_pushdown={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}',
                              'loosescan={on|off}',
                              'materialization={on|off}',
                              'mrr={on|off}',
                              'mrr_cost_based={on|off}',
                              'semijoin={on|off}',
                              'subquery_materialization_cost_based={on|off}',
                              'use_index_extensions={on|off}'],
                  'inversion': (5, 7, 6),
                  'outversion': (5, 7, 7),
                  'type': 'set'},
                { 'choice': [ 'batched_key_access={on|off}',
                              'block_nested_loop={on|off}',
                              'condition_fanout_filter={on|off}',
                              'derived_merge={on|off}',
                              'duplicateweedout={on|off}',
                              'engine_condition_pushdown={on|off}',
                              'firstmatch={on|off}',
                              'index_condition_pushdown={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}',
                              'loosescan={on|off}',
                              'materialization={on|off}',
                              'mrr={on|off}',
                              'mrr_cost_based={on|off}',
                              'semijoin={on|off}',
                              'subquery_materialization_cost_based={on|off}',
                              'use_index_extensions={on|off}'],
                  'inversion': (5, 7, 8),
                  'type': 'set'},
                { 'choice': [ 'no_firstmatch',
                              'no_loosescan',
                              'no_materialization',
                              'no_semijoin'],
                  'default': "''",
                  'inversion': (6, 0, 0),
                  'outversion': (6, 0, 10),
                  'type': 'set'},
                { 'choice': [ 'firstmatch={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}',
                              'loosescan={on|off}',
                              'materialization={on|off}',
                              'semijoin={on|off}'],
                  'inversion': (6, 0, 11),
                  'outversion': (6, 0, 13),
                  'type': 'set'},
                { 'choice': [ 'engine_condition_pushdown={on|off}',
                              'firstmatch={on|off}',
                              'index_condition_pushdown={on|off}',
                              'index_merge={on|off}',
                              'index_merge_intersection={on|off}',
                              'index_merge_sort_union={on|off}',
                              'index_merge_union={on|off}',
                              'loosescan={on|off}',
                              'materialization={on|off}',
                              'mrr={on|off}',
                              'mrr_cost_based={on|off}',
                              'semijoin={on|off}'],
                  'inversion': (6, 0, 14),
                  'type': 'set'}],
    'versions': [ ((5, 1, 34), (5, 2, 4), (5, 4, 2)),
                  ( (5, 1),
                    (5, 2),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'parser_max_mem_size',
    'description': 'Maximum amount of memory available to parser',
    'name': 'parser_max_mem_size',
    'values': [ { 'bitsize': '32',
                  'default': '4294967295',
                  'maximum': '4294967295',
                  'minimum': '400000',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '18446744073709551615',
                  'maximum': '18446744073709551615',
                  'minimum': '400000',
                  'type': 'integer'}],
    'versions': [((5, 7, 12),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'partition',
    'description': 'Enable (or disable) partitioning support',
    'disabledby': 'skip-partition',
    'name': 'partition',
    'values': [ { 'default': 'on',
                  'off': 'disabledby',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)),
                  ((8, 0, 0),)]},
  { 'caption': 'performance-schema-consumer-events-stages-current',
    'description': 'Configure events-stages-current consumer',
    'name': 'performance-schema-consumer-events-stages-current',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-stages-history',
    'description': 'Configure events-stages-history consumer',
    'name': 'performance-schema-consumer-events-stages-history',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-stages-history-long',
    'description': 'Configure events-stages-history-long consumer',
    'name': 'performance-schema-consumer-events-stages-history-long',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-statements-current',
    'description': 'Configure events-statements-current consumer',
    'name': 'performance-schema-consumer-events-statements-current',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-statements-history',
    'description': 'Configure events-statements-history consumer',
    'name': 'performance-schema-consumer-events-statements-history',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-statements-history-long',
    'description': 'Configure events-statements-history-long consumer',
    'name': 'performance-schema-consumer-events-statements-history-long',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-transactions-current',
    'description': 'Configure events-transactions-current consumer',
    'name': 'performance-schema-consumer-events-transactions-current',
    'values': [],
    'versions': [((5, 7, 3),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-transactions-history',
    'description': 'Configure events-transactions-history consumer',
    'name': 'performance-schema-consumer-events-transactions-history',
    'values': [],
    'versions': [((5, 7, 3),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-transactions-history-long',
    'description': 'Configure events-transactions-history-long consumer',
    'name': 'performance-schema-consumer-events-transactions-history-long',
    'values': [],
    'versions': [((5, 7, 3),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-waits-current',
    'description': 'Configure events-waits-current consumer',
    'name': 'performance-schema-consumer-events-waits-current',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-waits-history',
    'description': 'Configure events-waits-history consumer',
    'name': 'performance-schema-consumer-events-waits-history',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-events-waits-history-long',
    'description': 'Configure events-waits-history-long consumer',
    'name': 'performance-schema-consumer-events-waits-history-long',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-global-instrumentation',
    'description': 'Configure global-instrumentation consumer',
    'name': 'performance-schema-consumer-global-instrumentation',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-statements-digest',
    'description': 'Configure statements-digest consumer',
    'name': 'performance-schema-consumer-statements-digest',
    'values': [],
    'versions': [((5, 6, 5),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-consumer-thread-instrumentation',
    'description': 'Configure thread-instrumentation consumer',
    'name': 'performance-schema-consumer-thread-instrumentation',
    'values': [],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance-schema-instrument',
    'description': 'Configure Performance Schema instrument',
    'name': 'performance-schema-instrument',
    'values': [{ 'type': 'string'}],
    'versions': [((5, 6, 4),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema',
    'description': 'Whether Performance Schema is enabled',
    'name': 'performance_schema',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 6, 5),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (5, 6, 6),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_accounts_size',
    'description': 'Number of rows in the accounts table',
    'name': 'performance_schema_accounts_size',
    'values': [ { 'default': '10',
                  'maximum': '1048576',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'maximum': '1048576',
                  'minimum': '-1 (autosized)',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'maximum': '1048576',
                  'minimum': '-1 (autoscaled)',
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_digests_size',
    'description': 'Number of rows in the events_statements_summary_by_digest table',
    'name': 'performance_schema_digests_size',
    'values': [ { 'default': '-1 (autosized)',
                  'maximum': '1048576',
                  'minimum': '-1',
                  'type': 'integer'}],
    'versions': [((5, 6, 5),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_error_size',
    'description': 'Number of instrumented errors',
    'name': 'performance_schema_error_size',
    'values': [ { 'default': 'number of server error codes',
                  'maximum': '1048576',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [(), ((8, 0),), ()]},
  { 'caption': 'performance_schema_events_stages_history_long_size',
    'description': 'Number of rows in the events_stages_history_long table',
    'name': 'performance_schema_events_stages_history_long_size',
    'values': [ { 'default': '10000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_events_stages_history_size',
    'description': 'Number of rows per thread in the events_stages_history table',
    'name': 'performance_schema_events_stages_history_size',
    'values': [ { 'default': '10',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_events_statements_history_long_size',
    'description': 'Number of rows in the events_statements_history_long table',
    'name': 'performance_schema_events_statements_history_long_size',
    'values': [ { 'default': '10000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_events_statements_history_size',
    'description': 'Number of rows per thread in the events_statements_history table',
    'name': 'performance_schema_events_statements_history_size',
    'values': [ { 'default': '10',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_events_transactions_history_long_size',
    'description': 'Number of rows in the events_transactions_history_long table',
    'name': 'performance_schema_events_transactions_history_long_size',
    'values': [{ 'default': '-1 (autosized)', 'type': 'integer'}],
    'versions': [((5, 7, 3),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_events_transactions_history_size',
    'description': 'Number of rows per thread in the events_transactions_history table',
    'name': 'performance_schema_events_transactions_history_size',
    'values': [{ 'default': '-1 (autosized)', 'type': 'integer'}],
    'versions': [((5, 7, 3),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_events_waits_history_long_size',
    'description': 'Number of rows in the events_waits_history_long table',
    'name': 'performance_schema_events_waits_history_long_size',
    'values': [ { 'default': '10000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_events_waits_history_size',
    'description': 'Number of rows per thread in the events_waits_history table',
    'name': 'performance_schema_events_waits_history_size',
    'values': [ { 'default': '10',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_hosts_size',
    'description': 'Number of rows in the hosts table',
    'name': 'performance_schema_hosts_size',
    'values': [ { 'default': '10',
                  'maximum': '1048576',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'maximum': '1048576',
                  'minimum': '-1 (autosized)',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'maximum': '1048576',
                  'minimum': '-1 (autoscaled)',
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_cond_classes',
    'description': 'The maximum number of condition instruments',
    'name': 'performance_schema_max_cond_classes',
    'values': [{ 'default': '80', 'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_cond_instances',
    'description': 'The maximum number of instrumented condition objects',
    'name': 'performance_schema_max_cond_instances',
    'values': [ { 'default': '1000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_digest_length',
    'description': 'The maximum Performance Schema digest size in bytes',
    'name': 'performance_schema_max_digest_length',
    'values': [ { 'default': '1024',
                  'maximum': '1048576',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 26), (5, 7, 8)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_file_classes',
    'description': 'The maximum number of file instruments',
    'name': 'performance_schema_max_file_classes',
    'values': [ { 'default': '50',
                  'outversion': (5, 7, 8),
                  'type': 'integer'},
                { 'default': '80', 'inversion': (5, 7, 9), 'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_file_handles',
    'description': 'The maximum number of opened file objects',
    'name': 'performance_schema_max_file_handles',
    'values': [{ 'default': '32768', 'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_file_instances',
    'description': 'The maximum number of instrumented file objects',
    'name': 'performance_schema_max_file_instances',
    'values': [ { 'default': '10000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_index_stat',
    'description': 'Maximum number of indexes to keep statistics for',
    'name': 'performance_schema_max_index_stat',
    'values': [{ 'default': '-1 (autosized)', 'type': 'integer'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_memory_classes',
    'description': 'The maximum number of memory instruments',
    'name': 'performance_schema_max_memory_classes',
    'values': [ { 'default': '250',
                  'outversion': (5, 7, 4),
                  'type': 'integer'},
                { 'default': '320',
                  'inversion': (5, 7, 5),
                  'type': 'integer'}],
    'versions': [((5, 7, 2),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_metadata_locks',
    'description': 'The maximum number of metadata locks to track',
    'name': 'performance_schema_max_metadata_locks',
    'values': [ { 'default': '-1 (autosized)',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [((5, 7, 3),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_mutex_classes',
    'description': 'The maximum number of mutex instruments',
    'name': 'performance_schema_max_mutex_classes',
    'values': [{ 'default': '200', 'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_mutex_instances',
    'description': 'The maximum number of instrumented mutex objects',
    'name': 'performance_schema_max_mutex_instances',
    'values': [ { 'default': '1000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_prepared_statements_instances',
    'description': 'Number of rows in the prepared_statements_instances table',
    'name': 'performance_schema_max_prepared_statements_instances',
    'values': [ { 'default': '-1 (autosized)',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [((5, 7, 4),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_program_instances',
    'description': 'The maximum number of stored programs for statistics',
    'name': 'performance_schema_max_program_instances',
    'values': [ { 'default': '5000',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [((5, 7, 2),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_rwlock_classes',
    'description': 'The maximum number of rwlock instruments',
    'name': 'performance_schema_max_rwlock_classes',
    'values': [ { 'default': '20',
                  'outversion': (5, 5, 6),
                  'type': 'integer'},
                { 'default': '30',
                  'inversion': (5, 5, 7),
                  'outversion': (5, 5, 99),
                  'type': 'integer'},
                { 'default': '20',
                  'inversion': (5, 6, 0),
                  'outversion': (5, 6, 0),
                  'type': 'integer'},
                { 'default': '30',
                  'inversion': (5, 6, 1),
                  'outversion': (5, 6, 14),
                  'type': 'integer'},
                { 'default': '40',
                  'inversion': (5, 6, 15),
                  'outversion': (5, 6, 99),
                  'type': 'integer'},
                { 'default': '30',
                  'inversion': (5, 7, 0),
                  'outversion': (5, 7, 2),
                  'type': 'integer'},
                { 'default': '40', 'inversion': (5, 7, 3), 'type': 'integer'},
                { 'default': '20', 'inversion': (6, 0, 0), 'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_rwlock_instances',
    'description': 'The maximum number of instrumented rwlock objects',
    'name': 'performance_schema_max_rwlock_instances',
    'values': [ { 'default': '1000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_socket_classes',
    'description': 'The maximum number of socket instruments',
    'name': 'performance_schema_max_socket_classes',
    'values': [{ 'default': '10', 'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_socket_instances',
    'description': 'The maximum number of instrumented socket objects',
    'name': 'performance_schema_max_socket_instances',
    'values': [ { 'default': '1000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_sql_text_length',
    'description': 'The maximum number of bytes stored from SQL statements',
    'name': 'performance_schema_max_sql_text_length',
    'values': [ { 'default': '1024',
                  'maximum': '1048576',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_stage_classes',
    'description': 'The maximum number of stage instruments',
    'name': 'performance_schema_max_stage_classes',
    'values': [{ 'default': '150', 'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_statement_classes',
    'description': 'The maximum number of statement instruments',
    'name': 'performance_schema_max_statement_classes',
    'values': [{ 'default': '-1 (autosized)', 'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_statement_stack',
    'description': 'The maximum stored program nesting for statistics',
    'name': 'performance_schema_max_statement_stack',
    'values': [{ 'default': '10', 'type': 'integer'}],
    'versions': [((5, 7, 2),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_table_handles',
    'description': 'The maximum number of opened table objects',
    'name': 'performance_schema_max_table_handles',
    'values': [ { 'default': '100000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_table_instances',
    'description': 'The maximum number of instrumented table objects',
    'name': 'performance_schema_max_table_instances',
    'values': [ { 'default': '50000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_table_lock_stat',
    'description': 'Maximum number of tables to keep lock statistics for',
    'name': 'performance_schema_max_table_lock_stat',
    'values': [{ 'default': '-1 (autosized)', 'type': 'integer'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_max_thread_classes',
    'description': 'The maximum number of thread instruments',
    'name': 'performance_schema_max_thread_classes',
    'values': [{ 'default': '50', 'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_max_thread_instances',
    'description': 'The maximum number of instrumented thread objects',
    'name': 'performance_schema_max_thread_instances',
    'values': [ { 'default': '1000',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [ ((5, 5, 3), (6, 0, 14)),
                  ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'performance_schema_session_connect_attrs_size',
    'description': 'Size of the connection attribute strings buffer per thread',
    'name': 'performance_schema_session_connect_attrs_size',
    'values': [ { 'default': '-1 (autosized)',
                  'maximum': '1048576',
                  'minimum': '-1',
                  'type': 'integer'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_setup_actors_size',
    'description': 'Number of rows in the setup_actors table',
    'name': 'performance_schema_setup_actors_size',
    'values': [ { 'default': '100',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [((5, 6, 1),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_setup_objects_size',
    'description': 'Number of rows in the setup_objects table',
    'name': 'performance_schema_setup_objects_size',
    'values': [ { 'default': '100',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'type': 'integer'}],
    'versions': [((5, 6, 1),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'performance_schema_users_size',
    'description': 'Number of rows in the users table',
    'name': 'performance_schema_users_size',
    'values': [ { 'default': '10',
                  'maximum': '1048576',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 6),
                  'maximum': '1048576',
                  'minimum': '-1 (autosized)',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '-1 (autoscaled)',
                  'inversion': (5, 7, 6),
                  'maximum': '1048576',
                  'minimum': '-1 (autoscaled)',
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'persisted_globals_load',
    'description': 'Whether to load persisted configuration settings',
    'name': 'persisted_globals_load',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((8, 0, 0),), ((8, 0),), ()]},
  { 'caption': 'pid-file',
    'description': 'Process ID file used by mysqld_safe',
    'name': 'pid-file',
    'values': [{ 'type': 'filename'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'plugin',
    'description': 'Prefix for specifying plugin-specific options.',
    'name': 'plugin',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'plugin-load',
    'description': 'Set the list of plugins to load at startup',
    'name': 'plugin-load',
    'values': [{ 'type': 'string'}],
    'versions': [ ((5, 1, 18),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'plugin-load-add',
    'description': 'Add to list of plugins to load at startup',
    'name': 'plugin-load-add',
    'values': [{ 'type': 'string'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'plugin_dir',
    'description': 'Directory for plugins',
    'name': 'plugin_dir',
    'values': [ { 'default': '', 'outversion': (5, 1, 1), 'type': 'dirname'},
                { 'default': 'BASEDIR/lib/plugin',
                  'inversion': (5, 1, 2),
                  'outversion': (5, 4, 99),
                  'platform': 'windows',
                  'type': 'dirname'},
                { 'default': 'BASEDIR/lib/plugin',
                  'inversion': (5, 5, 0),
                  'outversion': (5, 5, 4),
                  'platform': 'windows',
                  'type': 'dirname'},
                { 'default': 'BASEDIR/lib/mysql/plugin',
                  'inversion': (5, 1, 2),
                  'outversion': (5, 4, 99),
                  'platform': 'other',
                  'type': 'dirname'},
                { 'default': 'BASEDIR/lib/mysql/plugin',
                  'inversion': (5, 5, 0),
                  'outversion': (5, 5, 4),
                  'platform': 'other',
                  'type': 'dirname'},
                { 'default': 'BASEDIR/lib/plugin',
                  'inversion': (5, 5, 5),
                  'type': 'dirname'}],
    'versions': [ ((4, 1, 25), (5, 0, 67), (5, 1, 2)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'port',
    'description': 'Port number on which to listen for TCP/IP connections',
    'name': 'port',
    'values': [ { 'default': '3306',
                  'maximum': '65535',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'port-open-timeout',
    'description': 'Maximum time in seconds to wait for the port to become free (Default: no wait)',
    'name': 'port-open-timeout',
    'values': [{ 'default': '0', 'type': 'integer'}],
    'versions': [ ((5, 0, 19), (5, 1, 5)),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'preload_buffer_size',
    'description': 'Size of buffer that is allocated when preloading indexes',
    'name': 'preload_buffer_size',
    'values': [ { 'default': '32768',
                  'maximum': '1073741824',
                  'minimum': '1024',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'profiling_history_size',
    'description': 'How many statements to maintain profiling information for',
    'name': 'profiling_history_size',
    'values': [ { 'default': '15',
                  'maximum': '100',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 37), (5, 1, 24), (6, 0, 5)),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'query_alloc_block_size',
    'description': 'Allocation block size for query parsing and execution',
    'name': 'query_alloc_block_size',
    'values': [ { 'bitsize': '32',
                  'blocksize': '1024',
                  'default': '8192',
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'outversion': (5, 7, 8),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '8192',
                  'maximum': '18446744073709547520',
                  'minimum': '1024',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '1024',
                  'outversion': (5, 7, 8),
                  'type': 'integer'},
                { 'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 7, 9),
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'query_cache_limit',
    'description': 'Do not cache results that are bigger than this',
    'name': 'query_cache_limit',
    'values': [ { 'bitsize': '32',
                  'default': '1048576',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1048576',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1048576',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'query_cache_min_res_unit',
    'description': 'Minimal size of unit in which space for results is allocated (last unit will be trimmed after writing all result data)',
    'name': 'query_cache_min_res_unit',
    'values': [ { 'bitsize': '32',
                  'default': '4096',
                  'maximum': '4294967295',
                  'minimum': '512',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '4096',
                  'maximum': '18446744073709547520',
                  'minimum': '512',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '4096',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '512',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'query_cache_size',
    'description': 'The memory allocated to store results from old queries',
    'name': 'query_cache_size',
    'values': [ { 'bitsize': '32',
                  'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'outversion': (5, 6, 7),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '1048576',
                  'inversion': (5, 6, 8),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'outversion': (5, 6, 7),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1048576',
                  'inversion': (5, 6, 8),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'query_cache_type',
    'description': 'Query cache type',
    'name': 'query_cache_type',
    'values': [ { 'choice': ['0', '1', '2'],
                  'default': '1',
                  'outversion': (5, 6, 7),
                  'type': 'enum'},
                { 'choice': ['0', '1', '2'],
                  'default': '0',
                  'inversion': (5, 6, 8),
                  'type': 'enum'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'query_cache_wlock_invalidate',
    'description': 'Invalidate queries in query cache on LOCK for write',
    'name': 'query_cache_wlock_invalidate',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'query_prealloc_size',
    'description': 'Persistent buffer for query parsing and execution',
    'name': 'query_prealloc_size',
    'values': [ { 'bitsize': '32',
                  'blocksize': '1024',
                  'default': '8192',
                  'maximum': '4294967295',
                  'minimum': '8192',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '8192',
                  'maximum': '18446744073709547520',
                  'minimum': '8192',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '8192',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'range_alloc_block_size',
    'description': 'Allocation block size for storing ranges during optimization',
    'name': 'range_alloc_block_size',
    'values': [ { 'bitsize': '32',
                  'blocksize': '1024',
                  'default': '4096',
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'outversion': (5, 7, 8),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 7, 8),
                  'maximum': '18446744073709547520',
                  'minimum': '4096',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '4096',
                  'outversion': (5, 7, 8),
                  'type': 'integer'},
                { 'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 7, 9),
                  'maximum': '4294967295',
                  'minimum': '4096',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'range_optimizer_max_mem_size',
    'description': 'Limit on range optimizer memory consumption',
    'name': 'range_optimizer_max_mem_size',
    'values': [ { 'default': '1536000',
                  'outversion': (5, 7, 11),
                  'type': 'integer'},
                { 'default': '8388608',
                  'inversion': (5, 7, 12),
                  'type': 'integer'}],
    'versions': [((5, 7, 9),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'read_buffer_size',
    'description': 'Each thread that does a sequential scan for a MyISAM table allocates a buffer of this size for each table it scans',
    'name': 'read_buffer_size',
    'values': [ { 'default': '131072',
                  'maximum': '2147479552',
                  'minimum': '8200',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'read_only',
    'description': 'Prevent client updates except from clients with SUPER',
    'name': 'read_only',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'read_rnd_buffer_size',
    'description': 'When reading rows from a MyISAM table in sorted order after a sort, the rows are read through this buffer to avoid a disk seeks. If not set, then it is set to the value of record_buffer.',
    'name': 'read_rnd_buffer_size',
    'values': [ { 'default': '262144',
                  'maximum': '2147483647',
                  'minimum': '8200',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'default': '262144',
                  'inversion': (5, 5, 3),
                  'maximum': '2147483647',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'relay-log',
    'description': 'The location and base name to use for relay logs',
    'name': 'relay-log',
    'values': [{ 'type': 'filename'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'relay-log-info-repository',
    'description': "Whether to write the replication SQL thread's location in the relay logs to a file or a table.",
    'name': 'relay-log-info-repository',
    'values': [ { 'choice': ['FILE', 'TABLE'],
                  'default': 'FILE',
                  'type': 'string'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'relay_log_index',
    'description': 'The name of the relay log index file',
    'name': 'relay_log_index',
    'values': [ { 'default': '*host_name*-relay-bin.index',
                  'type': 'filename'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'relay_log_info_file',
    'description': 'The name of the file in which the slave records information about the relay logs',
    'name': 'relay_log_info_file',
    'values': [{ 'default': 'relay-log.info', 'type': 'filename'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'relay_log_purge',
    'description': 'Determines whether relay logs are purged',
    'name': 'relay_log_purge',
    'values': [ { 'default': 'true',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'relay_log_recovery',
    'description': 'Whether automatic recovery of relay log files from master at startup is enabled; must be enabled for a crash-safe slave.',
    'name': 'relay_log_recovery',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [((6, 0, 11),), ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)), ()]},
  { 'caption': 'relay_log_space_limit',
    'description': 'Maximum space to use for all relay logs',
    'name': 'relay_log_space_limit',
    'values': [ { 'bitsize': '32',
                  'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'replicate-do-db',
    'description': 'Tells the slave SQL thread to restrict replication to the specified database',
    'name': 'replicate-do-db',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'replicate-do-table',
    'description': 'Tells the slave SQL thread to restrict replication to the specified table',
    'name': 'replicate-do-table',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'replicate-ignore-db',
    'description': 'Tells the slave SQL thread not to replicate to the specified database',
    'name': 'replicate-ignore-db',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'replicate-ignore-table',
    'description': 'Tells the slave SQL thread not to replicate to the specified table',
    'name': 'replicate-ignore-table',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'replicate-rewrite-db',
    'description': 'Updates to a database with a different name than the original',
    'name': 'replicate-rewrite-db',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'replicate-same-server-id',
    'description': 'In replication, if set to 1, do not skip events having our server id',
    'name': 'replicate-same-server-id',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'replicate-wild-do-table',
    'description': 'Tells the slave thread to restrict replication to the tables that match the specified wildcard pattern',
    'name': 'replicate-wild-do-table',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'replicate-wild-ignore-table',
    'description': 'Tells the slave thread not to replicate to the tables that match the given wildcard pattern',
    'name': 'replicate-wild-ignore-table',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'report-host',
    'description': 'Host name or IP of the slave to be reported to the master during slave registration',
    'name': 'report-host',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'report-password',
    'description': 'An arbitrary password that the slave server should report to the master. Not the same as the password for the MySQL replication user account.',
    'name': 'report-password',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'report-port',
    'description': 'Port for connecting to slave reported to the master during slave registration',
    'name': 'report-port',
    'values': [ { 'default': '3306',
                  'maximum': '65535',
                  'minimum': '0',
                  'outversion': (5, 5, 22),
                  'type': 'integer'},
                { 'default': '0',
                  'inversion': (5, 5, 23),
                  'maximum': '65535',
                  'minimum': '0',
                  'outversion': (5, 6, 4),
                  'type': 'integer'},
                { 'default': '[slave_port]',
                  'inversion': (5, 6, 5),
                  'maximum': '65535',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'report-user',
    'description': 'An arbitrary user name that a slave server should report to the master. Not the same as the name used with the MySQL replication user account.',
    'name': 'report-user',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'require_secure_transport',
    'description': 'Whether client connections must use secure transport',
    'name': 'require_secure_transport',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'restore_disables_events',
    'description': 'Whether RESTORE disables restored events',
    'name': 'restore_disables_events',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((6, 0, 14),), ((6, 0),), ()]},
  { 'caption': 'restore_elevation',
    'description': 'Enable or disable RESTORE privilege elevation',
    'name': 'restore_elevation',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((6, 0, 14),), ((6, 0),), ()]},
  { 'caption': 'restore_precheck',
    'description': 'Whether RESTORE performs privilege checking before restoring',
    'name': 'restore_precheck',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((6, 0, 14),), ((6, 0),), ()]},
  { 'caption': 'rpl_stop_slave_timeout',
    'description': 'Set the number of seconds that STOP SLAVE waits before timing out.',
    'name': 'rpl_stop_slave_timeout',
    'values': [ { 'default': '31536000',
                  'inversion': (5, 6, 13),
                  'maximum': '31536000',
                  'minimum': '2',
                  'type': 'integer'}],
    'versions': [((5, 6, 13), (5, 7, 2)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'safe-mode',
    'description': 'Skip some optimization stages (for testing)',
    'name': 'safe-mode',
    'values': [{ 'off': '0', 'on': '1', 'type': 'boolean'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                  ((5, 6, 6),)]},
  { 'caption': 'safe-show-database',
    'description': 'Deprecated option; use GRANT SHOW DATABASES instead',
    'name': 'safe-show-database',
    'values': [{ 'off': '0', 'on': '1', 'type': 'boolean'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                  ((5, 5, 3),)]},
  { 'caption': 'safe-user-create',
    'description': 'Do not allow new user creation by the user who has no write privileges to the mysql.user table',
    'name': 'safe-user-create',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'safemalloc-mem-limit',
    'description': 'Simulate memory shortage',
    'name': 'safemalloc-mem-limit',
    'values': [{ 'type': 'integer'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                  ((5, 5, 6),)]},
  { 'caption': 'schema_definition_cache',
    'description': 'Defines the number of schema definition objects that can be kept in the dictionary object cache',
    'name': 'schema_definition_cache',
    'values': [ { 'default': '256',
                  'maximum': '524288',
                  'minimum': '256',
                  'type': 'integer'}],
    'versions': [(), ((8, 0),), ()]},
  { 'caption': 'secure-auth',
    'description': 'Disallow authentication for accounts that have old (pre-4.1) passwords',
    'name': 'secure-auth',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 6, 4),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (5, 6, 5),
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 6, 99),
                  'type': 'boolean'},
                { 'choice': ['off', 'on'],
                  'default': 'on',
                  'inversion': (5, 7, 0),
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 7, 4),
                  'type': 'boolean'},
                { 'choice': ['on'],
                  'default': 'on',
                  'inversion': (5, 7, 5),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'secure-backup-file-priv',
    'description': 'Limit BACKUP DATABASE and RESTORE to files in a single directory',
    'name': 'secure-backup-file-priv',
    'values': [{ 'type': 'string'}],
    'versions': [((6, 0, 11),), ((6, 0),), ()]},
  { 'caption': 'secure-file-priv',
    'description': 'Limit LOAD DATA, and SELECT ... INTO OUTFILE, and LOAD_FILE() to files in specified directory',
    'name': 'secure-file-priv',
    'values': [ { 'choice': ['empty', 'dirname'],
                  'default': 'empty',
                  'outversion': (5, 5, 52),
                  'type': 'string'},
                { 'choice': ['empty', 'dirname', 'NULL'],
                  'default': 'platform specific',
                  'inversion': (5, 5, 53),
                  'outversion': (5, 5, 99),
                  'type': 'string'},
                { 'choice': ['empty', 'dirname'],
                  'default': 'empty',
                  'inversion': (5, 6, 0),
                  'outversion': (5, 6, 33),
                  'type': 'string'},
                { 'choice': ['empty', 'dirname', 'NULL'],
                  'default': 'platform specific',
                  'inversion': (5, 6, 34),
                  'outversion': (5, 6, 99),
                  'type': 'string'},
                { 'choice': ['empty', 'dirname'],
                  'default': 'empty',
                  'inversion': (5, 7, 0),
                  'outversion': (5, 7, 5),
                  'type': 'string'},
                { 'choice': ['empty', 'dirname', 'NULL'],
                  'default': 'platform specific',
                  'inversion': (5, 7, 6),
                  'type': 'string'}],
    'versions': [ ((5, 0, 38), (5, 1, 17)),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'server-id',
    'description': 'Uniquely identifies the server instance in the community of replication partners. Must be set to a value greater than 0 to enable replication.',
    'name': 'server-id',
    'values': [ { 'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'server_id_bits',
    'description': 'The effective value of server_id if the server was started with the --server-id-bits option set to a nondefault value.',
    'name': 'server_id_bits',
    'values': [ { 'default': '32',
                  'maximum': '32',
                  'minimum': '7',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 47), (5, 1, 47)),
                  ((5, 1), (5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'session_track_gtids',
    'description': 'Enables a tracker which can be configured to track different GTIDs.',
    'name': 'session_track_gtids',
    'optype': { 'format': 'session_track_gtids=[value]'},
    'values': [ { 'choice': ['OFF', 'OWN_GTID', 'ALL_GTIDS '],
                  'default': 'OFF',
                  'type': 'enum'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'session_track_schema',
    'description': 'Whether to track schema changes',
    'name': 'session_track_schema',
    'optype': { 'format': 'session_track_schema=#'},
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 4),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'session_track_state_change',
    'description': 'Whether to track session state changes',
    'name': 'session_track_state_change',
    'optype': { 'format': 'session_track_state_change=#'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 4),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'session_track_system_variables',
    'description': 'Session variables to track changes for',
    'name': 'session_track_system_variables',
    'optype': { 'format': 'session_track_system_variables=#'},
    'values': [ { 'default': 'time_zone, autocommit, character_set_client, character_set_results, character_set_connection',
                  'type': 'string'}],
    'versions': [((5, 7, 4),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'set-variable',
    'description': 'Change the value of a variable',
    'name': 'set-variable',
    'values': [{ 'type': 'string'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 5)), ((5, 5, 3),)]},
  { 'caption': 'sha256_password_auto_generate_rsa_keys',
    'description': 'Whether to autogenerate RSA key-pair files',
    'name': 'sha256_password_auto_generate_rsa_keys',
    'optype': { 'format': 'sha256_password_auto_generate_rsa_keys[={OFF|ON}]'},
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 5),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'sha256_password_proxy_users',
    'description': 'Whether the sha256_password authentication plugin does proxying',
    'name': 'sha256_password_proxy_users',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 7),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'shared_memory',
    'description': 'Whether the server allows shared-memory connections',
    'name': 'shared_memory',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((4, 1, 1),),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'shared_memory_base_name',
    'description': 'The name of shared memory to use for shared-memory connections',
    'name': 'shared_memory_base_name',
    'values': [{ 'default': 'MYSQL', 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'show-slave-auth-info',
    'description': 'Show user name and password in SHOW SLAVE HOSTS on this master',
    'name': 'show-slave-auth-info',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'show_compatibility_56',
    'description': 'Compatibility for SHOW STATUS/VARIABLES',
    'name': 'show_compatibility_56',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 7, 7),
                  'type': 'boolean'},
                { 'default': 'off',
                  'inversion': (5, 7, 8),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 6),), ((5, 7), (8, 0)), ((8, 0, 1),)]},
  { 'caption': 'show_old_temporals',
    'description': 'Whether SHOW CREATE TABLE should indicate pre-5.6.4 temporal columns',
    'name': 'show_old_temporals',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 24), (5, 7, 6)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'simplified_binlog_gtid_recovery',
    'description': 'Controls how binary logs are iterated during GTID recovery',
    'name': 'simplified_binlog_gtid_recovery',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [((5, 7, 5), (5, 6, 21)), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'skip-bdb',
    'description': 'Disable Berkeley DB (if this version of MySQL supports it)',
    'name': 'skip-bdb',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [(), ((4, 1), (5, 0)), ()]},
  { 'caption': 'skip-character-set-client-handshake',
    'description': 'Ignore client side character set value sent during handshake',
    'name': 'skip-character-set-client-handshake',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ ((4, 1, 15), (5, 0, 13)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'skip-concurrent-insert',
    'description': 'Turn off the ability to select and insert at the same time on MyISAM tables',
    'name': 'skip-concurrent-insert',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'skip-falcon',
    'description': 'Disable the Falcon storage engine',
    'name': 'skip-falcon',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [(), ((6, 0),), ()]},
  { 'caption': 'skip-grant-tables',
    'description': 'Start without grant tables. This gives all users FULL ACCESS to all tables',
    'name': 'skip-grant-tables',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'skip-host-cache',
    'description': 'Do not cache host names',
    'name': 'skip-host-cache',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'skip-locking',
    'description': 'Deprecated option',
    'name': 'skip-locking',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                  ((5, 5, 3),)]},
  { 'caption': 'skip-merge',
    'description': 'Disable Merge storage engine',
    'name': 'skip-merge',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [((5, 0, 24), (5, 1, 12)), ((5, 0), (5, 1)), ((5, 1, 14),)]},
  { 'caption': 'skip-name-resolve',
    'description': "Do not resolve host names. All host names are IPs or 'localhost'",
    'name': 'skip-name-resolve',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'skip-networking',
    'description': 'Do not allow connection with TCP/IP',
    'name': 'skip-networking',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'skip-partition',
    'description': 'Do not enable user-defined partitioning',
    'name': 'skip-partition',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ((8, 0, 0),)]},
  { 'caption': 'skip-safemalloc',
    'description': 'Do not check for memory overruns during each memory allocation',
    'name': 'skip-safemalloc',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                  ((5, 5, 6),)]},
  { 'caption': 'skip-show-database',
    'description': 'Do not allow SHOW DATABASE statements',
    'name': 'skip-show-database',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'skip-slave-start',
    'description': 'If set, slave is not autostarted',
    'name': 'skip-slave-start',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'skip-stack-trace',
    'description': 'Do not print a stack trace on failure',
    'name': 'skip-stack-trace',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'skip-symlink',
    'description': 'Do not allow symlinking of tables. Deprecated option. Use --skip-symbolic-links.',
    'name': 'skip-symlink',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                  ((5, 5, 3),)]},
  { 'caption': 'skip-sync-bdb-logs',
    'description': 'Disables synchronous BDB log flushes',
    'name': 'skip-sync-bdb-logs',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [(), ((4, 1), (5, 0)), ()]},
  { 'caption': 'skip-thread-priority',
    'description': 'Do not give threads different priorities',
    'name': 'skip-thread-priority',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                  ((5, 6, 1),)]},
  { 'caption': 'skip_external_locking',
    'description': 'Skip system (external) locking',
    'name': 'skip_external_locking',
    'values': [ { 'default': 'on',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'slave-load-tmpdir',
    'description': 'The location where the slave should put its temporary files when replicating a LOAD DATA INFILE statement',
    'name': 'slave-load-tmpdir',
    'values': [{ 'default': '/tmp', 'type': 'dirname'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'slave-max-allowed-packet',
    'description': 'Maximum size, in bytes, of a packet that can be sent from a replication master to a slave; overrides max_allowed_packet.',
    'name': 'slave-max-allowed-packet',
    'values': [ { 'default': '1073741824',
                  'maximum': '1073741824',
                  'minimum': '1024',
                  'type': 'integer'}],
    'versions': [ ((5, 1, 64), (5, 5, 26), (5, 6, 6)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'slave-net-timeout',
    'description': 'Number of seconds to wait for more data from a master/slave connection before aborting the read',
    'name': 'slave-net-timeout',
    'values': [ { 'default': '3600', 'minimum': '1', 'type': 'integer'},
                { 'default': '60',
                  'inversion': (5, 7, 7),
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'slave-parallel-type',
    'description': 'Tells the slave to use database partioning (DATABASE) or timestamp information (LOGICAL_CLOCK) from the master to parallelize transactions. The default is DATABASE.',
    'name': 'slave-parallel-type',
    'values': [ { 'choice': ['DATABASE', 'LOGICAL_CLOCK'],
                  'default': 'DATABASE',
                  'type': 'enum'}],
    'versions': [((5, 7, 2),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'slave-parallel-workers',
    'description': 'Number of worker threads for executing events in parallel. Set to 0 (the default) to disable slave multi-threading. Not supported by MySQL Cluster.',
    'name': 'slave-parallel-workers',
    'values': [ { 'default': '0',
                  'maximum': '1024',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'slave-rows-search-algorithms',
    'description': 'Determines search algorithms used for slave update batching. Any 2 or 3 from the list INDEX_SEARCH, TABLE_SCAN, HASH_SCAN; the default is TABLE_SCAN,INDEX_SCAN.',
    'name': 'slave-rows-search-algorithms',
    'values': [ { 'choice': [ 'TABLE_SCAN,INDEX_SCAN',
                              'INDEX_SCAN,HASH_SCAN',
                              'TABLE_SCAN,HASH_SCAN',
                              'TABLE_SCAN,INDEX_SCAN,HASH_SCAN'],
                  'default': 'TABLE_SCAN,INDEX_SCAN',
                  'type': 'set'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'slave-skip-errors',
    'description': 'Tells the slave thread to continue replication when a query returns an error from the provided list',
    'name': 'slave-skip-errors',
    'values': [],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'slave-sql-verify-checksum',
    'description': 'Cause slave to examine checksums when reading from the relay log',
    'name': 'slave-sql-verify-checksum',
    'values': [ { 'choice': ['0', '1'],
                  'default': '0',
                  'off': '0',
                  'on': '1',
                  'type': 'boolean'}],
    'versions': [((5, 6, 2),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'slave_allow_batching',
    'description': 'Turns update batching on and off for a replication slave',
    'name': 'slave_allow_batching',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 1, 19),), ((5, 1), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'slave_checkpoint_group',
    'description': 'Maximum number of transactions processed by a multi-threaded slave before a checkpoint operation is called to update progress status. Not supported by MySQL Cluster.',
    'name': 'slave_checkpoint_group',
    'values': [ { 'blocksize': '8',
                  'default': '512',
                  'maximum': '524280',
                  'minimum': '32',
                  'type': 'integer'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'slave_checkpoint_period',
    'description': 'Update progress status of multi-threaded slave and flush relay log info to disk after this number of milliseconds. Not supported by MySQL Cluster.',
    'name': 'slave_checkpoint_period',
    'values': [ { 'default': '300',
                  'maximum': '4G',
                  'minimum': '1',
                  'type': 'integer',
                  'units': 'millisecond'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'slave_compressed_protocol',
    'description': 'Use compression on master/slave protocol',
    'name': 'slave_compressed_protocol',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'slave_exec_mode',
    'description': 'Allows for switching the slave thread between IDEMPOTENT mode (key and some other errors suppressed) and STRICT mode; STRICT mode is the default, except for MySQL Cluster, where IDEMPOTENT is always used',
    'name': 'slave_exec_mode',
    'values': [ { 'choice': ['IDEMPOTENT', 'STRICT'],
                  'default': 'STRICT',
                  'type': 'enum'}],
    'versions': [ ((5, 1, 23), (5, 1, 23), (5, 1, 24), (6, 0, 5)),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'slave_transaction_retries',
    'description': 'Number of times the slave SQL thread will retry a transaction in case it failed with a deadlock or elapsed lock wait timeout, before giving up and stopping',
    'name': 'slave_transaction_retries',
    'values': [ { 'bitsize': '32',
                  'default': '10',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 11), (5, 0, 3)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'slave_type_conversions',
    'description': 'Controls type conversion mode on replication slave. Value is a list of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY. Set to an empty string to disallow type conversions between master and slave.',
    'name': 'slave_type_conversions',
    'values': [ { 'choice': ['ALL_LOSSY', 'ALL_NON_LOSSY'],
                  'default': '',
                  'outversion': (5, 6, 12),
                  'type': 'set'},
                { 'choice': [ 'ALL_LOSSY',
                              'ALL_NON_LOSSY',
                              'ALL_SIGNED',
                              'ALL_UNSIGNED'],
                  'default': '',
                  'inversion': (5, 6, 13),
                  'outversion': (5, 6, 99),
                  'type': 'set'},
                { 'choice': ['ALL_LOSSY', 'ALL_NON_LOSSY'],
                  'default': '',
                  'inversion': (5, 7, 0),
                  'outversion': (5, 7, 1),
                  'type': 'set'},
                { 'choice': [ 'ALL_LOSSY',
                              'ALL_NON_LOSSY',
                              'ALL_SIGNED',
                              'ALL_UNSIGNED'],
                  'default': '',
                  'inversion': (5, 7, 2),
                  'type': 'set'}],
    'versions': [ ( (5, 1, 44),
                    (5, 1, 44),
                    (5, 1, 44),
                    (5, 5, 3),
                    (6, 0, 14)),
                  ((5, 1), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'slow-query-log',
    'description': 'Enable|disable slow query log',
    'name': 'slow-query-log',
    'optype': { 'inversion': '5.1.29'},
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 1, 12),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'slow-start-timeout',
    'description': 'Wait before trying to kill windows service at startup',
    'name': 'slow-start-timeout',
    'values': [ { 'default': '15000',
                  'platform': 'windows',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 20), (5, 6, 5)),
                  ((5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'slow_launch_time',
    'description': 'If creating the thread takes longer than this value (in seconds), the Slow_launch_threads counter will be incremented',
    'name': 'slow_launch_time',
    'values': [{ 'default': '2', 'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'slow_query_log_file',
    'description': 'Name of the slow query log file',
    'name': 'slow_query_log_file',
    'values': [{ 'default': 'host_name-slow.log', 'type': 'filename'}],
    'versions': [ ((5, 1, 12),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'socket',
    'description': 'Socket file on which to listen for Unix socket connections',
    'name': 'socket',
    'values': [{ 'default': '/tmp/mysql.sock', 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'sort_buffer_size',
    'description': 'Each thread that needs to do a sort allocates a buffer of this size',
    'name': 'sort_buffer_size',
    'values': [ { 'default': '2097144',
                  'maximum': '4294967295',
                  'minimum': '32768',
                  'outversion': (5, 1, 22),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '2097144',
                  'inversion': (5, 1, 23),
                  'maximum': '4294967295',
                  'minimum': '32768',
                  'outversion': (5, 6, 3),
                  'platform': 'other',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '2097144',
                  'inversion': (5, 1, 23),
                  'maximum': '18446744073709551615',
                  'minimum': '32768',
                  'outversion': (5, 6, 3),
                  'platform': 'other',
                  'type': 'integer'},
                { 'default': '2097144',
                  'inversion': (5, 1, 23),
                  'maximum': '4294967295',
                  'minimum': '32768',
                  'outversion': (5, 6, 3),
                  'platform': 'windows',
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '262144',
                  'inversion': (5, 6, 4),
                  'maximum': '4294967295',
                  'minimum': '32768',
                  'platform': 'other',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '262144',
                  'inversion': (5, 6, 4),
                  'maximum': '18446744073709551615',
                  'minimum': '32768',
                  'platform': 'other',
                  'type': 'integer'},
                { 'default': '262144',
                  'inversion': (5, 6, 4),
                  'maximum': '4294967295',
                  'minimum': '32768',
                  'platform': 'windows',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'sporadic-binlog-dump-fail',
    'description': 'Option used by mysql-test for debugging and testing of replication',
    'name': 'sporadic-binlog-dump-fail',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'sql-bin-update-same',
    'description': 'The update log is deprecated since version 5.0, is replaced by the binary log and this option does nothing anymore',
    'name': 'sql-bin-update-same',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [(), ((4, 1),), ()]},
  { 'caption': 'sql-mode',
    'description': 'Set the SQL server mode',
    'name': 'sql-mode',
    'values': [ { 'choice': [ 'ALLOW_INVALID_DATES',
                              'ANSI_QUOTES',
                              'ERROR_FOR_DIVISION_BY_ZERO',
                              'HIGH_NOT_PRECEDENCE',
                              'IGNORE_SPACE',
                              'NO_AUTO_CREATE_USER',
                              'NO_AUTO_VALUE_ON_ZERO',
                              'NO_BACKSLASH_ESCAPES',
                              'NO_DIR_IN_CREATE',
                              'NO_ENGINE_SUBSTITUTION',
                              'NO_FIELD_OPTIONS',
                              'NO_KEY_OPTIONS',
                              'NO_TABLE_OPTIONS',
                              'NO_UNSIGNED_SUBTRACTION',
                              'NO_ZERO_DATE',
                              'NO_ZERO_IN_DATE',
                              'ONLY_FULL_GROUP_BY',
                              'PAD_CHAR_TO_FULL_LENGTH',
                              'PIPES_AS_CONCAT',
                              'REAL_AS_FLOAT',
                              'STRICT_ALL_TABLES',
                              'STRICT_TRANS_TABLES'],
                  'default': "''",
                  'inversion': (4, 1, 0),
                  'outversion': (5, 6, 5),
                  'type': 'set'},
                { 'choice': [ 'ALLOW_INVALID_DATES',
                              'ANSI_QUOTES',
                              'ERROR_FOR_DIVISION_BY_ZERO',
                              'HIGH_NOT_PRECEDENCE',
                              'IGNORE_SPACE',
                              'NO_AUTO_CREATE_USER',
                              'NO_AUTO_VALUE_ON_ZERO',
                              'NO_BACKSLASH_ESCAPES',
                              'NO_DIR_IN_CREATE',
                              'NO_ENGINE_SUBSTITUTION',
                              'NO_FIELD_OPTIONS',
                              'NO_KEY_OPTIONS',
                              'NO_TABLE_OPTIONS',
                              'NO_UNSIGNED_SUBTRACTION',
                              'NO_ZERO_DATE',
                              'NO_ZERO_IN_DATE',
                              'ONLY_FULL_GROUP_BY',
                              'PAD_CHAR_TO_FULL_LENGTH',
                              'PIPES_AS_CONCAT',
                              'REAL_AS_FLOAT',
                              'STRICT_ALL_TABLES',
                              'STRICT_TRANS_TABLES'],
                  'default': 'NO_ENGINE_SUBSTITUTION',
                  'inversion': (5, 6, 6),
                  'outversion': (5, 7, 4),
                  'type': 'set'},
                { 'choice': [ 'ALLOW_INVALID_DATES',
                              'ANSI_QUOTES',
                              'ERROR_FOR_DIVISION_BY_ZERO',
                              'HIGH_NOT_PRECEDENCE',
                              'IGNORE_SPACE',
                              'NO_AUTO_CREATE_USER',
                              'NO_AUTO_VALUE_ON_ZERO',
                              'NO_BACKSLASH_ESCAPES',
                              'NO_DIR_IN_CREATE',
                              'NO_ENGINE_SUBSTITUTION',
                              'NO_FIELD_OPTIONS',
                              'NO_KEY_OPTIONS',
                              'NO_TABLE_OPTIONS',
                              'NO_UNSIGNED_SUBTRACTION',
                              'NO_ZERO_DATE',
                              'NO_ZERO_IN_DATE',
                              'ONLY_FULL_GROUP_BY',
                              'PAD_CHAR_TO_FULL_LENGTH',
                              'PIPES_AS_CONCAT',
                              'REAL_AS_FLOAT',
                              'STRICT_ALL_TABLES',
                              'STRICT_TRANS_TABLES'],
                  'default': 'ONLY_FULL_GROUP_BY STRICT_TRANS_TABLES NO_ENGINE_SUBSTITUTION',
                  'inversion': (5, 7, 5),
                  'outversion': (5, 7, 6),
                  'type': 'set'},
                { 'choice': [ 'ALLOW_INVALID_DATES',
                              'ANSI_QUOTES',
                              'ERROR_FOR_DIVISION_BY_ZERO',
                              'HIGH_NOT_PRECEDENCE',
                              'IGNORE_SPACE',
                              'NO_AUTO_CREATE_USER',
                              'NO_AUTO_VALUE_ON_ZERO',
                              'NO_BACKSLASH_ESCAPES',
                              'NO_DIR_IN_CREATE',
                              'NO_ENGINE_SUBSTITUTION',
                              'NO_FIELD_OPTIONS',
                              'NO_KEY_OPTIONS',
                              'NO_TABLE_OPTIONS',
                              'NO_UNSIGNED_SUBTRACTION',
                              'NO_ZERO_DATE',
                              'NO_ZERO_IN_DATE',
                              'ONLY_FULL_GROUP_BY',
                              'PAD_CHAR_TO_FULL_LENGTH',
                              'PIPES_AS_CONCAT',
                              'REAL_AS_FLOAT',
                              'STRICT_ALL_TABLES',
                              'STRICT_TRANS_TABLES'],
                  'default': 'ONLY_FULL_GROUP_BY STRICT_TRANS_TABLES NO_AUTO_CREATE_USER NO_ENGINE_SUBSTITUTION',
                  'inversion': (5, 7, 7),
                  'outversion': (5, 7, 7),
                  'type': 'set'},
                { 'choice': [ 'ALLOW_INVALID_DATES',
                              'ANSI_QUOTES',
                              'ERROR_FOR_DIVISION_BY_ZERO',
                              'HIGH_NOT_PRECEDENCE',
                              'IGNORE_SPACE',
                              'NO_AUTO_CREATE_USER',
                              'NO_AUTO_VALUE_ON_ZERO',
                              'NO_BACKSLASH_ESCAPES',
                              'NO_DIR_IN_CREATE',
                              'NO_ENGINE_SUBSTITUTION',
                              'NO_FIELD_OPTIONS',
                              'NO_KEY_OPTIONS',
                              'NO_TABLE_OPTIONS',
                              'NO_UNSIGNED_SUBTRACTION',
                              'NO_ZERO_DATE',
                              'NO_ZERO_IN_DATE',
                              'ONLY_FULL_GROUP_BY',
                              'PAD_CHAR_TO_FULL_LENGTH',
                              'PIPES_AS_CONCAT',
                              'REAL_AS_FLOAT',
                              'STRICT_ALL_TABLES',
                              'STRICT_TRANS_TABLES'],
                  'default': 'ONLY_FULL_GROUP_BY STRICT_TRANS_TABLES NO_ZERO_IN_DATE NO_ZERO_DATE ERROR_FOR_DIVISION_BY_ZERO NO_AUTO_CREATE_USER NO_ENGINE_SUBSTITUTION',
                  'inversion': (5, 7, 8),
                  'type': 'set'},
                { 'choice': [ 'ALLOW_INVALID_DATES',
                              'ANSI_QUOTES',
                              'ERROR_FOR_DIVISION_BY_ZERO',
                              'HIGH_NOT_PRECEDENCE',
                              'IGNORE_SPACE',
                              'NO_AUTO_CREATE_USER',
                              'NO_AUTO_VALUE_ON_ZERO',
                              'NO_BACKSLASH_ESCAPES',
                              'NO_DIR_IN_CREATE',
                              'NO_ENGINE_SUBSTITUTION',
                              'NO_FIELD_OPTIONS',
                              'NO_KEY_OPTIONS',
                              'NO_TABLE_OPTIONS',
                              'NO_UNSIGNED_SUBTRACTION',
                              'NO_ZERO_DATE',
                              'NO_ZERO_IN_DATE',
                              'ONLY_FULL_GROUP_BY',
                              'PAD_CHAR_TO_FULL_LENGTH',
                              'PIPES_AS_CONCAT',
                              'REAL_AS_FLOAT',
                              'STRICT_ALL_TABLES',
                              'STRICT_TRANS_TABLES',
                              'TIME_TRUNCATE_FRACTIONAL'],
                  'default': 'ONLY_FULL_GROUP_BY STRICT_TRANS_TABLES NO_ZERO_IN_DATE NO_ZERO_DATE ERROR_FOR_DIVISION_BY_ZERO NO_AUTO_CREATE_USER NO_ENGINE_SUBSTITUTION',
                  'inversion': (8, 0, 1),
                  'type': 'set'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ssl',
    'description': 'Enable secure connection',
    'disabledby': 'skip-ssl',
    'name': 'ssl',
    'values': [ { 'default': 'false',
                  'off': 'disabledby',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ssl-ca',
    'description': 'Path of file that contains list of trusted SSL CAs',
    'name': 'ssl-ca',
    'values': [{ 'type': 'filename'}],
    'versions': [ ((5, 0, 23), (5, 1, 11)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ssl-capath',
    'description': 'Path of directory that contains trusted SSL CA certificates in PEM format',
    'name': 'ssl-capath',
    'values': [{ 'type': 'dirname'}],
    'versions': [ ((5, 0, 23), (5, 1, 11)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ssl-cert',
    'description': 'Path of file that contains X509 certificate in PEM format',
    'name': 'ssl-cert',
    'values': [{ 'type': 'filename'}],
    'versions': [ ((5, 0, 23), (5, 1, 11)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ssl-cipher',
    'description': 'List of permitted ciphers to use for connection encryption',
    'name': 'ssl-cipher',
    'values': [{ 'type': 'string'}],
    'versions': [ ((5, 0, 23), (5, 1, 11)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'ssl-crl',
    'description': 'Path of file that contains certificate revocation lists',
    'name': 'ssl-crl',
    'values': [{ 'type': 'filename'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ssl-crlpath',
    'description': 'Path of directory that contains certificate revocation list files',
    'name': 'ssl-crlpath',
    'values': [{ 'type': 'dirname'}],
    'versions': [((5, 6, 3),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'ssl-key',
    'description': 'Path of file that contains X509 key in PEM format',
    'name': 'ssl-key',
    'values': [{ 'type': 'filename'}],
    'versions': [ ((5, 0, 23), (5, 1, 11)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'standalone',
    'description': 'Instructs the MySQL server not to run as a service',
    'name': 'standalone',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'stored_program_cache',
    'description': 'Sets a "soft" upper limit for number of cached stored routines per connection. Stored procedures and stored functions are cached separately; this variable sets size for both of these.',
    'name': 'stored_program_cache',
    'values': [ { 'default': '256',
                  'maximum': '524288',
                  'minimum': '256',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'default': '256',
                  'inversion': (5, 7, 6),
                  'maximum': '524288',
                  'minimum': '16',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 21), (5, 6, 5)),
                  ((5, 5), (5, 6), (5, 7), (8, 0)),
                  ()]},
  { 'caption': 'stored_program_definition_cache',
    'description': 'Defines the number of stored program and event definition objects that can be kept in the dictionary object cache',
    'name': 'stored_program_definition_cache',
    'values': [ { 'default': '256',
                  'maximum': '524288',
                  'minimum': '256',
                  'type': 'integer'}],
    'versions': [(), ((8, 0),), ()]},
  { 'caption': 'super-large-pages',
    'description': 'Enable support for super large pages',
    'name': 'super-large-pages',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'platform': 'solaris',
                  'type': 'boolean'}],
    'versions': [((5, 5, 3),), ((5, 4), (5, 5), (5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'super_read_only',
    'description': 'Whether to ignore SUPER exceptions to read-only mode',
    'name': 'super_read_only',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'symbolic-links',
    'description': 'Use symbolic links',
    'disabledby': 'skip-symbolic-links',
    'name': 'symbolic-links',
    'values': [{ 'off': '0', 'on': '1', 'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'sync_binlog',
    'description': 'Synchronously flush binary log to disk after every #th event',
    'name': 'sync_binlog',
    'values': [ { 'bitsize': '32',
                  'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'inversion': (5, 5, 3),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'default': '1',
                  'inversion': (5, 7, 7),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((4, 1, 3), (5, 0, 1)),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'sync_frm',
    'description': 'Sync .frm to disk on create. Enabled by default',
    'name': 'sync_frm',
    'values': [ { 'default': 'true',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0)),
                  ((8, 0, 0),)]},
  { 'caption': 'sync_master_info',
    'description': 'Synchronize master.info to disk after every #th event.',
    'name': 'sync_master_info',
    'values': [ { 'bitsize': '32',
                  'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '10000',
                  'inversion': (5, 6, 6),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10000',
                  'inversion': (5, 6, 6),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((6, 0, 11),), ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)), ()]},
  { 'caption': 'sync_relay_log',
    'description': 'Synchronize relay log to disk after every #th event.',
    'name': 'sync_relay_log',
    'values': [ { 'bitsize': '32',
                  'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '10000',
                  'inversion': (5, 6, 6),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10000',
                  'inversion': (5, 6, 6),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((6, 0, 10),), ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)), ()]},
  { 'caption': 'sync_relay_log_info',
    'description': 'Synchronize relay.info file to disk after every #th event.',
    'name': 'sync_relay_log_info',
    'values': [ { 'bitsize': '32',
                  'default': '0',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'default': '10000',
                  'inversion': (5, 6, 6),
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '0',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'outversion': (5, 6, 5),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '10000',
                  'inversion': (5, 6, 6),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [((6, 0, 11),), ((5, 5), (5, 6), (5, 7), (6, 0), (8, 0)), ()]},
  { 'caption': 'sysdate-is-now',
    'description': 'Nondefault option to alias SYSDATE() to NOW() to make it safe-replicable',
    'name': 'sysdate-is-now',
    'values': [ { 'default': 'false',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 20), (5, 1, 8)),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'tablespace_definition_cache',
    'description': 'Defines the number of tablespace definition objects that can be kept in the dictionary object cache',
    'name': 'tablespace_definition_cache',
    'values': [ { 'default': '256',
                  'maximum': '524288',
                  'minimum': '256',
                  'type': 'integer'}],
    'versions': [(), ((8, 0),), ()]},
  { 'caption': 'table_cache',
    'description': 'Number of open tables for all threads',
    'name': 'table_cache',
    'values': [ { 'default': '64',
                  'maximum': '524288',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [(), ((4, 1), (5, 0), (5, 1)), ((5, 1, 3),)]},
  { 'caption': 'table_lock_wait_timeout',
    'description': 'Currently unused',
    'name': 'table_lock_wait_timeout',
    'values': [ { 'default': '50',
                  'maximum': '1073741824',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 0, 10),),
                  ((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                  ((5, 5, 3), (6, 0, 14))]},
  { 'caption': 'tc-heuristic-recover',
    'description': 'Decision to use in heuristic recover process. Possible values are COMMIT or ROLLBACK',
    'name': 'tc-heuristic-recover',
    'values': [ { 'choice': ['COMMIT', 'ROLLBACK'],
                  'default': 'COMMIT',
                  'type': 'enum'}],
    'versions': [ ((5, 0, 3),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'temp-pool',
    'description': 'Using this option will cause most temporary files created to use a small set of names, rather than a unique name for each new file',
    'name': 'temp-pool',
    'values': [ { 'default': 'true',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'thread_cache_size',
    'description': 'How many threads we should keep in a cache for reuse',
    'name': 'thread_cache_size',
    'values': [ { 'default': '0',
                  'maximum': '16384',
                  'minimum': '0',
                  'outversion': (5, 6, 7),
                  'type': 'integer'},
                { 'default': '-1 (autosized)',
                  'inversion': (5, 6, 8),
                  'maximum': '16384',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'thread_concurrency',
    'description': 'Permits the application to give the threads system a hint for the desired number of threads that should be run at the same time',
    'name': 'thread_concurrency',
    'values': [ { 'default': '10',
                  'maximum': '512',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0)),
                  ((5, 7, 2),)]},
  { 'caption': 'thread_handling',
    'description': 'The thread-handling model',
    'name': 'thread_handling',
    'values': [ { 'choice': ['no-threads', 'one-thread-per-connection'],
                  'default': 'one-thread-per-connection',
                  'outversion': (5, 5, 13),
                  'type': 'enum'},
                { 'choice': [ 'no-threads',
                              'one-thread-per-connection',
                              'dynamically-loaded'],
                  'default': 'one-thread-per-connection',
                  'inversion': (5, 5, 16),
                  'outversion': (5, 6, 99),
                  'type': 'enum'},
                { 'choice': ['no-threads', 'one-thread-per-connection'],
                  'default': 'one-thread-per-connection',
                  'inversion': (5, 7, 0),
                  'outversion': (5, 7, 8),
                  'type': 'enum'},
                { 'choice': [ 'no-threads',
                              'one-thread-per-connection',
                              'dynamically-loaded'],
                  'default': 'one-thread-per-connection',
                  'inversion': (5, 7, 9),
                  'type': 'enum'},
                { 'choice': ['no-threads', 'one-thread-per-connection'],
                  'default': 'one-thread-per-connection',
                  'inversion': (6, 0, 0),
                  'outversion': (6, 0, 3),
                  'type': 'enum'},
                { 'choice': [ 'no-threads',
                              'one-thread-per-connection',
                              'pool-of-threads'],
                  'default': 'one-thread-per-connection',
                  'inversion': (6, 0, 4),
                  'type': 'enum'}],
    'versions': [ ((5, 1, 17),),
                  ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0), (8, 0)),
                  ()]},
  { 'caption': 'thread_pool_algorithm',
    'description': 'The thread pool algorithm',
    'name': 'thread_pool_algorithm',
    'values': [ { 'default': '0',
                  'maximum': '1',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 16), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'thread_pool_high_priority_connection',
    'description': 'Whether the current session is high priority',
    'name': 'thread_pool_high_priority_connection',
    'values': [ { 'default': '0',
                  'maximum': '1',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 16), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'thread_pool_max_unused_threads',
    'description': 'The maximum permitted number of unused threads',
    'name': 'thread_pool_max_unused_threads',
    'values': [ { 'default': '0',
                  'maximum': '4096',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 16), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'thread_pool_prio_kickup_timer',
    'description': 'How long before a statement is moved to high-priority execution',
    'name': 'thread_pool_prio_kickup_timer',
    'values': [ { 'default': '1000',
                  'maximum': '4294967294',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 16), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'thread_pool_size',
    'description': 'Number of thread groups in the thread pool',
    'name': 'thread_pool_size',
    'values': [ { 'default': '16',
                  'maximum': '64',
                  'minimum': '1',
                  'type': 'integer'},
                { 'default': '20',
                  'inversion': (6, 0, 4),
                  'maximum': '16384',
                  'minimum': '1',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 16), (5, 6, 10), (5, 7, 9), (6, 0, 4)),
                  ((5, 5), (5, 6), (5, 7), (6, 0)),
                  ((6, 0, 14),)]},
  { 'caption': 'thread_pool_stall_limit',
    'description': 'How long before a statement is defined as stalled',
    'name': 'thread_pool_stall_limit',
    'values': [ { 'default': '6',
                  'maximum': '600',
                  'minimum': '4',
                  'type': 'integer'}],
    'versions': [ ((5, 5, 16), (5, 6, 10), (5, 7, 9)),
                  ((5, 5), (5, 6), (5, 7)),
                  ()]},
  { 'caption': 'thread_stack',
    'description': 'The stack size for each thread',
    'name': 'thread_stack',
    'values': [ { 'bitsize': '32',
                  'blocksize': '1024',
                  'default': '196608',
                  'maximum': '4294967295',
                  'minimum': '131072',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '262144',
                  'maximum': '18446744073709547520',
                  'minimum': '131072',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '262144',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '131072',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'timed_mutexes',
    'description': 'Specify whether to time mutexes (only InnoDB mutexes are currently supported)',
    'name': 'timed_mutexes',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [ ((5, 0, 3),),
                  ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)),
                  ((5, 7, 5),)]},
  { 'caption': 'tls_version',
    'description': 'Protocols permitted for secure connections',
    'name': 'tls_version',
    'values': [ { 'default': 'TLSv1,TLSv1.1,TLSv1.2',
                  'platform': 'openssl',
                  'type': 'string'},
                { 'default': 'TLSv1,TLSv1.1',
                  'platform': 'yassl',
                  'type': 'string'}],
    'versions': [((5, 7, 10),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'tmp_table_size',
    'description': 'If an in-memory temporary table exceeds this size, MySQL will automatically convert it to an on-disk MyISAM table',
    'name': 'tmp_table_size',
    'values': [ { 'default': '33554432',
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'outversion': (5, 0, 85),
                  'type': 'integer'},
                { 'default': '33554432',
                  'inversion': (5, 0, 86),
                  'maximum': '9223372036854775807',
                  'minimum': '1024',
                  'outversion': (5, 0, 99),
                  'type': 'integer'},
                { 'default': '33554432',
                  'inversion': (5, 1, 0),
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'outversion': (5, 1, 11),
                  'type': 'integer'},
                { 'default': '16777216',
                  'inversion': (5, 1, 12),
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'outversion': (5, 1, 36),
                  'type': 'integer'},
                { 'default': '16777216',
                  'inversion': (5, 1, 37),
                  'maximum': '9223372036854775807',
                  'minimum': '1024',
                  'outversion': (5, 1, 55),
                  'type': 'integer'},
                { 'default': '16777216',
                  'inversion': (5, 1, 56),
                  'maximum': '18446744073709551615',
                  'minimum': '1024',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'tmpdir',
    'description': 'Path for temporary files',
    'name': 'tmpdir',
    'values': [{ 'type': 'dirname'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'transaction-isolation',
    'description': 'Default transaction isolation level',
    'name': 'transaction-isolation',
    'values': [ { 'choice': [ 'READ-UNCOMMITTED',
                              'READ-COMMITTED',
                              'REPEATABLE-READ',
                              'SERIALIZABLE'],
                  'default': 'REPEATABLE-READ',
                  'type': 'enum'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'transaction-read-only',
    'description': 'Default transaction access mode',
    'name': 'transaction-read-only',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 6, 5),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'transaction_alloc_block_size',
    'description': 'Allocation block size for transactions to be stored in binary log',
    'name': 'transaction_alloc_block_size',
    'values': [ { 'bitsize': '32',
                  'blocksize': '1024',
                  'default': '8192',
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'outversion': (5, 5, 42),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 6, 0),
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'outversion': (5, 6, 23),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 7, 0),
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '8192',
                  'maximum': '18446744073709547520',
                  'minimum': '1024',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '1024',
                  'outversion': (5, 5, 42),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 6, 0),
                  'maximum': '18446744073709551615',
                  'minimum': '1024',
                  'outversion': (5, 6, 23),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 7, 0),
                  'maximum': '18446744073709551615',
                  'minimum': '1024',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 5, 43),
                  'maximum': '131072',
                  'minimum': '1024',
                  'outversion': (5, 5, 99),
                  'type': 'integer'},
                { 'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 6, 24),
                  'maximum': '131072',
                  'minimum': '1024',
                  'outversion': (5, 6, 99),
                  'type': 'integer'},
                { 'blocksize': '1024',
                  'default': '8192',
                  'inversion': (5, 7, 6),
                  'maximum': '131072',
                  'minimum': '1024',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'transaction_prealloc_size',
    'description': 'Persistent buffer for transactions to be stored in binary log',
    'name': 'transaction_prealloc_size',
    'values': [ { 'bitsize': '32',
                  'blocksize': '1024',
                  'default': '4096',
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'outversion': (5, 5, 42),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 6, 0),
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'outversion': (5, 6, 23),
                  'type': 'integer'},
                { 'bitsize': '32',
                  'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 7, 0),
                  'maximum': '4294967295',
                  'minimum': '1024',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '4096',
                  'maximum': '18446744073709547520',
                  'minimum': '1024',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '1024',
                  'outversion': (5, 5, 42),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 6, 0),
                  'maximum': '18446744073709551615',
                  'minimum': '1024',
                  'outversion': (5, 6, 23),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 7, 0),
                  'maximum': '18446744073709551615',
                  'minimum': '1024',
                  'outversion': (5, 7, 5),
                  'type': 'integer'},
                { 'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 5, 43),
                  'maximum': '131072',
                  'minimum': '1024',
                  'outversion': (5, 5, 99),
                  'type': 'integer'},
                { 'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 6, 24),
                  'maximum': '131072',
                  'minimum': '1024',
                  'outversion': (5, 6, 99),
                  'type': 'integer'},
                { 'blocksize': '1024',
                  'default': '4096',
                  'inversion': (5, 7, 6),
                  'maximum': '131072',
                  'minimum': '1024',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'updatable_views_with_limit',
    'description': 'This variable controls whether updates to a view can be made when the view does not contain all columns of the primary key',
    'name': 'updatable_views_with_limit',
    'values': [{ 'default': '1', 'off': '0', 'on': '1', 'type': 'boolean'}],
    'versions': [ ((5, 0, 2),),
                  ( (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'use-symbolic-links',
    'description': 'Enable symbolic link support. Deprecated option. Use --symbolic-links.',
    'name': 'use-symbolic-links',
    'values': [ { 'default': 'true',
                  'off': 'false',
                  'on': 'true',
                  'type': 'boolean'}],
    'versions': [(), ((5, 1), (5, 4), (6, 0)), ()]},
  { 'caption': 'user',
    'description': 'Run mysqld daemon as user',
    'name': 'user',
    'values': [{ 'type': 'string'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'validate-password',
    'description': 'Whether to activate the password validation plugin',
    'name': 'validate-password',
    'values': [ { 'choice': ['ON', 'OFF', 'FORCE', 'FORCE_PLUS_PERMANENT'],
                  'default': 'ON',
                  'type': 'enum'}],
    'versions': [((5, 6, 6),), ((5, 6), (5, 7), (8, 0)), ()]},
  { 'caption': 'validate_password_check_user_name',
    'description': 'Whether to check passwords against user name',
    'name': 'validate_password_check_user_name',
    'values': [ { 'default': 'off',
                  'off': 'off',
                  'on': 'on',
                  'outversion': (5, 7, 99),
                  'type': 'boolean'},
                { 'default': 'on',
                  'inversion': (8, 0, 0),
                  'off': 'off',
                  'on': 'on',
                  'type': 'boolean'}],
    'versions': [((5, 7, 15),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'verbose',
    'description': 'Used with --help option for detailed help',
    'name': 'verbose',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'version_tokens_session',
    'description': 'Client token list for Version Tokens',
    'name': 'version_tokens_session',
    'values': [{ 'default': 'NULL', 'type': 'string'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'version_tokens_session_number',
    'description': 'For internal use',
    'name': 'version_tokens_session_number',
    'values': [{ 'default': '0', 'type': 'integer'}],
    'versions': [((5, 7, 8),), ((5, 7), (8, 0)), ()]},
  { 'caption': 'wait_timeout',
    'description': 'Number of seconds the server waits for activity on a connection before closing it',
    'name': 'wait_timeout',
    'values': [ { 'default': '28800',
                  'maximum': '31536000',
                  'minimum': '1',
                  'platform': 'other',
                  'type': 'integer'},
                { 'default': '28800',
                  'maximum': '2147483',
                  'minimum': '1',
                  'platform': 'windows',
                  'type': 'integer'}],
    'versions': [ (),
                  ( (4, 1),
                    (5, 0),
                    (5, 1),
                    (5, 4),
                    (5, 5),
                    (5, 6),
                    (5, 7),
                    (6, 0),
                    (8, 0)),
                  ()]},
  { 'caption': 'warnings',
    'description': 'Deprecated; use --log-warnings instead',
    'name': 'warnings',
    'values': [ { 'bitsize': '32',
                  'default': '1',
                  'maximum': '4294967295',
                  'minimum': '0',
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1',
                  'maximum': '18446744073709547520',
                  'minimum': '0',
                  'outversion': (5, 5, 2),
                  'type': 'integer'},
                { 'bitsize': '64',
                  'default': '1',
                  'inversion': (5, 5, 3),
                  'maximum': '18446744073709551615',
                  'minimum': '0',
                  'type': 'integer'}],
    'versions': [(), ((4, 1), (5, 0)), ()]},
  { 'caption': 'skip-innodb',
    'description': 'Disable InnoDB',
    'name': 'skip-innodb',
    'values': [{ 'off': 'del', 'on': 'name', 'type': 'boolean'}],
    'versions': ((), ((5, 1),), ())}]
