# -*- coding: utf-8 -*-
#
# «debconftalk» - libmythbuntu class for speaking to debconf within packages
#
# This script:
# Copyright (C) 2007-2008, Michael Haas, for Mythbuntu
# Copyright (C) 2008, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import popen2

class debconftalk:
    """Class allowing communication to debconf"""

    def run(self,command,arg):
        debconf_read,debconf_write,debconf_err = popen2.popen3('debconf-communicate')

        print >>debconf_write, command, arg
        debconf_write.close()

        # print what debconf says on stderr
        # print debconf_err.readlines()[0]

        # split debconf response into numeric return code and extended result code
        # response[0] contains the return code
        # response[1] the delimiter (whitespace)
        # response[2] contains extended result code
        # note: if we set something, reponse[1] and [2] might be empty
        try:
            response = debconf_read.readlines()[0].partition(' ')
        except IndexError:
            print "IndexError while reading debconf"
            return '5'

        if response[0] == '0':
            # print "debconf reports success"
            returncode = '0'

        # the extend return code (second part of the answer) shouldn't be parsed unless command was "get"
        if command == 'get':
            #  print response[1]
            #  print response[2]
            #  print "Entire debconf reponse was:"
            #  print response
            # strip \n
            returncode = response[2].rstrip('\n')
        elif response[0] != '0':
            print "Sorry, there's a problem with debconf."
            print "Here's the output of debconf:"
            print response

        # close the fds
        debconf_read.close()
        debconf_err.close()

        # if talking to debconf was successful and if command is 'get', return the extended return code
        # return basic return code otherwise
        return returncode
