# -*- coding: utf-8 -*-
#
# «mysql» - mythbuntu class for mysql mangling
#
# This script:
# Copyright (C) 2007-2008, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import shutil
import os
import subprocess
import re
import string

#MySQL testing support
import MySQLdb

class MySQLHandler:
    """MySQL configuration, mangling, and activation class"""

    def __init__(self,config={"user":"mythtv","password":"mythtv","server":"localhost","database":"mythconverg"}):
        self.user=config["user"]
        self.password=config["password"]
        self.server=config["server"]
        self.database=config["database"]

    def read_mysql_txt(self,file):
        """Reads in file to setup stored mysql information"""
        try:
            in_f=open(file)
            for line in in_f:
                if re.compile("^DBHostName").search(line):
                    text=string.split(string.split(line,"=")[1],'\n')[0]
                    self.server = text
                elif re.compile("^DBUserName").search(line):
                    text=string.split(string.split(line,"=")[1],'\n')[0]
                    self.user = text
                elif re.compile("^DBName").search(line):
                    text=string.split(string.split(line,"=")[1],'\n')[0]
                    self.database = text
                elif re.compile("^DBPassword").search(line):
                    text=string.split(string.split(line,"=")[1],'\n')[0]
                    self.password= text
            in_f.close()
        except IOError:
            print "Error reading %s" % file

    def write_mysql_txt(self,file,debug=False):
        """Writes mysql.txt to a given file name"""
        f_host = False
        f_user = False
        f_pass = False
        f_db = False
        if os.path.exists(file):
            print "Copying %s to %s~" % (file,file)
            shutil.copy(file, file + "~")
            in_f = open(file + "~", 'r')
            out_f = open(file, "w")
            for line in in_f:
                if line.startswith("DBHostName"):
                    if not f_host:
                        out_f.write("DBHostName=" + self.server + "\n")
                        f_host = True
                elif line.startswith("DBUserName"):
                    if not f_user:
                        out_f.write("DBUserName=" + self.user + "\n")
                        f_user = True
                elif line.startswith("DBName"):
                    if not f_db:
                        out_f.write("DBName=" + self.database + "\n")
                        f_db = True
                elif line.startswith("DBPassword"):
                    if not f_pass:
                        out_f.write("DBPassword=" + self.password + "\n")
                        f_pass = True
                else:
                    out_f.write(line)
            in_f.close()
            if not debug:
                os.remove(file + "~")
        else:
            out_f = open(file, "w")
        if not f_host:
            out_f.write("DBHostName=" + self.server + "\n")
        if not f_user:
            out_f.write("DBUserName=" + self.user + "\n")
        if not f_db:
            out_f.write("DBName=" + self.database + "\n")
        if not f_pass:
            out_f.write("DBPassword=" + self.password + "\n")
        out_f.close()

    def toggle_mysql_service_config(self,enable):
        """Enables and disables the mysql service on all interfaces"""
        if not os.path.exists("/etc/mysql/conf.d"):
            os.mkdir("/etc/mysql/conf.d")
        lines = None
        out_f = None
        found = False
        pattern = re.compile("^bind-address|^#bind-address")
        try:
            in_f = open("/etc/mysql/conf.d/mythtv.cnf")
            lines = in_f.readlines()
            in_f.close()
            out_f=open("/etc/mysql/conf.d/mythtv.cnf","w")
            for line in lines:
                if pattern.search(line) is None:
                    out_f.write(line)
                elif not found:
                    if enable:
                        out_f.write("bind-address=0.0.0.0\n")
                    else:
                        out_f.write("#bind-address=0.0.0.0\n")
                    found = True
            if not found:
                if enable:
                    out_f.write("bind-address=0.0.0.0\n")
                else:
                    out_f.write("#bind-address=0.0.0.0\n")
        except IOError:
            print "/etc/mysql/conf.d/mythtv.cnf not found"
            out_f=open("/etc/mysql/conf.d/mythtv.cnf","w")
            out_f.write("[mysqld]\n")
            if enable:
                out_f.write("bind-address=0.0.0.0\n")
            else:
                out_f.write("#bind-address=0.0.0.0\n")
        out_f.close()

    def restart_mysql_service(self):
        """Restarts MySQL service"""
        start_mysql = subprocess.Popen(["/usr/sbin/invoke-rc.d", "mysql", "restart"],stdout=subprocess.PIPE).communicate()[0]
        print start_mysql

    def update_config(self,config):
        """Sets up a new configuration based on the dict {user,pass,server,db}"""
        self.user=config["user"]
        self.password=config["password"]
        self.server=config["server"]
        self.database=config["database"]

    def get_config(self):
        """Returns our currently stored configuration"""
        return {"user":self.user,"password":self.password,"server":self.server,"database":self.database}

    def reset_user_password(self,admin_pass,password):
        """Resets a user's password if it was forgotten"""
        commands = ["UPDATE user SET Password=PASSWORD('"+password+"') WHERE user=mythtv')",
        "FLUSH PRIVILEGES"]
        if self.run_mysql_commands(commands,mysql_user="root"):
            return "Successful"
        else:
            return "Failure"

    def run_mysql_commands(self,commands,mysql_user=None):
        """Runs mysql command(s) and returns the response"""
        if mysql_user is None:
            mysql_user = self.user
        try:
            db = MySQLdb.connect(host=self.server, user=mysql_user, passwd=self.password,db=self.database)
            cursor = db.cursor()
            if type(commands) is list:
                for command in commands:
                    cursor.execute(command)
                    result = cursor.fetchone()
            elif type(commands) is str:
                result = cursor.execute(commands)
            else:
                print "Unknown type"
            cursor.close()
            db.close()
        except:
            result = False
        return result

    def do_connection_test(self):
        """Tests to make sure that the backend is accessible"""
        if self.run_mysql_commands("SELECT NULL"):
            return "Successful"
        else:
            return "Failure"
