# -*- coding: utf-8 -*-
#
# «MythTVHandler» - MythTV Application lirc creator
#
# Copyright (C) 2007, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuLircGenerator.core import ProgramHandler

class MythTVHandler(ProgramHandler):
    def __init__(self,lircd, lircrc,repeat,delay):
        application_name="mythtv"
        application_dictionary={ \
        "up":"Up", \
        "down":"Down", \
        "left":"Left", \
        "right":"Right", \
        "enter":"Enter", \
        "rewind":"<", \
        "forward":">", \
        "vol-":"[", \
        "vol+":"]", \
        "mute":"|", \
        "chan-":"PgDown", \
        "chan+":"PgUp", \
        "ok":"Return", \
        "home":"M", \
        "menu":"M", \
        "info":"I", \
        "pause":"P", \
        "play":"P", \
        "stop":"Escape", \
        "exit":"D", \
        "record":"R", \
        "one":"1", \
        "two":"2", \
        "three":"3", \
        "four":"4", \
        "five":"5", \
        "six":"6", \
        "seven":"7", \
        "eight":"8", \
        "nine":"9", \
        "zero":"0", \
        "skip":"Z", \
        "replay":"Q", \
        "guide":"S" \
        #"power":"Escape" \ #removing this mapping until a proper power script can be generated
        }
        ProgramHandler.__init__(self,application_name,application_dictionary,lircd,lircrc,repeat,delay)
