## -*- coding: utf-8 -*-
#
# «mythbuntu_log_grabber» - Utility to grab diagnostic logs and data for user support
#
# Copyright (C) 2009, Nick Fox, for Mythbuntu
# Copyright (C) 2009, Thomas Mashos, for Mythbuntu
# Copyright (C) 2010, Thomas Mashos, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuControlCentre.plugin import MCCPlugin
import gtk
import os
import subprocess
import urllib
import socket
import threading

class LogGrabberPostThread(threading.Thread):
    def __init__(self, data_input):
        self.data_input = data_input
        threading.Thread.__init__(self)
    def run(self):
        return post_data(self.data_input)

def post_data(data_in):
    """ Post data to Mythbutnu Pastebin """
    try:
        subdomain = "mythbuntu"
        url = "http://pastebin.com/api_public.php"
        params={}
        params['paste_code'] = data_in
        params['paste_subdomain'] = subdomain 
        data = urllib.urlencode(params)
        page = urllib.urlopen(url, data).read()
        paste_url = page
    except:
        paste_url = "Timeout/Error occured while uploading data. Local Data: /tmp/mythbuntu.diag"
    return paste_url

class LogGrabberPlugin(MCCPlugin):
    """An Example Plugin for showing how to use MCC as a developer"""
    #
    #Load GUI & Calculate Changes
    #

    TOC = [
    ]

    def __init__(self):
        import os
        #Initialize parent class
        information = {}
        information["name"] = "Log Grabber"
        information["icon"] = "mythbuntu-log-grabber"
        information["ui"] = "tab_log_grabber"
        """Remove Any Old Logs"""
        if os.path.exists('/tmp/mythbuntu.diag'):
            os.remove('/tmp/mythbuntu.diag')
        socket.setdefaulttimeout(45)
        MCCPlugin.__init__(self,information)

    def captureState(self):
        """Determines the state of the items on managed by this plugin
           and stores it into the plugin's own internal structures"""
        self.changes = {}
        self.changes['syslog'] = os.path.exists('/var/log/syslog')
        self.changes['backend'] = os.path.exists('/var/log/mythtv/mythbackend.log')
        self.changes['frontend'] = os.path.exists('/var/log/mythtv/mythfrontend.log')
        self.changes['xorg'] = os.path.exists('/var/log/Xorg.0.log')
        self.changes['xsession'] = os.path.exists(os.environ['HOME'] + '/.xsession-errors')
        self.changes['disk'] = True
        self.changes['version'] = True
        self.changes['hardware'] = True

    def applyStateToGUI(self):
        """Takes the current state information and sets the GUI
           for this plugin"""
        if not self.changes['syslog']:
            self.sys_log_check.set_sensitive(False)
        if not self.changes['backend']:
            self.backend_check.set_sensitive(False)
        if not self.changes['frontend']:
            self.frontend_check.set_sensitive(False)
        if not self.changes['xorg']:
            self.xorg_check.set_sensitive(False)
        if not self.changes['xsession']:
            self.xsession_check.set_sensitive(False)
        # MCC Will Try to upload logs if This is enabled by default
        self.enable_all_checkbox.set_active(False)
        
    def compareState(self):
        """Determines what items have been modified on this plugin"""
        MCCPlugin.clearParentState(self)
        if self.sys_log_check.get_active():
            self._markReconfigureUser('Syslog', self.sys_log_check.get_active())
        if self.backend_check.get_active():
            self._markReconfigureUser('Mythbackend Log', self.backend_check.get_active())
        if self.frontend_check.get_active():
            self._markReconfigureUser('Mythfrontend Log', self.frontend_check.get_active())
        if self.xorg_check.get_active():
            self._markReconfigureUser('Xorg Log', self.xorg_check.get_active())
        if self.xsession_check.get_active():
            self._markReconfigureUser('Xsession Errors', self.xsession_check.get_active())
        if self.hardware_check.get_active():
            self._markReconfigureUser('Installed Hardware', self.hardware_check.get_active())
        if self.version_check.get_active():
            self._markReconfigureUser('Mythbuntu Version', self.version_check.get_active())
        if self.disk_space_check.get_active():
            self._markReconfigureUser('Disk Space', self.disk_space_check.get_active())
            
            
    #
    # Callbacks
    #
    def on_enable_all_checkbox_toggled(self,widget,data=None):
        """Enable/Disable all Options in GUI"""
        check_changed = self.enable_all_checkbox.get_active()
        if check_changed:
            if self.sys_log_check.props.sensitive:
                self.sys_log_check.set_active(True)
            if self.backend_check.props.sensitive:
                self.backend_check.set_active(True)
            if self.frontend_check.props.sensitive:
                self.frontend_check.set_active(True)
            if self.xorg_check.props.sensitive:
                self.xorg_check.set_active(True)
            if self.xsession_check.props.sensitive:
                self.xsession_check.set_active(True)
            if self.hardware_check.props.sensitive:
                self.hardware_check.set_active(True)
            if self.version_check.props.sensitive:
                self.version_check.set_active(True)
            if self.disk_space_check.props.sensitive:
                self.disk_space_check.set_active(True)
        else:
            if self.sys_log_check.props.sensitive:
                self.sys_log_check.set_active(False)
            if self.backend_check.props.sensitive:
                self.backend_check.set_active(False)
            if self.frontend_check.props.sensitive:
                self.frontend_check.set_active(False)
            if self.xorg_check.props.sensitive:
                self.xorg_check.set_active(False)
            if self.xsession_check.props.sensitive:
                self.xsession_check.set_active(False)
            if self.hardware_check.props.sensitive:
                self.hardware_check.set_active(False)
            if self.version_check.props.sensitive:
                self.version_check.set_active(False)
            if self.disk_space_check.props.sensitive:
                self.disk_space_check.set_active(False)
    #
    # Process selected activities
    #
    def user_scripted_changes(self, reconfigure):
        for item in reconfigure:
            self.TOC.append(item)
        self.init_log()
        for item in reconfigure:
            if item == "Syslog":
                if reconfigure[item]:
                    self.emit_progress("Gathering the Syslog...", 20)
                    self.syslog()
            elif item == "Mythbackend Log":
                if reconfigure[item]:
                    self.emit_progress("Gathering the MythTV Backend log...", 30)
                    self.mythbackend()
            elif item == "Mythfrontend Log":
                if reconfigure[item]:
                    self.emit_progress("Gathering the MythTV Frontend Log...", 40)
                    self.mythfrontend()
            elif item == "Xorg Log":
                if reconfigure[item]:
                    self.emit_progress("Gathering the Xorg Log...", 50)
                    self.xorg_log()
            elif item == "Xsession Errors":
                if reconfigure[item]:
                    self.emit_progress("Gathering the Xsession Log...", 60)
                    self.xsession_errors()
            elif item == "Installed Hardware":
                if reconfigure[item]:
                    self.emit_progress("Gathering System hardware Info...", 70)
                    self.installed_hardware()
            elif item == "Mythbuntu Version":
                if reconfigure[item]:
                    self.emit_progress("Gathering the Mythbuntu Version Info...", 80)
                    self.mythbuntu_version()
            elif item == "Disk Space":
                if reconfigure[item]:
                    self.emit_progress("Gathering the Hard disk info...", 90)
                    self.disk_space()
        if os.path.exists('/tmp/mythbuntu.diag'):            
            if len(reconfigure) >= 1:
                with open('/tmp/mythbuntu.diag') as file:
                    self.emit_progress("Posting the diagnostic data...", 95)
                    paste_data = file.read()
                    get_url = LogGrabberPostThread(paste_data)
                    paste_url = get_url.run()
                    while get_url.isAlive():
                        """ Just keep passing until the thread goes away """
                        pass
                    self.pastebin_output.set_text(paste_url)
                    file.close()
        else:
            print "Diagnostic data file not found!"

    def write_log(self, section_name, data_in=None):
        """Builds the Actual Log File on the Local Machine"""
        if ( section_name == "Initialize" ):
            log = open('/tmp/mythbuntu.diag', 'w')
            log.write("Gathered following logs\n")
            for TOC in self.TOC:
                log.write('=== '+TOC+' ===\n')
            log.write('\n')
            log.close()
        else:
            """Append"""
            log = open('/tmp/mythbuntu.diag', 'a')
            log.write('=== ' + section_name + ' ===\n')
            log.write(data_in)
            log.write('\n')
            log.close()

    def tail_log(self, FILEPATH, HEADER):
        MAXLINES=1000
        MLP=MAXLINES/100
        LINES=MAXLINES+MLP
        f = open(FILEPATH, "r")
        linestuffs = []
        more = True
        while more:
            line = f.readline()
            if line:
                if len(linestuffs) >= LINES:
                    del linestuffs[0:MLP]
                linestuffs.append(line)
            else:
                more = False
        f.close()
        data_in = "=== "+FILEPATH+" ===\n"
        for stuff in linestuffs:
            data_in += stuff ## Change to write to logfile
        self.write_log(HEADER,data_in)

    def init_log(self):
        self.write_log("Initialize")

    def installed_hardware(self):
        """Gather all Hardware Information"""
        data_in = subprocess.Popen(["/usr/bin/lspci"], stdout=subprocess.PIPE).communicate()[0]
        data_in += subprocess.Popen(["/usr/bin/lsusb"], stdout=subprocess.PIPE).communicate()[0]
        self.write_log("Installed Hardware",data_in)

    def xorg_log(self):
        """Read in the Xorg.0.log"""
        self.tail_log('/var/log/Xorg.0.log',"Xorg Log")

    def xsession_errors(self):
        """Get the Xsession Errors"""
        session_log = os.environ['HOME'] + '/.xsession-errors'
        self.tail_log(session_log,"Xsession Log")

    def syslog(self):
        """Read in the Syslog"""
        self.tail_log('/var/log/syslog', "Syslog")

    def mythfrontend(self):
        """Read in the Frontend Log"""
        self.tail_log('/var/log/mythtv/mythfrontend.log', "Mythfrontend Log")

    def mythbackend(self):
        """Read in the Backend Log"""
        self.tail_log('/var/log/mythtv/mythbackend.log', "Mythbackend Log")

    def disk_space(self):
        """Gather all Disk Information"""
        data_in = subprocess.Popen(["/bin/df", "-h"], stdout=subprocess.PIPE).communicate()[0]
        self.write_log("Disk Space",data_in)

    def mythbuntu_version(self):
        """Gather Mythbuntu Version"""
        data_in = subprocess.Popen(["/usr/bin/lsb_release", "-a"], stdout=subprocess.PIPE).communicate()[0]
        self.write_log("Mythbuntu Version",data_in)
