#!/usr/bin/perl

use strict;
use CGI qw(:standard);
use HTML::Template;
use Config::Simple; 

require includes;

my $file = "/etc/mythtv/mythexport/mythexport_settings.cfg";
my ($script,$content) = "";
my $template = HTML::Template->new(filename => 'template/template.tmpl');

# if we have a valid config
if(-e $file && -s $file > 207){
    my $cfg = new Config::Simple();
    $cfg->read($file) || die $cfg->error();

    $script = "<script type=\"text/javascript\">//<![CDATA[
    function changeBlock(){
    var url = \"setup_edit.cgi?block=\" + document.getElementById(\"block\").value;
    window.location = url;
    }
    function deleteConfig(){
        document.getElementById(\"delete\").value = 1;
        document.forms[0].submit();
    }
    //]]>
    </script>";

    my $block = param("block");

    my $test = $cfg->as_string();
    $test =~ s/\n//g;
    $test =~ s/^(.*?)\[//;
    $test =~ s/\](.*?)\[/,/g;
    $test =~ s/\](.*?)$//;

    my @blocks = split(",", $test);

    if ($block eq ""){
        $block = @blocks[0];
    }

    $content = "<form id=\"form\" action=\"save_setup.cgi\" method=\"post\"><p>
    Choose a configuration to Edit: <select id=\"block\" name=\"block\" onchange=\"javascript:changeBlock();\">";

    foreach(@blocks){
	    $content .= "<option value=\"$_\"";
	    if ($_ eq $block){
		    $content .= " selected=\"selected\"";
	    }
	    $content .= ">$_</option>";
    }

    my $sizeX = $cfg->param("$block.sizeX") unless ref $cfg->param("$block.sizeX") eq 'ARRAY'; 
    my $sizeY = $cfg->param("$block.sizeY") unless ref $cfg->param("$block.sizeY") eq 'ARRAY';
    my $audioBR = $cfg->param("$block.audioBR") unless ref $cfg->param("$block.audioBR") eq 'ARRAY';
    my $videoBR = $cfg->param("$block.videoBR") unless ref $cfg->param("$block.videoBR") eq 'ARRAY';
    my $device = $cfg->param("$block.device") unless ref $cfg->param("$block.device") eq 'ARRAY';
    my $aspect = $cfg->param("$block.aspect") unless ref $cfg->param("$block.aspect") eq 'ARRAY';
    my $codec = $cfg->param("$block.codec") unless ref $cfg->param("$block.codec") eq 'ARRAY';
    my $deinterlace = $cfg->param("$block.deinterlace") unless ref $cfg->param("$block.deinterlace") eq 'ARRAY';
    my $deletePeriod = $cfg->param("$block.deletePeriod") unless ref $cfg->param("$block.deletePeriod") eq 'ARRAY';
    my $podcastName = $cfg->param("$block.podcastName") unless ref $cfg->param("$block.podcastName") eq 'ARRAY';
    my $removeCommercials = $cfg->param("$block.removeCommercials") unless ref $cfg->param("$block.removeCommercials") eq 'ARRAY';
    my $audioChannels = $cfg->param("$block.audioChannels") unless ref $cfg->param("$block.audioChannels") eq 'ARRAY';
    my $threads = $cfg->param("$block.threads") unless ref $cfg->param("$block.threads") eq 'ARRAY';
    my $extension = $cfg->param("$block.extension") unless ref $cfg->param("$block.extension") eq 'ARRAY';
    my $ffmpegArgs = $cfg->param("$block.ffmpegArgs") unless ref $cfg->param("$block.ffmpegArgs") eq 'ARRAY';

    $content .= "</select>&nbsp;<span class=\"red\">*</span><br /><br />
        <input type=\"hidden\" id=\"delete\" name=\"delete\" value=\"0\" />
	    <input type=\"hidden\" id=\"device\" name=\"device\" value=\"$device\" />
	    Title: $block<input type=\"hidden\" id=\"title\" name=\"title\" value=\"$block\" />&nbsp;<span class=\"red\">*</span><br />";

    if($device eq "custom"){
	    $content .= "FFmpeg Arguments: <input type=\"text\" id=\"args\" name=\"args\" value=\"$ffmpegArgs\" />&nbsp;<span class=\"red\">*</span><br />
        File Extension: <input type=\"text\" id=\"extension\" name=\"extension\" value=\"$extension\" /><br />";
    }
    elsif($device eq "mp3"){
	    $content .= "Audio Bitrate: <input type=\"text\" id=\"audioBR\" name=\"audioBR\" value=\"$audioBR\" />&nbsp;<span class=\"red\">*</span><br />";
    }
    elsif($device eq "symlink"){
	    $content .= "Symlinks will be created and linked to your original recordings.";
    }
    else{
	    $content .= "Size: <input type=\"text\" id=\"sizeX\" name=\"sizeX\" value=\"$sizeX\" />&nbsp;<span class=\"red\">*</span>&nbsp;X&nbsp;
	    <input type=\"text\" id=\"sizeY\" name=\"sizeY\" value=\"$sizeY\" />&nbsp;<span class=\"red\">*</span><br />
	    Aspect: <input type=\"text\" id=\"aspect\" name=\"aspect\" value=\"$aspect\" />&nbsp;<span class=\"red\">*</span><br />
	    Audio Bitrate: <input type=\"text\" id=\"audioBR\" name=\"audioBR\" value=\"$audioBR\" />&nbsp;<span class=\"red\">*</span><br />
	    Video Bitrate: <input type=\"text\" id=\"videoBR\" name=\"videoBR\" value=\"$videoBR\" />&nbsp;<span class=\"red\">*</span><br />
	    Codec: <select id=\"codec\" name=\"codec\">
	    <option value=\"none\">None</option>
	    <option value=\"mpeg4\"";
	    if ($codec eq "mpeg4"){
		    $content .= " selected=\"selected\"";
	    }
	    $content .= ">mpeg4</option>
	    <option value=\"xvid\"";
	    if ($codec eq "xvid"){
		    $content .= " selected=\"selected\"";
	    }
	    $content .= ">xvid</option>";
	    if($device ne "psp"){
		    $content .= "<option value=\"h264\"";
		    if ($codec eq "h264"){
			    $content .= " selected=\"selected\"";
		    }
		    $content .= ">h.264</option>";
	    }
	    $content .= "<option value=\"mp3\"";
	    if ($codec eq "mp3"){
		    $content .= " selected=\"selected\"";
	    }
	    $content .= ">mp3</option>
	    </select>&nbsp;<span class=\"red\">*</span><br />
	    Delete Period: <input type=\"text\" id=\"deletePeriod\" name=\"deletePeriod\" value=\"$deletePeriod\" /><br />
	    Podcast Name: <input type=\"text\" id=\"podcastName\" name=\"podcastName\" value=\"$podcastName\" /><br />
	    Deinterlace: <input type=\"checkbox\" id=\"deinterlace\" name=\"deinterlace\" value=\"1\" ";
	    if ($deinterlace == 1){
		    $content .= "checked=\"checked\" ";
	    }
	    $content .= "/><br />
	    Remove Commercials: <input type=\"checkbox\" id=\"removeCommercials\" name=\"removeCommercials\" value=\"1\" ";
	    if ($removeCommercials == 1){
		    $content .= "checked=\"checked\" ";
	    }
	    $content .= "/><br /><br />
	    - Addition Tweaks -<br /><br />
	    Audio Channels: <input type=\"text\" id=\"audioChannels\" name=\"audioChannels\" value=\"$audioChannels\" />&nbsp;* May help with dvb recordings<br />
	    Muti-threading: <input type=\"checkbox\" id=\"threads\" name=\"threads\" value=\"1\" ";
	    if ($threads == 1){
		    $content .= "checked=\"checked\" ";
	    }
	    $content .= "/><br />";
    }

    $content .= "<br />&nbsp;<span class=\"red\">* Are required</span><br /><input type=\"submit\" id=\"submitButton\" name=\"submitButton\" value=\"Submit\" />
    <input type=\"button\" id=\"deleteButton\" name=\"deleteButton\" value=\"Delete\" onclick=\"javascript:deleteConfig();\" />
    </p></form>";
}
else{
    $content = "<p>Missing or Invalid configuration file, please create one.</p>";
}

$template->param(SCRIPT => $script);
$template->param(CONTENT => $content);
$template->param(LOCATION => "setup");

print generateContentType(), $template->output;
exit(0);
