#ifndef _CalendarView_
#define _CalendarView_

#include <AppKit/AppKit.h>

static NSString *CalendarViewSelectionDidChangeNotification = @"CalendarViewSelectionDidChangeNotification";

@interface CalendarView : NSView
{
  NSBox *calendarBox;
  NSTextField *label;
  NSButton *lastMonthButton, *nextMonthButton;
  NSMatrix *dayMatrix;
  NSCalendarDate *date;
  id delegate;
}

- (NSCalendarDate *) date;
- (void) setDate: (NSCalendarDate *)date;

/* Used by interface */
- (void) updateDate: (id) sender;
- (void) setDelegate: (id) delegate;
- (id) delegate;

@end

@interface NSObject (CalendarViewDelegate)
- (void) calendarViewSelectionDidChange: (NSNotification *) not;
- (void) calendarView: (CalendarView *) view
         willDisplayCell: (id) cell
	 ofDate: (NSCalendarDate *) date;
@end

#endif /* _CalendarView_ */


