/* Data Source */

#ifndef __DataSource__
#define __DataSource__

#include <Foundation/Foundation.h>

static NSString *XMLTitleTag = @"title";
static NSString *XMLContentTag = @"content";
static NSString *XMLCreatedDateTag = @"createddate";
static NSString *XMLModifiedDateTag = @"modifieddate";
static NSString *XMLVersionTag = @"version";

static NSString *TitleKey = @"Title";
static NSString *ContentKey = @"Content";
static NSString *CreatedDateKey = @"CreatedDate";
static NSString *ModifiedDateKey = @"ModifiedDate";

// "Tues 1/31/2003 23:47 -0500 New York"
static NSString *DateFormat = @"%a %m/%d/%Y %H:%M %z %Z";

static NSString *HomeTitle = @"Home";
static NSString *SearchResultTitle = @"__Search Result__";
static NSString *JournalTitle = @"__Journal__";

@interface DataSource: NSObject
{
  NSMutableString *fileContent;

  /** Array of dictionary
   * Key: TitleKey, ContentKey, CreatedDateKey, ModifiedDateKey
   */
  NSMutableArray *wikiPages; 
}

// read from file
- (void) setDataFromContentOfFile: (NSString *) content;
// data for save file
- (NSData *) dataOfIndexFile;

- (void) setContent: (NSString *) content withTitle: (NSString *) title;
- (NSAttributedString *) renderWithTitle: (NSString *) title;
- (NSString *) sourceWithTitle: (NSString *) title;
- (BOOL) canRemoveContentOfTitle: (NSString *) title;
// page which can not be edited is always in render view
- (BOOL) canEditContentOfTitle: (NSString *) title;
- (void) removeContentOfTitle: (NSString *) title;

- (unsigned int) numberOfPages;
- (NSArray *) titles;
- (unsigned int) indexOfTitle: (NSString *) title;
- (NSString *) titleAtIndex: (unsigned int) index;
- (void) replaceTitle: (NSString *) oldTitle withTitle: (NSString *) newTitle;

// Replace old link to new one
- (void) replaceContentOfLink: (NSString *) oldString 
                   withString: (NSString *) newString;
// Check whether this page is linked by other pages
- (BOOL) isLinkedByOthers: (NSString *) title;

		   
- (BOOL) hasContentCreatedOnDate: (NSCalendarDate *) date;
- (BOOL) hasContentModifiedOnDate: (NSCalendarDate *) date;
// Array of title strings
- (NSArray *) titlesCreatedOnDate: (NSCalendarDate *) date;
- (NSArray *) titlesModifiedOnDate: (NSCalendarDate *) date;

@end

#endif
