/*
**  LinkHandler.m
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju  <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "LinkHandler.h"
#include "GNUstep.h"
#include <AppKit/AppKit.h>

@implementation LinkHandler

- (void) special: (NSString *) element
{
  [result appendString: element];
}

- (void) content: (NSString *) element
{
  if ((linkTag == YES) && 
      ([element isEqualToString: oldTitle]))
    {
      [result appendString: newTitle];
    }
  else
    [result appendString: element];
}

- (void) tag: (NSString *) element
{
  if ([element isEqualToString: @"link"])
    {
      linkTag = YES;
    }
  else if ([element isEqualToString: @"/link"])
    {
      linkTag = NO;
    }
  [result appendString: [NSString stringWithFormat: @"<%@>", element]];
}

- (id) init
{
  self = [super init];

  linkTag = NO;
  result = [[NSMutableString alloc] init];

  return self;
}

- (void) dealloc
{
  RELEASE(result);
  [super dealloc];
}

- (void) setOldLink: (NSString *) oldString
         replacedBy: (NSString *) newString
{
  ASSIGN(oldTitle, oldString);
  ASSIGN(newTitle, newString);
}

- (NSString *) updatedString
{
  return result;
}

@end

