/*
**  TagHandler.h
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju  <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _TagHandler_H_
#define _TagHandler_H_

#include "CodeHandler.h"
#include <Foundation/Foundation.h>

/** It extract tag (<xxx>) and content (string between tag)
 *  and call -tag: and -content: alternatively.
 *
 *  '>>', '<<' and '\n' will be treated as special 
 *  because they are not allowed in standard XML document.
 *  They are also not allowed to be in the tag.
 *  If they are in the tag, they will be ignored and -error: will be filed,
 *
 *  Ex. "first <second> third </fourth> fifth << sixth <sev<<enth>" will be
 *  Content: @"first "
 *      Tag: @"second"
 *  Content: @" third "
 *      Tag: @"/fourth"
 *  Content: @" fifth "
 *  Special: @"<<"
 *  Content: @" sixth"
 *    Error: InvalidCharacterInTag
 *      Tag: @"seventh"
 */

typedef enum _ErrorType {
  InvalidCharacterInTag = 1 // '<<', '>>' or '\n' in the tag
} ErrorType;

@interface TagHandler: NSObject <CodeHandler>
{
  NSMutableString *_tag, *_content;
  BOOL _inTag;
  unichar _preSymbol;
}

// Override by subclass

- (void) tag: (NSString *) tag;
- (void) content: (NSString *) content;
- (void) special: (NSString *) special;
- (void) error: (ErrorType) type;

@end

#endif /* _TagHandler_H_ */
