/*
 * Mausezahn - A fast versatile traffic generator
 * Copyright (C) 2008 Herbert Haas
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 as published by the 
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with 
 * this program; if not, see http://www.gnu.org/licenses/gpl-2.0.html
 * 
*/



#include "mz.h"



int create_rtp_packet()
{
   u_int8_t 
     byte1,
     byte2;
   u_int16_t 
     seqnr;
   u_int32_t 
     ssrc;
//     csrc;  // currently unused
   
   u_int8_t 
     *ptr;

   char argval[MAX_PAYLOAD_SIZE];
   
   unsigned int rtp_payload_size=160;
   
   if ( (getarg(tx.arg_string,"help", NULL)==1) && (mode==RTP) )
     {
	fprintf(stderr,"\n"
		MAUSEZAHN_VERSION
		"\n"
		"| RTP type: Send Real Time Protocol packets.\n"
		"|\n"
		"| This mode is solely intended to perform delay and jitter measurements to test\n"
		"| Voice (Video) over IP networks. You will typically initiate another Mausezahn\n"
		"| instance on the destination host, which will perform the measurements or even\n"
		"| 'bounce back' the packets for Round Trip Time (RTT) measurements.\n"
		"|\n"
		"| When the delay parameter is not specifed, the default (inter-packet) delay is\n"
		"| set to 20 msec. You must specify the destination host using the -B option.\n"
		"| The default destination port is (UDP) 30000 but can be overridden (dp parameter).\n"
		"| You do not need to specify the count option (-c), because 'infinite' (0) is assumed.\n"
		"|\n"
		"| You can specify these additional GENERAL options:\n"
		"|\n"
		"|  -c <count>     ..... use this packet count value instead of infinity.\n"
		"|  -d <delay>     ..... use this delay value instead of the defaul. Per default\n"
		"|                       the units are microseconds but you can also use msec or sec\n"
		"|\n"
		"| You can specify these additional UDP/RTP-specific arguments:\n"
		"|\n"
		"|   dp  = <1-65535> .... use this UDP destination port instead of 30,000.\n"		
		"|   sp  = <1-65535> .... use this UDP source port instead of random.\n"
		"|   pld = <1..1000> .... create specified payload size (default=160 bytes, which results\n"
		"|                        in a total datagram length of 180 bytes, considering the UDP and"
		"|                        RTP header lengths (8 and 12 bytes, respectively).\n"
		"|\n"
		"|\n"
		);
	exit(0);
     }
   
   
   if (getarg(tx.arg_string,"pld", argval)==1)
     {
	rtp_payload_size = (unsigned int) str2int(argval);
     }

   
   // TODO: Optional arguments for RTP
   
   
   // Create header:
   // 
   // 1st byte: 
   // 
   // +--+--+--+--+--+--+--+--+
   // | ver | P| X| CSRC Count|
   // +--+--+--+--+--+--+--+--+
   // 
   // Default: ver=2, Padding=0, Extension_Header=0, CSRC_Count=0 => 10 0 0 0000 = 0x80

   byte1 = 0x80;
   
   // 2nd byte:
   // 
   // +--+--+--+--+--+--+--+--+
   // | M|    Payload Type    |
   // +--+--+--+--+--+--+--+--+
   // 
   // Marker=0, Payload Type=0 (or 8 alternatively)

   byte2 = 0x00;
   
   // 3rd and 4th byte:
   // 
   // +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
   // |               Sequence Number                 |
   // +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+

   seqnr = 0x0000;
   
   /////////////////////////////////////////////////////////////////////////
   // next 4 bytes: Timestamp (!!! this has index 4,5,6,7 in a C array !!!)
   
   /* see below */
   /////////////////////////////////////////////////////////////////////////
   
   
   // next 4 bytes: Synchronization Source Identifier

   ssrc = 0xcafefeed;
   
   // next 4 bytes: Contributing Source Identifiers (optional, only used by mixers)

/*   csrc = 0x00000000; */
   
   // next 4 bytes: Header Extension (optional) NOT USED HERE!

   // !!! Thus payload begins with index 16 in a C array !!!

   // ------------ Now combine all fields: ----------------
   tx.udp_payload[0] = byte1;
   tx.udp_payload[1] = byte2;
   
   ptr = (u_int8_t*) &seqnr;
   tx.udp_payload[2] = *(ptr+1);
   tx.udp_payload[3] = *ptr;
   
   // TIMESTAMP: will be linearly increased, e.g. using 20msec G.711: 0, 160, 320, ...
   tx.udp_payload[4] = 0x00;
   tx.udp_payload[5] = 0x00;
   tx.udp_payload[6] = 0x00;
   tx.udp_payload[7] = 0x00;

   ptr = (u_int8_t*) &ssrc;
   tx.udp_payload[8] = *(ptr+3);
   tx.udp_payload[9] = *(ptr+2);
   tx.udp_payload[10] = *(ptr+1);
   tx.udp_payload[11] = *ptr;
   
   /*
   ptr = (u_int8_t*) &csrc;
   tx.udp_payload[12] = *(ptr+3);
   tx.udp_payload[13] = *(ptr+2);
   tx.udp_payload[14] = *(ptr+1);
   tx.udp_payload[15] = *ptr;
   */
   
   // Now set the 4 bytes sec and 4 bytes usec timestamp as the first payload bytes
   getcurtime(&tv);
   ptr = (u_int8_t*) &tv.tv_sec;
   tx.udp_payload[12] = *(ptr+3);
   tx.udp_payload[13] = *(ptr+2);
   tx.udp_payload[14] = *(ptr+1);
   tx.udp_payload[15] = *ptr;

   ptr = (u_int8_t*) &tv.tv_usec;
   tx.udp_payload[16] = *(ptr+3);
   tx.udp_payload[17] = *(ptr+2);
   tx.udp_payload[18] = *(ptr+1);
   tx.udp_payload[19] = *ptr;

   
   memset(&tx.udp_payload[20], 0x00, (rtp_payload_size-8)); // payload (considering our 8 byte timestamp)
   tx.udp_payload_s = 12 + rtp_payload_size; // the latter ist the payload size
   
   // ---------- now hand over to UDP -----------------

   tx.dp = 30000;
   tx.sp = 30000;
     
   tx.udp_len = 8 + tx.udp_payload_s;
   
   return 0;
}





