<?php
/**
 * $Horde: nag/list.php,v 1.28.2.9 2005/01/03 11:26:00 jan Exp $
 *
 * Copyright 2001-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';
require_once NAG_BASE . '/config/html.php';

/* Get the current action ID. */
$actionID = Horde::getFormData('actionID');

/* Sort out the sorting values. */
if (Horde::getFormData('sortby') !== null) {
    $prefs->setValue('sortby', Horde::getFormData('sortby'));
}
if (Horde::getFormData('sortdir') !== null) {
   $prefs->setValue('sortdir', Horde::getFormData('sortdir'));
}

/* Create a Nag storage instance. */
$storage = &Nag_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                $conf['storage']['params']);
$storage->retrieve();

/* Get the full, sorted task list. */
$tasks = Nag::listTasks($storage, $prefs->getValue('sortby'),
                        $prefs->getValue('sortdir'));

/* Page variables. */
$i = 0;
$title = _("Task List");
$js_onLoad = null;

switch ($actionID) {
 case NAG_DELETE_TASKS:
     $items = Horde::getFormData('items');
     if (isset($items) && (count($items) > 0)) {
         foreach ($items as $task_id) {
             if (isset($tasks[$task_id])) {
                 $storage->deleteTask($task_id);
                 unset($tasks[$task_id]);
             }
         }

         if (!PEAR::isError($storage->store())) {
             if (count($items) == 1) {
                 $message = _("Deleted 1 task.");
             } elseif (count($items) > 1) {
                 $message = sprintf(_("Deleted %d tasks."), count($items));
             } else {
                 $message = _("No tasks were deleted.");
             }
             $notification->push($message, 'horde.success');
         } else {
             $notification->push(_("There was a problem deleting tasks."), 'horde.error');
         }
     }
     break;

 case NAG_COMPLETE_TASKS:
     $items = Horde::getFormData('items');
     if (isset($items) && (count($items) > 0)) {
         foreach ($items as $task_id) {
             if (isset($tasks[$task_id])) {
                 $storage->modifyTask($task_id, 'completed', 1);
                 if (!$prefs->getValue('show_completed')) {
                     unset($tasks[$task_id]);
                 } else {
                     $tasks[$task_id]['completed'] = 1;
                 }
             }
         }

         if (!PEAR::isError($storage->store())) {
             if (count($items) == 1) {
                 $message = _("Marked 1 task as completed.");
             } elseif (count($items) > 1) {
                 $message = sprintf(_("Marked %d tasks as completed."), count($items));
             } else {
                 $message = _("No tasks were changed.");
             }
             $notification->push($message, 'horde.success');
         } else {
             $notification->push(_("There was a problem setting task completion status."), 'horde.error');
         }
     }
     break;

 case NAG_SET_PRIORITY:
     $items = Horde::getFormData('items');
     $priority = intval(Horde::getFormData('priority'));
     if (isset($items) && (count($items) > 0) && ($priority >= 1 || $priority <= 5)) {
         foreach ($items as $task_id) {
             if (isset($tasks[$task_id])) {
                 $storage->modifyTask($task_id, 'priority', $priority);
                 $tasks[$task_id]['priority'] = $priority;
             }
         }

         if (!PEAR::isError($storage->store())) {
             if (count($items) == 1) {
                 $message = sprintf(_("Changed 1 task to priority %d."), $priority);
             } elseif (count($items) > 1) {
                 $message = sprintf(_("Changed %d tasks to priority %d."), count($items), $priority);
             } else {
                 $message = _("No tasks were changed.");
             }
             $notification->push($message, 'horde.success');
         } else {
             $notification->push(_("There was a problem setting task priority."), 'horde.error');
         }
     }
     break;

 case NAG_SEARCH_TASKS:
     /* If we're searching, only list those tasks that match the
        search result. */
     /* Get the search parameters. */
     $pattern = Horde::getFormData('search_pattern');
     $search_name = (Horde::getFormData('search_name') == 'on');
     $search_desc = (Horde::getFormData('search_desc') == 'on');

     if (!empty($pattern) && ($search_name || $search_desc)) {
         $search_results = array();
         foreach ($tasks as $task_id => $task) {
             if (($search_name && preg_match("/$pattern/i", $task['name'])) ||
                 ($search_desc && preg_match("/$pattern/i", $task['desc']))) {
                 $search_results[$task_id] = $task;
             }
         }

         /* Reassign $tasks to the search result. */
         $tasks = $search_results;
         $title = _("Search Results");
     }
     break;
}

require NAG_TEMPLATES . '/common-header.inc';
require NAG_BASE . '/menu.php';
$notification->notify();
require NAG_TEMPLATES . '/list/javascript.inc';
require NAG_TEMPLATES . '/list/header.inc';
require NAG_TEMPLATES . '/list/actions.inc';

if (count($tasks) > 0) {
    include NAG_TEMPLATES . '/list/task_headers.inc';

    foreach ($tasks as $task_id => $task) {
        if (!empty($task['completed'])) {
            $style = 'closed';
        } else {
            $style = 'text' . $task['priority'];
        }
        include NAG_TEMPLATES . '/list/task_summaries.inc';
    }

    include NAG_TEMPLATES . '/list/task_footers.inc';
    include NAG_TEMPLATES . '/list/actions.inc';
} else {
    include NAG_TEMPLATES . '/list/empty.inc';
}

require NAG_TEMPLATES . '/list/footer.inc';
require NAG_TEMPLATES . '/common-footer.inc';

$prefs->store();
