<?php

$block_name = _("Tasks Summary");

/**
 * $Horde: nag/lib/Block/summary.php,v 1.51.8.2 2005/01/25 22:21:00 jan Exp $
 *
 * @package Horde_Block
 */
class Horde_Block_nag_summary extends Horde_Block {

    var $_app = 'nag';

    function _title()
    {
        global $registry;
        $html  = Horde::link(Horde::applicationUrl($registry->getInitialPage(), true), $registry->get('name'), 'header') . $registry->get('name') . '</a> :: ';
        $html .= Horde::link(Util::addParameter(Horde::applicationUrl('task.php', true), 'actionID', 'add_task'), _("New Task"), 'smallheader') . Horde::img('nag.png', _("New Task"), 'align="middle"', Horde::url($registry->getImageDir(), true, -1)) . ' ' . _("New Task") . '</a>';

        return $html;
    }

    function _params()
    {
        require_once dirname(__FILE__) . '/../base.php';
        require_once 'Horde/Prefs/CategoryManager.php';
        $cManager = &new Prefs_CategoryManager();
        $categories = array();
        foreach ($cManager->get() as $c) {
            $categories[$c] = $c;
        }
        $categories['unfiled'] = _("Unfiled");

        return array('show_pri' => array('type' => 'checkbox',
                                         'name' => _("Show priorities?"),
                                         'default' => 1),
                     'show_actions' => array('type' => 'checkbox',
                                             'name' => _("Show action buttons?"),
                                             'default' => 1),
                     'show_due' => array('type' => 'checkbox',
                                         'name' => _("Show due dates?"),
                                         'default' => 1),
                     'show_tasklist' => array('type' => 'checkbox',
                                              'name' => _("Show tasklist name?"),
                                              'default' => 1),
                     'show_alarms' => array('type' => 'checkbox',
                                            'name' => _("Show task alarms?"),
                                            'default' => 1),
                     'show_category' => array('type' => 'checkbox',
                                              'name' => _("Show task category?"),
                                              'default' => 1),
                     'show_overdue' => array('type' => 'checkbox',
                                             'name' => _("Always show overdue tasks?"),
                                             'default' => 1),
                     'show_completed' => array('type' => 'checkbox',
                                              'name' => _("Always show completed tasks?"),
                                              'default' => 1),
                     'show_categories' => array('type' => 'multienum',
                                                'name' => _("Show tasks from these categories"),
                                                'default' => array(),
                                                'values' => $categories)
               );
    }

    function _content()
    {
        global $registry, $prefs;
        require_once dirname(__FILE__) . '/../base.php';

        $now = time();

        $html = '';

        if (!empty($this->_params['show_alarms'])) {
            $messages = array();
            $alarmList = Nag::listAlarms($now);
            if (is_a($alarmList, 'PEAR_Error')) {
                return $alarmList->getMessage();
            }
            foreach ($alarmList as $task) {
                $differential = $task['due'] - $now;
                $key = $differential;
                while (isset($messages[$key])) {
                    $key++;
                }
                $viewurl = Util::addParameter('view.php', 'task', $task['task_id']);
                $viewurl = Util::addParameter($viewurl, 'tasklist', $task['tasklist_id']);
                $link = Horde::link(htmlspecialchars(Horde::applicationUrl($viewurl, true)), $task['name']);
                $link .= (!empty($task['name']) ? htmlspecialchars($task['name']) : _("[none]")) . '</a>';
                if ($differential >= -60 && $differential < 60) {
                    $messages[$key] = sprintf(_("%s is due now."), $link);
                } elseif ($differential >= 60) {
                    $messages[$key] = sprintf(_("%s is due in %s"), $link, Nag::secondsToString($differential));
                }
            }

            ksort($messages);
            foreach ($messages as $message) {
                $html .= '<tr><td class="control">' . Horde::img('alarm_small.png') . '&nbsp;&nbsp;<b>' . $message . '</b></td></tr>';
            }

            if (!empty($messages)) {
                $html .= '</table><br><table border="0" cellpadding="0" cellspacing="0" width="100%">';
            }
        }

        $i = 0;
        $tasks = Nag::listTasks();
        foreach ($tasks as $id => $task) {
            // Only print tasks due in the past if the show_overdue
            // flag is on. Only display selected categories (possibly
            // unfiled).
            if (($task['due'] > 0 &&
                 $now > $task['due'] &&
                 empty($this->_params['show_overdue'])) ||
                (!empty($this->_params['show_categories']) &&
                 (!in_array($task['category'], $this->_params['show_categories']) && 
                  !(empty($task['category']) && 
                    in_array('unfiled', $this->_params['show_categories']))))) {
                continue;
            }

            // Only display completed tasks if the show_completed
            // parameter is on.
            if ($task['completed'] && empty($this->_params['show_completed'])) {
                continue;
            }

            $tstyle = '';
            if (!empty($task['completed'])) {
                $style = 'closed';
                $tstyle = 'linethrough';
            } elseif (!empty($task['due']) && $task['due'] < time()) {
                $style = 'overdue';
                $tstyle = 'overdue-link';
            } else {
                $style = 'text';
            }

            $html .= '<tr class="' . $style . '">';

            if (!empty($this->_params['show_actions'])) {
                $taskurl = Util::addParameter('task.php', 'task', $task['task_id']);
                $taskurl = Util::addParameter($taskurl, 'tasklist', $task['tasklist_id']);
                $taskurl = Util::addParameter($taskurl, 'url', Horde::selfURL(true));
                $html .= '<td width="1%">' . Horde::link(Horde::applicationUrl(Util::addParameter($taskurl, 'actionID', 'modify_task')), _("Edit Task"), 'widget') . Horde::img('edit.png', _("Edit Task"), null, $registry->getImageDir('horde')) . '</a></td>';
                if ($task['completed']) {
                    $html .= '<td width="1%">' . Horde::img('checked.png', _("Completed"), 'hspace="2"') . '</td>';
                } else {
                    $html .= '<td width="1%">' . Horde::link(Horde::applicationUrl(Util::addParameter($taskurl, 'actionID', 'complete_task')), _("Complete Task"), 'widget') . Horde::img('unchecked.png', _("Complete Task"), 'hspace="2"') . '</a></td>';
                }
            }

            if (!empty($this->_params['show_pri'])) {
                $html .= '<td align="center" nowrap="nowrap">&nbsp;' . Nag::formatPriority($task['priority']) . '&nbsp;</td>';
            }

            if (!empty($this->_params['show_tasklist'])) {
                $owner = $task['tasklist_id'];
                $shares = &Horde_Share::singleton($registry->getApp());
                $share = $shares->getShare($owner);
                if (!is_a($share, 'PEAR_Error')) {
                    $owner = $share->get('name');
                }
                $html .= '<td width="1%" class="' . $tstyle . '">&nbsp;' . $owner . '&nbsp;</td>';
            }

            $html .= '<td>';

            $viewurl = Util::addParameter('view.php', 'task', $task['task_id']);
            $viewurl = Util::addParameter($viewurl, 'tasklist', $task['tasklist_id']);
            $html .= Horde::link(htmlspecialchars(Horde::applicationUrl($viewurl, true)), $task['name'], $tstyle);
            $html .= (!empty($task['name']) ? htmlspecialchars($task['name']) : _("[none]")) . '</a>';

            if ($task['due'] > 0 && empty($task['completed']) && !empty($this->_params['show_due'])) {
                $html .= ' (' . strftime($prefs->getValue('date_format'), $task['due']) . ')';
            }

            $html .= "</td>";

            if (!empty($this->_params['show_category'])) {
                $html .= '<td width="1%" nowrap="nowrap" class="' . $tstyle . '">&nbsp;'
                    . htmlspecialchars($task['category'] ? $task['category'] : _("Unfiled"))
                    . '&nbsp;</td>';
            }
            $html .= "</tr>\n";
        }

        if (empty($html)) {
            return '<span style="font-style:italic;">' . _("No tasks to display") . '</span>';
        } else {
            return '<table border="0" cellpadding="0" cellspacing="1" width="100%" class="item">' . $html . '</table>';
        }
    }

}
