# NanoBlogger Article Manager plugin

# How it works:
#	Looks for .txt files in multiple directories.
#	Reads 1st line as title (MKPAGE_TITLE).
# 	Reads everything after 1st line as content (NB_Entries).
#	Creates the article using the makepage.htm template.
#	Adds links to NB_ArticleLinks.

# sample code for templates, based off the default stylesheet
#
# <div class="side">
# $NB_Article_Links
# </div>

# space seperated list of sub-directories inside $BLOG_DIR, where articles are located
# e.g. ARTICLE_DIRS="articles stories poems"
set_articleconf(){
: ${ARTICLE_DIRS:=articles}
: ${ARTICLE_SUFFIX:=txt}
: ${ARTICLE_TEMPLATE:=$NB_TEMPLATE_DIR/$MAKEPAGE_TEMPLATE}
}

# reset basic configs to allow for multiple article configs
reset_articleconf(){
ARTICLE_SUFFIX=; ARTICLE_TEMPLATE=
set_articleconf
}

ARTICLE_PLUGIN_OUTFILE="$BLOG_DIR/$PARTS_DIR/article_links.$NB_FILETYPE"
#set_baseurl "../"

set_articlelink(){
	articlelink_var="$1"
	article_title=`sed 1q "$BLOG_DIR/$ARTICLE_DIR/$articlelink_var"`

	# new way
	article_name=`echo "$articlelink_var" |cut -d"." -f 1`
	article_dir=`set_title2link "$article_name"`
	article_file="$article_dir/index.$NB_FILETYPE"
	article_link="$article_dir/$NB_INDEX"

	# old way
	#article_file=`chg_suffix "$articlelink_var"`
	#article_link="$article_file"
}

addalist_name(){
	NB_ArticleListName=
	# try getting alternate title from .list text file, should be on 1st line
	[ -f "$BLOG_DIR/$ARTICLE_DIR/.article_list.txt" ] &&
		NB_ArticleListName=`sed 1q $BLOG_DIR/$ARTICLE_DIR/.article_list.txt`
	[ -z "$NB_ArticleListName" ] && NB_ArticleListName="$ARTICLE_DIR"
	cat >> "$ARTICLE_PLUGIN_OUTFILE" <<-EOF
		<div class="sidetitle">
			$NB_ArticleListName
		</div>
	EOF
	}

add_articlelink(){
	echo '<a href="'${BASE_URL}$ARTICLE_DIR/$article_link'">'$MKPAGE_TITLE'</a><br />' >> "$ARTICLE_PLUGIN_OUTFILE"
	}

create_article(){
	MKPAGE_SRCFILE="$BLOG_DIR/$ARTICLE_DIR/$article_srcfile"
	MKPAGE_OUTFILE="$BLOG_DIR/$ARTICLE_DIR/$article_file"
	[ "$USR_QUERY" = articles ] || [ "$USR_QUERY" = all ] && rm -f "$MKPAGE_OUTFILE"
	if [ "$MKPAGE_SRCFILE" -nt "$MKPAGE_OUTFILE" ]; then
		NB_Entries=`sed 1d "$BLOG_DIR/$ARTICLE_DIR/$article_srcfile"`
		# modify page content used by make_page function
		MKPAGE_CONTENT="$NB_Entries"
		make_page "$BLOG_DIR/$ARTICLE_DIR/$article_srcfile" "$ARTICLE_TEMPLATE" "$MKPAGE_OUTFILE"
	fi
	}

cycle_articles_for(){
	build_part="$1"
	build_list=`cd "$BLOG_DIR/$ARTICLE_DIR"; for articles in *.$ARTICLE_SUFFIX; do echo "$articles"; done`
	[ "$build_list" = "*.$ARTICLE_SUFFIX" ] && build_list=
	article_lines=`echo "$build_list" |grep -n "." |cut -c1-2 |sed -e '/[\:\]/ s///g'`
	for line in $article_lines ; do
		article_line=`echo "$build_list" |sed -n "$line"p`
		article_srcfile=`echo "$article_line"`
		if [ -f "$BLOG_DIR/$ARTICLE_DIR/$article_srcfile" ]; then
			set_articlelink "$article_srcfile"
			MKPAGE_TITLE="$article_title"
			"$build_part"
		fi
	done
	}

> "$ARTICLE_PLUGIN_OUTFILE"
set_articleconf
for articles_pass in 1 2; do
	for ARTICLE_DIR in $ARTICLE_DIRS; do
		if [ -d "$BLOG_DIR/$ARTICLE_DIR" ]; then
			# load articles config file
			ARTICLE_CONF="$BLOG_DIR/$ARTICLE_DIR/article.conf"
			if [ -f "$ARTICLE_CONF" ]; then
				reset_articleconf
				. "$ARTICLE_CONF"
			fi
			if [ "$articles_pass" -lt 2 ]; then
				addalist_name
				cycle_articles_for add_articlelink
				NB_ArticleLinks=$(< "$ARTICLE_PLUGIN_OUTFILE")
			else
				[ -d "$BLOG_DIR/$ARTICLE_DIR" ] && nb_msg "generating articles for $BLOG_DIR/$ARTICLE_DIR ..."
				cycle_articles_for create_article
			fi
		fi
	done
done

