--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Interfaces.C.Strings;
package body Shared_Library is

   pragma Linker_Options ("-ldl");

   function Open_Library (Library_Name : String;
                          Options : Flag_Type) return Handle_Type is
      function Dlopen (Library_Name : String;
                       Options : Flag_Type) return Handle_Type;
      pragma Import (C, Dlopen, "dlopen");
      Handle_To_Return : Handle_Type;
      use type System.Address;
   begin
      Handle_To_Return := Dlopen (Library_Name & ASCII.NUL, Options);
      if Handle_To_Return = System.Null_Address then
         raise Library_Loading_Failed;
      end if;
      return Handle_To_Return;
   end Open_Library;


   function Library_Error return String is
      function Dlerror return Interfaces.C.Strings.chars_ptr;
      pragma Import (C, Dlerror, "dlerror");
   begin
      return Interfaces.C.Strings.Value (Dlerror);
   end Library_Error;


   function Library_Symbol (Library : Handle_Type;
                            Symbol_Name : String) return Symbol_Access
   is
      function Dlsym (Library : Handle_Type;
                      Symbol_Name : String) return Symbol_Access;
      pragma Import (C, Dlsym, "dlsym");
   begin
      return Dlsym (Library, Symbol_Name & ASCII.NUL);
   end Library_Symbol;

   function Close_Library (Library : Handle_Type) return Integer is
      function Dlclose (Library : Handle_Type) return Integer;
      pragma Import (C, Dlclose, "dlclose");
   begin
      return Dlclose (Library);
   end Close_Library;
end Shared_Library;
