--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
package body Narval.Buffers is

   --------------
   -- Allocate --
   --------------

   procedure Allocate
     (Pool                     : in out Buffer_Type;
      Storage_Address          : out System.Address;
      Size_In_Storage_Elements : in System.Storage_Elements.Storage_Count;
      Alignment                : in System.Storage_Elements.Storage_Count)
   is
      pragma Unreferenced (Alignment);
   begin
      if Pool.Memory.Dumping_Event_By_Event_Mode then
         Pool.Memory.Get_Memory_For_Dumping (Size_In_Storage_Elements,
                                             Storage_Address);
      else
         Pool.Memory.Get_Memory_For_Filling (Size_In_Storage_Elements,
                                             Storage_Address,
                                             Pool.Duplicate);
      end if;
   end Allocate;

   ----------------
   -- Deallocate --
   ----------------

   procedure Deallocate
     (Pool                     : in out Buffer_Type;
      Storage_Address          : in System.Address;
      Size_In_Storage_Elements : in System.Storage_Elements.Storage_Count;
      Alignment                : in System.Storage_Elements.Storage_Count)
   is
      pragma Unreferenced (Storage_Address);
      pragma Unreferenced (Size_In_Storage_Elements);
      pragma Unreferenced (Alignment);
   begin
      Pool.Memory.Release_Memory (Pool.Duplicate);
   end Deallocate;

   -----------------
   -- Initialiser --
   -----------------

   procedure Initialise
     (Pool : in out Buffer_Type;
      Memory : Protected_Memory.Memory_Access)
   is
   begin
      Pool.Memory := Memory;
      Pool.Duplicate := False;
   end Initialise;

   procedure Set_Duplicate (Pool : in out Buffer_Type; Duplicate : Boolean) is
   begin
      Pool.Duplicate := Duplicate;
   end Set_Duplicate;

   ------------------
   -- Storage_Size --
   ------------------

   function Storage_Size
     (Pool : Buffer_Type)
      return System.Storage_Elements.Storage_Count
   is
      pragma Unreferenced (Pool);
   begin
      return 0;
   end Storage_Size;

end Narval.Buffers;

