--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Strings.Unbounded;
with Ada.Exceptions;

with Options;

with Log4ada;

with Narval.Actors;
with Narval.Narval_Naming_Registry;
with Narval.Local_Configuration;
with Narval.Configurator.Abstract_Actors_Coordination;

procedure Actor_Body (Object : Narval.Actors.Actor_Class_Access) is
   use Ada.Strings.Unbounded;
   use Narval.Actors;
   Unbounded_Actor_Name : Unbounded_String;
   use Narval.Configurator.Abstract_Actors_Coordination;
   Config : Configuration_Access;
begin
   Unbounded_Actor_Name := To_Unbounded_String
     (Options.Get_Option ("name"));
   Config := Narval.Narval_Naming_Registry.Get_Configuration
     (Options.Get_Option ("config_name"));
   Narval.Local_Configuration.Set_Configuration_Name
     (Options.Get_Option ("config_name"));
   declare
      Actor_Name : constant String := To_String (Unbounded_Actor_Name);
   begin
      Initialise (Object, Actor_Name);
      Register (Config, Actor_Name, Object);
      loop
         exit when Have_To_End (Object.all);
         delay 1.0;
      end loop;
   end;
exception
   when Options.Non_Present_Option =>
      Log_Message (Object,
                   "actor need following options --name, --config_name",
                   Log4ada.Fatal);
   when E : others =>
      Log_Message (Object,
                   "unhandled exception named : " &
                   Ada.Exceptions.Exception_Name (E) &
                   ", message : """ & Ada.Exceptions.Exception_Message (E) &
                   """",
                   Log4ada.Fatal);
end Actor_Body;
