--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Unchecked_Deallocation;
with Narval.Buffers;

package body Narval.Actors.Actives.Producers.Data_Rate is

   -----------------
   -- Initialiser --
   -----------------

   procedure Initialise (Object : access Data_Rate_Producer_Type;
                         Actor_Name : String) is
   begin
      Producers.Initialise (Producer_Access (Object), Actor_Name);
      Object.Waiting_Delay := 0.1;
   end Initialise;

   ----------------------------
   -- Travail_En_Acquisition --
   ----------------------------

   procedure Buffer_Handling
     (Object : access Data_Rate_Producer_Type) is
      type Integer_Array is array (1 .. 10000) of Integer;
   begin
      for I in Object.Outputs'Range loop
         declare
            Buffer : Buffers.Buffer_Type;
         begin
            Buffers.Initialise (Buffer, Object.Outputs (I).Memory);
            if Object.Duplicate then
               Buffers.Set_Duplicate (Buffer, True);
            else
               Buffers.Set_Duplicate (Buffer, False);
            end if;
            declare
               type Integer_Array_Access is access Integer_Array;
               for Integer_Array_Access'Storage_Pool use Buffer;
               procedure Flush is new Ada.Unchecked_Deallocation
                 (Integer_Array,
                  Integer_Array_Access);
               An_Integer_Array : Integer_Array_Access;
            begin
               An_Integer_Array := new Integer_Array;
               An_Integer_Array (1) := 1;
               Flush (An_Integer_Array);
            end;
         end;
      end loop;
   exception
      when E : others =>
         Log4ada.Loggers.Fatal_Out (Object.Logger'Access,
                                    "Travail_En_Acquisition", E);
   end Buffer_Handling;

end Narval.Actors.Actives.Producers.Data_Rate;

