--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
package Narval.Actors.Actives.Stand_Alone_Actors.Example is

   type Stand_Alone_Actor_Exemple_Type is
     new Stand_Alone_Actor_Type with private;

   procedure Initialise (Object : access Stand_Alone_Actor_Exemple_Type;
                         Actor_Name : String);

private

   task type Task_Test_Type
     (Wrapper : access Stand_Alone_Actor_Exemple_Type) is
      entry Start;
      entry Stop;
   end Task_Test_Type;

   type Stand_Alone_Actor_Exemple_Type is
     new Stand_Alone_Actor_Type with record
        Port : Positive;
        Task_Test : Task_Test_Type (Stand_Alone_Actor_Exemple_Type'Access);
   end record;

   procedure Buffer_Handling
     (Object : access Stand_Alone_Actor_Exemple_Type);
   procedure Parameter_Changed (Object : access Stand_Alone_Actor_Exemple_Type;
                                Parameter : Parameters.Parameter_Access);
end Narval.Actors.Actives.Stand_Alone_Actors.Example;
