--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------

--  wsdl2aws SOAP Generator v2.0
--
--  AWS 2.2.0 - SOAP 1.4.0
--  This file was generated on Wednesday 06 February 2008 at 10:05:06
--
--  $ wsdl2aws -spec narval_aws_interface -f
--  -main aws_interface_main -cb narval_aws.wsdl

pragma Warnings (Off);

with Ada.Exceptions;

with SOAP.Client;
pragma Elaborate_All (SOAP.Client);
with SOAP.Message.Payload;
pragma Elaborate_All (SOAP);
pragma Elaborate_All (SOAP.Message);
pragma Elaborate_All (SOAP.Message.Payload);
with SOAP.Message.Response;
pragma Elaborate_All (SOAP.Message.Response);
with SOAP.Name_Space;
pragma Elaborate_All (SOAP.Name_Space);
with SOAP.Parameters;
pragma Elaborate_All (SOAP.Parameters);
with SOAP.Utils;
pragma Elaborate_All (SOAP.Utils);

package body narval_aws_Service.Client is

   use SOAP.Types;
   use type SOAP.Parameters.List;

   pragma Style_Checks (Off);

   ------------------
   -- Send_Command --
   ------------------

   function Send_Command
     (Command  : in String;
      Endpoint : in String := narval_aws_Service.URL)
      return String
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +SOAP.Types.S (Command, "Command");
      Payload := SOAP.Message.Payload.Build
        ("Send_Command", P_Set,
         SOAP.Name_Space.Create ("tns", "http://soapaws/narval_aws_def/"));

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                (Endpoint, Payload, "Send_Command");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant String
                 := SOAP.Parameters.Get (R_Param, "Result");
            begin
               return Result;
            end;
         end if;
      end;
   end Send_Command;

   ---------------------------------
   -- Send_Command_With_Arguments --
   ---------------------------------

   function Send_Command_With_Arguments
     (Command   : in String;
      Arguments : in String_Array_Type;
      Endpoint  : in String := narval_aws_Service.URL)
      return String
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +SOAP.Types.S (Command, "Command")
         & A (To_Object_Set (Arguments), "Arguments");
      Payload := SOAP.Message.Payload.Build
        ("Send_Command_With_Arguments", P_Set,
         SOAP.Name_Space.Create ("tns", "http://soapaws/narval_aws_def/"));

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                (Endpoint, Payload, "Send_Command_With_Arguments");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant String
                 := SOAP.Parameters.Get (R_Param, "Result");
            begin
               return Result;
            end;
         end if;
      end;
   end Send_Command_With_Arguments;

end narval_aws_Service.Client;
