/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2011 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

#define _XOPEN_SOURCE 700

#include "internal.h"

#include <pthread.h>

struct _nacore_mutex
  {
	pthread_mutex_t mutex;
  };

_NACORE_DEF nacore_mutex
nacore_mutex_new()
{
	pthread_mutexattr_t attr;
	nacore_mutex ret;
	int err;

	ret = malloc(sizeof(struct _nacore_mutex));
	if (ret == NULL)
	  {
		errno = ENOMEM;
		return NULL;
	  }

	if (pthread_mutexattr_init(&attr) != 0)
	  {
		free(ret);
		errno = ENOMEM;
		return NULL;
	  }

	pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_ERRORCHECK);
	err = pthread_mutex_init(&ret->mutex, &attr);
	pthread_mutexattr_destroy(&attr);
	if (err != 0)
	  {
		free(ret);
		errno = err;
		return NULL;
	  }

	return ret;
}

_NACORE_DEF void
nacore_mutex_free(nacore_mutex mutex)
{
	pthread_mutex_destroy(&mutex->mutex);

	free(mutex);
}

_NACORE_DEF int
nacore_mutex_lock(nacore_mutex mutex)
{
	return pthread_mutex_lock(&mutex->mutex);
}

_NACORE_DEF int
nacore_mutex_trylock(nacore_mutex mutex)
{
	return pthread_mutex_trylock(&mutex->mutex);
}

_NACORE_DEF void
nacore_mutex_unlock(nacore_mutex mutex)
{
	pthread_mutex_unlock(&mutex->mutex);
}
