/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2011 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

#include "internal.h"

#include <windows.h>

_NACORE_DEF nacore_dl_handle
nacore_dl_open(const char *filename, nacore_msg_context msg_context,
	       void *msg_data)
{
	HMODULE ret;
	char *filenamew;

	filenamew = nacore_string_utf8_to_utf16le(filename);
	if (filenamew == NULL)
		return NULL;

	ret = LoadLibraryW((LPCWSTR)filenamew);
	free(filenamew);
	if (ret == NULL)
	  {
		/* TODO: add formatted error message */
		nacore_msg_text(msg_context, nacore_msg_severity_err, msg_data,
				"Could not load the dynamic library");
	  }

	return (nacore_dl_handle)ret;
}

_NACORE_DEF void *
nacore_dl_sym(nacore_dl_handle handle, const char *symbol,
	      nacore_msg_context msg_context, void *msg_data)
{
	FARPROC ret;

	ret = GetProcAddress((HMODULE)handle, symbol);
	if (ret == NULL)
	  {
		/* TODO: add formatted error message */
		nacore_msg_text(msg_context, nacore_msg_severity_err, msg_data,
				"Could not resolve symbol `%s'", symbol);
		errno = NACORE_EUNKNOWN;
	  }

	return (void *)((NACORE_LIBC_SIZE_FORMAT_TYPE)ret);
}

_NACORE_DEF int
nacore_dl_close(nacore_dl_handle handle, nacore_msg_context msg_context,
		void *msg_data)
{
	if (FreeLibrary((HMODULE)handle) != 0)
	  {
		/* TODO: add formatted error message */
		nacore_msg_text(msg_context, nacore_msg_severity_err, msg_data,
				"Could not unload the dynamic library");
		return NACORE_EUNKNOWN;
	  }

	return 0;
}
