/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2011 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

#include "internal.h"

#define _WIN32_WINNT 0x0400
#include <windows.h>

struct _nacore_mutex
  {
	CRITICAL_SECTION cs;
	char locked;
	DWORD owner;
  };

_NACORE_DEF nacore_mutex
nacore_mutex_new()
{
	nacore_mutex ret;

	ret = malloc(sizeof(struct _nacore_mutex));
	if (ret == NULL)
	  {
		errno = ENOMEM;
		return NULL;
	  }

	InitializeCriticalSection(&ret->cs);
	ret->locked = 0;

	return ret;
}

_NACORE_DEF void
nacore_mutex_free(nacore_mutex mutex)
{
	DeleteCriticalSection(&mutex->cs);

	free(mutex);
}

_NACORE_DEF int
nacore_mutex_lock(nacore_mutex mutex)
{
	DWORD tid;

	tid = GetCurrentThreadId();

	if (TryEnterCriticalSection(&mutex->cs) == 0)
	  {
		EnterCriticalSection(&mutex->cs);

		mutex->locked = 1;
		mutex->owner = tid;

		return 0;
	  }

	if ((mutex->locked != 0) && (mutex->owner == tid))
	  {
		LeaveCriticalSection(&mutex->cs);
		return EDEADLK;
	  }

	mutex->locked = 1;
	mutex->owner = tid;

	return 0;
}

_NACORE_DEF int
nacore_mutex_trylock(nacore_mutex mutex)
{
	DWORD tid;

	tid = GetCurrentThreadId();

	if (TryEnterCriticalSection(&mutex->cs) == 0)
		return EBUSY;

	if ((mutex->locked != 0) && (mutex->owner == tid))
	  {
		LeaveCriticalSection(&mutex->cs);
		return EBUSY;
	  }

	mutex->locked = 1;
	mutex->owner = tid;

	return 0;
}

_NACORE_DEF void
nacore_mutex_unlock(nacore_mutex mutex)
{
	mutex->locked = 0;

	LeaveCriticalSection(&mutex->cs);
}
