#!/usr/bin/env python
#Nautilus Clam scanner - https://launchpad.net/nautilus-clamscan
#Installer
#(c) Clement Lorteau <northern_lights@users.sourceforge.net>
#
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys

#check modules
try:
   import pyclamav
   import urllib
   import pygtk
   pygtk.require("2.0")
   import gtk
   import pango
   import os
except:
   print "nautilus-clamscan requires the following python modules:"
   print "\t- nautilus"
   print "\t- pyclamav"
   print "\t- pango"
   print "\t- pygtk > 2.0"
   print "One or more of these modules were not found. Aborting."
   sys.exit(1)

#check root
import os
if os.getuid():
   ret = raw_input("You are not root! Install nautilus-clamscan only for the current user? (yes/no) [no]")
   if not ret == "yes":
      print "Aborting."
      sys.exit(2)
   else:
      print "Installing nautilus-clamscan only for the current user..."
else:
   print "Installing nautilus-clamscan..."

#install
import shutil
if os.getuid(): #local user install
   dir = os.path.expanduser("~/.nautilus/python-extensions")
else: #system-wide install
   dir = "/usr/lib/nautilus/extensions-2.0/python"
if not os.path.exists(dir):
   os.mkdir(dir)
shutil.copy("nautilus-clamscan.py",dir)
print "Done. Re-start nautilus for the changes to take effect."

