/* $Id: BioSource.hpp 371868 2012-08-13 15:10:25Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'seqfeat.asn'.
 */

#ifndef OBJECTS_SEQFEAT_BIOSOURCE_HPP
#define OBJECTS_SEQFEAT_BIOSOURCE_HPP


// generated includes
#include <objects/seqfeat/BioSource_.hpp>


// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class COrgName;

class NCBI_SEQFEAT_EXPORT CBioSource : public CBioSource_Base
{
    typedef CBioSource_Base Tparent;
public:
    // constructor
    CBioSource(void);
    // destructor
    ~CBioSource(void);

    // Get the appropriate gene code from this BioSource.
    int GetGenCode(void) const;

    // function for getting genome value from organelle name
    static CBioSource::EGenome GetGenomeByOrganelle (string organelle, NStr::ECase use_case = NStr::eCase, bool starts_with = false);

    // function for getting organelle name from genome value
    static string GetOrganelleByGenome (unsigned int genome);

    // shortcut access to selected Org-ref and OrgName methods
    bool IsSetTaxname(void) const;
    const string& GetTaxname(void) const;

    bool IsSetCommon(void) const;
    const string& GetCommon(void) const;

    bool IsSetLineage(void) const;
    const string& GetLineage(void) const;

    bool IsSetGcode(void) const;
    int GetGcode(void) const;

    bool IsSetMgcode(void) const;
    int GetMgcode(void) const;

    bool IsSetPgcode(void) const;
    int GetPgcode(void) const;

    bool IsSetDivision(void) const;
    const string& GetDivision(void) const;

    bool IsSetOrgname(void) const;
    const COrgName& GetOrgname(void) const;

    bool IsSetOrgMod(void) const;

    // for GenColl
    string GetRepliconName (void) const;
    string GetBioprojectType (void) const;
    string GetBioprojectLocation (void) const;

private:
    // Prohibit copy constructor and assignment operator
    CBioSource(const CBioSource& value);
    CBioSource& operator=(const CBioSource& value);

};



/////////////////// CBioSource inline methods

// constructor
inline
CBioSource::CBioSource(void)
{
}


/////////////////// end of CBioSource inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // OBJECTS_SEQFEAT_BIOSOURCE_HPP
/* Original file checksum: lines: 93, chars: 2400, CRC32: 29efac3b */
