/* $Id: Seq_point.hpp 371868 2012-08-13 15:10:25Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqloc.asn'.
 */

#ifndef OBJECTS_SEQLOC_SEQ_POINT_HPP
#define OBJECTS_SEQLOC_SEQ_POINT_HPP


// generated includes
#include <objects/seqloc/Seq_point_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class NCBI_SEQLOC_EXPORT CSeq_point : public CSeq_point_Base
{
    typedef CSeq_point_Base Tparent;
public:
    // constructor
    CSeq_point(void);
    CSeq_point(TId& id, TPoint point, TStrand strand = eNa_strand_unknown);

    // destructor
    ~CSeq_point(void);

    // check start or stop end of location for e_Lim fuzz
    bool IsPartialStart(ESeqLocExtremes ext) const;
    bool IsPartialStop (ESeqLocExtremes ext) const;

    // set / remove e_Lim fuzz on start or stop end
    void SetPartialStart(bool val, ESeqLocExtremes ext);
    void SetPartialStop (bool val, ESeqLocExtremes ext);

    /// check if parts of the seq-loc are missing
    bool IsTruncatedStart(ESeqLocExtremes ext) const;
    bool IsTruncatedStop (ESeqLocExtremes ext) const;

    /// set / remove e_Lim fuzz on start or stop
    /// (tl/tr - indicating removed parts of the seq-loc)
    void SetTruncatedStart(bool val, ESeqLocExtremes ext);
    void SetTruncatedStop (bool val, ESeqLocExtremes ext);

    // is location the space left (5') / right (3') of point
    bool IsLeftOf (void) const;
    bool IsRightOf(void) const;

    // set location to be the space left (5') / right (3') of position
    void SetLeftOf (bool val);
    void SetRightOf(bool val);

    // Flip the strand (e.g. plus to minus)
    void FlipStrand(void);
        
private:
    // Prohibit copy constructor and assignment operator
    CSeq_point(const CSeq_point& value);
    CSeq_point& operator=(const CSeq_point& value);

    bool x_IsMinusStrand(void) const;
};



/////////////////// CSeq_point inline methods

// constructor
inline
CSeq_point::CSeq_point(void)
{
}


inline
CSeq_point::CSeq_point(TId& id, TPoint point, TStrand strand)
{
    SetPoint(point);
    SetId(id);
    if ( strand != eNa_strand_unknown ) {
        SetStrand(strand);
    }
}


/////////////////// end of CSeq_point inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_SEQ_POINT_HPP
/* Original file checksum: lines: 90, chars: 2400, CRC32: 5b2ee1f6 */
