/* $Id: Variation.hpp 371868 2012-08-13 15:10:25Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Variation.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'variation.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Variation_.hpp


#ifndef OBJECTS_VARIATION_VARIATION_HPP
#define OBJECTS_VARIATION_VARIATION_HPP


// generated includes
#include <objects/variation/Variation_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_VARIATION_EXPORT CVariation : public CVariation_Base
{
    typedef CVariation_Base Tparent;
public:
    // constructor
    CVariation(void);
    // destructor
    ~CVariation(void);
    
    const CVariation* GetParent() const;
    CVariation* SetParent();   

    const CVariation* GetConsequenceParent() const;
    CVariation* SetConsequenceParent();   

    // Update children->parent links
    void Index();

private:
    // Prohibit copy constructor and assignment operator
    CVariation(const CVariation& value);
    CVariation& operator=(const CVariation& value);

    CVariation* m_parent; //Point to the parent variation from a variation.data.set
    CVariation* m_consequence_parent; //Point to the parent variation from variation.consequence
    
};

/////////////////// CVariation inline methods

// constructor
inline
CVariation::CVariation(void)
  : m_parent(NULL)
  , m_consequence_parent(NULL)
{
}


inline const CVariation* CVariation::GetParent() const
{
    return m_parent;
}

inline CVariation* CVariation::SetParent()
{
    return m_parent;
}


inline const CVariation* CVariation::GetConsequenceParent() const
{
    return m_consequence_parent;
}

inline CVariation* CVariation::SetConsequenceParent()
{
    return m_consequence_parent;
}


/////////////////// end of CVariation inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARIATION_VARIATION_HPP
/* Original file checksum: lines: 86, chars: 2406, CRC32: 26c1b01f */
