/* $Id: genomic_collections_cli.hpp 499302 2016-04-25 15:35:38Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file genomic_collections_cli.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'gencoll_client.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: genomic_collections_cli_.hpp


#ifndef INTERNAL_GPIPE_OBJECTS_GENOMECOLL_GENOMIC_COLLECTIONS_CLI_HPP
#define INTERNAL_GPIPE_OBJECTS_GENOMECOLL_GENOMIC_COLLECTIONS_CLI_HPP


// generated includes
#include <objects/genomecoll/genomic_collections_cli_.hpp>
#include <objects/genomecoll/GCClient_AttributeFlags.hpp>
#include <objects/genomecoll/GCClient_GetAssemblyReques.hpp>
#include <objects/genomecoll/GCClient_FindBestAssemblyR.hpp>
#include <objects/genomecoll/cached_assembly.hpp>
// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CGCClient_AssemblyInfo;
class CGCClient_AssemblySequenceInfo;
class CGCClient_EquivalentAssemblies;

/////////////////////////////////////////////////////////////////////////////
class CGenomicCollectionsService : public CGenomicCollectionsService_Base
{
public:
    CGenomicCollectionsService();


    typedef CGCClient_GetAssemblyRequest::ELevel ELevel;

    typedef EGCClient_AttributeFlags EAttributeFlags;

    /// @deprecated Use GetAssembly(const string& acc, const string& mode)
    NCBI_DEPRECATED
    CRef<CGC_Assembly> GetAssembly
        (const string& acc, 
         int level = CGCClient_GetAssemblyRequest::eLevel_scaffold,
         int asmAttrFlags = eGCClient_AttributeFlags_none, 
         int chrAttrFlags = eGCClient_AttributeFlags_biosource, 
         int scafAttrFlags = eGCClient_AttributeFlags_none, 
         int compAttrFlags = eGCClient_AttributeFlags_none);

    /// @deprecated Use GetAssembly(int releaseId,     const string& mode)
    NCBI_DEPRECATED
    CRef<CGC_Assembly> GetAssembly
        (int releaseId, 
         int level = CGCClient_GetAssemblyRequest::eLevel_scaffold,
         int asmAttrFlags = eGCClient_AttributeFlags_none, 
         int chrAttrFlags = eGCClient_AttributeFlags_biosource, 
         int scafAttrFlags = eGCClient_AttributeFlags_none, 
         int compAttrFlags = eGCClient_AttributeFlags_none);

    /// @deprecated Use GetAssembly(const string& acc, const string& mode)
    NCBI_DEPRECATED
    CRef<CGC_Assembly> GetAssembly(const string& acc, CGCClient_GetAssemblyRequest::EAssemblyMode mode);
    /// @deprecated Use GetAssembly(int releaseId,     const string& mode)
    NCBI_DEPRECATED
    CRef<CGC_Assembly> GetAssembly(int releaseId,     CGCClient_GetAssemblyRequest::EAssemblyMode mode);

    CRef<CGC_Assembly> GetAssembly(const string& acc, const string& mode);
    CRef<CGC_Assembly> GetAssembly(int releaseId,     const string& mode);

    //Some general modes
    //please contact NCBI if you have other needs
    struct SAssemblyMode
    {
        //as defined in GenomeColl_Master.dbo.CodeServiceModeAlias

        //minimal contents: Only metadata
        static string kAssemblyOnly() {return "AssemblyOnly";};

        // Top-level molecules
        // No statistics
        // No alignments data (which could be very large)
        // pseudo scaffolds are reported as unlocalized/unplaced, as needed for analysis
        static string kScaffolds()  {return "Scaffolds";};

        // Top-level molecules
        // all statistics on assembly, units and replicons
        // alignments data when available
        // pseudo scaffolds are reported as unlocalized/unplaced, as needed for analysis
        static string kScaffoldsWithAlignments()  {return "ScaffoldsWithAlignments";};

        // Almost maximum contents:
        // all sequences down to contigs
        // No statistics
        // No alignments data (which could be very large)
        // pseudo scaffolds are reported as unlocalized/unplaced, as needed for analysis
        static string kAllSequences()  {return "AllSequences";};

        // Maximum contents:
        // all sequences down to contigs
        // all statistics on assembly, units and replicons
        // alignments data when available
        // pseudo scaffolds are reported as unlocalized/unplaced, as needed for analysis
        static string kAllSequencesWithAlignments()  {return "AllSequencesWithAlignments";};
    };

    string ValidateChrType(const string& chrType, const string& chrLoc);

    CRef<CGCClient_AssemblyInfo> FindBestAssembly
        (const string& seq_id,
         int filter_type,
         int sort_type = eGCClient_FindBestAssemblySort_default);

    CRef<CGCClient_AssemblySequenceInfo> FindBestAssembly
        (const list<string>& seq_id,
         int filter_type,
         int sort_type = eGCClient_FindBestAssemblySort_default);

    CRef<CGCClient_AssembliesForSequences> FindAllAssemblies
        (const list<string>& seq_id,
         int filter_type,
         int sort_type = eGCClient_FindBestAssemblySort_default);


    CRef<CGCClient_EquivalentAssemblies> GetEquivalentAssemblies(const string& acc,
                                                                 int equivalency); // see CGCClient_GetEquivalentAssembliesRequest_::EEquivalency

private:
    // Prohibit copy constructor and assignment operator
    CGenomicCollectionsService(const CGenomicCollectionsService& value);
    CGenomicCollectionsService& operator=(const CGenomicCollectionsService& value);

};

END_objects_SCOPE
END_NCBI_SCOPE
#endif
