// ===========================================================================
//
//                            PUBLIC DOMAIN NOTICE
//            National Center for Biotechnology Information (NCBI)
//
//  This software/database is a "United States Government Work" under the
//  terms of the United States Copyright Act. It was written as part of
//  the author's official duties as a United States Government employee and
//  thus cannot be copyrighted. This software/database is freely available
//  to the public for use. The National Library of Medicine and the U.S.
//  Government do not place any restriction on its use or reproduction.
//  We would, however, appreciate having the NCBI and the author cited in
//  any work or product based on this material.
//
//  Although all reasonable efforts have been taken to ensure the accuracy
//  and reliability of the software and data, the NLM and the U.S.
//  Government do not and cannot warrant the performance or results that
//  may be obtained by using this software or data. The NLM and the U.S.
//  Government disclaim all warranties, express or implied, including
//  warranties of performance, merchantability or fitness for any particular
//  purpose.
//
// ===========================================================================
//
// File Name:  clean.go
//
// Author:  Jonathan Kans
//
// ==========================================================================

package eutils

import (
	"bufio"
	"os"
	"path/filepath"
	"strconv"
	"strings"
	"sync"
	"unicode/utf8"
)

var (
	externRunes    map[rune]string
	extRunesLoaded bool
)

// reencodes < and > to &lt and &gt
var rfix *strings.Replacer

var extraRunes = map[rune]string{
	0x05BE: "-",
	0x115F: "(?)",
	0x25AF: "(rectangle)",
	0x25CF: "(circle)",
}

var germanCapitals = map[rune]string{
	0x0028: "(",
	0x0029: ")",
	0x002D: "-",
	0x0041: "A",
	0x0042: "B",
	0x0043: "C",
	0x0044: "D",
	0x0045: "E",
	0x0046: "F",
	0x0047: "G",
	0x0048: "H",
	0x0049: "I",
	0x004A: "J",
	0x004B: "K",
	0x004C: "L",
	0x004D: "M",
	0x004E: "N",
	0x004F: "O",
	0x0050: "P",
	0x0051: "Q",
	0x0052: "R",
	0x0053: "S",
	0x0054: "T",
	0x0055: "U",
	0x0056: "V",
	0x0057: "W",
	0x0058: "X",
	0x0059: "Y",
	0x005A: "Z",
	0x00C4: "A",
	0x00D6: "O",
	0x00DC: "U",
	0x00DF: "ss",
	0x1E9E: "SS",
}

var germanRunes = map[rune]string{
	0x0028: "(",
	0x0029: ")",
	0x002D: "-",
	0x0041: "A",
	0x0042: "B",
	0x0043: "C",
	0x0044: "D",
	0x0045: "E",
	0x0046: "F",
	0x0047: "G",
	0x0048: "H",
	0x0049: "I",
	0x004A: "J",
	0x004B: "K",
	0x004C: "L",
	0x004D: "M",
	0x004E: "N",
	0x004F: "O",
	0x0050: "P",
	0x0051: "Q",
	0x0052: "R",
	0x0053: "S",
	0x0054: "T",
	0x0055: "U",
	0x0056: "V",
	0x0057: "W",
	0x0058: "X",
	0x0059: "Y",
	0x005A: "Z",
	0x0061: "a",
	0x0062: "b",
	0x0063: "c",
	0x0064: "d",
	0x0065: "e",
	0x0066: "f",
	0x0067: "g",
	0x0068: "h",
	0x0069: "i",
	0x006A: "j",
	0x006B: "k",
	0x006C: "l",
	0x006D: "m",
	0x006E: "n",
	0x006F: "o",
	0x0070: "p",
	0x0071: "q",
	0x0072: "r",
	0x0073: "s",
	0x0074: "t",
	0x0075: "u",
	0x0076: "v",
	0x0077: "w",
	0x0078: "x",
	0x0079: "y",
	0x007A: "z",
	0x00DF: "ss",
	0x00E4: "a",
	0x00F6: "o",
	0x00FC: "u",
	0x00C4: "A",
	0x00D6: "O",
	0x00DC: "U",
	0x1E9E: "SS",
}

var germanVowels = map[rune]string{
	0x0041: "A",
	0x0045: "E",
	0x0049: "I",
	0x004F: "O",
	0x0055: "U",
	0x0061: "a",
	0x0065: "e",
	0x0069: "i",
	0x006F: "o",
	0x0075: "u",
	0x00E4: "a",
	0x00F6: "o",
	0x00FC: "u",
	0x00C4: "A",
	0x00D6: "O",
	0x00DC: "U",
}

var greekRunes = map[rune]string{
	0x0190: "epsilon",
	0x025B: "epsilon",
	0x0391: "alpha",
	0x0392: "beta",
	0x0393: "gamma",
	0x0394: "delta",
	0x0395: "epsilon",
	0x0396: "zeta",
	0x0397: "eta",
	0x0398: "theta",
	0x0399: "iota",
	0x039A: "kappa",
	0x039B: "lambda",
	0x039C: "mu",
	0x039D: "nu",
	0x039E: "xi",
	0x039F: "omicron",
	0x03A0: "pi",
	0x03A1: "rho",
	0x03A3: "sigma",
	0x03A4: "tau",
	0x03A5: "upsilon",
	0x03A6: "phi",
	0x03A7: "chi",
	0x03A8: "psi",
	0x03A9: "omega",
	0x03B1: "alpha",
	0x03B2: "beta",
	0x03B3: "gamma",
	0x03B4: "delta",
	0x03B5: "epsilon",
	0x03B6: "zeta",
	0x03B7: "eta",
	0x03B8: "theta",
	0x03B9: "iota",
	0x03BA: "kappa",
	0x03BB: "lambda",
	0x03BC: "mu",
	0x03BD: "nu",
	0x03BE: "xi",
	0x03BF: "omicron",
	0x03C0: "pi",
	0x03C1: "rho",
	0x03C2: "sigma",
	0x03C3: "sigma",
	0x03C4: "tau",
	0x03C5: "upsilon",
	0x03C6: "phi",
	0x03C7: "chi",
	0x03C8: "psi",
	0x03C9: "omega",
	0x03D0: "beta",
	0x03D1: "theta",
	0x03D5: "phi",
	0x03D6: "pi",
	0x03F0: "kappa",
	0x03F1: "rho",
	0x03F5: "epsilon",
	0x1D5D: "beta",
	0x1D66: "beta",
}

var symbolRunes = map[rune]string{
	0x20A0: "ECU",
	0x20A1: "CL",
	0x20A2: "Cr",
	0x20A3: "FF",
	0x20A4: "L",
	0x20A5: "mil",
	0x20A6: "N",
	0x20A7: "Pts",
	0x20A8: "Rs",
	0x20A9: "W",
	0x20AA: "NS",
	0x20AB: "D",
	0x20AC: "EU",
	0x20AD: "K",
	0x20AE: "T",
	0x20AF: "Dr",
	0x20DB: "...",
	0x20DC: "....",
	0x2102: " (Copf) ",
	0x2103: "degrees C",
	0x2105: " (incare) ",
	0x2107: " (euler) ",
	0x2109: "degrees F",
	0x210A: " (gscr) ",
	0x210B: " (hamilt) ",
	0x210C: " (Hfr) ",
	0x210D: " (Hopf) ",
	0x210E: " (planckh) ",
	0x210F: " (planck) ",
	0x2110: " (Iscr) ",
	0x2111: " (image) ",
	0x2112: " (Lscr) ",
	0x2113: " (ell) ",
	0x2115: " (Nopf) ",
	0x2116: " (numero) ",
	0x2117: " (copysr) ",
	0x2118: " (weierp) ",
	0x2119: " (Popf) ",
	0x211A: " (Qopf) ",
	0x211B: " (Rscr) ",
	0x211C: " (real) ",
	0x211D: " (Ropf) ",
	0x211E: " (rx) ",
	0x2120: " (sm) ",
	0x2121: " (TEL) ",
	0x2122: " (trade) ",
	0x2124: " (Zopf) ",
	0x2126: " (ohm) ",
	0x2127: " (mho) ",
	0x2128: " (Zfr) ",
	0x2129: " (iiota) ",
	0x212A: " (kelvin) ",
	0x212B: "A",
	0x212C: " (bernou) ",
	0x212D: "C",
	0x212E: " (estimated) ",
	0x212F: "e",
	0x2130: "E",
	0x2131: "F",
	0x2132: "F",
	0x2133: "M",
	0x2134: "o",
	0x2135: " (alef) ",
	0x2136: " (beth) ",
	0x2137: " (gimel) ",
	0x2138: " (daleth) ",
	0x213B: " (FAX) ",
	0x2145: "D",
	0x2146: "d",
	0x2147: "e",
	0x2148: "i",
	0x2149: "j",
	0x214E: "F",
	0x2150: " (1/7) ",
	0x2151: " (1/9) ",
	0x2152: " (1/10) ",
	0x2153: " (1/3) ",
	0x2154: " (2/3) ",
	0x2155: " (1/5) ",
	0x2156: " (2/5) ",
	0x2157: " (3/5) ",
	0x2158: " (4/5) ",
	0x2159: " (1/6) ",
	0x215A: " (5/6) ",
	0x215B: " (1/8) ",
	0x215C: " (3/8) ",
	0x215D: " (5/8) ",
	0x215E: " (7/8) ",
	0x215F: " 1/",
	0x2160: " I ",
	0x2161: " II ",
	0x2162: " III ",
	0x2163: " IV ",
	0x2164: " V ",
	0x2165: " VI ",
	0x2166: " VII ",
	0x2167: " VIII ",
	0x2168: " IX ",
	0x2169: " X ",
	0x216A: " XI ",
	0x216B: " XII ",
	0x216C: " L ",
	0x216D: " C ",
	0x216E: " D ",
	0x216F: " M ",
	0x2170: " i ",
	0x2171: " ii ",
	0x2172: " iii ",
	0x2173: " iv ",
	0x2174: " v ",
	0x2175: " vi ",
	0x2176: " vii ",
	0x2177: " viii ",
	0x2178: " ix ",
	0x2179: " x ",
	0x217A: " xi ",
	0x217B: " xii ",
	0x217C: " l ",
	0x217D: " c ",
	0x217E: " d ",
	0x217F: " m ",
	0x2180: "(D",
	0x2181: "D)",
	0x2182: "((|))",
	0x2183: ")",
	0x2190: "-",
	0x2191: "|",
	0x2192: "-",
	0x2193: "|",
	0x2194: "-",
	0x2195: "|",
	0x2196: "\\",
	0x2197: "/",
	0x2198: "\\",
	0x2199: "/",
	0x219A: "-",
	0x219B: "-",
	0x219C: "~",
	0x219D: "~",
	0x219E: "-",
	0x219F: "|",
	0x21A0: "-",
	0x21A1: "|",
	0x21A2: "-",
	0x21A3: "-",
	0x21A4: "-",
	0x21A5: "|",
	0x21A6: "-",
	0x21A7: "|",
	0x21A8: "|",
	0x21A9: "-",
	0x21AA: "-",
	0x21AB: "-",
	0x21AC: "-",
	0x21AD: "-",
	0x21AE: "-",
	0x21AF: "|",
	0x21B0: "|",
	0x21B1: "|",
	0x21B2: "|",
	0x21B3: "|",
	0x21B4: "|",
	0x21B5: "|",
	0x21B6: "^",
	0x21B7: "V",
	0x21B8: "\\",
	0x21B9: "=",
	0x21BA: " (olarr) ",
	0x21BB: " (orarr) ",
	0x21BC: " (lharu) ",
	0x21BD: " (lhard) ",
	0x21BE: " (uharr) ",
	0x21BF: " (uharl) ",
	0x21C0: " (rharu) ",
	0x21C1: " (rhard) ",
	0x21C2: " (dharr) ",
	0x21C3: " (dharl) ",
	0x21C4: " (rlarr) ",
	0x21C5: " (udarr) ",
	0x21C6: " (lrarr) ",
	0x21C7: " (llarr) ",
	0x21C8: " (uuarr) ",
	0x21C9: " (rrarr) ",
	0x21CA: " (ddarr) ",
	0x21CB: " (lrhar) ",
	0x21CC: " (rlhar) ",
	0x21CD: " (nlArr) ",
	0x21CE: " (nhArr) ",
	0x21CF: " (nrArr) ",
	0x21D0: " (lArr) ",
	0x21D1: " (uArr) ",
	0x21D2: " (rArr) ",
	0x21D3: " (dArr) ",
	0x21D4: " (hArr) ",
	0x21D5: " (vArr) ",
	0x21D6: " (nwArr) ",
	0x21D7: " (neArr) ",
	0x21D8: " (seArr) ",
	0x21D9: " (swArr) ",
	0x21DA: " (lAarr) ",
	0x21DB: " (rAarr) ",
	0x21DC: " (ziglarr) ",
	0x21DD: " (zigrarr) ",
	0x21DE: "|",
	0x21DF: "|",
	0x21E0: "-",
	0x21E1: "|",
	0x21E2: "-",
	0x21E3: "|",
	0x21E4: " (larrb) ",
	0x21E5: " (rarrb) ",
	0x21E6: "-",
	0x21E7: "|",
	0x21E8: "-",
	0x21E9: "|",
	0x21EA: "|",
	0x21EB: "|",
	0x21EC: "|",
	0x21ED: "|",
	0x21EE: "|",
	0x21EF: "|",
	0x21F0: "-",
	0x21F1: "\\",
	0x21F2: "\\",
	0x21F3: "|",
	0x21FF: " (hoarr)",
	0x2200: " (forall)",
	0x2201: " (comp)) ",
	0x2202: " (part) ",
	0x2203: " (exist)) ",
	0x2204: " (nexist) ",
	0x2205: " (empty) ",
	0x2206: " (increment) ",
	0x2207: " (nabla) ",
	0x2208: " (isin) ",
	0x2209: " (notin) ",
	0x220B: " (ni)",
	0x220C: " (notni) ",
	0x220F: " (product) ",
	0x2210: " (coprod) ",
	0x2211: " (sum) ",
	0x2212: " (minus) ",
	0x2213: " (mnplus) ",
	0x2214: " (plusdo) ",
	0x2215: " (division slash) ",
	0x2216: " (setminus) ",
	0x2217: " (lowast) ",
	0x2218: " (compfn) ",
	0x2219: " (bullet) ",
	0x221A: " (radic) ",
	0x221B: " (cube root) ",
	0x221C: " (fourth root) ",
	0x221D: " (prop) ",
	0x221E: " (infin) ",
	0x221F: " (angrt) ",
	0x2220: " (ang) ",
	0x2221: " (angmsd) ",
	0x2222: " (angsph) ",
	0x2223: " (mid) ",
	0x2224: " (nmid) ",
	0x2225: " (parallel) ",
	0x2226: " (npar) ",
	0x2227: " (and) ",
	0x2228: " (or) ",
	0x2229: " (cap) ",
	0x222A: " (cup) ",
	0x222B: " (int) ",
	0x222C: " (Int) ",
	0x222D: " (iiint) ",
	0x222E: " (conint) ",
	0x222F: " (Conint) ",
	0x2230: " (Cconint) ",
	0x2231: " (cwint) ",
	0x2232: " (cwconint) ",
	0x2233: " (awconint) ",
	0x2234: " (there4) ",
	0x2235: " (because) ",
	0x2236: " : ",
	0x2237: " :: ",
	0x2238: " (minusd) ",
	0x223A: " (mDDot) ",
	0x223B: " (homth) ",
	0x223C: " (sim) ",
	0x223D: " (bsim) ",
	0x223E: " (ac) ",
	0x223F: " (acd) ",
	0x2240: " (wreath) ",
	0x2241: " (nsim) ",
	0x2242: " (esim) ",
	0x2243: " (sime) ",
	0x2244: " (nsime) ",
	0x2245: " (cong) ",
	0x2246: " (simne) ",
	0x2247: " (ncong) ",
	0x2248: " (asymp) ",
	0x2249: " (nap) ",
	0x224A: " (approxeq)",
	0x224B: " (apid) ",
	0x224C: " (bcong) ",
	0x224D: " (asympeq) ",
	0x224E: " (bump) ",
	0x224F: " (bumpe) ",
	0x2250: " (esdot) ",
	0x2251: " (eDot) ",
	0x2252: " (efDot) ",
	0x2253: " (erDot) ",
	0x2254: " (colone) ",
	0x2255: " (ecolon) ",
	0x2256: " (ecir) ",
	0x2257: " (cire) ",
	0x2259: " (wedgeq)",
	0x225A: " (veeeq) ",
	0x225B: " (star eq) ",
	0x225C: " (trie) ",
	0x225F: " (equest) ",
	0x2260: " (ne) ",
	0x2261: " (equiv) ",
	0x2262: " (nequiv) ",
	0x2264: " <= ",
	0x2265: " >= ",
	0x2266: " <= ",
	0x2267: " >= ",
	0x2268: " (lnE) ",
	0x2269: " (gnE) ",
	0x226A: " << ",
	0x226B: " >> ",
	0x226C: " (between) ",
	0x226D: " (NotCupCap) ",
	0x226E: " (nlt) ",
	0x226F: " (ngt) ",
	0x2270: " (nle) ",
	0x2271: " (nge) ",
	0x2272: " (lsim) ",
	0x2273: " (gsim) ",
	0x2274: " (nlsim) ",
	0x2275: " (ngsim) ",
	0x2276: " <> ",
	0x2277: " >< ",
	0x2278: " (ntlg) ",
	0x2279: " (ntgl) ",
	0x227A: " (pr) ",
	0x227B: " (sc) ",
	0x227C: " (prcue) ",
	0x227D: " (sccue) ",
	0x227E: " (prsim) ",
	0x227F: " (scsim) ",
	0x2280: " (npr) ",
	0x2281: " (nsc) ",
	0x2282: " (sub) ",
	0x2283: " (sup) ",
	0x2284: " (nsub) ",
	0x2285: " (nsup) ",
	0x2286: " (sube) ",
	0x2287: " (supe) ",
	0x2288: " (nsube) ",
	0x2289: " (nsupe) ",
	0x228A: " (subne) ",
	0x228B: " (supne) ",
	0x228D: " (cupdot) ",
	0x228E: " (uplus) ",
	0x228F: " (sqsub) ",
	0x2290: " (sqsup) ",
	0x2291: " (sqsube) ",
	0x2292: " (sqsupe) ",
	0x2293: " (sqcap) )",
	0x2294: " (sqcup) ",
	0x2295: " (oplus) ",
	0x2296: " (ominus) ",
	0x2297: " (ominus) ",
	0x2298: " (osol) ",
	0x2299: " (odot) ",
	0x229A: " (ocir) ",
	0x229B: " (oast) ",
	0x229D: " (odash) ",
	0x229E: " (plusb) ",
	0x229F: " (minusb) ",
	0x22A0: " (timesb) ",
	0x22A1: " (sdotb) ",
	0x22A2: " (vdash) ",
	0x22A3: " (dashv) ",
	0x22A4: " (top) ",
	0x22A5: " (perp) ",
	0x22A7: " (models) ",
	0x22A8: " (vDash) ",
	0x22A9: " (Vdash) ",
	0x22AA: " (Vvdash) ",
	0x22AB: " (VDash) ",
	0x22AC: " (nvdash) ",
	0x22AD: " (nvDash) ",
	0x22AE: " (nVdash) ",
	0x22AF: " (nVDash) ",
	0x22B0: " (prurel) ",
	0x22B2: " (vltri) ",
	0x22B3: " (vrtri) ",
	0x22B4: " (ltrie) ",
	0x22B5: " (rtrie) ",
	0x22B6: " (origof) ",
	0x22B7: " (imof) ",
	0x22B8: " (mumap) ",
	0x22B9: " (hercon) ",
	0x22BA: " (intcal) ",
	0x22BB: " (veebar) ",
	0x22BC: " (Nand) ",
	0x22BD: " (barvee) ",
	0x22BE: " (angrtvb) ",
	0x22BF: " (lrtri) ",
	0x22C0: " (xwedge) ",
	0x22C1: " (xvee) ",
	0x22C2: " (xcap) ",
	0x22C3: " (xcup) ",
	0x22C4: " (diamond) ",
	0x22C5: " (sdot) ",
	0x22C6: " (Star) ",
	0x22C7: " (divonx) ",
	0x22C8: " (bowtie) ",
	0x22C9: " (ltimes) ",
	0x22CA: " (rtimes) ",
	0x22CB: " (lthree) ",
	0x22CC: " (rthree) ",
	0x22CD: " (bsime) ",
	0x22CE: " (cuvee) ",
	0x22CF: " (cuwed) ",
	0x22D0: " (Sub) ",
	0x22D1: " (Sup) ",
	0x22D2: " (Cap) ",
	0x22D3: " (Cup) ",
	0x22D4: " (fork) ",
	0x22D5: " (epar) ",
	0x22D6: " (ltdot) ",
	0x22D7: " (gtdot) ",
	0x22D8: " <<< ",
	0x22D9: " >>> ",
	0x22DA: " <=> ",
	0x22DB: " >=< ",
	0x22DC: " =/< ",
	0x22DD: " =/> ",
	0x22DE: " (cuepr) ",
	0x22DF: " (cuesc) ",
	0x22E0: " (nprcue) ",
	0x22E1: " (nsccue) ",
	0x22E2: " (nsqsube) ",
	0x22E3: " (nsqsupe) ",
	0x22E6: " (lnsim) ",
	0x22E7: " (gnsim)",
	0x22E8: " (prnsim) ",
	0x22E9: " (scnsim) ",
	0x22EA: " (nltri) ",
	0x22EB: " (nrtri) ",
	0x22EC: " (nltrie) ",
	0x22ED: " (nrtrie) ",
	0x22EE: " (vellip) ",
	0x22EF: " (ctdot) ",
	0x22F0: " (utdot) ",
	0x22F1: " (dtdot) ",
	0x2303: " ^ ",
	0x2306: " (log dbl bar) ",
	0x2308: " (lceil) ",
	0x2309: " (rceil) ",
	0x230A: " (lfloor) ",
	0x230B: " (rfloor) ",
	0x230C: "downward right crop mark ",
	0x230D: "downward left crop mark ",
	0x230E: "upward right crop mark ",
	0x230F: "upward left crop mark ",
	0x2310: "reverse not",
	0x2312: "profile of a line",
	0x2313: "profile of a surface",
	0x2315: "telephone recorder symbol",
	0x2316: "register mark or target",
	0x231C: " upper left corner",
	0x231D: " upper right corner",
	0x231E: " downward left corner",
	0x231F: " downward right corner",
	0x2322: " down curve",
	0x2323: " up curve",
	0x2329: " < ",
	0x232A: " > ",
	0x232D: " (cylindricity) ",
	0x232E: " (aa profile) ",
	0x2336: " (I beam) ",
	0x244A: "\\\\",
	0x2460: " 1 ",
	0x2461: " 2 ",
	0x2462: " 3 ",
	0x2463: " 4 ",
	0x2464: " 5 ",
	0x2465: " 6 ",
	0x2466: " 7 ",
	0x2467: " 8 ",
	0x2468: " 9 ",
	0x2469: " 10 ",
	0x246A: " 11 ",
	0x246B: " 12 ",
	0x246C: " 13 ",
	0x246D: " 14 ",
	0x246E: " 15 ",
	0x246F: " 16 ",
	0x2470: " 17 ",
	0x2471: " 18 ",
	0x2472: " 19 ",
	0x2473: " 20 ",
	0x2474: " (1) ",
	0x2475: " (2) ",
	0x2476: " (3) ",
	0x2477: " (4) ",
	0x2478: " (5) ",
	0x2479: " (6) ",
	0x247A: " (7) ",
	0x247B: " (8) ",
	0x247C: " (9) ",
	0x247D: " (10) ",
	0x247E: " (11) ",
	0x247F: " (12) ",
	0x2480: " (13) ",
	0x2481: " (14) ",
	0x2482: " (15) ",
	0x2483: " (16) ",
	0x2484: " (17) ",
	0x2485: " (18) ",
	0x2486: " (19) ",
	0x2487: " (20) ",
	0x2488: " 1. ",
	0x2489: " 2. ",
	0x248A: " 3. ",
	0x248B: " 4. ",
	0x248C: " 5. ",
	0x248D: " 6. ",
	0x248E: " 7. ",
	0x248F: " 8. ",
	0x2490: " 9. ",
	0x2491: " 10. ",
	0x2492: " 11. ",
	0x2493: " 12. ",
	0x2494: " 13. ",
	0x2495: " 14. ",
	0x2496: " 15. ",
	0x2497: " 16. ",
	0x2498: " 17. ",
	0x2499: " 18. ",
	0x249A: " 19. ",
	0x249B: " 20. ",
	0x249C: " (a) ",
	0x249D: " (b) ",
	0x249E: " (c) ",
	0x249F: " (d) ",
	0x24A0: " (e) ",
	0x24A1: " (f) ",
	0x24A2: " (g) ",
	0x24A3: " (h) ",
	0x24A4: " (i) ",
	0x24A5: " (j) ",
	0x24A6: " (k) ",
	0x24A7: " (l) ",
	0x24A8: " (m) ",
	0x24A9: " (n) ",
	0x24AA: " (o) ",
	0x24AB: " (p) ",
	0x24AC: " (q) ",
	0x24AD: " (r) ",
	0x24AE: " (s) ",
	0x24AF: " (t) ",
	0x24B0: " (u) ",
	0x24B1: " (v) ",
	0x24B2: " (w) ",
	0x24B3: " (x) ",
	0x24B4: " (y) ",
	0x24B5: " (z) ",
	0x24B6: " A ",
	0x24B7: " B ",
	0x24B8: " C ",
	0x24B9: " D ",
	0x24BA: " E ",
	0x24BB: " F ",
	0x24BC: " G ",
	0x24BD: " H ",
	0x24BE: " I ",
	0x24BF: " J ",
	0x24C0: " K ",
	0x24C1: " L ",
	0x24C2: " M ",
	0x24C3: " N ",
	0x24C4: " O ",
	0x24C5: " P ",
	0x24C6: " Q ",
	0x24C7: " R ",
	0x24C8: " S ",
	0x24C9: " T ",
	0x24CA: " U ",
	0x24CB: " V ",
	0x24CC: " W ",
	0x24CD: " X ",
	0x24CE: " Y ",
	0x24CF: " Z ",
	0x24D0: " a ",
	0x24D1: " b ",
	0x24D2: " c ",
	0x24D3: " d ",
	0x24D4: " e ",
	0x24D5: " f ",
	0x24D6: " g ",
	0x24D7: " h ",
	0x24D8: " i ",
	0x24D9: " j ",
	0x24DA: " k ",
	0x24DB: " l ",
	0x24DC: " m ",
	0x24DD: " n ",
	0x24DE: " o ",
	0x24DF: " p ",
	0x24E0: " q ",
	0x24E1: " r ",
	0x24E2: " s ",
	0x24E3: " t ",
	0x24E4: " u ",
	0x24E5: " v ",
	0x24E6: " w ",
	0x24E7: " x ",
	0x24E8: " y ",
	0x24E9: " z ",
	0x24EA: " 0 ",
	0x24EB: " 11 ",
	0x24EC: " 12 ",
	0x24ED: " 13 ",
	0x24EE: " 14 ",
	0x24EF: " 15 ",
	0x24F0: " 16 ",
	0x24F1: " 17 ",
	0x24F2: " 18 ",
	0x24F3: " 19 ",
	0x24F4: " 20 ",
	0x24F5: " 1 ",
	0x24F6: " 2 ",
	0x24F7: " 3 ",
	0x24F8: " 4 ",
	0x24F9: " 5 ",
	0x24FA: " 6 ",
	0x24FB: " 7 ",
	0x24FC: " 8 ",
	0x24FD: " 9 ",
	0x24FE: " 10 ",
	0x24FF: " 0 ",
	0x2500: "-",
	0x2501: "-",
	0x2502: "|",
	0x2503: "|",
	0x2504: "-",
	0x2505: "-",
	0x2506: "|",
	0x2507: "|",
	0x2508: "-",
	0x2509: "-",
	0x250A: "|",
	0x250B: "|",
	0x250C: "+",
	0x250D: "+",
	0x250E: "+",
	0x250F: "+",
	0x2510: "+",
	0x2511: "+",
	0x2512: "+",
	0x2513: "+",
	0x2514: "+",
	0x2515: "+",
	0x2516: "+",
	0x2517: "+",
	0x2518: "+",
	0x2519: "+",
	0x251A: "+",
	0x251B: "+",
	0x251C: "+",
	0x251D: "+",
	0x251E: "+",
	0x251F: "+",
	0x2520: "+",
	0x2521: "+",
	0x2522: "+",
	0x2523: "+",
	0x2524: "+",
	0x2525: "+",
	0x2526: "+",
	0x2527: "+",
	0x2528: "+",
	0x2529: "+",
	0x252A: "+",
	0x252B: "+",
	0x252C: "+",
	0x252D: "+",
	0x252E: "+",
	0x252F: "+",
	0x2530: "+",
	0x2531: "+",
	0x2532: "+",
	0x2533: "+",
	0x2534: "+",
	0x2535: "+",
	0x2536: "+",
	0x2537: "+",
	0x2538: "+",
	0x2539: "+",
	0x253A: "+",
	0x253B: "+",
	0x253C: "+",
	0x253D: "+",
	0x253E: "+",
	0x253F: "+",
	0x2540: "+",
	0x2541: "+",
	0x2542: "+",
	0x2543: "+",
	0x2544: "+",
	0x2545: "+",
	0x2546: "+",
	0x2547: "+",
	0x2548: "+",
	0x2549: "+",
	0x254A: "+",
	0x254B: "+",
	0x254C: "-",
	0x254D: "-",
	0x254E: "|",
	0x254F: "|",
	0x2550: "-",
	0x2551: "|",
	0x2552: "+",
	0x2553: "+",
	0x2554: "+",
	0x2555: "+",
	0x2556: "+",
	0x2557: "+",
	0x2558: "+",
	0x2559: "+",
	0x255A: "+",
	0x255B: "+",
	0x255C: "+",
	0x255D: "+",
	0x255E: "+",
	0x255F: "+",
	0x2560: "+",
	0x2561: "+",
	0x2562: "+",
	0x2563: "+",
	0x2564: "+",
	0x2565: "+",
	0x2566: "+",
	0x2567: "+",
	0x2568: "+",
	0x2569: "+",
	0x256A: "+",
	0x256B: "+",
	0x256C: "+",
	0x256D: "+",
	0x256E: "+",
	0x256F: "+",
	0x2570: "+",
	0x2571: "/",
	0x2572: "\\",
	0x2573: "X",
	0x2574: "-",
	0x2575: "|",
	0x2576: "-",
	0x2577: "|",
	0x2578: "-",
	0x2579: "|",
	0x257A: "-",
	0x257B: "|",
	0x257C: "-",
	0x257D: "|",
	0x257E: "-",
	0x257F: "|",
	0x2580: "#",
	0x2581: "#",
	0x2582: "#",
	0x2583: "#",
	0x2584: "#",
	0x2585: "#",
	0x2586: "#",
	0x2587: "#",
	0x2588: "#",
	0x2589: "#",
	0x258A: "#",
	0x258B: "#",
	0x258C: "#",
	0x258D: "#",
	0x258E: "#",
	0x258F: "#",
	0x2590: "#",
	0x2591: "#",
	0x2592: "#",
	0x2593: "#",
	0x2594: "-",
	0x2595: "|",
	0x25A0: "#",
	0x25A1: "#",
	0x25A2: "#",
	0x25A3: "#",
	0x25A4: "#",
	0x25A5: "#",
	0x25A6: "#",
	0x25A7: "#",
	0x25A8: "#",
	0x25A9: "#",
	0x25AA: "#",
	0x25AB: "#",
	0x25AC: "#",
	0x25AD: "#",
	0x25AE: "#",
	0x25AF: "#",
	0x25B0: "#",
	0x25B1: "#",
	0x25B2: "^",
	0x25B3: "^",
	0x25B4: "^",
	0x25B5: "^",
	0x25B6: ">",
	0x25B7: ">",
	0x25B8: ">",
	0x25B9: ">",
	0x25BA: ">",
	0x25BB: ">",
	0x25BC: "V",
	0x25BD: "V",
	0x25BE: "V",
	0x25BF: "V",
	0x25C0: "<",
	0x25C1: "<",
	0x25C2: "<",
	0x25C3: "<",
	0x25C4: "<",
	0x25C5: "<",
	0x25C6: "*",
	0x25C7: "*",
	0x25C8: "*",
	0x25C9: "*",
	0x25CA: "*",
	0x25CB: "*",
	0x25CC: "*",
	0x25CD: "*",
	0x25CE: "*",
	0x25CF: "*",
	0x25D0: "*",
	0x25D1: "*",
	0x25D2: "*",
	0x25D3: "*",
	0x25D4: "*",
	0x25D5: "*",
	0x25D6: "*",
	0x25D7: "*",
	0x25D8: "*",
	0x25D9: "*",
	0x25DA: "*",
	0x25DB: "*",
	0x25DC: "*",
	0x25DD: "*",
	0x25DE: "*",
	0x25DF: "*",
	0x25E0: "*",
	0x25E1: "*",
	0x25E2: "*",
	0x25E3: "*",
	0x25E4: "*",
	0x25E5: "*",
	0x25E6: "*",
	0x25E7: "#",
	0x25E8: "#",
	0x25E9: "#",
	0x25EA: "#",
	0x25EB: "#",
	0x25EC: "^",
	0x25ED: "^",
	0x25EE: "^",
	0x25EF: "O",
	0x25F0: "#",
	0x25F1: "#",
	0x25F2: "#",
	0x25F3: "#",
	0x25F4: "#",
	0x25F5: "#",
	0x25F6: "#",
	0x25F7: "#",
	0x2605: " (starf) )",
	0x2606: " (star) ",
	0x260E: " (phone) ",
	0x2640: " (female) ",
	0x2642: " (male) ",
	0x2660: " (spades) ",
	0x2661: " (hearts) ",
	0x2662: " (diamonds) ",
	0x2663: " (clubs) ",
	0x2664: " (spades) ",
	0x2665: " (hearts) ",
	0x2666: " (diamonds) ",
	0x2667: " (clubs) ",
	0x2669: " (music note) ",
	0x266A: " (sung) ",
	0x266B: " (music note) ",
	0x266C: " (music note) ",
	0x266D: " (flat) ",
	0x266E: " (natural) ",
	0x266F: " (sharp) ",
	0x2713: " (check) ",
	0x2714: " (check) ",
	0x2717: " (cross) ",
	0x2720: " (malt) ",
	0x2731: "*",
	0x2736: " (sext) ",
	0x2758: "|",
	0x2762: "!",
	0x27E6: "[",
	0x27E7: "]",
	0x27E8: "<",
	0x27E9: "> ",
	0x2801: "a",
	0x2802: "1",
	0x2803: "b",
	0x2804: "'",
	0x2805: "k",
	0x2806: "2",
	0x2807: "l",
	0x2808: "@",
	0x2809: "c",
	0x280A: "i",
	0x280B: "f",
	0x280C: "/",
	0x280D: "m",
	0x280E: "s",
	0x280F: "p",
	0x2810: "",
	0x2811: "e",
	0x2812: "3",
	0x2813: "h",
	0x2814: "9",
	0x2815: "o",
	0x2816: "6",
	0x2817: "r",
	0x2818: "^",
	0x2819: "d",
	0x281A: "j",
	0x281B: "g",
	0x281C: ">",
	0x281D: "n",
	0x281E: "t",
	0x281F: "q",
	0x2820: ",",
	0x2821: "*",
	0x2822: "5",
	0x2823: "<",
	0x2824: "-",
	0x2825: "u",
	0x2826: "8",
	0x2827: "v",
	0x2828: ".",
	0x2829: "%",
	0x282A: "[",
	0x282B: "$",
	0x282C: "+",
	0x282D: "x",
	0x282E: "!",
	0x282F: "&",
	0x2830: ";",
	0x2831: ":",
	0x2832: "4",
	0x2833: "\\",
	0x2834: "0",
	0x2835: "z",
	0x2836: "7",
	0x2837: "(",
	0x2838: "_",
	0x2839: "?",
	0x283A: "w",
	0x283B: "]",
	0x283C: "#",
	0x283D: "y",
	0x283E: ")",
	0x283F: "=",
	0x2840: "[d7]",
	0x2841: "[d17]",
	0x2842: "[d27]",
	0x2843: "[d127]",
	0x2844: "[d37]",
	0x2845: "[d137]",
	0x2846: "[d237]",
	0x2847: "[d1237]",
	0x2848: "[d47]",
	0x2849: "[d147]",
	0x284A: "[d247]",
	0x284B: "[d1247]",
	0x284C: "[d347]",
	0x284D: "[d1347]",
	0x284E: "[d2347]",
	0x284F: "[d12347]",
	0x2850: "[d57]",
	0x2851: "[d157]",
	0x2852: "[d257]",
	0x2853: "[d1257]",
	0x2854: "[d357]",
	0x2855: "[d1357]",
	0x2856: "[d2357]",
	0x2857: "[d12357]",
	0x2858: "[d457]",
	0x2859: "[d1457]",
	0x285A: "[d2457]",
	0x285B: "[d12457]",
	0x285C: "[d3457]",
	0x285D: "[d13457]",
	0x285E: "[d23457]",
	0x285F: "[d123457]",
	0x2860: "[d67]",
	0x2861: "[d167]",
	0x2862: "[d267]",
	0x2863: "[d1267]",
	0x2864: "[d367]",
	0x2865: "[d1367]",
	0x2866: "[d2367]",
	0x2867: "[d12367]",
	0x2868: "[d467]",
	0x2869: "[d1467]",
	0x286A: "[d2467]",
	0x286B: "[d12467]",
	0x286C: "[d3467]",
	0x286D: "[d13467]",
	0x286E: "[d23467]",
	0x286F: "[d123467]",
	0x2870: "[d567]",
	0x2871: "[d1567]",
	0x2872: "[d2567]",
	0x2873: "[d12567]",
	0x2874: "[d3567]",
	0x2875: "[d13567]",
	0x2876: "[d23567]",
	0x2877: "[d123567]",
	0x2878: "[d4567]",
	0x2879: "[d14567]",
	0x287A: "[d24567]",
	0x287B: "[d124567]",
	0x287C: "[d34567]",
	0x287D: "[d134567]",
	0x287E: "[d234567]",
	0x287F: "[d1234567]",
	0x2880: "[d8]",
	0x2881: "[d18]",
	0x2882: "[d28]",
	0x2883: "[d128]",
	0x2884: "[d38]",
	0x2885: "[d138]",
	0x2886: "[d238]",
	0x2887: "[d1238]",
	0x2888: "[d48]",
	0x2889: "[d148]",
	0x288A: "[d248]",
	0x288B: "[d1248]",
	0x288C: "[d348]",
	0x288D: "[d1348]",
	0x288E: "[d2348]",
	0x288F: "[d12348]",
	0x2890: "[d58]",
	0x2891: "[d158]",
	0x2892: "[d258]",
	0x2893: "[d1258]",
	0x2894: "[d358]",
	0x2895: "[d1358]",
	0x2896: "[d2358]",
	0x2897: "[d12358]",
	0x2898: "[d458]",
	0x2899: "[d1458]",
	0x289A: "[d2458]",
	0x289B: "[d12458]",
	0x289C: "[d3458]",
	0x289D: "[d13458]",
	0x289E: "[d23458]",
	0x289F: "[d123458]",
	0x28A0: "[d68]",
	0x28A1: "[d168]",
	0x28A2: "[d268]",
	0x28A3: "[d1268]",
	0x28A4: "[d368]",
	0x28A5: "[d1368]",
	0x28A6: "[d2368]",
	0x28A7: "[d12368]",
	0x28A8: "[d468]",
	0x28A9: "[d1468]",
	0x28AA: "[d2468]",
	0x28AB: "[d12468]",
	0x28AC: "[d3468]",
	0x28AD: "[d13468]",
	0x28AE: "[d23468]",
	0x28AF: "[d123468]",
	0x28B0: "[d568]",
	0x28B1: "[d1568]",
	0x28B2: "[d2568]",
	0x28B3: "[d12568]",
	0x28B4: "[d3568]",
	0x28B5: "[d13568]",
	0x28B6: "[d23568]",
	0x28B7: "[d123568]",
	0x28B8: "[d4568]",
	0x28B9: "[d14568]",
	0x28BA: "[d24568]",
	0x28BB: "[d124568]",
	0x28BC: "[d34568]",
	0x28BD: "[d134568]",
	0x28BE: "[d234568]",
	0x28BF: "[d1234568]",
	0x28C0: "[d78]",
	0x28C1: "[d178]",
	0x28C2: "[d278]",
	0x28C3: "[d1278]",
	0x28C4: "[d378]",
	0x28C5: "[d1378]",
	0x28C6: "[d2378]",
	0x28C7: "[d12378]",
	0x28C8: "[d478]",
	0x28C9: "[d1478]",
	0x28CA: "[d2478]",
	0x28CB: "[d12478]",
	0x28CC: "[d3478]",
	0x28CD: "[d13478]",
	0x28CE: "[d23478]",
	0x28CF: "[d123478]",
	0x28D0: "[d578]",
	0x28D1: "[d1578]",
	0x28D2: "[d2578]",
	0x28D3: "[d12578]",
	0x28D4: "[d3578]",
	0x28D5: "[d13578]",
	0x28D6: "[d23578]",
	0x28D7: "[d123578]",
	0x28D8: "[d4578]",
	0x28D9: "[d14578]",
	0x28DA: "[d24578]",
	0x28DB: "[d124578]",
	0x28DC: "[d34578]",
	0x28DD: "[d134578]",
	0x28DE: "[d234578]",
	0x28DF: "[d1234578]",
	0x28E0: "[d678]",
	0x28E1: "[d1678]",
	0x28E2: "[d2678]",
	0x28E3: "[d12678]",
	0x28E4: "[d3678]",
	0x28E5: "[d13678]",
	0x28E6: "[d23678]",
	0x28E7: "[d123678]",
	0x28E8: "[d4678]",
	0x28E9: "[d14678]",
	0x28EA: "[d24678]",
	0x28EB: "[d124678]",
	0x28EC: "[d34678]",
	0x28ED: "[d134678]",
	0x28EE: "[d234678]",
	0x28EF: "[d1234678]",
	0x28F0: "[d5678]",
	0x28F1: "[d15678]",
	0x28F2: "[d25678]",
	0x28F3: "[d125678]",
	0x28F4: "[d35678]",
	0x28F5: "[d135678]",
	0x28F6: "[d235678]",
	0x28F7: "[d1235678]",
	0x28F8: "[d45678]",
	0x28F9: "[d145678]",
	0x28FA: "[d245678]",
	0x28FB: "[d1245678]",
	0x28FC: "[d345678]",
	0x28FD: "[d1345678]",
	0x28FE: "[d2345678]",
	0x28FF: "[d12345678]",
	0x2983: "{",
	0x2984: "} ",
	0x2A74: "::=",
	0x2A75: "==",
	0x2A76: "===",
	0x2A7D: "<=",
	0x2A7E: ">=",
	0x2C60: "L",
	0x2C61: "l",
	0x2C62: "L",
	0x2C63: "P",
	0x2C64: "R",
	0x2C65: "a",
	0x2C66: "t",
	0x2C67: "H",
	0x2C68: "h",
	0x2C69: "K",
	0x2C6A: "k",
	0x2C6B: "Z",
	0x2C6C: "z",
	0x2C6D: "",
	0x2C6E: "M",
	0x2C6F: "A",
	0x3001: ", ",
	0x3002: ". ",
	0x3003: "\"",
	0x3004: "[JIS]",
	0x3005: "\"",
	0x3006: "/",
	0x3007: "0",
	0x3008: "<",
	0x3009: "> ",
	0x300A: "<<",
	0x300B: ">> ",
	0x300C: "[",
	0x300D: "] ",
	0x300E: "{",
	0x300F: "} ",
	0x3010: "[(",
	0x3011: ")] ",
	0x3012: "@",
	0x3013: "X ",
	0x3014: "[",
	0x3015: "] ",
	0x3016: "[[",
	0x3017: "]] ",
	0x3018: "((",
	0x3019: ")) ",
	0x301A: "[[",
	0x301B: "]] ",
	0x301C: "~ ",
	0x301D: "``",
	0x301E: "''",
	0x301F: ",,",
	0x3020: "@",
	0x3021: "1",
	0x3022: "2",
	0x3023: "3",
	0x3024: "4",
	0x3025: "5",
	0x3026: "6",
	0x3027: "7",
	0x3028: "8",
	0x3029: "9",
	0x3030: "~",
	0x3031: "+",
	0x3032: "+",
	0x3033: "+",
	0x3034: "+",
	0x3035: "",
	0x3036: "@",
	0x3037: " // ",
	0x3038: "+10+",
	0x3039: "+20+",
	0x303A: "+30+",
}

// asciiRunes is merged from several sources

var asciiRunes = map[rune]string{
	0x0000: "",
	0x0001: "",
	0x0002: "",
	0x0003: "",
	0x0004: "",
	0x0005: "",
	0x0006: "",
	0x0007: "",
	0x0008: "",
	0x0009: "",
	0x000A: "",
	0x000B: "",
	0x000C: "",
	0x000D: "",
	0x000E: "",
	0x000F: "",
	0x0010: "",
	0x0011: "",
	0x0012: "",
	0x0013: "",
	0x0014: "",
	0x0015: "",
	0x0016: "",
	0x0017: "",
	0x0018: "",
	0x0019: "",
	0x001A: "",
	0x001B: "",
	0x001C: "",
	0x001D: "",
	0x001E: "",
	0x001F: "",
	0x0020: " ",
	0x0021: "!",
	0x0022: "\"",
	0x0023: "#",
	0x0024: "$",
	0x0025: "%",
	0x0026: "&",
	0x0027: "'",
	0x0028: "(",
	0x0029: ")",
	0x002A: "*",
	0x002B: "+",
	0x002C: ",",
	0x002D: "-",
	0x002E: ".",
	0x002F: "/",
	0x0030: "0",
	0x0031: "1",
	0x0032: "2",
	0x0033: "3",
	0x0034: "4",
	0x0035: "5",
	0x0036: "6",
	0x0037: "7",
	0x0038: "8",
	0x0039: "9",
	0x003A: ":",
	0x003B: ";",
	0x003C: "<",
	0x003D: "=",
	0x003E: ">",
	0x003F: "?",
	0x0040: "@",
	0x0041: "A",
	0x0042: "B",
	0x0043: "C",
	0x0044: "D",
	0x0045: "E",
	0x0046: "F",
	0x0047: "G",
	0x0048: "H",
	0x0049: "I",
	0x004A: "J",
	0x004B: "K",
	0x004C: "L",
	0x004D: "M",
	0x004E: "N",
	0x004F: "O",
	0x0050: "P",
	0x0051: "Q",
	0x0052: "R",
	0x0053: "S",
	0x0054: "T",
	0x0055: "U",
	0x0056: "V",
	0x0057: "W",
	0x0058: "X",
	0x0059: "Y",
	0x005A: "Z",
	0x005B: "[",
	0x005C: "\\",
	0x005D: "]",
	0x005E: "^",
	0x005F: "_",
	0x0060: "`",
	0x0061: "a",
	0x0062: "b",
	0x0063: "c",
	0x0064: "d",
	0x0065: "e",
	0x0066: "f",
	0x0067: "g",
	0x0068: "h",
	0x0069: "i",
	0x006A: "j",
	0x006B: "k",
	0x006C: "l",
	0x006D: "m",
	0x006E: "n",
	0x006F: "o",
	0x0070: "p",
	0x0071: "q",
	0x0072: "r",
	0x0073: "s",
	0x0074: "t",
	0x0075: "u",
	0x0076: "v",
	0x0077: "w",
	0x0078: "x",
	0x0079: "y",
	0x007A: "z",
	0x007B: "{",
	0x007C: "|",
	0x007D: "}",
	0x007E: "~",
	0x007F: "",
	0x00A0: " ",
	0x00A1: "!",
	0x00A2: " (cent) ",
	0x00A3: " (pound) ",
	0x00A4: " (curren) ",
	0x00A5: " (yen) ",
	0x00A6: "|",
	0x00A7: " SS ",
	0x00A8: "",
	0x00A9: " (copy) ",
	0x00AA: "",
	0x00AB: "<<",
	0x00AC: "!",
	0x00AD: "-",
	0x00AE: " (reg) ",
	0x00AF: "-",
	0x00B0: " degrees ",
	0x00B1: "+/-",
	0x00B2: "(2)",
	0x00B3: "(3)",
	0x00B4: "'",
	0x00B5: " micro ",
	0x00B6: " (p) ",
	0x00B7: "",
	0x00B8: "",
	0x00B9: "(1)",
	0x00BA: "",
	0x00BB: ">>",
	0x00BC: "(1/4)",
	0x00BD: "(1/2)",
	0x00BE: "(3/4)",
	0x00BF: "?",
	0x00C0: "A",
	0x00C1: "A",
	0x00C2: "A",
	0x00C3: "A",
	0x00C4: "A",
	0x00C5: "A",
	0x00C6: "AE",
	0x00C7: "C",
	0x00C8: "E",
	0x00C9: "E",
	0x00CA: "E",
	0x00CB: "E",
	0x00CC: "I",
	0x00CD: "I",
	0x00CE: "I",
	0x00CF: "I",
	0x00D0: "D",
	0x00D1: "N",
	0x00D2: "O",
	0x00D3: "O",
	0x00D4: "O",
	0x00D5: "O",
	0x00D6: "O",
	0x00D7: "x",
	0x00D8: "O",
	0x00D9: "U",
	0x00DA: "U",
	0x00DB: "U",
	0x00DC: "U",
	0x00DD: "Y",
	0x00DE: "Th",
	0x00DF: "ss",
	0x00E0: "a",
	0x00E1: "a",
	0x00E2: "a",
	0x00E3: "a",
	0x00E4: "a",
	0x00E5: "a",
	0x00E6: "ae",
	0x00E7: "c",
	0x00E8: "e",
	0x00E9: "e",
	0x00EA: "e",
	0x00EB: "e",
	0x00EC: "i",
	0x00ED: "i",
	0x00EE: "i",
	0x00EF: "i",
	0x00F0: "d",
	0x00F1: "n",
	0x00F2: "o",
	0x00F3: "o",
	0x00F4: "o",
	0x00F5: "o",
	0x00F6: "o",
	0x00F7: "/",
	0x00F8: "o",
	0x00F9: "u",
	0x00FA: "u",
	0x00FB: "u",
	0x00FC: "u",
	0x00FD: "y",
	0x00FE: "th",
	0x00FF: "y",
	0x0100: "A",
	0x0101: "a",
	0x0102: "A",
	0x0103: "a",
	0x0104: "A",
	0x0105: "a",
	0x0106: "C",
	0x0107: "c",
	0x0108: "C",
	0x0109: "c",
	0x010A: "C",
	0x010B: "c",
	0x010C: "C",
	0x010D: "c",
	0x010E: "D",
	0x010F: "d",
	0x0110: "D",
	0x0111: "d",
	0x0112: "E",
	0x0113: "e",
	0x0114: "E",
	0x0115: "e",
	0x0116: "E",
	0x0117: "e",
	0x0118: "E",
	0x0119: "e",
	0x011A: "E",
	0x011B: "e",
	0x011C: "G",
	0x011D: "g",
	0x011E: "G",
	0x011F: "g",
	0x0120: "G",
	0x0121: "g",
	0x0122: "G",
	0x0123: "g",
	0x0124: "H",
	0x0125: "h",
	0x0126: "H",
	0x0127: "h",
	0x0128: "I",
	0x0129: "i",
	0x012A: "I",
	0x012B: "i",
	0x012C: "I",
	0x012D: "i",
	0x012E: "I",
	0x012F: "i",
	0x0130: "I",
	0x0131: "i",
	0x0132: "IJ",
	0x0133: "ij",
	0x0134: "J",
	0x0135: "j",
	0x0136: "K",
	0x0137: "k",
	0x0138: "k",
	0x0139: "L",
	0x013A: "l",
	0x013B: "L",
	0x013C: "l",
	0x013D: "L",
	0x013E: "l",
	0x013F: "L",
	0x0140: "l",
	0x0141: "L",
	0x0142: "l",
	0x0143: "N",
	0x0144: "n",
	0x0145: "N",
	0x0146: "n",
	0x0147: "N",
	0x0148: "n",
	0x0149: "'n",
	0x014A: "ng",
	0x014B: "NG",
	0x014C: "O",
	0x014D: "o",
	0x014E: "O",
	0x014F: "o",
	0x0150: "O",
	0x0151: "o",
	0x0152: "OE",
	0x0153: "oe",
	0x0154: "R",
	0x0155: "r",
	0x0156: "R",
	0x0157: "r",
	0x0158: "R",
	0x0159: "r",
	0x015A: "S",
	0x015B: "s",
	0x015C: "S",
	0x015D: "s",
	0x015E: "S",
	0x015F: "s",
	0x0160: "S",
	0x0161: "s",
	0x0162: "T",
	0x0163: "t",
	0x0164: "T",
	0x0165: "t",
	0x0166: "T",
	0x0167: "t",
	0x0168: "U",
	0x0169: "u",
	0x016A: "U",
	0x016B: "u",
	0x016C: "U",
	0x016D: "u",
	0x016E: "U",
	0x016F: "u",
	0x0170: "U",
	0x0171: "u",
	0x0172: "U",
	0x0173: "u",
	0x0174: "W",
	0x0175: "w",
	0x0176: "Y",
	0x0177: "y",
	0x0178: "Y",
	0x0179: "Z",
	0x017A: "z",
	0x017B: "Z",
	0x017C: "z",
	0x017D: "Z",
	0x017E: "z",
	0x017F: "s",
	0x0180: "b",
	0x0181: "B",
	0x0182: "B",
	0x0183: "b",
	0x0184: "6",
	0x0185: "6",
	0x0186: "O",
	0x0187: "C",
	0x0188: "c",
	0x0189: "D",
	0x018A: "D",
	0x018B: "D",
	0x018C: "d",
	0x018D: "d",
	0x018E: "3",
	0x018F: "@",
	0x0190: "E",
	0x0191: "F",
	0x0192: "f",
	0x0193: "G",
	0x0194: "G",
	0x0195: "hv",
	0x0196: "I",
	0x0197: "I",
	0x0198: "K",
	0x0199: "k",
	0x019A: "l",
	0x019B: "l",
	0x019C: "W",
	0x019D: "N",
	0x019E: "n",
	0x019F: "O",
	0x01A0: "O",
	0x01A1: "o",
	0x01A2: "OI",
	0x01A3: "oi",
	0x01A4: "P",
	0x01A5: "p",
	0x01A6: "YR",
	0x01A7: "2",
	0x01A8: "2",
	0x01A9: "SH",
	0x01AA: "sh",
	0x01AB: "t",
	0x01AC: "T",
	0x01AD: "t",
	0x01AE: "T",
	0x01AF: "U",
	0x01B0: "u",
	0x01B1: "Y",
	0x01B2: "V",
	0x01B3: "Y",
	0x01B4: "y",
	0x01B5: "Z",
	0x01B6: "z",
	0x01B7: "ZH",
	0x01B8: "ZH",
	0x01B9: "zh",
	0x01BA: "zh",
	0x01BB: "2",
	0x01BC: "5",
	0x01BD: "5",
	0x01BE: "ts",
	0x01BF: "w",
	0x01C0: "|",
	0x01C1: "||",
	0x01C2: "|=",
	0x01C3: "!",
	0x01C4: "DZ",
	0x01C5: "Dz",
	0x01C6: "dz",
	0x01C7: "LJ",
	0x01C8: "Lj",
	0x01C9: "lj",
	0x01CA: "NJ",
	0x01CB: "Nj",
	0x01CC: "nj",
	0x01CD: "A",
	0x01CE: "a",
	0x01CF: "I",
	0x01D0: "i",
	0x01D1: "O",
	0x01D2: "o",
	0x01D3: "U",
	0x01D4: "u",
	0x01D5: "U",
	0x01D6: "u",
	0x01D7: "U",
	0x01D8: "u",
	0x01D9: "U",
	0x01DA: "u",
	0x01DB: "U",
	0x01DC: "u",
	0x01DD: "@",
	0x01DE: "A",
	0x01DF: "a",
	0x01E0: "A",
	0x01E1: "a",
	0x01E2: "AE",
	0x01E3: "ae",
	0x01E4: "G",
	0x01E5: "g",
	0x01E6: "G",
	0x01E7: "g",
	0x01E8: "K",
	0x01E9: "k",
	0x01EA: "O",
	0x01EB: "o",
	0x01EC: "O",
	0x01ED: "o",
	0x01EE: "ZH",
	0x01EF: "zh",
	0x01F0: "j",
	0x01F1: "DZ",
	0x01F2: "Dz",
	0x01F3: "dz",
	0x01F4: "G",
	0x01F5: "g",
	0x01F6: "HV",
	0x01F7: "W",
	0x01F8: "N",
	0x01F9: "n",
	0x01FA: "A",
	0x01FB: "a",
	0x01FC: "AE",
	0x01FD: "ae",
	0x01FE: "O",
	0x01FF: "o",
	0x0200: "A",
	0x0201: "a",
	0x0202: "A",
	0x0203: "a",
	0x0204: "E",
	0x0205: "e",
	0x0206: "E",
	0x0207: "e",
	0x0208: "I",
	0x0209: "i",
	0x020A: "I",
	0x020B: "i",
	0x020C: "O",
	0x020D: "o",
	0x020E: "O",
	0x020F: "o",
	0x0210: "R",
	0x0211: "r",
	0x0212: "R",
	0x0213: "r",
	0x0214: "U",
	0x0215: "u",
	0x0216: "U",
	0x0217: "u",
	0x0218: "S",
	0x0219: "s",
	0x021A: "T",
	0x021B: "t",
	0x021C: "Y",
	0x021D: "y",
	0x021E: "H",
	0x021F: "h",
	0x0220: "N",
	0x0221: "d",
	0x0222: "OU",
	0x0223: "ou",
	0x0224: "Z",
	0x0225: "z",
	0x0226: "A",
	0x0227: "a",
	0x0228: "E",
	0x0229: "e",
	0x022A: "O",
	0x022B: "o",
	0x022C: "O",
	0x022D: "o",
	0x022E: "O",
	0x022F: "o",
	0x0230: "O",
	0x0231: "o",
	0x0232: "Y",
	0x0233: "y",
	0x0234: "l",
	0x0235: "n",
	0x0236: "t",
	0x0237: "j",
	0x0238: "db",
	0x0239: "qp",
	0x023A: "A",
	0x023B: "C",
	0x023C: "c",
	0x023D: "L",
	0x023E: "T",
	0x023F: "s",
	0x0240: "z",
	0x0243: "B",
	0x0244: "U",
	0x0245: "^",
	0x0246: "E",
	0x0247: "e",
	0x0248: "J",
	0x0249: "j",
	0x024A: "q",
	0x024B: "q",
	0x024C: "R",
	0x024D: "r",
	0x024E: "Y",
	0x024F: "y",
	0x0250: "a",
	0x0251: "a",
	0x0252: "a",
	0x0253: "b",
	0x0254: "o",
	0x0255: "c",
	0x0256: "d",
	0x0257: "d",
	0x0258: "e",
	0x0259: "@",
	0x025A: "@",
	0x025B: "e",
	0x025C: "e",
	0x025D: "e",
	0x025E: "e",
	0x025F: "j",
	0x0260: "g",
	0x0261: "g",
	0x0262: "g",
	0x0263: "g",
	0x0264: "u",
	0x0265: "Y",
	0x0266: "h",
	0x0267: "h",
	0x0268: "i",
	0x0269: "i",
	0x026A: "I",
	0x026B: "l",
	0x026C: "l",
	0x026D: "l",
	0x026E: "lZ",
	0x026F: "W",
	0x0270: "W",
	0x0271: "m",
	0x0272: "n",
	0x0273: "n",
	0x0274: "n",
	0x0275: "o",
	0x0276: "OE",
	0x0277: "O",
	0x0278: "F",
	0x0279: "r",
	0x027A: "r",
	0x027B: "r",
	0x027C: "r",
	0x027D: "r",
	0x027E: "r",
	0x027F: "r",
	0x0280: "R",
	0x0281: "R",
	0x0282: "s",
	0x0283: "S",
	0x0284: "j",
	0x0285: "S",
	0x0286: "S",
	0x0287: "t",
	0x0288: "t",
	0x0289: "u",
	0x028A: "U",
	0x028B: "v",
	0x028C: "^",
	0x028D: "w",
	0x028E: "y",
	0x028F: "Y",
	0x0290: "z",
	0x0291: "z",
	0x0292: "Z",
	0x0293: "Z",
	0x0297: "C",
	0x0298: "@",
	0x0299: "B",
	0x029A: "E",
	0x029B: "G",
	0x029C: "H",
	0x029D: "j",
	0x029E: "k",
	0x029F: "L",
	0x02A0: "q",
	0x02A3: "dz",
	0x02A4: "dZ",
	0x02A5: "dz",
	0x02A6: "ts",
	0x02A7: "tS",
	0x02A8: "tC",
	0x02A9: "fN",
	0x02AA: "ls",
	0x02AB: "lz",
	0x02AC: "WW",
	0x02AD: "]]",
	0x02AE: "h",
	0x02AF: "h",
	0x02B0: "k",
	0x02B1: "h",
	0x02B2: "j",
	0x02B3: "r",
	0x02B4: "r",
	0x02B5: "r",
	0x02B6: "r",
	0x02B7: "w",
	0x02B8: "y",
	0x02B9: "'",
	0x02BA: "\"",
	0x02BB: "`",
	0x02BC: "'",
	0x02BD: "`",
	0x02BE: "`",
	0x02BF: "'",
	0x02C0: "?",
	0x02C1: "?",
	0x02C2: "<",
	0x02C3: ">",
	0x02C4: "^",
	0x02C5: "v",
	0x02C6: "^",
	0x02C7: "V",
	0x02C8: "'",
	0x02C9: "-",
	0x02CA: "'",
	0x02CB: "`",
	0x02CC: ",",
	0x02CD: "_",
	0x02CE: "'",
	0x02CF: "`",
	0x02D0: ":",
	0x02D1: ".",
	0x02D2: "`",
	0x02D3: "'",
	0x02D4: "^",
	0x02D5: "V",
	0x02D6: "+",
	0x02D7: "-",
	0x02D8: "V",
	0x02D9: ".",
	0x02DA: "@",
	0x02DB: ",",
	0x02DC: "~",
	0x02DD: "",
	0x02DE: "R",
	0x02DF: "X",
	0x02E0: "G",
	0x02E1: "l",
	0x02E2: "s",
	0x02E3: "x",
	0x02EC: "V",
	0x02ED: "=",
	0x02EE: "\"",
	0x02F1: "l",
	0x02F2: "s",
	0x02F3: "x",
	0x02FC: "v",
	0x02FD: "=",
	0x0363: "a",
	0x0364: "e",
	0x0365: "i",
	0x0366: "o",
	0x0367: "u",
	0x0368: "c",
	0x0369: "d",
	0x036A: "h",
	0x036B: "m",
	0x036C: "r",
	0x036D: "t",
	0x036E: "v",
	0x036F: "x",
	0x0374: "'",
	0x0375: ",",
	0x037E: "?",
	0x037F: "J",
	0x0386: "A",
	0x0387: "",
	0x0388: "E",
	0x0389: "E",
	0x038A: "I",
	0x038C: "O",
	0x038E: "U",
	0x038F: " Omega ",
	0x0390: " iota ",
	0x0391: " Alpha ",
	0x0392: " Beta ",
	0x0393: " Gamma ",
	0x0394: " Delta ",
	0x0395: " Epsilon",
	0x0396: " Zeta ",
	0x0397: " Eta ",
	0x0398: " Theta ",
	0x0399: " Iota ",
	0x039A: " Kappa ",
	0x039B: " Lambda ",
	0x039C: " Mu ",
	0x039D: " Nu ",
	0x039E: " Xi ",
	0x039F: " Omicron ",
	0x03A0: " Pi ",
	0x03A1: " Rho ",
	0x03A3: " Sigma ",
	0x03A4: " Tau ",
	0x03A5: " Upsilon ",
	0x03A6: " Phi ",
	0x03A7: " Chi ",
	0x03A8: " Psi ",
	0x03A9: " Omega ",
	0x03AA: " Iota ",
	0x03AB: " Upsilon ",
	0x03AC: " alpha ",
	0x03AD: " epsilon ",
	0x03AE: " eta ",
	0x03AF: " iota ",
	0x03B0: " upsilon ",
	0x03B1: " alpha ",
	0x03B2: " beta ",
	0x03B3: " gamma ",
	0x03B4: " delta ",
	0x03B5: " epsilon ",
	0x03B6: " zeta ",
	0x03B7: " eta ",
	0x03B8: " theta ",
	0x03B9: " iota ",
	0x03BA: " kappa ",
	0x03BB: " lambda ",
	0x03BC: " mu ",
	0x03BD: " nu ",
	0x03BE: " xi ",
	0x03BF: " omicron ",
	0x03C0: " pi ",
	0x03C1: " rho ",
	0x03C2: " sigma ",
	0x03C3: " sigma ",
	0x03C4: " tau ",
	0x03C5: " upsilon ",
	0x03C6: " phi ",
	0x03C7: " chi ",
	0x03C8: " psi ",
	0x03C9: " omega ",
	0x03CA: " iota ",
	0x03CB: " upsilon ",
	0x03CC: " omicron ",
	0x03CD: " upsilon ",
	0x03CE: " omega ",
	0x03CF: " Kai ",
	0x03D0: " beta ",
	0x03D1: " theta ",
	0x03D2: " Upsilon ",
	0x03D3: "",
	0x03D4: " Upsilon ",
	0x03D5: " Phi ",
	0x03D6: " Pi ",
	0x03D7: " Kai ",
	0x03DA: " Stigma ",
	0x03DB: " stigma ",
	0x03DC: " Digamma ",
	0x03DD: " digamma ",
	0x03DE: " Koppa ",
	0x03DF: " koppa ",
	0x03E0: " Sampi ",
	0x03E1: " sampi ",
	0x03E2: "Sh",
	0x03E3: "sh",
	0x03E4: "F",
	0x03E5: "f",
	0x03E6: "Kh",
	0x03E7: "kh",
	0x03E8: "H",
	0x03E9: "h",
	0x03EA: "G",
	0x03EB: "g",
	0x03EC: "CH",
	0x03ED: "ch",
	0x03EE: "Ti",
	0x03EF: "ti",
	0x03F0: "k",
	0x03F1: "r",
	0x03F2: "c",
	0x03F3: "j",
	0x03F4: "Th",
	0x03F5: "e",
	0x03F6: "e",
	0x03F7: "",
	0x03F8: "",
	0x03F9: "S",
	0x03FA: "",
	0x03FB: "",
	0x03FC: "r",
	0x03FD: "S",
	0x03FE: "S",
	0x03FF: "S",
	0x0400: "Ie",
	0x0401: "Io",
	0x0402: "Dj",
	0x0403: "Gj",
	0x0404: "Ie",
	0x0405: "Dz",
	0x0406: "I",
	0x0407: "Yi",
	0x0408: "J",
	0x0409: "Lj",
	0x040A: "Nj",
	0x040B: "Tsh",
	0x040C: "Kj",
	0x040D: "I",
	0x040E: "U",
	0x040F: "Dzh",
	0x0410: "A",
	0x0411: "B",
	0x0412: "V",
	0x0413: "G",
	0x0414: "D",
	0x0415: "E",
	0x0416: "Zh",
	0x0417: "Z",
	0x0418: "I",
	0x0419: "I",
	0x041A: "K",
	0x041B: "L",
	0x041C: "M",
	0x041D: "N",
	0x041E: "O",
	0x041F: "P",
	0x0420: "R",
	0x0421: "S",
	0x0422: "T",
	0x0423: "U",
	0x0424: "F",
	0x0425: "Kh",
	0x0426: "Ts",
	0x0427: "Ch",
	0x0428: "Sh",
	0x0429: "Shch",
	0x042A: "'",
	0x042B: "Y",
	0x042C: "'",
	0x042D: "E",
	0x042E: "Iu",
	0x042F: "Ia",
	0x0430: "a",
	0x0431: "b",
	0x0432: "v",
	0x0433: "g",
	0x0434: "d",
	0x0435: "e",
	0x0436: "zh",
	0x0437: "z",
	0x0438: "i",
	0x0439: "i",
	0x043A: "k",
	0x043B: "l",
	0x043C: "m",
	0x043D: "n",
	0x043E: "o",
	0x043F: "p",
	0x0440: "r",
	0x0441: "s",
	0x0442: "t",
	0x0443: "u",
	0x0444: "f",
	0x0445: "kh",
	0x0446: "ts",
	0x0447: "ch",
	0x0448: "sh",
	0x0449: "shch",
	0x044A: "'",
	0x044B: "y",
	0x044C: "'",
	0x044D: "e",
	0x044E: "iu",
	0x044F: "ia",
	0x0450: "ie",
	0x0451: "io",
	0x0452: "dj",
	0x0453: "gj",
	0x0454: "ie",
	0x0455: "dz",
	0x0456: "i",
	0x0457: "yi",
	0x0458: "j",
	0x0459: "lj",
	0x045A: "nj",
	0x045B: "tsh",
	0x045C: "kj",
	0x045D: "i",
	0x045E: "u",
	0x045F: "dzh",
	0x0460: "O",
	0x0461: "o",
	0x0462: "E",
	0x0463: "e",
	0x0464: "Ie",
	0x0465: "ie",
	0x0466: "E",
	0x0467: "e",
	0x0468: "Ie",
	0x0469: "ie",
	0x046A: "O",
	0x046B: "o",
	0x046C: "Io",
	0x046D: "io",
	0x046E: "Ks",
	0x046F: "ks",
	0x0470: "Ps",
	0x0471: "ps",
	0x0472: "F",
	0x0473: "f",
	0x0474: "Y",
	0x0475: "y",
	0x0476: "Y",
	0x0477: "y",
	0x0478: "u",
	0x0479: "u",
	0x047A: "O",
	0x047B: "o",
	0x047C: "O",
	0x047D: "o",
	0x047E: "Ot",
	0x047F: "ot",
	0x0480: "Q",
	0x0481: "q",
	0x048C: "",
	0x048D: "",
	0x048E: "R'",
	0x048F: "r'",
	0x0490: "G'",
	0x0491: "g'",
	0x0492: "G'",
	0x0493: "g'",
	0x0494: "G'",
	0x0495: "g'",
	0x0496: "Zh'",
	0x0497: "zh'",
	0x0498: "Z'",
	0x0499: "z'",
	0x049A: "K'",
	0x049B: "k'",
	0x049C: "K'",
	0x049D: "k'",
	0x049E: "K'",
	0x049F: "k'",
	0x04A0: "K'",
	0x04A1: "k'",
	0x04A2: "N'",
	0x04A3: "n'",
	0x04A4: "Ng",
	0x04A5: "ng",
	0x04A6: "P'",
	0x04A7: "p'",
	0x04A8: "Kh",
	0x04A9: "kh",
	0x04AA: "S'",
	0x04AB: "s'",
	0x04AC: "T'",
	0x04AD: "t'",
	0x04AE: "U",
	0x04AF: "u",
	0x04B0: "U'",
	0x04B1: "u'",
	0x04B2: "Kh'",
	0x04B3: "kh'",
	0x04B4: "Tts",
	0x04B5: "tts",
	0x04B6: "Ch'",
	0x04B7: "ch'",
	0x04B8: "Ch'",
	0x04B9: "ch'",
	0x04BA: "H",
	0x04BB: "h",
	0x04BC: "Ch",
	0x04BD: "ch",
	0x04BE: "Ch'",
	0x04BF: "ch'",
	0x04C0: "`",
	0x04C1: "Zh",
	0x04C2: "zh",
	0x04C3: "K'",
	0x04C4: "k'",
	0x04C7: "N'",
	0x04C8: "n'",
	0x04CB: "Ch",
	0x04CC: "ch",
	0x04D0: "a",
	0x04D1: "a",
	0x04D2: "A",
	0x04D3: "a",
	0x04D4: "Ae",
	0x04D5: "ae",
	0x04D6: "Ie",
	0x04D7: "ie",
	0x04D8: "@",
	0x04D9: "@",
	0x04DA: "@",
	0x04DB: "@",
	0x04DC: "Zh",
	0x04DD: "zh",
	0x04DE: "Z",
	0x04DF: "z",
	0x04E0: "Dz",
	0x04E1: "dz",
	0x04E2: "I",
	0x04E3: "i",
	0x04E4: "I",
	0x04E5: "i",
	0x04E6: "O",
	0x04E7: "o",
	0x04E8: "O",
	0x04E9: "o",
	0x04EA: "O",
	0x04EB: "o",
	0x04EC: "E",
	0x04ED: "e",
	0x04EE: "U",
	0x04EF: "u",
	0x04F0: "U",
	0x04F1: "u",
	0x04F2: "U",
	0x04F3: "u",
	0x04F4: "Ch",
	0x04F5: "ch",
	0x04F8: "Y",
	0x04F9: "y",
	0x0531: "A",
	0x0532: "B",
	0x0533: "G",
	0x0534: "D",
	0x0535: "E",
	0x0536: "Z",
	0x0537: "E",
	0x0538: "E",
	0x0539: "T`",
	0x053A: "Zh",
	0x053B: "I",
	0x053C: "L",
	0x053D: "Kh",
	0x053E: "Ts",
	0x053F: "K",
	0x0540: "H",
	0x0541: "Dz",
	0x0542: "Gh",
	0x0543: "Ch",
	0x0544: "M",
	0x0545: "Y",
	0x0546: "N",
	0x0547: "Sh",
	0x0548: "O",
	0x0549: "Ch`",
	0x054A: "P",
	0x054B: "J",
	0x054C: "Rh",
	0x054D: "S",
	0x054E: "V",
	0x054F: "T",
	0x0550: "R",
	0x0551: "Ts`",
	0x0552: "W",
	0x0553: "P`",
	0x0554: "K`",
	0x0555: "O",
	0x0556: "F",
	0x0559: "<",
	0x055A: "'",
	0x055B: "/",
	0x055C: "!",
	0x055D: ",",
	0x055E: "?",
	0x055F: ".",
	0x0561: "a",
	0x0562: "b",
	0x0563: "g",
	0x0564: "d",
	0x0565: "e",
	0x0566: "z",
	0x0567: "e",
	0x0568: "e",
	0x0569: "t`",
	0x056A: "zh",
	0x056B: "i",
	0x056C: "l",
	0x056D: "kh",
	0x056E: "ts",
	0x056F: "k",
	0x0570: "h",
	0x0571: "dz",
	0x0572: "gh",
	0x0573: "ch",
	0x0574: "m",
	0x0575: "y",
	0x0576: "n",
	0x0577: "sh",
	0x0578: "o",
	0x0579: "ch`",
	0x057A: "p",
	0x057B: "j",
	0x057C: "rh",
	0x057D: "s",
	0x057E: "v",
	0x057F: "t",
	0x0580: "r",
	0x0581: "ts`",
	0x0582: "w",
	0x0583: "p`",
	0x0584: "k`",
	0x0585: "o",
	0x0586: "f",
	0x0587: "ew",
	0x0589: ":",
	0x058A: "-",
	0x05B0: "@",
	0x05B1: "e",
	0x05B2: "a",
	0x05B3: "o",
	0x05B4: "i",
	0x05B5: "e",
	0x05B6: "e",
	0x05B7: "a",
	0x05B8: "a",
	0x05B9: "o",
	0x05BB: "u",
	0x05BC: "'",
	0x05C0: "|",
	0x05C3: ":",
	0x05D0: "a",
	0x05D1: "b",
	0x05D2: "g",
	0x05D3: "d",
	0x05D4: "h",
	0x05D5: "v",
	0x05D6: "z",
	0x05D7: "kh",
	0x05D8: "t",
	0x05D9: "y",
	0x05DA: "k",
	0x05DB: "k",
	0x05DC: "l",
	0x05DD: "m",
	0x05DE: "m",
	0x05DF: "n",
	0x05E0: "n",
	0x05E1: "s",
	0x05E2: "`",
	0x05E3: "p",
	0x05E4: "p",
	0x05E5: "ts",
	0x05E6: "ts",
	0x05E7: "q",
	0x05E8: "r",
	0x05E9: "sh",
	0x05EA: "t",
	0x05F0: "V",
	0x05F1: "oy",
	0x05F2: "i",
	0x05F3: "'",
	0x05F4: "",
	0x060C: ",",
	0x061B: ";",
	0x061F: "?",
	0x0622: "a",
	0x0623: "'",
	0x0624: "w'",
	0x0626: "y'",
	0x0628: "b",
	0x0629: "@",
	0x062A: "t",
	0x062B: "th",
	0x062C: "j",
	0x062D: "H",
	0x062E: "kh",
	0x062F: "d",
	0x0630: "dh",
	0x0631: "r",
	0x0632: "z",
	0x0633: "s",
	0x0634: "sh",
	0x0635: "S",
	0x0636: "D",
	0x0637: "T",
	0x0638: "Z",
	0x0639: "`",
	0x063A: "G",
	0x0641: "f",
	0x0642: "q",
	0x0643: "k",
	0x0644: "l",
	0x0645: "m",
	0x0646: "n",
	0x0647: "h",
	0x0648: "w",
	0x0649: "~",
	0x064A: "y",
	0x064B: "an",
	0x064C: "un",
	0x064D: "in",
	0x064E: "a",
	0x064F: "u",
	0x0650: "i",
	0x0651: "W",
	0x0654: "'",
	0x0655: "'",
	0x0660: "0",
	0x0661: "1",
	0x0662: "2",
	0x0663: "3",
	0x0664: "4",
	0x0665: "5",
	0x0666: "6",
	0x0667: "7",
	0x0668: "8",
	0x0669: "9",
	0x066A: "%",
	0x066B: ".",
	0x066C: ",",
	0x066D: "*",
	0x0671: "'",
	0x0672: "'",
	0x0673: "'",
	0x0675: "'",
	0x0676: "'w",
	0x0677: "'u",
	0x0678: "'y",
	0x0679: "tt",
	0x067A: "tth",
	0x067B: "b",
	0x067C: "t",
	0x067D: "T",
	0x067E: "p",
	0x067F: "th",
	0x0680: "bh",
	0x0681: "'h",
	0x0682: "H",
	0x0683: "ny",
	0x0684: "dy",
	0x0685: "H",
	0x0686: "ch",
	0x0687: "cch",
	0x0688: "dd",
	0x0689: "D",
	0x068A: "D",
	0x068B: "Dt",
	0x068C: "dh",
	0x068D: "ddh",
	0x068E: "d",
	0x068F: "D",
	0x0690: "D",
	0x0691: "rr",
	0x0692: "R",
	0x0693: "R",
	0x0694: "R",
	0x0695: "R",
	0x0696: "R",
	0x0697: "R",
	0x0698: "j",
	0x0699: "R",
	0x069A: "S",
	0x069B: "S",
	0x069C: "S",
	0x069D: "S",
	0x069E: "S",
	0x069F: "T",
	0x06A0: "GH",
	0x06A1: "F",
	0x06A2: "F",
	0x06A3: "F",
	0x06A4: "v",
	0x06A5: "f",
	0x06A6: "ph",
	0x06A7: "Q",
	0x06A8: "Q",
	0x06A9: "kh",
	0x06AA: "k",
	0x06AB: "K",
	0x06AC: "K",
	0x06AD: "ng",
	0x06AE: "K",
	0x06AF: "g",
	0x06B0: "G",
	0x06B1: "N",
	0x06B2: "G",
	0x06B3: "G",
	0x06B4: "G",
	0x06B5: "L",
	0x06B6: "L",
	0x06B7: "L",
	0x06B8: "L",
	0x06B9: "N",
	0x06BA: "N",
	0x06BB: "N",
	0x06BC: "N",
	0x06BD: "N",
	0x06BE: "h",
	0x06BF: "Ch",
	0x06C0: "hy",
	0x06C1: "h",
	0x06C2: "H",
	0x06C3: "@",
	0x06C4: "W",
	0x06C5: "oe",
	0x06C6: "oe",
	0x06C7: "u",
	0x06C8: "yu",
	0x06C9: "yu",
	0x06CA: "W",
	0x06CB: "v",
	0x06CC: "y",
	0x06CD: "Y",
	0x06CE: "Y",
	0x06CF: "W",
	0x06D2: "y",
	0x06D3: "y'",
	0x06D4: ".",
	0x06D5: "ae",
	0x06DD: "@",
	0x06DE: "#",
	0x06E9: "^",
	0x06F0: "0",
	0x06F1: "1",
	0x06F2: "2",
	0x06F3: "3",
	0x06F4: "4",
	0x06F5: "5",
	0x06F6: "6",
	0x06F7: "7",
	0x06F8: "8",
	0x06F9: "9",
	0x06FA: "Sh",
	0x06FB: "D",
	0x06FC: "Gh",
	0x06FD: "&",
	0x06FE: "+m",
	0x06FF: "",
	0x0700: "//",
	0x0701: "/",
	0x0702: ",",
	0x0703: "!",
	0x0704: "!",
	0x0705: "-",
	0x0706: ",",
	0x0707: ",",
	0x0708: ";",
	0x0709: "?",
	0x070A: "~",
	0x070B: "{",
	0x070C: "}",
	0x070D: "*",
	0x0712: "b",
	0x0713: "g",
	0x0714: "g",
	0x0715: "d",
	0x0716: "d",
	0x0717: "h",
	0x0718: "w",
	0x0719: "z",
	0x071A: "H",
	0x071B: "t",
	0x071C: "t",
	0x071D: "y",
	0x071E: "yh",
	0x071F: "k",
	0x0720: "l",
	0x0721: "m",
	0x0722: "n",
	0x0723: "s",
	0x0724: "s",
	0x0725: "`",
	0x0726: "p",
	0x0727: "p",
	0x0728: "S",
	0x0729: "q",
	0x072A: "r",
	0x072B: "sh",
	0x072C: "t",
	0x0730: "a",
	0x0731: "a",
	0x0732: "a",
	0x0733: "A",
	0x0734: "A",
	0x0735: "A",
	0x0736: "e",
	0x0737: "e",
	0x0738: "e",
	0x0739: "E",
	0x073A: "i",
	0x073B: "i",
	0x073C: "u",
	0x073D: "u",
	0x073E: "u",
	0x073F: "o",
	0x0741: "`",
	0x0742: "'",
	0x0745: "X",
	0x0746: "Q",
	0x0747: "@",
	0x0748: "@",
	0x0749: "|",
	0x074A: "+",
	0x0780: "h",
	0x0781: "sh",
	0x0782: "n",
	0x0783: "r",
	0x0784: "b",
	0x0785: "L",
	0x0786: "k",
	0x0787: "'",
	0x0788: "v",
	0x0789: "m",
	0x078A: "f",
	0x078B: "dh",
	0x078C: "th",
	0x078D: "l",
	0x078E: "g",
	0x078F: "ny",
	0x0790: "s",
	0x0791: "d",
	0x0792: "z",
	0x0793: "t",
	0x0794: "y",
	0x0795: "p",
	0x0796: "j",
	0x0797: "ch",
	0x0798: "tt",
	0x0799: "hh",
	0x079A: "kh",
	0x079B: "th",
	0x079C: "z",
	0x079D: "sh",
	0x079E: "s",
	0x079F: "d",
	0x07A0: "t",
	0x07A1: "z",
	0x07A2: "`",
	0x07A3: "gh",
	0x07A4: "q",
	0x07A5: "w",
	0x07A6: "a",
	0x07A7: "aa",
	0x07A8: "i",
	0x07A9: "ee",
	0x07AA: "u",
	0x07AB: "oo",
	0x07AC: "e",
	0x07AD: "ey",
	0x07AE: "o",
	0x07AF: "oa",
	0x0901: "N",
	0x0902: "N",
	0x0903: "H",
	0x0905: "a",
	0x0906: "aa",
	0x0907: "i",
	0x0908: "ii",
	0x0909: "u",
	0x090A: "uu",
	0x090B: "R",
	0x090C: "L",
	0x090D: "eN",
	0x090E: "e",
	0x090F: "e",
	0x0910: "ai",
	0x0911: "oN",
	0x0912: "o",
	0x0913: "o",
	0x0914: "au",
	0x0915: "k",
	0x0916: "kh",
	0x0917: "g",
	0x0918: "gh",
	0x0919: "ng",
	0x091A: "c",
	0x091B: "ch",
	0x091C: "j",
	0x091D: "jh",
	0x091E: "ny",
	0x091F: "tt",
	0x0920: "tth",
	0x0921: "dd",
	0x0922: "ddh",
	0x0923: "nn",
	0x0924: "t",
	0x0925: "th",
	0x0926: "d",
	0x0927: "dh",
	0x0928: "n",
	0x0929: "nnn",
	0x092A: "p",
	0x092B: "ph",
	0x092C: "b",
	0x092D: "bh",
	0x092E: "m",
	0x092F: "y",
	0x0930: "r",
	0x0931: "rr",
	0x0932: "l",
	0x0933: "l",
	0x0934: "lll",
	0x0935: "v",
	0x0936: "sh",
	0x0937: "ss",
	0x0938: "s",
	0x0939: "h",
	0x093C: "'",
	0x093D: "'",
	0x093E: "aa",
	0x093F: "i",
	0x0940: "ii",
	0x0941: "u",
	0x0942: "uu",
	0x0943: "R",
	0x0944: "RR",
	0x0945: "eN",
	0x0946: "e",
	0x0947: "e",
	0x0948: "ai",
	0x0949: "oN",
	0x094A: "o",
	0x094B: "o",
	0x094C: "au",
	0x0950: "AUM",
	0x0951: "'",
	0x0952: "'",
	0x0953: "`",
	0x0954: "'",
	0x0958: "q",
	0x0959: "khh",
	0x095A: "ghh",
	0x095B: "z",
	0x095C: "dddh",
	0x095D: "rh",
	0x095E: "f",
	0x095F: "yy",
	0x0960: "RR",
	0x0961: "LL",
	0x0962: "L",
	0x0963: "LL",
	0x0964: " / ",
	0x0965: " // ",
	0x0966: "0",
	0x0967: "1",
	0x0968: "2",
	0x0969: "3",
	0x096A: "4",
	0x096B: "5",
	0x096C: "6",
	0x096D: "7",
	0x096E: "8",
	0x096F: "9",
	0x0970: ".",
	0x0981: "N",
	0x0982: "N",
	0x0983: "H",
	0x0985: "a",
	0x0986: "aa",
	0x0987: "i",
	0x0988: "ii",
	0x0989: "u",
	0x098A: "uu",
	0x098B: "R",
	0x098C: "RR",
	0x098F: "e",
	0x0990: "ai",
	0x0993: "o",
	0x0994: "au",
	0x0995: "k",
	0x0996: "kh",
	0x0997: "g",
	0x0998: "gh",
	0x0999: "ng",
	0x099A: "c",
	0x099B: "ch",
	0x099C: "j",
	0x099D: "jh",
	0x099E: "ny",
	0x099F: "tt",
	0x09A0: "tth",
	0x09A1: "dd",
	0x09A2: "ddh",
	0x09A3: "nn",
	0x09A4: "t",
	0x09A5: "th",
	0x09A6: "d",
	0x09A7: "dh",
	0x09A8: "n",
	0x09AA: "p",
	0x09AB: "ph",
	0x09AC: "b",
	0x09AD: "bh",
	0x09AE: "m",
	0x09AF: "y",
	0x09B0: "r",
	0x09B2: "l",
	0x09B6: "sh",
	0x09B7: "ss",
	0x09B8: "s",
	0x09B9: "h",
	0x09BC: "'",
	0x09BE: "aa",
	0x09BF: "i",
	0x09C0: "ii",
	0x09C1: "u",
	0x09C2: "uu",
	0x09C3: "R",
	0x09C4: "RR",
	0x09C7: "e",
	0x09C8: "ai",
	0x09CB: "o",
	0x09CC: "au",
	0x09D7: "+",
	0x09DC: "rr",
	0x09DD: "rh",
	0x09DF: "yy",
	0x09E0: "RR",
	0x09E1: "LL",
	0x09E2: "L",
	0x09E3: "LL",
	0x09E6: "0",
	0x09E7: "1",
	0x09E8: "2",
	0x09E9: "3",
	0x09EA: "4",
	0x09EB: "5",
	0x09EC: "6",
	0x09ED: "7",
	0x09EE: "8",
	0x09EF: "9",
	0x09F0: "r'",
	0x09F1: "r`",
	0x09F2: "Rs",
	0x09F3: "Rs",
	0x09F4: "1/",
	0x09F5: "2/",
	0x09F6: "3/",
	0x09F7: "4/",
	0x09F8: " 1 - 1/",
	0x09F9: "/16",
	0x0A02: "N",
	0x0A05: "a",
	0x0A06: "aa",
	0x0A07: "i",
	0x0A08: "ii",
	0x0A09: "u",
	0x0A0A: "uu",
	0x0A0F: "ee",
	0x0A10: "ai",
	0x0A13: "oo",
	0x0A14: "au",
	0x0A15: "k",
	0x0A16: "kh",
	0x0A17: "g",
	0x0A18: "gh",
	0x0A19: "ng",
	0x0A1A: "c",
	0x0A1B: "ch",
	0x0A1C: "j",
	0x0A1D: "jh",
	0x0A1E: "ny",
	0x0A1F: "tt",
	0x0A20: "tth",
	0x0A21: "dd",
	0x0A22: "ddh",
	0x0A23: "nn",
	0x0A24: "t",
	0x0A25: "th",
	0x0A26: "d",
	0x0A27: "dh",
	0x0A28: "n",
	0x0A2A: "p",
	0x0A2B: "ph",
	0x0A2C: "b",
	0x0A2D: "bb",
	0x0A2E: "m",
	0x0A2F: "y",
	0x0A30: "r",
	0x0A32: "l",
	0x0A33: "ll",
	0x0A35: "v",
	0x0A36: "sh",
	0x0A38: "s",
	0x0A39: "h",
	0x0A3C: "'",
	0x0A3E: "aa",
	0x0A3F: "i",
	0x0A40: "ii",
	0x0A41: "u",
	0x0A42: "uu",
	0x0A47: "ee",
	0x0A48: "ai",
	0x0A4B: "oo",
	0x0A4C: "au",
	0x0A59: "khh",
	0x0A5A: "ghh",
	0x0A5B: "z",
	0x0A5C: "rr",
	0x0A5E: "f",
	0x0A66: "0",
	0x0A67: "1",
	0x0A68: "2",
	0x0A69: "3",
	0x0A6A: "4",
	0x0A6B: "5",
	0x0A6C: "6",
	0x0A6D: "7",
	0x0A6E: "8",
	0x0A6F: "9",
	0x0A70: "N",
	0x0A71: "H",
	0x0A74: "G.E.O.",
	0x0A81: "N",
	0x0A82: "N",
	0x0A83: "H",
	0x0A85: "a",
	0x0A86: "aa",
	0x0A87: "i",
	0x0A88: "ii",
	0x0A89: "u",
	0x0A8A: "uu",
	0x0A8B: "R",
	0x0A8C: "",
	0x0A8D: "eN",
	0x0A8F: "e",
	0x0A90: "ai",
	0x0A91: "oN",
	0x0A93: "o",
	0x0A94: "au",
	0x0A95: "k",
	0x0A96: "kh",
	0x0A97: "g",
	0x0A98: "gh",
	0x0A99: "ng",
	0x0A9A: "c",
	0x0A9B: "ch",
	0x0A9C: "j",
	0x0A9D: "jh",
	0x0A9E: "ny",
	0x0A9F: "tt",
	0x0AA0: "tth",
	0x0AA1: "dd",
	0x0AA2: "ddh",
	0x0AA3: "nn",
	0x0AA4: "t",
	0x0AA5: "th",
	0x0AA6: "d",
	0x0AA7: "dh",
	0x0AA8: "n",
	0x0AAA: "p",
	0x0AAB: "ph",
	0x0AAC: "b",
	0x0AAD: "bh",
	0x0AAE: "m",
	0x0AAF: "ya",
	0x0AB0: "r",
	0x0AB2: "l",
	0x0AB3: "ll",
	0x0AB5: "v",
	0x0AB6: "sh",
	0x0AB7: "ss",
	0x0AB8: "s",
	0x0AB9: "h",
	0x0ABC: "'",
	0x0ABD: "'",
	0x0ABE: "aa",
	0x0ABF: "i",
	0x0AC0: "ii",
	0x0AC1: "u",
	0x0AC2: "uu",
	0x0AC3: "R",
	0x0AC4: "RR",
	0x0AC5: "eN",
	0x0AC7: "e",
	0x0AC8: "ai",
	0x0AC9: "oN",
	0x0ACB: "o",
	0x0ACC: "au",
	0x0AD0: "AUM",
	0x0AE0: "RR",
	0x0AE6: "0",
	0x0AE7: "1",
	0x0AE8: "2",
	0x0AE9: "3",
	0x0AEA: "4",
	0x0AEB: "5",
	0x0AEC: "6",
	0x0AED: "7",
	0x0AEE: "8",
	0x0AEF: "9",
	0x0B01: "N",
	0x0B02: "N",
	0x0B03: "H",
	0x0B05: "a",
	0x0B06: "aa",
	0x0B07: "i",
	0x0B08: "ii",
	0x0B09: "u",
	0x0B0A: "uu",
	0x0B0B: "R",
	0x0B0C: "L",
	0x0B0F: "e",
	0x0B10: "ai",
	0x0B13: "o",
	0x0B14: "au",
	0x0B15: "k",
	0x0B16: "kh",
	0x0B17: "g",
	0x0B18: "gh",
	0x0B19: "ng",
	0x0B1A: "c",
	0x0B1B: "ch",
	0x0B1C: "j",
	0x0B1D: "jh",
	0x0B1E: "ny",
	0x0B1F: "tt",
	0x0B20: "tth",
	0x0B21: "dd",
	0x0B22: "ddh",
	0x0B23: "nn",
	0x0B24: "t",
	0x0B25: "th",
	0x0B26: "d",
	0x0B27: "dh",
	0x0B28: "n",
	0x0B2A: "p",
	0x0B2B: "ph",
	0x0B2C: "b",
	0x0B2D: "bh",
	0x0B2E: "m",
	0x0B2F: "y",
	0x0B30: "r",
	0x0B32: "l",
	0x0B33: "ll",
	0x0B36: "sh",
	0x0B37: "ss",
	0x0B38: "s",
	0x0B39: "h",
	0x0B3C: "'",
	0x0B3D: "'",
	0x0B3E: "aa",
	0x0B3F: "i",
	0x0B40: "ii",
	0x0B41: "u",
	0x0B42: "uu",
	0x0B43: "R",
	0x0B47: "e",
	0x0B48: "ai",
	0x0B4B: "o",
	0x0B4C: "au",
	0x0B56: "+",
	0x0B57: "+",
	0x0B5C: "rr",
	0x0B5D: "rh",
	0x0B5F: "yy",
	0x0B60: "RR",
	0x0B61: "LL",
	0x0B66: "0",
	0x0B67: "1",
	0x0B68: "2",
	0x0B69: "3",
	0x0B6A: "4",
	0x0B6B: "5",
	0x0B6C: "6",
	0x0B6D: "7",
	0x0B6E: "8",
	0x0B6F: "9",
	0x0B82: "N",
	0x0B83: "H",
	0x0B85: "a",
	0x0B86: "aa",
	0x0B87: "i",
	0x0B88: "ii",
	0x0B89: "u",
	0x0B8A: "uu",
	0x0B8E: "e",
	0x0B8F: "ee",
	0x0B90: "ai",
	0x0B92: "o",
	0x0B93: "oo",
	0x0B94: "au",
	0x0B95: "k",
	0x0B99: "ng",
	0x0B9A: "c",
	0x0B9C: "j",
	0x0B9E: "ny",
	0x0B9F: "tt",
	0x0BA3: "nn",
	0x0BA4: "t",
	0x0BA8: "n",
	0x0BA9: "nnn",
	0x0BAA: "p",
	0x0BAE: "m",
	0x0BAF: "y",
	0x0BB0: "r",
	0x0BB1: "rr",
	0x0BB2: "l",
	0x0BB3: "ll",
	0x0BB4: "lll",
	0x0BB5: "v",
	0x0BB6: "",
	0x0BB7: "ss",
	0x0BB8: "s",
	0x0BB9: "h",
	0x0BBE: "aa",
	0x0BBF: "i",
	0x0BC0: "ii",
	0x0BC1: "u",
	0x0BC2: "uu",
	0x0BC6: "e",
	0x0BC7: "ee",
	0x0BC8: "ai",
	0x0BCA: "o",
	0x0BCB: "oo",
	0x0BCC: "au",
	0x0BD7: "+",
	0x0BE6: "0",
	0x0BE7: "1",
	0x0BE8: "2",
	0x0BE9: "3",
	0x0BEA: "4",
	0x0BEB: "5",
	0x0BEC: "6",
	0x0BED: "7",
	0x0BEE: "8",
	0x0BEF: "9",
	0x0BF0: "+10+",
	0x0BF1: "+100+",
	0x0BF2: "+1000+",
	0x0C01: "N",
	0x0C02: "N",
	0x0C03: "H",
	0x0C05: "a",
	0x0C06: "aa",
	0x0C07: "i",
	0x0C08: "ii",
	0x0C09: "u",
	0x0C0A: "uu",
	0x0C0B: "R",
	0x0C0C: "L",
	0x0C0E: "e",
	0x0C0F: "ee",
	0x0C10: "ai",
	0x0C12: "o",
	0x0C13: "oo",
	0x0C14: "au",
	0x0C15: "k",
	0x0C16: "kh",
	0x0C17: "g",
	0x0C18: "gh",
	0x0C19: "ng",
	0x0C1A: "c",
	0x0C1B: "ch",
	0x0C1C: "j",
	0x0C1D: "jh",
	0x0C1E: "ny",
	0x0C1F: "tt",
	0x0C20: "tth",
	0x0C21: "dd",
	0x0C22: "ddh",
	0x0C23: "nn",
	0x0C24: "t",
	0x0C25: "th",
	0x0C26: "d",
	0x0C27: "dh",
	0x0C28: "n",
	0x0C2A: "p",
	0x0C2B: "ph",
	0x0C2C: "b",
	0x0C2D: "bh",
	0x0C2E: "m",
	0x0C2F: "y",
	0x0C30: "r",
	0x0C31: "rr",
	0x0C32: "l",
	0x0C33: "ll",
	0x0C35: "v",
	0x0C36: "sh",
	0x0C37: "ss",
	0x0C38: "s",
	0x0C39: "h",
	0x0C3E: "aa",
	0x0C3F: "i",
	0x0C40: "ii",
	0x0C41: "u",
	0x0C42: "uu",
	0x0C43: "R",
	0x0C44: "RR",
	0x0C46: "e",
	0x0C47: "ee",
	0x0C48: "ai",
	0x0C4A: "o",
	0x0C4B: "oo",
	0x0C4C: "au",
	0x0C55: "+",
	0x0C56: "+",
	0x0C60: "RR",
	0x0C61: "LL",
	0x0C66: "0",
	0x0C67: "1",
	0x0C68: "2",
	0x0C69: "3",
	0x0C6A: "4",
	0x0C6B: "5",
	0x0C6C: "6",
	0x0C6D: "7",
	0x0C6E: "8",
	0x0C6F: "9",
	0x0C82: "N",
	0x0C83: "H",
	0x0C85: "a",
	0x0C86: "aa",
	0x0C87: "i",
	0x0C88: "ii",
	0x0C89: "u",
	0x0C8A: "uu",
	0x0C8B: "R",
	0x0C8C: "L",
	0x0C8E: "e",
	0x0C8F: "ee",
	0x0C90: "ai",
	0x0C92: "o",
	0x0C93: "oo",
	0x0C94: "au",
	0x0C95: "k",
	0x0C96: "kh",
	0x0C97: "g",
	0x0C98: "gh",
	0x0C99: "ng",
	0x0C9A: "c",
	0x0C9B: "ch",
	0x0C9C: "j",
	0x0C9D: "jh",
	0x0C9E: "ny",
	0x0C9F: "tt",
	0x0CA0: "tth",
	0x0CA1: "dd",
	0x0CA2: "ddh",
	0x0CA3: "nn",
	0x0CA4: "t",
	0x0CA5: "th",
	0x0CA6: "d",
	0x0CA7: "dh",
	0x0CA8: "n",
	0x0CAA: "p",
	0x0CAB: "ph",
	0x0CAC: "b",
	0x0CAD: "bh",
	0x0CAE: "m",
	0x0CAF: "y",
	0x0CB0: "r",
	0x0CB1: "rr",
	0x0CB2: "l",
	0x0CB3: "ll",
	0x0CB5: "v",
	0x0CB6: "sh",
	0x0CB7: "ss",
	0x0CB8: "s",
	0x0CB9: "h",
	0x0CBE: "aa",
	0x0CBF: "i",
	0x0CC0: "ii",
	0x0CC1: "u",
	0x0CC2: "uu",
	0x0CC3: "R",
	0x0CC4: "RR",
	0x0CC6: "e",
	0x0CC7: "ee",
	0x0CC8: "ai",
	0x0CCA: "o",
	0x0CCB: "oo",
	0x0CCC: "au",
	0x0CD5: "+",
	0x0CD6: "+",
	0x0CDE: "lll",
	0x0CE0: "RR",
	0x0CE1: "LL",
	0x0CE6: "0",
	0x0CE7: "1",
	0x0CE8: "2",
	0x0CE9: "3",
	0x0CEA: "4",
	0x0CEB: "5",
	0x0CEC: "6",
	0x0CED: "7",
	0x0CEE: "8",
	0x0CEF: "9",
	0x0D02: "N",
	0x0D03: "H",
	0x0D05: "a",
	0x0D06: "aa",
	0x0D07: "i",
	0x0D08: "ii",
	0x0D09: "u",
	0x0D0A: "uu",
	0x0D0B: "R",
	0x0D0C: "L",
	0x0D0E: "e",
	0x0D0F: "ee",
	0x0D10: "ai",
	0x0D12: "o",
	0x0D13: "oo",
	0x0D14: "au",
	0x0D15: "k",
	0x0D16: "kh",
	0x0D17: "g",
	0x0D18: "gh",
	0x0D19: "ng",
	0x0D1A: "c",
	0x0D1B: "ch",
	0x0D1C: "j",
	0x0D1D: "jh",
	0x0D1E: "ny",
	0x0D1F: "tt",
	0x0D20: "tth",
	0x0D21: "dd",
	0x0D22: "ddh",
	0x0D23: "nn",
	0x0D24: "t",
	0x0D25: "th",
	0x0D26: "d",
	0x0D27: "dh",
	0x0D28: "n",
	0x0D2A: "p",
	0x0D2B: "ph",
	0x0D2C: "b",
	0x0D2D: "bh",
	0x0D2E: "m",
	0x0D2F: "y",
	0x0D30: "r",
	0x0D31: "rr",
	0x0D32: "l",
	0x0D33: "ll",
	0x0D34: "lll",
	0x0D35: "v",
	0x0D36: "sh",
	0x0D37: "ss",
	0x0D38: "s",
	0x0D39: "h",
	0x0D3E: "aa",
	0x0D3F: "i",
	0x0D40: "ii",
	0x0D41: "u",
	0x0D42: "uu",
	0x0D43: "R",
	0x0D46: "e",
	0x0D47: "ee",
	0x0D48: "ai",
	0x0D4A: "o",
	0x0D4B: "oo",
	0x0D4C: "au",
	0x0D57: "+",
	0x0D60: "RR",
	0x0D61: "LL",
	0x0D66: "0",
	0x0D67: "1",
	0x0D68: "2",
	0x0D69: "3",
	0x0D6A: "4",
	0x0D6B: "5",
	0x0D6C: "6",
	0x0D6D: "7",
	0x0D6E: "8",
	0x0D6F: "9",
	0x0D82: "N",
	0x0D83: "H",
	0x0D85: "a",
	0x0D86: "aa",
	0x0D87: "ae",
	0x0D88: "aae",
	0x0D89: "i",
	0x0D8A: "ii",
	0x0D8B: "u",
	0x0D8C: "uu",
	0x0D8D: "R",
	0x0D8E: "RR",
	0x0D8F: "L",
	0x0D90: "LL",
	0x0D91: "e",
	0x0D92: "ee",
	0x0D93: "ai",
	0x0D94: "o",
	0x0D95: "oo",
	0x0D96: "au",
	0x0D9A: "k",
	0x0D9B: "kh",
	0x0D9C: "g",
	0x0D9D: "gh",
	0x0D9E: "ng",
	0x0D9F: "nng",
	0x0DA0: "c",
	0x0DA1: "ch",
	0x0DA2: "j",
	0x0DA3: "jh",
	0x0DA4: "ny",
	0x0DA5: "jny",
	0x0DA6: "nyj",
	0x0DA7: "tt",
	0x0DA8: "tth",
	0x0DA9: "dd",
	0x0DAA: "ddh",
	0x0DAB: "nn",
	0x0DAC: "nndd",
	0x0DAD: "t",
	0x0DAE: "th",
	0x0DAF: "d",
	0x0DB0: "dh",
	0x0DB1: "n",
	0x0DB3: "nd",
	0x0DB4: "p",
	0x0DB5: "ph",
	0x0DB6: "b",
	0x0DB7: "bh",
	0x0DB8: "m",
	0x0DB9: "mb",
	0x0DBA: "y",
	0x0DBB: "r",
	0x0DBD: "l",
	0x0DC0: "v",
	0x0DC1: "sh",
	0x0DC2: "ss",
	0x0DC3: "s",
	0x0DC4: "h",
	0x0DC5: "ll",
	0x0DC6: "f",
	0x0DCF: "aa",
	0x0DD0: "ae",
	0x0DD1: "aae",
	0x0DD2: "i",
	0x0DD3: "ii",
	0x0DD4: "u",
	0x0DD6: "uu",
	0x0DD8: "R",
	0x0DD9: "e",
	0x0DDA: "ee",
	0x0DDB: "ai",
	0x0DDC: "o",
	0x0DDD: "oo",
	0x0DDE: "au",
	0x0DDF: "L",
	0x0DF2: "RR",
	0x0DF3: "LL",
	0x0DF4: " . ",
	0x0E01: "k",
	0x0E02: "kh",
	0x0E03: "kh",
	0x0E04: "kh",
	0x0E05: "kh",
	0x0E06: "kh",
	0x0E07: "ng",
	0x0E08: "cch",
	0x0E09: "ch",
	0x0E0A: "ch",
	0x0E0B: "ch",
	0x0E0C: "ch",
	0x0E0D: "y",
	0x0E0E: "d",
	0x0E0F: "t",
	0x0E10: "th",
	0x0E11: "th",
	0x0E12: "th",
	0x0E13: "n",
	0x0E14: "d",
	0x0E15: "t",
	0x0E16: "th",
	0x0E17: "th",
	0x0E18: "th",
	0x0E19: "n",
	0x0E1A: "b",
	0x0E1B: "p",
	0x0E1C: "ph",
	0x0E1D: "f",
	0x0E1E: "ph",
	0x0E1F: "f",
	0x0E20: "ph",
	0x0E21: "m",
	0x0E22: "y",
	0x0E23: "r",
	0x0E24: "R",
	0x0E25: "l",
	0x0E26: "L",
	0x0E27: "w",
	0x0E28: "s",
	0x0E29: "s",
	0x0E2A: "s",
	0x0E2B: "h",
	0x0E2C: "l",
	0x0E2D: "`",
	0x0E2E: "h",
	0x0E2F: "~",
	0x0E30: "a",
	0x0E31: "a",
	0x0E32: "aa",
	0x0E33: "am",
	0x0E34: "i",
	0x0E35: "ii",
	0x0E36: "ue",
	0x0E37: "uue",
	0x0E38: "u",
	0x0E39: "uu",
	0x0E3F: "Bh.",
	0x0E40: "e",
	0x0E41: "ae",
	0x0E42: "o",
	0x0E43: "ai",
	0x0E44: "ai",
	0x0E45: "ao",
	0x0E46: "+",
	0x0E4D: "M",
	0x0E4F: " * ",
	0x0E50: "0",
	0x0E51: "1",
	0x0E52: "2",
	0x0E53: "3",
	0x0E54: "4",
	0x0E55: "5",
	0x0E56: "6",
	0x0E57: "7",
	0x0E58: "8",
	0x0E59: "9",
	0x0E5A: " // ",
	0x0E5B: " /// ",
	0x0E81: "k",
	0x0E82: "kh",
	0x0E84: "kh",
	0x0E87: "ng",
	0x0E88: "ch",
	0x0E8A: "s",
	0x0E8D: "ny",
	0x0E94: "d",
	0x0E95: "h",
	0x0E96: "th",
	0x0E97: "th",
	0x0E99: "n",
	0x0E9A: "b",
	0x0E9B: "p",
	0x0E9C: "ph",
	0x0E9D: "f",
	0x0E9E: "ph",
	0x0E9F: "f",
	0x0EA1: "m",
	0x0EA2: "y",
	0x0EA3: "r",
	0x0EA5: "l",
	0x0EA7: "w",
	0x0EAA: "s",
	0x0EAB: "h",
	0x0EAD: "`",
	0x0EAF: "~",
	0x0EB0: "a",
	0x0EB2: "aa",
	0x0EB3: "am",
	0x0EB4: "i",
	0x0EB5: "ii",
	0x0EB6: "y",
	0x0EB7: "yy",
	0x0EB8: "u",
	0x0EB9: "uu",
	0x0EBB: "o",
	0x0EBC: "l",
	0x0EBD: "ny",
	0x0EC0: "e",
	0x0EC1: "ei",
	0x0EC2: "o",
	0x0EC3: "ay",
	0x0EC4: "ai",
	0x0EC6: "+",
	0x0ECD: "M",
	0x0ED0: "0",
	0x0ED1: "1",
	0x0ED2: "2",
	0x0ED3: "3",
	0x0ED4: "4",
	0x0ED5: "5",
	0x0ED6: "6",
	0x0ED7: "7",
	0x0ED8: "8",
	0x0ED9: "9",
	0x0EDC: "hn",
	0x0EDD: "hm",
	0x0F00: "AUM",
	0x0F08: " // ",
	0x0F09: " * ",
	0x0F0B: "-",
	0x0F0C: " / ",
	0x0F0D: " / ",
	0x0F0E: " // ",
	0x0F0F: " -/ ",
	0x0F10: " +/ ",
	0x0F11: " X/ ",
	0x0F12: " /XX/ ",
	0x0F13: " /X/ ",
	0x0F14: ", ",
	0x0F20: "0",
	0x0F21: "1",
	0x0F22: "2",
	0x0F23: "3",
	0x0F24: "4",
	0x0F25: "5",
	0x0F26: "6",
	0x0F27: "7",
	0x0F28: "8",
	0x0F29: "9",
	0x0F2A: ".5",
	0x0F2B: "1.5",
	0x0F2C: "2.5",
	0x0F2D: "3.5",
	0x0F2E: "4.5",
	0x0F2F: "5.5",
	0x0F30: "6.5",
	0x0F31: "7.5",
	0x0F32: "8.5",
	0x0F33: "-.5",
	0x0F34: "+",
	0x0F35: "*",
	0x0F36: "^",
	0x0F37: "_",
	0x0F39: "~",
	0x0F3B: "]",
	0x0F3C: "[[",
	0x0F3D: "]]",
	0x0F40: "k",
	0x0F41: "kh",
	0x0F42: "g",
	0x0F43: "gh",
	0x0F44: "ng",
	0x0F45: "c",
	0x0F46: "ch",
	0x0F47: "j",
	0x0F49: "ny",
	0x0F4A: "tt",
	0x0F4B: "tth",
	0x0F4C: "dd",
	0x0F4D: "ddh",
	0x0F4E: "nn",
	0x0F4F: "t",
	0x0F50: "th",
	0x0F51: "d",
	0x0F52: "dh",
	0x0F53: "n",
	0x0F54: "p",
	0x0F55: "ph",
	0x0F56: "b",
	0x0F57: "bh",
	0x0F58: "m",
	0x0F59: "ts",
	0x0F5A: "tsh",
	0x0F5B: "dz",
	0x0F5C: "dzh",
	0x0F5D: "w",
	0x0F5E: "zh",
	0x0F5F: "z",
	0x0F60: "'",
	0x0F61: "y",
	0x0F62: "r",
	0x0F63: "l",
	0x0F64: "sh",
	0x0F65: "ssh",
	0x0F66: "s",
	0x0F67: "h",
	0x0F68: "a",
	0x0F69: "kss",
	0x0F6A: "r",
	0x0F71: "aa",
	0x0F72: "i",
	0x0F73: "ii",
	0x0F74: "u",
	0x0F75: "uu",
	0x0F76: "R",
	0x0F77: "RR",
	0x0F78: "L",
	0x0F79: "LL",
	0x0F7A: "e",
	0x0F7B: "ee",
	0x0F7C: "o",
	0x0F7D: "oo",
	0x0F7E: "M",
	0x0F7F: "H",
	0x0F80: "i",
	0x0F81: "ii",
	0x0F90: "k",
	0x0F91: "kh",
	0x0F92: "g",
	0x0F93: "gh",
	0x0F94: "ng",
	0x0F95: "c",
	0x0F96: "ch",
	0x0F97: "j",
	0x0F99: "ny",
	0x0F9A: "tt",
	0x0F9B: "tth",
	0x0F9C: "dd",
	0x0F9D: "ddh",
	0x0F9E: "nn",
	0x0F9F: "t",
	0x0FA0: "th",
	0x0FA1: "d",
	0x0FA2: "dh",
	0x0FA3: "n",
	0x0FA4: "p",
	0x0FA5: "ph",
	0x0FA6: "b",
	0x0FA7: "bh",
	0x0FA8: "m",
	0x0FA9: "ts",
	0x0FAA: "tsh",
	0x0FAB: "dz",
	0x0FAC: "dzh",
	0x0FAD: "w",
	0x0FAE: "zh",
	0x0FAF: "z",
	0x0FB0: "'",
	0x0FB1: "y",
	0x0FB2: "r",
	0x0FB3: "l",
	0x0FB4: "sh",
	0x0FB5: "ss",
	0x0FB6: "s",
	0x0FB7: "h",
	0x0FB8: "a",
	0x0FB9: "kss",
	0x0FBA: "w",
	0x0FBB: "y",
	0x0FBC: "r",
	0x0FBE: "X",
	0x0FBF: " :X: ",
	0x0FC0: " /O/ ",
	0x0FC1: " /o/ ",
	0x0FC2: " \\o\\ ",
	0x0FC3: " (O) ",
	0x1000: "k",
	0x1001: "kh",
	0x1002: "g",
	0x1003: "gh",
	0x1004: "ng",
	0x1005: "c",
	0x1006: "ch",
	0x1007: "j",
	0x1008: "jh",
	0x1009: "ny",
	0x100A: "nny",
	0x100B: "tt",
	0x100C: "tth",
	0x100D: "dd",
	0x100E: "ddh",
	0x100F: "nn",
	0x1010: "tt",
	0x1011: "th",
	0x1012: "d",
	0x1013: "dh",
	0x1014: "n",
	0x1015: "p",
	0x1016: "ph",
	0x1017: "b",
	0x1018: "bh",
	0x1019: "m",
	0x101A: "y",
	0x101B: "r",
	0x101C: "l",
	0x101D: "w",
	0x101E: "s",
	0x101F: "h",
	0x1020: "ll",
	0x1021: "a",
	0x1023: "i",
	0x1024: "ii",
	0x1025: "u",
	0x1026: "uu",
	0x1027: "e",
	0x1029: "o",
	0x102A: "au",
	0x102C: "aa",
	0x102D: "i",
	0x102E: "ii",
	0x102F: "u",
	0x1030: "uu",
	0x1031: "e",
	0x1032: "ai",
	0x1036: "N",
	0x1037: "'",
	0x1038: ":",
	0x1040: "0",
	0x1041: "1",
	0x1042: "2",
	0x1043: "3",
	0x1044: "4",
	0x1045: "5",
	0x1046: "6",
	0x1047: "7",
	0x1048: "8",
	0x1049: "9",
	0x104A: " / ",
	0x104B: " // ",
	0x104C: "n*",
	0x104D: "r*",
	0x104E: "l*",
	0x104F: "e*",
	0x1050: "sh",
	0x1051: "ss",
	0x1052: "R",
	0x1053: "RR",
	0x1054: "L",
	0x1055: "LL",
	0x1056: "R",
	0x1057: "RR",
	0x1058: "L",
	0x1059: "LL",
	0x10A0: "A",
	0x10A1: "B",
	0x10A2: "G",
	0x10A3: "D",
	0x10A4: "E",
	0x10A5: "V",
	0x10A6: "Z",
	0x10A7: "T`",
	0x10A8: "I",
	0x10A9: "K",
	0x10AA: "L",
	0x10AB: "M",
	0x10AC: "N",
	0x10AD: "O",
	0x10AE: "P",
	0x10AF: "Zh",
	0x10B0: "R",
	0x10B1: "S",
	0x10B2: "T",
	0x10B3: "U",
	0x10B4: "P`",
	0x10B5: "K`",
	0x10B6: "G'",
	0x10B7: "Q",
	0x10B8: "Sh",
	0x10B9: "Ch`",
	0x10BA: "C`",
	0x10BB: "Z'",
	0x10BC: "C",
	0x10BD: "Ch",
	0x10BE: "X",
	0x10BF: "J",
	0x10C0: "H",
	0x10C1: "E",
	0x10C2: "Y",
	0x10C3: "W",
	0x10C4: "Xh",
	0x10C5: "OE",
	0x10D0: "a",
	0x10D1: "b",
	0x10D2: "g",
	0x10D3: "d",
	0x10D4: "e",
	0x10D5: "v",
	0x10D6: "z",
	0x10D7: "t`",
	0x10D8: "i",
	0x10D9: "k",
	0x10DA: "l",
	0x10DB: "m",
	0x10DC: "n",
	0x10DD: "o",
	0x10DE: "p",
	0x10DF: "zh",
	0x10E0: "r",
	0x10E1: "s",
	0x10E2: "t",
	0x10E3: "u",
	0x10E4: "p`",
	0x10E5: "k`",
	0x10E6: "g'",
	0x10E7: "q",
	0x10E8: "sh",
	0x10E9: "ch`",
	0x10EA: "c`",
	0x10EB: "z'",
	0x10EC: "c",
	0x10ED: "ch",
	0x10EE: "x",
	0x10EF: "j",
	0x10F0: "h",
	0x10F1: "e",
	0x10F2: "y",
	0x10F3: "w",
	0x10F4: "xh",
	0x10F5: "oe",
	0x10F6: "f",
	0x10FB: " // ",
	0x1100: "g",
	0x1101: "gg",
	0x1102: "n",
	0x1103: "d",
	0x1104: "dd",
	0x1105: "r",
	0x1106: "m",
	0x1107: "b",
	0x1108: "bb",
	0x1109: "s",
	0x110A: "ss",
	0x110C: "j",
	0x110D: "jj",
	0x110E: "c",
	0x110F: "k",
	0x1110: "t",
	0x1111: "p",
	0x1112: "h",
	0x1113: "ng",
	0x1114: "nn",
	0x1115: "nd",
	0x1116: "nb",
	0x1117: "dg",
	0x1118: "rn",
	0x1119: "rr",
	0x111A: "rh",
	0x111B: "rN",
	0x111C: "mb",
	0x111D: "mN",
	0x111E: "bg",
	0x111F: "bn",
	0x1121: "bs",
	0x1122: "bsg",
	0x1123: "bst",
	0x1124: "bsb",
	0x1125: "bss",
	0x1126: "bsj",
	0x1127: "bj",
	0x1128: "bc",
	0x1129: "bt",
	0x112A: "bp",
	0x112B: "bN",
	0x112C: "bbN",
	0x112D: "sg",
	0x112E: "sn",
	0x112F: "sd",
	0x1130: "sr",
	0x1131: "sm",
	0x1132: "sb",
	0x1133: "sbg",
	0x1134: "sss",
	0x1135: "s",
	0x1136: "sj",
	0x1137: "sc",
	0x1138: "sk",
	0x1139: "st",
	0x113A: "sp",
	0x113B: "sh",
	0x1140: "Z",
	0x1141: "g",
	0x1142: "d",
	0x1143: "m",
	0x1144: "b",
	0x1145: "s",
	0x1146: "Z",
	0x1148: "j",
	0x1149: "c",
	0x114A: "t",
	0x114B: "p",
	0x114C: "N",
	0x114D: "j",
	0x1152: "ck",
	0x1153: "ch",
	0x1156: "pb",
	0x1157: "pN",
	0x1158: "hh",
	0x1159: "Q",
	0x1161: "a",
	0x1162: "ae",
	0x1163: "ya",
	0x1164: "yae",
	0x1165: "eo",
	0x1166: "e",
	0x1167: "yeo",
	0x1168: "ye",
	0x1169: "o",
	0x116A: "wa",
	0x116B: "wae",
	0x116C: "oe",
	0x116D: "yo",
	0x116E: "u",
	0x116F: "weo",
	0x1170: "we",
	0x1171: "wi",
	0x1172: "yu",
	0x1173: "eu",
	0x1174: "yi",
	0x1175: "i",
	0x1176: "a-o",
	0x1177: "a-u",
	0x1178: "ya-o",
	0x1179: "ya-yo",
	0x117A: "eo-o",
	0x117B: "eo-u",
	0x117C: "eo-eu",
	0x117D: "yeo-o",
	0x117E: "yeo-u",
	0x117F: "o-eo",
	0x1180: "o-e",
	0x1181: "o-ye",
	0x1182: "o-o",
	0x1183: "o-u",
	0x1184: "yo-ya",
	0x1185: "yo-yae",
	0x1186: "yo-yeo",
	0x1187: "yo-o",
	0x1188: "yo-i",
	0x1189: "u-a",
	0x118A: "u-ae",
	0x118B: "u-eo-eu",
	0x118C: "u-ye",
	0x118D: "u-u",
	0x118E: "yu-a",
	0x118F: "yu-eo",
	0x1190: "yu-e",
	0x1191: "yu-yeo",
	0x1192: "yu-ye",
	0x1193: "yu-u",
	0x1194: "yu-i",
	0x1195: "eu-u",
	0x1196: "eu-eu",
	0x1197: "yi-u",
	0x1198: "i-a",
	0x1199: "i-ya",
	0x119A: "i-o",
	0x119B: "i-u",
	0x119C: "i-eu",
	0x119D: "i-U",
	0x119E: "U",
	0x119F: "U-eo",
	0x11A0: "U-u",
	0x11A1: "U-i",
	0x11A2: "UU",
	0x11A8: "g",
	0x11A9: "gg",
	0x11AA: "gs",
	0x11AB: "n",
	0x11AC: "nj",
	0x11AD: "nh",
	0x11AE: "d",
	0x11AF: "l",
	0x11B0: "lg",
	0x11B1: "lm",
	0x11B2: "lb",
	0x11B3: "ls",
	0x11B4: "lt",
	0x11B5: "lp",
	0x11B6: "lh",
	0x11B7: "m",
	0x11B8: "b",
	0x11B9: "bs",
	0x11BA: "s",
	0x11BB: "ss",
	0x11BC: "ng",
	0x11BD: "j",
	0x11BE: "c",
	0x11BF: "k",
	0x11C0: "t",
	0x11C1: "p",
	0x11C2: "h",
	0x11C3: "gl",
	0x11C4: "gsg",
	0x11C5: "ng",
	0x11C6: "nd",
	0x11C7: "ns",
	0x11C8: "nZ",
	0x11C9: "nt",
	0x11CA: "dg",
	0x11CB: "tl",
	0x11CC: "lgs",
	0x11CD: "ln",
	0x11CE: "ld",
	0x11CF: "lth",
	0x11D0: "ll",
	0x11D1: "lmg",
	0x11D2: "lms",
	0x11D3: "lbs",
	0x11D4: "lbh",
	0x11D5: "rNp",
	0x11D6: "lss",
	0x11D7: "lZ",
	0x11D8: "lk",
	0x11D9: "lQ",
	0x11DA: "mg",
	0x11DB: "ml",
	0x11DC: "mb",
	0x11DD: "ms",
	0x11DE: "mss",
	0x11DF: "mZ",
	0x11E0: "mc",
	0x11E1: "mh",
	0x11E2: "mN",
	0x11E3: "bl",
	0x11E4: "bp",
	0x11E5: "ph",
	0x11E6: "pN",
	0x11E7: "sg",
	0x11E8: "sd",
	0x11E9: "sl",
	0x11EA: "sb",
	0x11EB: "Z",
	0x11EC: "g",
	0x11ED: "ss",
	0x11EE: "",
	0x11EF: "kh",
	0x11F0: "N",
	0x11F1: "Ns",
	0x11F2: "NZ",
	0x11F3: "pb",
	0x11F4: "pN",
	0x11F5: "hn",
	0x11F6: "hl",
	0x11F7: "hm",
	0x11F8: "hb",
	0x11F9: "Q",
	0x1200: "ha",
	0x1201: "hu",
	0x1202: "hi",
	0x1203: "haa",
	0x1204: "hee",
	0x1205: "he",
	0x1206: "ho",
	0x1208: "la",
	0x1209: "lu",
	0x120A: "li",
	0x120B: "laa",
	0x120C: "lee",
	0x120D: "le",
	0x120E: "lo",
	0x120F: "lwa",
	0x1210: "hha",
	0x1211: "hhu",
	0x1212: "hhi",
	0x1213: "hhaa",
	0x1214: "hhee",
	0x1215: "hhe",
	0x1216: "hho",
	0x1217: "hhwa",
	0x1218: "ma",
	0x1219: "mu",
	0x121A: "mi",
	0x121B: "maa",
	0x121C: "mee",
	0x121D: "me",
	0x121E: "mo",
	0x121F: "mwa",
	0x1220: "sza",
	0x1221: "szu",
	0x1222: "szi",
	0x1223: "szaa",
	0x1224: "szee",
	0x1225: "sze",
	0x1226: "szo",
	0x1227: "szwa",
	0x1228: "ra",
	0x1229: "ru",
	0x122A: "ri",
	0x122B: "raa",
	0x122C: "ree",
	0x122D: "re",
	0x122E: "ro",
	0x122F: "rwa",
	0x1230: "sa",
	0x1231: "su",
	0x1232: "si",
	0x1233: "saa",
	0x1234: "see",
	0x1235: "se",
	0x1236: "so",
	0x1237: "swa",
	0x1238: "sha",
	0x1239: "shu",
	0x123A: "shi",
	0x123B: "shaa",
	0x123C: "shee",
	0x123D: "she",
	0x123E: "sho",
	0x123F: "shwa",
	0x1240: "qa",
	0x1241: "qu",
	0x1242: "qi",
	0x1243: "qaa",
	0x1244: "qee",
	0x1245: "qe",
	0x1246: "qo",
	0x1247: "",
	0x1248: "qwa",
	0x124A: "qwi",
	0x124B: "qwaa",
	0x124C: "qwee",
	0x124D: "qwe",
	0x1250: "qha",
	0x1251: "qhu",
	0x1252: "qhi",
	0x1253: "qhaa",
	0x1254: "qhee",
	0x1255: "qhe",
	0x1256: "qho",
	0x1258: "qhwa",
	0x125A: "qhwi",
	0x125B: "qhwaa",
	0x125C: "qhwee",
	0x125D: "qhwe",
	0x1260: "ba",
	0x1261: "bu",
	0x1262: "bi",
	0x1263: "baa",
	0x1264: "bee",
	0x1265: "be",
	0x1266: "bo",
	0x1267: "bwa",
	0x1268: "va",
	0x1269: "vu",
	0x126A: "vi",
	0x126B: "vaa",
	0x126C: "vee",
	0x126D: "ve",
	0x126E: "vo",
	0x126F: "vwa",
	0x1270: "ta",
	0x1271: "tu",
	0x1272: "ti",
	0x1273: "taa",
	0x1274: "tee",
	0x1275: "te",
	0x1276: "to",
	0x1277: "twa",
	0x1278: "ca",
	0x1279: "cu",
	0x127A: "ci",
	0x127B: "caa",
	0x127C: "cee",
	0x127D: "ce",
	0x127E: "co",
	0x127F: "cwa",
	0x1280: "xa",
	0x1281: "xu",
	0x1282: "xi",
	0x1283: "xaa",
	0x1284: "xee",
	0x1285: "xe",
	0x1286: "xo",
	0x1288: "xwa",
	0x128A: "xwi",
	0x128B: "xwaa",
	0x128C: "xwee",
	0x128D: "xwe",
	0x1290: "na",
	0x1291: "nu",
	0x1292: "ni",
	0x1293: "naa",
	0x1294: "nee",
	0x1295: "ne",
	0x1296: "no",
	0x1297: "nwa",
	0x1298: "nya",
	0x1299: "nyu",
	0x129A: "nyi",
	0x129B: "nyaa",
	0x129C: "nyee",
	0x129D: "nye",
	0x129E: "nyo",
	0x129F: "nywa",
	0x12A0: "'a",
	0x12A1: "'u",
	0x12A3: "'aa",
	0x12A4: "'ee",
	0x12A5: "'e",
	0x12A6: "'o",
	0x12A7: "'wa",
	0x12A8: "ka",
	0x12A9: "ku",
	0x12AA: "ki",
	0x12AB: "kaa",
	0x12AC: "kee",
	0x12AD: "ke",
	0x12AE: "ko",
	0x12B0: "kwa",
	0x12B2: "kwi",
	0x12B3: "kwaa",
	0x12B4: "kwee",
	0x12B5: "kwe",
	0x12B8: "kxa",
	0x12B9: "kxu",
	0x12BA: "kxi",
	0x12BB: "kxaa",
	0x12BC: "kxee",
	0x12BD: "kxe",
	0x12BE: "kxo",
	0x12C0: "kxwa",
	0x12C2: "kxwi",
	0x12C3: "kxwaa",
	0x12C4: "kxwee",
	0x12C5: "kxwe",
	0x12C8: "wa",
	0x12C9: "wu",
	0x12CA: "wi",
	0x12CB: "waa",
	0x12CC: "wee",
	0x12CD: "we",
	0x12CE: "wo",
	0x12D0: "`a",
	0x12D1: "`u",
	0x12D2: "`i",
	0x12D3: "`aa",
	0x12D4: "`ee",
	0x12D5: "`e",
	0x12D6: "`o",
	0x12D8: "za",
	0x12D9: "zu",
	0x12DA: "zi",
	0x12DB: "zaa",
	0x12DC: "zee",
	0x12DD: "ze",
	0x12DE: "zo",
	0x12DF: "zwa",
	0x12E0: "zha",
	0x12E1: "zhu",
	0x12E2: "zhi",
	0x12E3: "zhaa",
	0x12E4: "zhee",
	0x12E5: "zhe",
	0x12E6: "zho",
	0x12E7: "zhwa",
	0x12E8: "ya",
	0x12E9: "yu",
	0x12EA: "yi",
	0x12EB: "yaa",
	0x12EC: "yee",
	0x12ED: "ye",
	0x12EE: "yo",
	0x12F0: "da",
	0x12F1: "du",
	0x12F2: "di",
	0x12F3: "daa",
	0x12F4: "dee",
	0x12F5: "de",
	0x12F6: "do",
	0x12F7: "dwa",
	0x12F8: "dda",
	0x12F9: "ddu",
	0x12FA: "ddi",
	0x12FB: "ddaa",
	0x12FC: "ddee",
	0x12FD: "dde",
	0x12FE: "ddo",
	0x12FF: "ddwa",
	0x1300: "ja",
	0x1301: "ju",
	0x1302: "ji",
	0x1303: "jaa",
	0x1304: "jee",
	0x1305: "je",
	0x1306: "jo",
	0x1307: "jwa",
	0x1308: "ga",
	0x1309: "gu",
	0x130A: "gi",
	0x130B: "gaa",
	0x130C: "gee",
	0x130D: "ge",
	0x130E: "go",
	0x1310: "gwa",
	0x1312: "gwi",
	0x1313: "gwaa",
	0x1314: "gwee",
	0x1315: "gwe",
	0x1318: "gga",
	0x1319: "ggu",
	0x131A: "ggi",
	0x131B: "ggaa",
	0x131C: "ggee",
	0x131D: "gge",
	0x131E: "ggo",
	0x1320: "tha",
	0x1321: "thu",
	0x1322: "thi",
	0x1323: "thaa",
	0x1324: "thee",
	0x1325: "the",
	0x1326: "tho",
	0x1327: "thwa",
	0x1328: "cha",
	0x1329: "chu",
	0x132A: "chi",
	0x132B: "chaa",
	0x132C: "chee",
	0x132D: "che",
	0x132E: "cho",
	0x132F: "chwa",
	0x1330: "pha",
	0x1331: "phu",
	0x1332: "phi",
	0x1333: "phaa",
	0x1334: "phee",
	0x1335: "phe",
	0x1336: "pho",
	0x1337: "phwa",
	0x1338: "tsa",
	0x1339: "tsu",
	0x133A: "tsi",
	0x133B: "tsaa",
	0x133C: "tsee",
	0x133D: "tse",
	0x133E: "tso",
	0x133F: "tswa",
	0x1340: "tza",
	0x1341: "tzu",
	0x1342: "tzi",
	0x1343: "tzaa",
	0x1344: "tzee",
	0x1345: "tze",
	0x1346: "tzo",
	0x1348: "fa",
	0x1349: "fu",
	0x134A: "fi",
	0x134B: "faa",
	0x134C: "fee",
	0x134D: "fe",
	0x134E: "fo",
	0x134F: "fwa",
	0x1350: "pa",
	0x1351: "pu",
	0x1352: "pi",
	0x1353: "paa",
	0x1354: "pee",
	0x1355: "pe",
	0x1356: "po",
	0x1357: "pwa",
	0x1358: "rya",
	0x1359: "mya",
	0x135A: "fya",
	0x1362: ".",
	0x1363: ",",
	0x1364: ";",
	0x1365: ":",
	0x1366: ":: ",
	0x1367: "?",
	0x1368: "//",
	0x1369: "1",
	0x136A: "2",
	0x136B: "3",
	0x136C: "4",
	0x136D: "5",
	0x136E: "6",
	0x136F: "7",
	0x1370: "8",
	0x1371: "9",
	0x1372: "10+",
	0x1373: "20+",
	0x1374: "30+",
	0x1375: "40+",
	0x1376: "50+",
	0x1377: "60+",
	0x1378: "70+",
	0x1379: "80+",
	0x137A: "90+",
	0x137B: "100+",
	0x137C: "10,000+",
	0x13A0: "a",
	0x13A1: "e",
	0x13A2: "i",
	0x13A3: "o",
	0x13A4: "u",
	0x13A5: "v",
	0x13A6: "ga",
	0x13A7: "ka",
	0x13A8: "ge",
	0x13A9: "gi",
	0x13AA: "go",
	0x13AB: "gu",
	0x13AC: "gv",
	0x13AD: "ha",
	0x13AE: "he",
	0x13AF: "hi",
	0x13B0: "ho",
	0x13B1: "hu",
	0x13B2: "hv",
	0x13B3: "la",
	0x13B4: "le",
	0x13B5: "li",
	0x13B6: "lo",
	0x13B7: "lu",
	0x13B8: "lv",
	0x13B9: "ma",
	0x13BA: "me",
	0x13BB: "mi",
	0x13BC: "mo",
	0x13BD: "mu",
	0x13BE: "na",
	0x13BF: "hna",
	0x13C0: "nah",
	0x13C1: "ne",
	0x13C2: "ni",
	0x13C3: "no",
	0x13C4: "nu",
	0x13C5: "nv",
	0x13C6: "qua",
	0x13C7: "que",
	0x13C8: "qui",
	0x13C9: "quo",
	0x13CA: "quu",
	0x13CB: "quv",
	0x13CC: "sa",
	0x13CD: "s",
	0x13CE: "se",
	0x13CF: "si",
	0x13D0: "so",
	0x13D1: "su",
	0x13D2: "sv",
	0x13D3: "da",
	0x13D4: "ta",
	0x13D5: "de",
	0x13D6: "te",
	0x13D7: "di",
	0x13D8: "ti",
	0x13D9: "do",
	0x13DA: "du",
	0x13DB: "dv",
	0x13DC: "dla",
	0x13DD: "tla",
	0x13DE: "tle",
	0x13DF: "tli",
	0x13E0: "tlo",
	0x13E1: "tlu",
	0x13E2: "tlv",
	0x13E3: "tsa",
	0x13E4: "tse",
	0x13E5: "tsi",
	0x13E6: "tso",
	0x13E7: "tsu",
	0x13E8: "tsv",
	0x13E9: "wa",
	0x13EA: "we",
	0x13EB: "wi",
	0x13EC: "wo",
	0x13ED: "wu",
	0x13EE: "wv",
	0x13EF: "ya",
	0x13F0: "ye",
	0x13F1: "yi",
	0x13F2: "yo",
	0x13F3: "yu",
	0x13F4: "yv",
	0x1401: "e",
	0x1402: "aai",
	0x1403: "i",
	0x1404: "ii",
	0x1405: "o",
	0x1406: "oo",
	0x1407: "oo",
	0x1408: "ee",
	0x1409: "i",
	0x140A: "a",
	0x140B: "aa",
	0x140C: "we",
	0x140D: "we",
	0x140E: "wi",
	0x140F: "wi",
	0x1410: "wii",
	0x1411: "wii",
	0x1412: "wo",
	0x1413: "wo",
	0x1414: "woo",
	0x1415: "woo",
	0x1416: "woo",
	0x1417: "wa",
	0x1418: "wa",
	0x1419: "waa",
	0x141A: "waa",
	0x141B: "waa",
	0x141C: "ai",
	0x141D: "w",
	0x141E: "'",
	0x141F: "t",
	0x1420: "k",
	0x1421: "sh",
	0x1422: "s",
	0x1423: "n",
	0x1424: "w",
	0x1425: "n",
	0x1427: "w",
	0x1428: "c",
	0x1429: "?",
	0x142A: "l",
	0x142B: "en",
	0x142C: "in",
	0x142D: "on",
	0x142E: "an",
	0x142F: "pe",
	0x1430: "paai",
	0x1431: "pi",
	0x1432: "pii",
	0x1433: "po",
	0x1434: "poo",
	0x1435: "poo",
	0x1436: "hee",
	0x1437: "hi",
	0x1438: "pa",
	0x1439: "paa",
	0x143A: "pwe",
	0x143B: "pwe",
	0x143C: "pwi",
	0x143D: "pwi",
	0x143E: "pwii",
	0x143F: "pwii",
	0x1440: "pwo",
	0x1441: "pwo",
	0x1442: "pwoo",
	0x1443: "pwoo",
	0x1444: "pwa",
	0x1445: "pwa",
	0x1446: "pwaa",
	0x1447: "pwaa",
	0x1448: "pwaa",
	0x1449: "p",
	0x144A: "p",
	0x144B: "h",
	0x144C: "te",
	0x144D: "taai",
	0x144E: "ti",
	0x144F: "tii",
	0x1450: "to",
	0x1451: "too",
	0x1452: "too",
	0x1453: "dee",
	0x1454: "di",
	0x1455: "ta",
	0x1456: "taa",
	0x1457: "twe",
	0x1458: "twe",
	0x1459: "twi",
	0x145A: "twi",
	0x145B: "twii",
	0x145C: "twii",
	0x145D: "two",
	0x145E: "two",
	0x145F: "twoo",
	0x1460: "twoo",
	0x1461: "twa",
	0x1462: "twa",
	0x1463: "twaa",
	0x1464: "twaa",
	0x1465: "twaa",
	0x1466: "t",
	0x1467: "tte",
	0x1468: "tti",
	0x1469: "tto",
	0x146A: "tta",
	0x146B: "ke",
	0x146C: "kaai",
	0x146D: "ki",
	0x146E: "kii",
	0x146F: "ko",
	0x1470: "koo",
	0x1471: "koo",
	0x1472: "ka",
	0x1473: "kaa",
	0x1474: "kwe",
	0x1475: "kwe",
	0x1476: "kwi",
	0x1477: "kwi",
	0x1478: "kwii",
	0x1479: "kwii",
	0x147A: "kwo",
	0x147B: "kwo",
	0x147C: "kwoo",
	0x147D: "kwoo",
	0x147E: "kwa",
	0x147F: "kwa",
	0x1480: "kwaa",
	0x1481: "kwaa",
	0x1482: "kwaa",
	0x1483: "k",
	0x1484: "kw",
	0x1485: "keh",
	0x1486: "kih",
	0x1487: "koh",
	0x1488: "kah",
	0x1489: "ce",
	0x148A: "caai",
	0x148B: "ci",
	0x148C: "cii",
	0x148D: "co",
	0x148E: "coo",
	0x148F: "coo",
	0x1490: "ca",
	0x1491: "caa",
	0x1492: "cwe",
	0x1493: "cwe",
	0x1494: "cwi",
	0x1495: "cwi",
	0x1496: "cwii",
	0x1497: "cwii",
	0x1498: "cwo",
	0x1499: "cwo",
	0x149A: "cwoo",
	0x149B: "cwoo",
	0x149C: "cwa",
	0x149D: "cwa",
	0x149E: "cwaa",
	0x149F: "cwaa",
	0x14A0: "cwaa",
	0x14A1: "c",
	0x14A2: "th",
	0x14A3: "me",
	0x14A4: "maai",
	0x14A5: "mi",
	0x14A6: "mii",
	0x14A7: "mo",
	0x14A8: "moo",
	0x14A9: "moo",
	0x14AA: "ma",
	0x14AB: "maa",
	0x14AC: "mwe",
	0x14AD: "mwe",
	0x14AE: "mwi",
	0x14AF: "mwi",
	0x14B0: "mwii",
	0x14B1: "mwii",
	0x14B2: "mwo",
	0x14B3: "mwo",
	0x14B4: "mwoo",
	0x14B5: "mwoo",
	0x14B6: "mwa",
	0x14B7: "mwa",
	0x14B8: "mwaa",
	0x14B9: "mwaa",
	0x14BA: "mwaa",
	0x14BB: "m",
	0x14BC: "m",
	0x14BD: "mh",
	0x14BE: "m",
	0x14BF: "m",
	0x14C0: "ne",
	0x14C1: "naai",
	0x14C2: "ni",
	0x14C3: "nii",
	0x14C4: "no",
	0x14C5: "noo",
	0x14C6: "noo",
	0x14C7: "na",
	0x14C8: "naa",
	0x14C9: "nwe",
	0x14CA: "nwe",
	0x14CB: "nwa",
	0x14CC: "nwa",
	0x14CD: "nwaa",
	0x14CE: "nwaa",
	0x14CF: "nwaa",
	0x14D0: "n",
	0x14D1: "ng",
	0x14D2: "nh",
	0x14D3: "le",
	0x14D4: "laai",
	0x14D5: "li",
	0x14D6: "lii",
	0x14D7: "lo",
	0x14D8: "loo",
	0x14D9: "loo",
	0x14DA: "la",
	0x14DB: "laa",
	0x14DC: "lwe",
	0x14DD: "lwe",
	0x14DE: "lwi",
	0x14DF: "lwi",
	0x14E0: "lwii",
	0x14E1: "lwii",
	0x14E2: "lwo",
	0x14E3: "lwo",
	0x14E4: "lwoo",
	0x14E5: "lwoo",
	0x14E6: "lwa",
	0x14E7: "lwa",
	0x14E8: "lwaa",
	0x14E9: "lwaa",
	0x14EA: "l",
	0x14EB: "l",
	0x14EC: "l",
	0x14ED: "se",
	0x14EE: "saai",
	0x14EF: "si",
	0x14F0: "sii",
	0x14F1: "so",
	0x14F2: "soo",
	0x14F3: "soo",
	0x14F4: "sa",
	0x14F5: "saa",
	0x14F6: "swe",
	0x14F7: "swe",
	0x14F8: "swi",
	0x14F9: "swi",
	0x14FA: "swii",
	0x14FB: "swii",
	0x14FC: "swo",
	0x14FD: "swo",
	0x14FE: "swoo",
	0x14FF: "swoo",
	0x1500: "swa",
	0x1501: "swa",
	0x1502: "swaa",
	0x1503: "swaa",
	0x1504: "swaa",
	0x1505: "s",
	0x1506: "s",
	0x1507: "sw",
	0x1508: "s",
	0x1509: "sk",
	0x150A: "skw",
	0x150B: "sW",
	0x150C: "spwa",
	0x150D: "stwa",
	0x150E: "skwa",
	0x150F: "scwa",
	0x1510: "she",
	0x1511: "shi",
	0x1512: "shii",
	0x1513: "sho",
	0x1514: "shoo",
	0x1515: "sha",
	0x1516: "shaa",
	0x1517: "shwe",
	0x1518: "shwe",
	0x1519: "shwi",
	0x151A: "shwi",
	0x151B: "shwii",
	0x151C: "shwii",
	0x151D: "shwo",
	0x151E: "shwo",
	0x151F: "shwoo",
	0x1520: "shwoo",
	0x1521: "shwa",
	0x1522: "shwa",
	0x1523: "shwaa",
	0x1524: "shwaa",
	0x1525: "sh",
	0x1526: "ye",
	0x1527: "yaai",
	0x1528: "yi",
	0x1529: "yii",
	0x152A: "yo",
	0x152B: "yoo",
	0x152C: "yoo",
	0x152D: "ya",
	0x152E: "yaa",
	0x152F: "ywe",
	0x1530: "ywe",
	0x1531: "ywi",
	0x1532: "ywi",
	0x1533: "ywii",
	0x1534: "ywii",
	0x1535: "ywo",
	0x1536: "ywo",
	0x1537: "ywoo",
	0x1538: "ywoo",
	0x1539: "ywa",
	0x153A: "ywa",
	0x153B: "ywaa",
	0x153C: "ywaa",
	0x153D: "ywaa",
	0x153E: "y",
	0x153F: "y",
	0x1540: "y",
	0x1541: "yi",
	0x1542: "re",
	0x1543: "re",
	0x1544: "le",
	0x1545: "raai",
	0x1546: "ri",
	0x1547: "rii",
	0x1548: "ro",
	0x1549: "roo",
	0x154A: "lo",
	0x154B: "ra",
	0x154C: "raa",
	0x154D: "la",
	0x154E: "rwaa",
	0x154F: "rwaa",
	0x1550: "r",
	0x1551: "r",
	0x1552: "r",
	0x1553: "fe",
	0x1554: "faai",
	0x1555: "fi",
	0x1556: "fii",
	0x1557: "fo",
	0x1558: "foo",
	0x1559: "fa",
	0x155A: "faa",
	0x155B: "fwaa",
	0x155C: "fwaa",
	0x155D: "f",
	0x155E: "the",
	0x155F: "the",
	0x1560: "thi",
	0x1561: "thi",
	0x1562: "thii",
	0x1563: "thii",
	0x1564: "tho",
	0x1565: "thoo",
	0x1566: "tha",
	0x1567: "thaa",
	0x1568: "thwaa",
	0x1569: "thwaa",
	0x156A: "th",
	0x156B: "tthe",
	0x156C: "tthi",
	0x156D: "ttho",
	0x156E: "ttha",
	0x156F: "tth",
	0x1570: "tye",
	0x1571: "tyi",
	0x1572: "tyo",
	0x1573: "tya",
	0x1574: "he",
	0x1575: "hi",
	0x1576: "hii",
	0x1577: "ho",
	0x1578: "hoo",
	0x1579: "ha",
	0x157A: "haa",
	0x157B: "h",
	0x157C: "h",
	0x157D: "hk",
	0x157E: "qaai",
	0x157F: "qi",
	0x1580: "qii",
	0x1581: "qo",
	0x1582: "qoo",
	0x1583: "qa",
	0x1584: "qaa",
	0x1585: "q",
	0x1586: "tlhe",
	0x1587: "tlhi",
	0x1588: "tlho",
	0x1589: "tlha",
	0x158A: "re",
	0x158B: "ri",
	0x158C: "ro",
	0x158D: "ra",
	0x158E: "ngaai",
	0x158F: "ngi",
	0x1590: "ngii",
	0x1591: "ngo",
	0x1592: "ngoo",
	0x1593: "nga",
	0x1594: "ngaa",
	0x1595: "ng",
	0x1596: "nng",
	0x1597: "she",
	0x1598: "shi",
	0x1599: "sho",
	0x159A: "sha",
	0x159B: "the",
	0x159C: "thi",
	0x159D: "tho",
	0x159E: "tha",
	0x159F: "th",
	0x15A0: "lhi",
	0x15A1: "lhii",
	0x15A2: "lho",
	0x15A3: "lhoo",
	0x15A4: "lha",
	0x15A5: "lhaa",
	0x15A6: "lh",
	0x15A7: "the",
	0x15A8: "thi",
	0x15A9: "thii",
	0x15AA: "tho",
	0x15AB: "thoo",
	0x15AC: "tha",
	0x15AD: "thaa",
	0x15AE: "th",
	0x15AF: "b",
	0x15B0: "e",
	0x15B1: "i",
	0x15B2: "o",
	0x15B3: "a",
	0x15B4: "we",
	0x15B5: "wi",
	0x15B6: "wo",
	0x15B7: "wa",
	0x15B8: "ne",
	0x15B9: "ni",
	0x15BA: "no",
	0x15BB: "na",
	0x15BC: "ke",
	0x15BD: "ki",
	0x15BE: "ko",
	0x15BF: "ka",
	0x15C0: "he",
	0x15C1: "hi",
	0x15C2: "ho",
	0x15C3: "ha",
	0x15C4: "ghu",
	0x15C5: "gho",
	0x15C6: "ghe",
	0x15C7: "ghee",
	0x15C8: "ghi",
	0x15C9: "gha",
	0x15CA: "ru",
	0x15CB: "ro",
	0x15CC: "re",
	0x15CD: "ree",
	0x15CE: "ri",
	0x15CF: "ra",
	0x15D0: "wu",
	0x15D1: "wo",
	0x15D2: "we",
	0x15D3: "wee",
	0x15D4: "wi",
	0x15D5: "wa",
	0x15D6: "hwu",
	0x15D7: "hwo",
	0x15D8: "hwe",
	0x15D9: "hwee",
	0x15DA: "hwi",
	0x15DB: "hwa",
	0x15DC: "thu",
	0x15DD: "tho",
	0x15DE: "the",
	0x15DF: "thee",
	0x15E0: "thi",
	0x15E1: "tha",
	0x15E2: "ttu",
	0x15E3: "tto",
	0x15E4: "tte",
	0x15E5: "ttee",
	0x15E6: "tti",
	0x15E7: "tta",
	0x15E8: "pu",
	0x15E9: "po",
	0x15EA: "pe",
	0x15EB: "pee",
	0x15EC: "pi",
	0x15ED: "pa",
	0x15EE: "p",
	0x15EF: "gu",
	0x15F0: "go",
	0x15F1: "ge",
	0x15F2: "gee",
	0x15F3: "gi",
	0x15F4: "ga",
	0x15F5: "khu",
	0x15F6: "kho",
	0x15F7: "khe",
	0x15F8: "khee",
	0x15F9: "khi",
	0x15FA: "kha",
	0x15FB: "kku",
	0x15FC: "kko",
	0x15FD: "kke",
	0x15FE: "kkee",
	0x15FF: "kki",
	0x1600: "kka",
	0x1601: "kk",
	0x1602: "nu",
	0x1603: "no",
	0x1604: "ne",
	0x1605: "nee",
	0x1606: "ni",
	0x1607: "na",
	0x1608: "mu",
	0x1609: "mo",
	0x160A: "me",
	0x160B: "mee",
	0x160C: "mi",
	0x160D: "ma",
	0x160E: "yu",
	0x160F: "yo",
	0x1610: "ye",
	0x1611: "yee",
	0x1612: "yi",
	0x1613: "ya",
	0x1614: "ju",
	0x1615: "ju",
	0x1616: "jo",
	0x1617: "je",
	0x1618: "jee",
	0x1619: "ji",
	0x161A: "ji",
	0x161B: "ja",
	0x161C: "jju",
	0x161D: "jjo",
	0x161E: "jje",
	0x161F: "jjee",
	0x1620: "jji",
	0x1621: "jja",
	0x1622: "lu",
	0x1623: "lo",
	0x1624: "le",
	0x1625: "lee",
	0x1626: "li",
	0x1627: "la",
	0x1628: "dlu",
	0x1629: "dlo",
	0x162A: "dle",
	0x162B: "dlee",
	0x162C: "dli",
	0x162D: "dla",
	0x162E: "lhu",
	0x162F: "lho",
	0x1630: "lhe",
	0x1631: "lhee",
	0x1632: "lhi",
	0x1633: "lha",
	0x1634: "tlhu",
	0x1635: "tlho",
	0x1636: "tlhe",
	0x1637: "tlhee",
	0x1638: "tlhi",
	0x1639: "tlha",
	0x163A: "tlu",
	0x163B: "tlo",
	0x163C: "tle",
	0x163D: "tlee",
	0x163E: "tli",
	0x163F: "tla",
	0x1640: "zu",
	0x1641: "zo",
	0x1642: "ze",
	0x1643: "zee",
	0x1644: "zi",
	0x1645: "za",
	0x1646: "z",
	0x1647: "z",
	0x1648: "dzu",
	0x1649: "dzo",
	0x164A: "dze",
	0x164B: "dzee",
	0x164C: "dzi",
	0x164D: "dza",
	0x164E: "su",
	0x164F: "so",
	0x1650: "se",
	0x1651: "see",
	0x1652: "si",
	0x1653: "sa",
	0x1654: "shu",
	0x1655: "sho",
	0x1656: "she",
	0x1657: "shee",
	0x1658: "shi",
	0x1659: "sha",
	0x165A: "sh",
	0x165B: "tsu",
	0x165C: "tso",
	0x165D: "tse",
	0x165E: "tsee",
	0x165F: "tsi",
	0x1660: "tsa",
	0x1661: "chu",
	0x1662: "cho",
	0x1663: "che",
	0x1664: "chee",
	0x1665: "chi",
	0x1666: "cha",
	0x1667: "ttsu",
	0x1668: "ttso",
	0x1669: "ttse",
	0x166A: "ttsee",
	0x166B: "ttsi",
	0x166C: "ttsa",
	0x166D: "X",
	0x166E: ".",
	0x166F: "qai",
	0x1670: "ngai",
	0x1671: "nngi",
	0x1672: "nngii",
	0x1673: "nngo",
	0x1674: "nngoo",
	0x1675: "nnga",
	0x1676: "nngaa",
	0x1681: "b",
	0x1682: "l",
	0x1683: "f",
	0x1684: "s",
	0x1685: "n",
	0x1686: "h",
	0x1687: "d",
	0x1688: "t",
	0x1689: "c",
	0x168A: "q",
	0x168B: "m",
	0x168C: "g",
	0x168D: "ng",
	0x168E: "z",
	0x168F: "r",
	0x1690: "a",
	0x1691: "o",
	0x1692: "u",
	0x1693: "e",
	0x1694: "i",
	0x1695: "ch",
	0x1696: "th",
	0x1697: "ph",
	0x1698: "p",
	0x1699: "x",
	0x169A: "p",
	0x169B: "<",
	0x169C: ">",
	0x16A0: "f",
	0x16A1: "v",
	0x16A2: "u",
	0x16A3: "yr",
	0x16A4: "y",
	0x16A5: "w",
	0x16A6: "th",
	0x16A7: "th",
	0x16A8: "a",
	0x16A9: "o",
	0x16AA: "ac",
	0x16AB: "ae",
	0x16AC: "o",
	0x16AD: "o",
	0x16AE: "o",
	0x16AF: "oe",
	0x16B0: "on",
	0x16B1: "r",
	0x16B2: "k",
	0x16B3: "c",
	0x16B4: "k",
	0x16B5: "g",
	0x16B6: "ng",
	0x16B7: "g",
	0x16B8: "g",
	0x16B9: "w",
	0x16BA: "h",
	0x16BB: "h",
	0x16BC: "h",
	0x16BD: "h",
	0x16BE: "n",
	0x16BF: "n",
	0x16C0: "n",
	0x16C1: "i",
	0x16C2: "e",
	0x16C3: "j",
	0x16C4: "g",
	0x16C5: "ae",
	0x16C6: "a",
	0x16C7: "eo",
	0x16C8: "p",
	0x16C9: "z",
	0x16CA: "s",
	0x16CB: "s",
	0x16CC: "s",
	0x16CD: "c",
	0x16CE: "z",
	0x16CF: "t",
	0x16D0: "t",
	0x16D1: "d",
	0x16D2: "b",
	0x16D3: "b",
	0x16D4: "p",
	0x16D5: "p",
	0x16D6: "e",
	0x16D7: "m",
	0x16D8: "m",
	0x16D9: "m",
	0x16DA: "l",
	0x16DB: "l",
	0x16DC: "ng",
	0x16DD: "ng",
	0x16DE: "d",
	0x16DF: "o",
	0x16E0: "ear",
	0x16E1: "ior",
	0x16E2: "qu",
	0x16E3: "qu",
	0x16E4: "qu",
	0x16E5: "s",
	0x16E6: "yr",
	0x16E7: "yr",
	0x16E8: "yr",
	0x16E9: "q",
	0x16EA: "x",
	0x16EB: ".",
	0x16EC: ":",
	0x16ED: "+",
	0x16EE: "17",
	0x16EF: "18",
	0x16F0: "19",
	0x1780: "k",
	0x1781: "kh",
	0x1782: "g",
	0x1783: "gh",
	0x1784: "ng",
	0x1785: "c",
	0x1786: "ch",
	0x1787: "j",
	0x1788: "jh",
	0x1789: "ny",
	0x178A: "t",
	0x178B: "tth",
	0x178C: "d",
	0x178D: "ddh",
	0x178E: "nn",
	0x178F: "t",
	0x1790: "th",
	0x1791: "d",
	0x1792: "dh",
	0x1793: "n",
	0x1794: "p",
	0x1795: "ph",
	0x1796: "b",
	0x1797: "bh",
	0x1798: "m",
	0x1799: "y",
	0x179A: "r",
	0x179B: "l",
	0x179C: "v",
	0x179D: "sh",
	0x179E: "ss",
	0x179F: "s",
	0x17A0: "h",
	0x17A1: "l",
	0x17A2: "q",
	0x17A3: "a",
	0x17A4: "aa",
	0x17A5: "i",
	0x17A6: "ii",
	0x17A7: "u",
	0x17A8: "uk",
	0x17A9: "uu",
	0x17AA: "uuv",
	0x17AB: "ry",
	0x17AC: "ryy",
	0x17AD: "ly",
	0x17AE: "lyy",
	0x17AF: "e",
	0x17B0: "ai",
	0x17B1: "oo",
	0x17B2: "oo",
	0x17B3: "au",
	0x17B4: "a",
	0x17B5: "aa",
	0x17B6: "aa",
	0x17B7: "i",
	0x17B8: "ii",
	0x17B9: "y",
	0x17BA: "yy",
	0x17BB: "u",
	0x17BC: "uu",
	0x17BD: "ua",
	0x17BE: "oe",
	0x17BF: "ya",
	0x17C0: "ie",
	0x17C1: "e",
	0x17C2: "ae",
	0x17C3: "ai",
	0x17C4: "oo",
	0x17C5: "au",
	0x17C6: "M",
	0x17C7: "H",
	0x17C8: "a`",
	0x17CC: "r",
	0x17CE: "!",
	0x17D4: ".",
	0x17D5: " // ",
	0x17D6: ":",
	0x17D7: "+",
	0x17D8: "++",
	0x17D9: " * ",
	0x17DA: " /// ",
	0x17DB: "KR",
	0x17DC: "'",
	0x17E0: "0",
	0x17E1: "1",
	0x17E2: "2",
	0x17E3: "3",
	0x17E4: "4",
	0x17E5: "5",
	0x17E6: "6",
	0x17E7: "7",
	0x17E8: "8",
	0x17E9: "9",
	0x1800: " @ ",
	0x1801: " ... ",
	0x1802: ", ",
	0x1803: ". ",
	0x1804: ": ",
	0x1805: " // ",
	0x1806: "",
	0x1807: "-",
	0x1808: ", ",
	0x1809: ". ",
	0x1810: "0",
	0x1811: "1",
	0x1812: "2",
	0x1813: "3",
	0x1814: "4",
	0x1815: "5",
	0x1816: "6",
	0x1817: "7",
	0x1818: "8",
	0x1819: "9",
	0x1820: "a",
	0x1821: "e",
	0x1822: "i",
	0x1823: "o",
	0x1824: "u",
	0x1825: "O",
	0x1826: "U",
	0x1827: "ee",
	0x1828: "n",
	0x1829: "ng",
	0x182A: "b",
	0x182B: "p",
	0x182C: "q",
	0x182D: "g",
	0x182E: "m",
	0x182F: "l",
	0x1830: "s",
	0x1831: "sh",
	0x1832: "t",
	0x1833: "d",
	0x1834: "ch",
	0x1835: "j",
	0x1836: "y",
	0x1837: "r",
	0x1838: "w",
	0x1839: "f",
	0x183A: "k",
	0x183B: "kha",
	0x183C: "ts",
	0x183D: "z",
	0x183E: "h",
	0x183F: "zr",
	0x1840: "lh",
	0x1841: "zh",
	0x1842: "ch",
	0x1843: "-",
	0x1844: "e",
	0x1845: "i",
	0x1846: "o",
	0x1847: "u",
	0x1848: "O",
	0x1849: "U",
	0x184A: "ng",
	0x184B: "b",
	0x184C: "p",
	0x184D: "q",
	0x184E: "g",
	0x184F: "m",
	0x1850: "t",
	0x1851: "d",
	0x1852: "ch",
	0x1853: "j",
	0x1854: "ts",
	0x1855: "y",
	0x1856: "w",
	0x1857: "k",
	0x1858: "g",
	0x1859: "h",
	0x185A: "jy",
	0x185B: "ny",
	0x185C: "dz",
	0x185D: "e",
	0x185E: "i",
	0x185F: "iy",
	0x1860: "U",
	0x1861: "u",
	0x1862: "ng",
	0x1863: "k",
	0x1864: "g",
	0x1865: "h",
	0x1866: "p",
	0x1867: "sh",
	0x1868: "t",
	0x1869: "d",
	0x186A: "j",
	0x186B: "f",
	0x186C: "g",
	0x186D: "h",
	0x186E: "ts",
	0x186F: "z",
	0x1870: "r",
	0x1871: "ch",
	0x1872: "zh",
	0x1873: "i",
	0x1874: "k",
	0x1875: "r",
	0x1876: "f",
	0x1877: "zh",
	0x1881: "H",
	0x1882: "X",
	0x1883: "W",
	0x1884: "M",
	0x1885: " 3 ",
	0x1886: " 333 ",
	0x1887: "a",
	0x1888: "i",
	0x1889: "k",
	0x188A: "ng",
	0x188B: "c",
	0x188C: "tt",
	0x188D: "tth",
	0x188E: "dd",
	0x188F: "nn",
	0x1890: "t",
	0x1891: "d",
	0x1892: "p",
	0x1893: "ph",
	0x1894: "ss",
	0x1895: "zh",
	0x1896: "z",
	0x1897: "a",
	0x1898: "t",
	0x1899: "zh",
	0x189A: "gh",
	0x189B: "ng",
	0x189C: "c",
	0x189D: "jh",
	0x189E: "tta",
	0x189F: "ddh",
	0x18A0: "t",
	0x18A1: "dh",
	0x18A2: "ss",
	0x18A3: "cy",
	0x18A4: "zh",
	0x18A5: "z",
	0x18A6: "u",
	0x18A7: "y",
	0x18A8: "bh",
	0x18A9: "'",
	0x1D5D: "b",
	0x1D66: "b",
	0x1D6C: "b",
	0x1D6D: "d",
	0x1D6E: "f",
	0x1D6F: "m",
	0x1D70: "n",
	0x1D71: "p",
	0x1D72: "r",
	0x1D73: "r",
	0x1D74: "s",
	0x1D75: "t",
	0x1D76: "z",
	0x1D77: "g",
	0x1D7D: "p",
	0x1D80: "b",
	0x1D81: "d",
	0x1D82: "f",
	0x1D83: "g",
	0x1D84: "k",
	0x1D85: "l",
	0x1D86: "m",
	0x1D87: "n",
	0x1D88: "p",
	0x1D89: "r",
	0x1D8A: "s",
	0x1D8C: "v",
	0x1D8D: "x",
	0x1D8E: "z",
	0x1E00: "A",
	0x1E01: "a",
	0x1E02: "B",
	0x1E03: "b",
	0x1E04: "B",
	0x1E05: "b",
	0x1E06: "B",
	0x1E07: "b",
	0x1E08: "C",
	0x1E09: "c",
	0x1E0A: "D",
	0x1E0B: "d",
	0x1E0C: "D",
	0x1E0D: "d",
	0x1E0E: "D",
	0x1E0F: "d",
	0x1E10: "D",
	0x1E11: "d",
	0x1E12: "D",
	0x1E13: "d",
	0x1E14: "E",
	0x1E15: "e",
	0x1E16: "E",
	0x1E17: "e",
	0x1E18: "E",
	0x1E19: "e",
	0x1E1A: "E",
	0x1E1B: "e",
	0x1E1C: "E",
	0x1E1D: "e",
	0x1E1E: "F",
	0x1E1F: "f",
	0x1E20: "G",
	0x1E21: "g",
	0x1E22: "H",
	0x1E23: "h",
	0x1E24: "H",
	0x1E25: "h",
	0x1E26: "H",
	0x1E27: "h",
	0x1E28: "H",
	0x1E29: "h",
	0x1E2A: "H",
	0x1E2B: "h",
	0x1E2C: "I",
	0x1E2D: "i",
	0x1E2E: "I",
	0x1E2F: "i",
	0x1E30: "K",
	0x1E31: "k",
	0x1E32: "K",
	0x1E33: "k",
	0x1E34: "K",
	0x1E35: "k",
	0x1E36: "L",
	0x1E37: "l",
	0x1E38: "L",
	0x1E39: "l",
	0x1E3A: "L",
	0x1E3B: "l",
	0x1E3C: "L",
	0x1E3D: "l",
	0x1E3E: "M",
	0x1E3F: "m",
	0x1E40: "M",
	0x1E41: "m",
	0x1E42: "M",
	0x1E43: "m",
	0x1E44: "N",
	0x1E45: "n",
	0x1E46: "N",
	0x1E47: "n",
	0x1E48: "N",
	0x1E49: "n",
	0x1E4A: "N",
	0x1E4B: "n",
	0x1E4C: "O",
	0x1E4D: "o",
	0x1E4E: "O",
	0x1E4F: "o",
	0x1E50: "O",
	0x1E51: "o",
	0x1E52: "O",
	0x1E53: "o",
	0x1E54: "P",
	0x1E55: "p",
	0x1E56: "P",
	0x1E57: "p",
	0x1E58: "R",
	0x1E59: "r",
	0x1E5A: "R",
	0x1E5B: "r",
	0x1E5C: "R",
	0x1E5D: "r",
	0x1E5E: "R",
	0x1E5F: "r",
	0x1E60: "S",
	0x1E61: "s",
	0x1E62: "S",
	0x1E63: "s",
	0x1E64: "S",
	0x1E65: "s",
	0x1E66: "S",
	0x1E67: "s",
	0x1E68: "S",
	0x1E69: "s",
	0x1E6A: "T",
	0x1E6B: "t",
	0x1E6C: "T",
	0x1E6D: "t",
	0x1E6E: "T",
	0x1E6F: "t",
	0x1E70: "T",
	0x1E71: "t",
	0x1E72: "U",
	0x1E73: "u",
	0x1E74: "U",
	0x1E75: "u",
	0x1E76: "U",
	0x1E77: "u",
	0x1E78: "U",
	0x1E79: "u",
	0x1E7A: "U",
	0x1E7B: "u",
	0x1E7C: "V",
	0x1E7D: "v",
	0x1E7E: "V",
	0x1E7F: "v",
	0x1E80: "W",
	0x1E81: "w",
	0x1E82: "W",
	0x1E83: "w",
	0x1E84: "W",
	0x1E85: "w",
	0x1E86: "W",
	0x1E87: "w",
	0x1E88: "W",
	0x1E89: "w",
	0x1E8A: "X",
	0x1E8B: "x",
	0x1E8C: "X",
	0x1E8D: "x",
	0x1E8E: "Y",
	0x1E8F: "y",
	0x1E90: "Z",
	0x1E91: "z",
	0x1E92: "Z",
	0x1E93: "z",
	0x1E94: "Z",
	0x1E95: "z",
	0x1E96: "h",
	0x1E97: "t",
	0x1E98: "w",
	0x1E99: "y",
	0x1E9A: "a",
	0x1E9B: "S",
	0x1E9E: "SS",
	0x1EA0: "A",
	0x1EA1: "a",
	0x1EA2: "A",
	0x1EA3: "a",
	0x1EA4: "A",
	0x1EA5: "a",
	0x1EA6: "A",
	0x1EA7: "a",
	0x1EA8: "A",
	0x1EA9: "a",
	0x1EAA: "A",
	0x1EAB: "a",
	0x1EAC: "A",
	0x1EAD: "a",
	0x1EAE: "A",
	0x1EAF: "a",
	0x1EB0: "A",
	0x1EB1: "a",
	0x1EB2: "A",
	0x1EB3: "a",
	0x1EB4: "A",
	0x1EB5: "a",
	0x1EB6: "A",
	0x1EB7: "a",
	0x1EB8: "E",
	0x1EB9: "e",
	0x1EBA: "E",
	0x1EBB: "e",
	0x1EBC: "E",
	0x1EBD: "e",
	0x1EBE: "E",
	0x1EBF: "e",
	0x1EC0: "E",
	0x1EC1: "e",
	0x1EC2: "E",
	0x1EC3: "e",
	0x1EC4: "E",
	0x1EC5: "e",
	0x1EC6: "E",
	0x1EC7: "e",
	0x1EC8: "I",
	0x1EC9: "i",
	0x1ECA: "I",
	0x1ECB: "i",
	0x1ECC: "O",
	0x1ECD: "o",
	0x1ECE: "O",
	0x1ECF: "o",
	0x1ED0: "O",
	0x1ED1: "o",
	0x1ED2: "O",
	0x1ED3: "o",
	0x1ED4: "O",
	0x1ED5: "o",
	0x1ED6: "O",
	0x1ED7: "o",
	0x1ED8: "O",
	0x1ED9: "o",
	0x1EDA: "O",
	0x1EDB: "o",
	0x1EDC: "O",
	0x1EDD: "o",
	0x1EDE: "O",
	0x1EDF: "o",
	0x1EE0: "O",
	0x1EE1: "o",
	0x1EE2: "O",
	0x1EE3: "o",
	0x1EE4: "U",
	0x1EE5: "u",
	0x1EE6: "U",
	0x1EE7: "u",
	0x1EE8: "U",
	0x1EE9: "u",
	0x1EEA: "U",
	0x1EEB: "u",
	0x1EEC: "U",
	0x1EED: "u",
	0x1EEE: "U",
	0x1EEF: "u",
	0x1EF0: "U",
	0x1EF1: "u",
	0x1EF2: "Y",
	0x1EF3: "y",
	0x1EF4: "Y",
	0x1EF5: "y",
	0x1EF6: "Y",
	0x1EF7: "y",
	0x1EF8: "Y",
	0x1EF9: "y",
	0x1F00: "a",
	0x1F01: "a",
	0x1F02: "a",
	0x1F03: "a",
	0x1F04: "a",
	0x1F05: "a",
	0x1F06: "a",
	0x1F07: "a",
	0x1F08: "A",
	0x1F09: "A",
	0x1F0A: "A",
	0x1F0B: "A",
	0x1F0C: "A",
	0x1F0D: "A",
	0x1F0E: "A",
	0x1F0F: "A",
	0x1F10: "e",
	0x1F11: "e",
	0x1F12: "e",
	0x1F13: "e",
	0x1F14: "e",
	0x1F15: "e",
	0x1F18: "E",
	0x1F19: "E",
	0x1F1A: "E",
	0x1F1B: "E",
	0x1F1C: "E",
	0x1F1D: "E",
	0x1F20: "e",
	0x1F21: "e",
	0x1F22: "e",
	0x1F23: "e",
	0x1F24: "e",
	0x1F25: "e",
	0x1F26: "e",
	0x1F27: "e",
	0x1F28: "E",
	0x1F29: "E",
	0x1F2A: "E",
	0x1F2B: "E",
	0x1F2C: "E",
	0x1F2D: "E",
	0x1F2E: "E",
	0x1F2F: "E",
	0x1F30: "i",
	0x1F31: "i",
	0x1F32: "i",
	0x1F33: "i",
	0x1F34: "i",
	0x1F35: "i",
	0x1F36: "i",
	0x1F37: "i",
	0x1F38: "I",
	0x1F39: "I",
	0x1F3A: "I",
	0x1F3B: "I",
	0x1F3C: "I",
	0x1F3D: "I",
	0x1F3E: "I",
	0x1F3F: "I",
	0x1F40: "o",
	0x1F41: "o",
	0x1F42: "o",
	0x1F43: "o",
	0x1F44: "o",
	0x1F45: "o",
	0x1F48: "O",
	0x1F49: "O",
	0x1F4A: "O",
	0x1F4B: "O",
	0x1F4C: "O",
	0x1F4D: "O",
	0x1F50: "u",
	0x1F51: "u",
	0x1F52: "u",
	0x1F53: "u",
	0x1F54: "u",
	0x1F55: "u",
	0x1F56: "u",
	0x1F57: "u",
	0x1F59: "U",
	0x1F5B: "U",
	0x1F5D: "U",
	0x1F5F: "U",
	0x1F60: "o",
	0x1F61: "o",
	0x1F62: "o",
	0x1F63: "o",
	0x1F64: "o",
	0x1F65: "o",
	0x1F66: "o",
	0x1F67: "o",
	0x1F68: "O",
	0x1F69: "O",
	0x1F6A: "O",
	0x1F6B: "O",
	0x1F6C: "O",
	0x1F6D: "O",
	0x1F6E: "O",
	0x1F6F: "O",
	0x1F70: "a",
	0x1F71: "a",
	0x1F72: "e",
	0x1F73: "e",
	0x1F74: "e",
	0x1F75: "e",
	0x1F76: "i",
	0x1F77: "i",
	0x1F78: "o",
	0x1F79: "o",
	0x1F7A: "u",
	0x1F7B: "u",
	0x1F7C: "o",
	0x1F7D: "o",
	0x1F80: "a",
	0x1F81: "a",
	0x1F82: "a",
	0x1F83: "a",
	0x1F84: "a",
	0x1F85: "a",
	0x1F86: "a",
	0x1F87: "a",
	0x1F88: "A",
	0x1F89: "A",
	0x1F8A: "A",
	0x1F8B: "A",
	0x1F8C: "A",
	0x1F8D: "A",
	0x1F8E: "A",
	0x1F8F: "A",
	0x1F90: "e",
	0x1F91: "e",
	0x1F92: "e",
	0x1F93: "e",
	0x1F94: "e",
	0x1F95: "e",
	0x1F96: "e",
	0x1F97: "e",
	0x1F98: "E",
	0x1F99: "E",
	0x1F9A: "E",
	0x1F9B: "E",
	0x1F9C: "E",
	0x1F9D: "E",
	0x1F9E: "E",
	0x1F9F: "E",
	0x1FA0: "o",
	0x1FA1: "o",
	0x1FA2: "o",
	0x1FA3: "o",
	0x1FA4: "o",
	0x1FA5: "o",
	0x1FA6: "o",
	0x1FA7: "o",
	0x1FA8: "O",
	0x1FA9: "O",
	0x1FAA: "O",
	0x1FAB: "O",
	0x1FAC: "O",
	0x1FAD: "O",
	0x1FAE: "O",
	0x1FAF: "O",
	0x1FB0: "a",
	0x1FB1: "a",
	0x1FB2: "a",
	0x1FB3: "a",
	0x1FB4: "a",
	0x1FB6: "a",
	0x1FB7: "a",
	0x1FB8: "A",
	0x1FB9: "A",
	0x1FBA: "A",
	0x1FBB: "A",
	0x1FBC: "A",
	0x1FBD: "'",
	0x1FBE: "i",
	0x1FBF: "'",
	0x1FC0: "~",
	0x1FC1: "\"~",
	0x1FC2: "e",
	0x1FC3: "e",
	0x1FC4: "e",
	0x1FC6: "e",
	0x1FC7: "e",
	0x1FC8: "E",
	0x1FC9: "E",
	0x1FCA: "E",
	0x1FCB: "E",
	0x1FCC: "E",
	0x1FCD: "'`",
	0x1FCE: "''",
	0x1FCF: "'~",
	0x1FD0: "i",
	0x1FD1: "i",
	0x1FD2: "i",
	0x1FD3: "i",
	0x1FD6: "i",
	0x1FD7: "i",
	0x1FD8: "I",
	0x1FD9: "I",
	0x1FDA: "I",
	0x1FDB: "I",
	0x1FDD: "`'",
	0x1FDE: "`'",
	0x1FDF: "`~",
	0x1FE0: "u",
	0x1FE1: "u",
	0x1FE2: "u",
	0x1FE3: "u",
	0x1FE4: "R",
	0x1FE5: "R",
	0x1FE6: "u",
	0x1FE7: "u",
	0x1FE8: "U",
	0x1FE9: "U",
	0x1FEA: "U",
	0x1FEB: "U",
	0x1FEC: "R",
	0x1FED: "\"`",
	0x1FEE: "\"'",
	0x1FEF: "`",
	0x1FF2: "o",
	0x1FF3: "o",
	0x1FF4: "o",
	0x1FF6: "o",
	0x1FF7: "o",
	0x1FF8: "O",
	0x1FF9: "O",
	0x1FFA: "O",
	0x1FFB: "O",
	0x1FFC: "O",
	0x1FFD: "'",
	0x1FFE: "`",
	0x2010: "-",
	0x2011: "-",
	0x2012: "-",
	0x2013: "-",
	0x2014: "--",
	0x2015: "--",
	0x2016: "||",
	0x2017: "_",
	0x2018: "'",
	0x2019: "'",
	0x201A: ",",
	0x201B: "'",
	0x201C: "\"",
	0x201D: "\"",
	0x201E: "\"",
	0x201F: "\"",
	0x2020: "+",
	0x2021: "++",
	0x2022: "*",
	0x2023: "*>",
	0x2024: ".",
	0x2025: "..",
	0x2026: "...",
	0x2027: ".",
	0x2030: "%0",
	0x2031: "%00",
	0x2032: "'",
	0x2033: "''",
	0x2034: "'''",
	0x2035: "`",
	0x2036: "``",
	0x2037: "```",
	0x2038: "^",
	0x203B: "*",
	0x203C: "!!",
	0x203D: "!?",
	0x203E: "-",
	0x203F: "_",
	0x2040: "-",
	0x2041: "^",
	0x2042: "***",
	0x2043: "--",
	0x2045: "-[",
	0x2046: "]-",
	0x2047: "??",
	0x2048: "?!",
	0x2049: "!?",
	0x204A: "7",
	0x204B: "PP",
	0x204C: "(]",
	0x204D: "[)",
	0x204E: "*",
	0x2052: "%",
	0x2053: "~",
	0x206F: "0",
	0x2070: "(0)",
	0x2071: "(i)",
	0x2074: "(4)",
	0x2075: "(5)",
	0x2076: "(6)",
	0x2077: "(7)",
	0x2078: "(8)",
	0x2079: "(9)",
	0x207A: "(+)",
	0x207B: "(-)",
	0x207C: "(=)",
	0x207D: "(()",
	0x207E: "())",
	0x207F: "(n)",
	0x2080: "(0)",
	0x2081: "(1)",
	0x2082: "(2)",
	0x2083: "(3)",
	0x2084: "(4)",
	0x2085: "(5)",
	0x2086: "(6)",
	0x2087: "(7)",
	0x2088: "(8)",
	0x2089: "(9)",
	0x208A: "(+)",
	0x208B: "(-)",
	0x208C: "(=)",
	0x208D: "(()",
	0x208E: "())",
	0x2090: "(a)",
	0x2091: "(e)",
	0x2092: "(o)",
	0x2093: "(x)",
	0x2095: "(h)",
	0x2096: "(k)",
	0x2097: "(l)",
	0x2098: "(m)",
	0x2099: "(n)",
	0x209A: "(p)",
	0x209B: "(s)",
	0x209C: "(t)",
	0x3041: "a",
	0x3042: "a",
	0x3043: "i",
	0x3044: "i",
	0x3045: "u",
	0x3046: "u",
	0x3047: "e",
	0x3048: "e",
	0x3049: "o",
	0x304A: "o",
	0x304B: "ka",
	0x304C: "ga",
	0x304D: "ki",
	0x304E: "gi",
	0x304F: "ku",
	0x3050: "gu",
	0x3051: "ke",
	0x3052: "ge",
	0x3053: "ko",
	0x3054: "go",
	0x3055: "sa",
	0x3056: "za",
	0x3057: "shi",
	0x3058: "zi",
	0x3059: "su",
	0x305A: "zu",
	0x305B: "se",
	0x305C: "ze",
	0x305D: "so",
	0x305E: "zo",
	0x305F: "ta",
	0x3060: "da",
	0x3061: "chi",
	0x3062: "di",
	0x3063: "tsu",
	0x3064: "tsu",
	0x3065: "du",
	0x3066: "te",
	0x3067: "de",
	0x3068: "to",
	0x3069: "do",
	0x306A: "na",
	0x306B: "ni",
	0x306C: "nu",
	0x306D: "ne",
	0x306E: "no",
	0x306F: "ha",
	0x3070: "ba",
	0x3071: "pa",
	0x3072: "hi",
	0x3073: "bi",
	0x3074: "pi",
	0x3075: "hu",
	0x3076: "bu",
	0x3077: "pu",
	0x3078: "he",
	0x3079: "be",
	0x307A: "pe",
	0x307B: "ho",
	0x307C: "bo",
	0x307D: "po",
	0x307E: "ma",
	0x307F: "mi",
	0x3080: "mu",
	0x3081: "me",
	0x3082: "mo",
	0x3083: "ya",
	0x3084: "ya",
	0x3085: "yu",
	0x3086: "yu",
	0x3087: "yo",
	0x3088: "yo",
	0x3089: "ra",
	0x308A: "ri",
	0x308B: "ru",
	0x308C: "re",
	0x308D: "ro",
	0x308E: "wa",
	0x308F: "wa",
	0x3090: "wi",
	0x3091: "we",
	0x3092: "wo",
	0x3093: "n",
	0x3094: "vu",
	0x309D: "\"",
	0x309E: "\"",
	0x30A1: "a",
	0x30A2: "a",
	0x30A3: "i",
	0x30A4: "i",
	0x30A5: "u",
	0x30A6: "u",
	0x30A7: "e",
	0x30A8: "e",
	0x30A9: "o",
	0x30AA: "o",
	0x30AB: "ka",
	0x30AC: "ga",
	0x30AD: "ki",
	0x30AE: "gi",
	0x30AF: "ku",
	0x30B0: "gu",
	0x30B1: "ke",
	0x30B2: "ge",
	0x30B3: "ko",
	0x30B4: "go",
	0x30B5: "sa",
	0x30B6: "za",
	0x30B7: "shi",
	0x30B8: "zi",
	0x30B9: "su",
	0x30BA: "zu",
	0x30BB: "se",
	0x30BC: "ze",
	0x30BD: "so",
	0x30BE: "zo",
	0x30BF: "ta",
	0x30C0: "da",
	0x30C1: "chi",
	0x30C2: "di",
	0x30C3: "tsu",
	0x30C4: "tsu",
	0x30C5: "du",
	0x30C6: "te",
	0x30C7: "de",
	0x30C8: "to",
	0x30C9: "do",
	0x30CA: "na",
	0x30CB: "ni",
	0x30CC: "nu",
	0x30CD: "ne",
	0x30CE: "no",
	0x30CF: "ha",
	0x30D0: "ba",
	0x30D1: "pa",
	0x30D2: "hi",
	0x30D3: "bi",
	0x30D4: "pi",
	0x30D5: "hu",
	0x30D6: "bu",
	0x30D7: "pu",
	0x30D8: "he",
	0x30D9: "be",
	0x30DA: "pe",
	0x30DB: "ho",
	0x30DC: "bo",
	0x30DD: "po",
	0x30DE: "ma",
	0x30DF: "mi",
	0x30E0: "mu",
	0x30E1: "me",
	0x30E2: "mo",
	0x30E3: "ya",
	0x30E4: "ya",
	0x30E5: "yu",
	0x30E6: "yu",
	0x30E7: "yo",
	0x30E8: "yo",
	0x30E9: "ra",
	0x30EA: "ri",
	0x30EB: "ru",
	0x30EC: "re",
	0x30ED: "ro",
	0x30EE: "wa",
	0x30EF: "wa",
	0x30F0: "wi",
	0x30F1: "we",
	0x30F2: "wo",
	0x30F3: "n",
	0x30F4: "vu",
	0x30F5: "ka",
	0x30F6: "ke",
	0x30F7: "va",
	0x30F8: "vi",
	0x30F9: "ve",
	0x30FA: "vo",
	0x30FD: "\\",
	0x30FE: "\\",
	0x3105: "B",
	0x3106: "P",
	0x3107: "M",
	0x3108: "F",
	0x3109: "D",
	0x310A: "T",
	0x310B: "N",
	0x310C: "L",
	0x310D: "G",
	0x310E: "K",
	0x310F: "H",
	0x3110: "J",
	0x3111: "Q",
	0x3112: "X",
	0x3113: "ZH",
	0x3114: "CH",
	0x3115: "SH",
	0x3116: "R",
	0x3117: "Z",
	0x3118: "C",
	0x3119: "S",
	0x311A: "A",
	0x311B: "O",
	0x311C: "E",
	0x311D: "EH",
	0x311E: "AI",
	0x311F: "EI",
	0x3120: "AU",
	0x3121: "OU",
	0x3122: "AN",
	0x3123: "EN",
	0x3124: "ANG",
	0x3125: "ENG",
	0x3126: "ER",
	0x3127: "I",
	0x3128: "U",
	0x3129: "IU",
	0x312A: "V",
	0x312B: "NG",
	0x312C: "GN",
	0x3131: "g",
	0x3132: "gg",
	0x3133: "gs",
	0x3134: "n",
	0x3135: "nj",
	0x3136: "nh",
	0x3137: "d",
	0x3138: "dd",
	0x3139: "r",
	0x313A: "lg",
	0x313B: "lm",
	0x313C: "lb",
	0x313D: "ls",
	0x313E: "lt",
	0x313F: "lp",
	0x3140: "rh",
	0x3141: "m",
	0x3142: "b",
	0x3143: "bb",
	0x3144: "bs",
	0x3145: "s",
	0x3146: "ss",
	0x3147: "o",
	0x3148: "j",
	0x3149: "jj",
	0x314A: "c",
	0x314B: "k",
	0x314C: "t",
	0x314D: "p",
	0x314E: "h",
	0x314F: "a",
	0x3150: "ae",
	0x3151: "ya",
	0x3152: "yae",
	0x3153: "eo",
	0x3154: "e",
	0x3155: "yeo",
	0x3156: "ye",
	0x3157: "o",
	0x3158: "wa",
	0x3159: "wae",
	0x315A: "oe",
	0x315B: "yo",
	0x315C: "u",
	0x315D: "weo",
	0x315E: "we",
	0x315F: "wi",
	0x3160: "yu",
	0x3161: "eu",
	0x3162: "yi",
	0x3163: "i",
	0x3165: "nn",
	0x3166: "nd",
	0x3167: "ns",
	0x3168: "nZ",
	0x3169: "lgs",
	0x316A: "ld",
	0x316B: "lbs",
	0x316C: "lZ",
	0x316D: "lQ",
	0x316E: "mb",
	0x316F: "ms",
	0x3170: "mZ",
	0x3171: "mN",
	0x3172: "bg",
	0x3174: "bsg",
	0x3175: "bst",
	0x3176: "bj",
	0x3177: "bt",
	0x3178: "bN",
	0x3179: "bbN",
	0x317A: "sg",
	0x317B: "sn",
	0x317C: "sd",
	0x317D: "sb",
	0x317E: "sj",
	0x317F: "Z",
	0x3181: "N",
	0x3182: "Ns",
	0x3183: "NZ",
	0x3184: "pN",
	0x3185: "hh",
	0x3186: "Q",
	0x3187: "yo-ya",
	0x3188: "yo-yae",
	0x3189: "yo-i",
	0x318A: "yu-yeo",
	0x318B: "yu-ye",
	0x318C: "yu-i",
	0x318D: "U",
	0x318E: "U-i",
	0x31A0: "BU",
	0x31A1: "ZI",
	0x31A2: "JI",
	0x31A3: "GU",
	0x31A4: "EE",
	0x31A5: "ENN",
	0x31A6: "OO",
	0x31A7: "ONN",
	0x31A8: "IR",
	0x31A9: "ANN",
	0x31AA: "INN",
	0x31AB: "UNN",
	0x31AC: "IM",
	0x31AD: "NGG",
	0x31AE: "AINN",
	0x31AF: "AUNN",
	0x31B0: "AM",
	0x31B1: "OM",
	0x31B2: "ONG",
	0x31B3: "INNN",
	0x31B4: "P",
	0x31B5: "T",
	0x31B6: "K",
	0x31B7: "H",
	0x3200: "(g)",
	0x3201: "(n)",
	0x3202: "(d)",
	0x3203: "(r)",
	0x3204: "(m)",
	0x3205: "(b)",
	0x3206: "(s)",
	0x3207: "()",
	0x3208: "(j)",
	0x3209: "(c)",
	0x320A: "(k)",
	0x320B: "(t)",
	0x320C: "(p)",
	0x320D: "(h)",
	0x320E: "(ga)",
	0x320F: "(na)",
	0x3210: "(da)",
	0x3211: "(ra)",
	0x3212: "(ma)",
	0x3213: "(ba)",
	0x3214: "(sa)",
	0x3215: "(a)",
	0x3216: "(ja)",
	0x3217: "(ca)",
	0x3218: "(ka)",
	0x3219: "(ta)",
	0x321A: "(pa)",
	0x321B: "(ha)",
	0x321C: "(ju)",
	0x3220: "(1) ",
	0x3221: "(2) ",
	0x3222: "(3) ",
	0x3223: "(4) ",
	0x3224: "(5) ",
	0x3225: "(6) ",
	0x3226: "(7) ",
	0x3227: "(8) ",
	0x3228: "(9) ",
	0x3229: "(10) ",
	0x322A: "(Yue) ",
	0x322B: "(Huo) ",
	0x322C: "(Shui) ",
	0x322D: "(Mu) ",
	0x322E: "(Jin) ",
	0x322F: "(Tu) ",
	0x3230: "(Ri) ",
	0x3231: "(Zhu) ",
	0x3232: "(You) ",
	0x3233: "(She) ",
	0x3234: "(Ming) ",
	0x3235: "(Te) ",
	0x3236: "(Cai) ",
	0x3237: "(Zhu) ",
	0x3238: "(Lao) ",
	0x3239: "(Dai) ",
	0x323A: "(Hu) ",
	0x323B: "(Xue) ",
	0x323C: "(Jian) ",
	0x323D: "(Qi) ",
	0x323E: "(Zi) ",
	0x323F: "(Xie) ",
	0x3240: "(Ji) ",
	0x3241: "(Xiu) ",
	0x3242: "<<",
	0x3243: ">>",
	0x3251: "21",
	0x3252: "22",
	0x3253: "23",
	0x3254: "24",
	0x3255: "25",
	0x3256: "26",
	0x3257: "27",
	0x3258: "28",
	0x3259: "29",
	0x325A: "30",
	0x325B: "31",
	0x325C: "32",
	0x325D: "33",
	0x325E: "34",
	0x325F: "35",
	0x3260: "(g)",
	0x3261: "(n)",
	0x3262: "(d)",
	0x3263: "(r)",
	0x3264: "(m)",
	0x3265: "(b)",
	0x3266: "(s)",
	0x3267: "()",
	0x3268: "(j)",
	0x3269: "(c)",
	0x326A: "(k)",
	0x326B: "(t)",
	0x326C: "(p)",
	0x326D: "(h)",
	0x326E: "(ga)",
	0x326F: "(na)",
	0x3270: "(da)",
	0x3271: "(ra)",
	0x3272: "(ma)",
	0x3273: "(ba)",
	0x3274: "(sa)",
	0x3275: "(a)",
	0x3276: "(ja)",
	0x3277: "(ca)",
	0x3278: "(ka)",
	0x3279: "(ta)",
	0x327A: "(pa)",
	0x327B: "(ha)",
	0x327F: "KIS ",
	0x3280: "(1) ",
	0x3281: "(2) ",
	0x3282: "(3) ",
	0x3283: "(4) ",
	0x3284: "(5) ",
	0x3285: "(6) ",
	0x3286: "(7) ",
	0x3287: "(8) ",
	0x3288: "(9) ",
	0x3289: "(10) ",
	0x328A: "(Yue) ",
	0x328B: "(Huo) ",
	0x328C: "(Shui) ",
	0x328D: "(Mu) ",
	0x328E: "(Jin) ",
	0x328F: "(Tu) ",
	0x3290: "(Ri) ",
	0x3291: "(Zhu) ",
	0x3292: "(You) ",
	0x3293: "(She) ",
	0x3294: "(Ming) ",
	0x3295: "(Te) ",
	0x3296: "(Cai) ",
	0x3297: "(Zhu) ",
	0x3298: "(Lao) ",
	0x3299: "(Mi) ",
	0x329A: "(Nan) ",
	0x329B: "(Nu) ",
	0x329C: "(Shi) ",
	0x329D: "(You) ",
	0x329E: "(Yin) ",
	0x329F: "(Zhu) ",
	0x32A0: "(Xiang) ",
	0x32A1: "(Xiu) ",
	0x32A2: "(Xie) ",
	0x32A3: "(Zheng) ",
	0x32A4: "(Shang) ",
	0x32A5: "(Zhong) ",
	0x32A6: "(Xia) ",
	0x32A7: "(Zuo) ",
	0x32A8: "(You) ",
	0x32A9: "(Yi) ",
	0x32AA: "(Zong) ",
	0x32AB: "(Xue) ",
	0x32AC: "(Jian) ",
	0x32AD: "(Qi) ",
	0x32AE: "(Zi) ",
	0x32AF: "(Xie) ",
	0x32B0: "(Ye) ",
	0x32B1: "36",
	0x32B2: "37",
	0x32B3: "38",
	0x32B4: "39",
	0x32B5: "40",
	0x32B6: "41",
	0x32B7: "42",
	0x32B8: "43",
	0x32B9: "44",
	0x32BA: "45",
	0x32BB: "46",
	0x32BC: "47",
	0x32BD: "48",
	0x32BE: "49",
	0x32BF: "50",
	0x32C0: "1M",
	0x32C1: "2M",
	0x32C2: "3M",
	0x32C3: "4M",
	0x32C4: "5M",
	0x32C5: "6M",
	0x32C6: "7M",
	0x32C7: "8M",
	0x32C8: "9M",
	0x32C9: "10M",
	0x32CA: "11M",
	0x32CB: "12M",
	0x32D0: "a",
	0x32D1: "i",
	0x32D2: "u",
	0x32D3: "u",
	0x32D4: "o",
	0x32D5: "ka",
	0x32D6: "ki",
	0x32D7: "ku",
	0x32D8: "ke",
	0x32D9: "ko",
	0x32DA: "sa",
	0x32DB: "si",
	0x32DC: "su",
	0x32DD: "se",
	0x32DE: "so",
	0x32DF: "ta",
	0x32E0: "ti",
	0x32E1: "tu",
	0x32E2: "te",
	0x32E3: "to",
	0x32E4: "na",
	0x32E5: "ni",
	0x32E6: "nu",
	0x32E7: "ne",
	0x32E8: "no",
	0x32E9: "ha",
	0x32EA: "hi",
	0x32EB: "hu",
	0x32EC: "he",
	0x32ED: "ho",
	0x32EE: "ma",
	0x32EF: "mi",
	0x32F0: "mu",
	0x32F1: "me",
	0x32F2: "mo",
	0x32F3: "ya",
	0x32F4: "yu",
	0x32F5: "yo",
	0x32F6: "ra",
	0x32F7: "ri",
	0x32F8: "ru",
	0x32F9: "re",
	0x32FA: "ro",
	0x32FB: "wa",
	0x32FC: "wi",
	0x32FD: "we",
	0x32FE: "wo",
	0x3300: "apartment",
	0x3301: "alpha",
	0x3302: "ampere",
	0x3303: "are",
	0x3304: "inning",
	0x3305: "inch",
	0x3306: "won",
	0x3307: "escudo",
	0x3308: "acre",
	0x3309: "ounce",
	0x330A: "ohm",
	0x330B: "kai-ri",
	0x330C: "carat",
	0x330D: "calorie",
	0x330E: "gallon",
	0x330F: "gamma",
	0x3310: "giga",
	0x3311: "guinea",
	0x3312: "curie",
	0x3313: "guilder",
	0x3314: "kilo",
	0x3315: "kilogram",
	0x3316: "kilometer",
	0x3317: "kilowatt",
	0x3318: "gram",
	0x3319: "gram ton",
	0x331A: "cruzeiro",
	0x331B: "krone",
	0x331C: "case",
	0x331D: "koruna",
	0x331E: "co-op",
	0x331F: "cycle",
	0x3320: "centime",
	0x3321: "shilling",
	0x3322: "centi",
	0x3323: "cent",
	0x3324: "dozen",
	0x3325: "desi",
	0x3326: "dollar",
	0x3327: "ton",
	0x3328: "nano",
	0x3329: "knot",
	0x332A: "heights",
	0x332B: "percent",
	0x332C: "parts",
	0x332D: "barrel",
	0x332E: "piaster",
	0x332F: "picul",
	0x3330: "pico",
	0x3331: "building",
	0x3332: "farad",
	0x3333: "feet",
	0x3334: "bushel",
	0x3335: "franc",
	0x3336: "hectare",
	0x3337: "peso",
	0x3338: "pfennig",
	0x3339: "hertz",
	0x333A: "pence",
	0x333B: "page",
	0x333C: "beta",
	0x333D: "point",
	0x333E: "volt",
	0x333F: "hon",
	0x3340: "pound",
	0x3341: "hall",
	0x3342: "horn",
	0x3343: "micro",
	0x3344: "mile",
	0x3345: "mach",
	0x3346: "mark",
	0x3347: "mansion",
	0x3348: "micron",
	0x3349: "milli",
	0x334A: "millibar",
	0x334B: "mega",
	0x334C: "megaton",
	0x334D: "meter",
	0x334E: "yard",
	0x334F: "yard",
	0x3350: "yuan",
	0x3351: "liter",
	0x3352: "lira",
	0x3353: "rupee",
	0x3354: "ruble",
	0x3355: "rem",
	0x3356: "roentgen",
	0x3357: "watt",
	0x3358: "0h",
	0x3359: "1h",
	0x335A: "2h",
	0x335B: "3h",
	0x335C: "4h",
	0x335D: "5h",
	0x335E: "6h",
	0x335F: "7h",
	0x3360: "8h",
	0x3361: "9h",
	0x3362: "10h",
	0x3363: "11h",
	0x3364: "12h",
	0x3365: "13h",
	0x3366: "14h",
	0x3367: "15h",
	0x3368: "16h",
	0x3369: "17h",
	0x336A: "18h",
	0x336B: "19h",
	0x336C: "20h",
	0x336D: "21h",
	0x336E: "22h",
	0x336F: "23h",
	0x3370: "24h",
	0x3371: "HPA",
	0x3372: "da",
	0x3373: "AU",
	0x3374: "bar",
	0x3375: "oV",
	0x3376: "pc",
	0x337B: "Heisei",
	0x337C: "Syouwa",
	0x337D: "Taisyou",
	0x337E: "Meiji",
	0x337F: "Inc.",
	0x3380: "pA",
	0x3381: "nA",
	0x3382: "microamp",
	0x3383: "mA",
	0x3384: "kA",
	0x3385: "kB",
	0x3386: "MB",
	0x3387: "GB",
	0x3388: "cal",
	0x3389: "kcal",
	0x338A: "pF",
	0x338B: "nF",
	0x338C: "microFarad",
	0x338D: "microgram",
	0x338E: "mg",
	0x338F: "kg",
	0x3390: "Hz",
	0x3391: "kHz",
	0x3392: "MHz",
	0x3393: "GHz",
	0x3394: "THz",
	0x3395: "microliter",
	0x3396: "ml",
	0x3397: "dl",
	0x3398: "kl",
	0x3399: "fm",
	0x339A: "nm",
	0x339B: "micrometer",
	0x339C: "mm",
	0x339D: "cm",
	0x339E: "km",
	0x339F: "mm^2",
	0x33A0: "cm^2",
	0x33A1: "m^2",
	0x33A2: "km^2",
	0x33A3: "mm^4",
	0x33A4: "cm^3",
	0x33A5: "m^3",
	0x33A6: "km^3",
	0x33A7: "m/s",
	0x33A8: "m/s^2",
	0x33A9: "Pa",
	0x33AA: "kPa",
	0x33AB: "MPa",
	0x33AC: "GPa",
	0x33AD: "rad",
	0x33AE: "rad/s",
	0x33AF: "rad/s^2",
	0x33B0: "ps",
	0x33B1: "ns",
	0x33B2: "microsecond",
	0x33B3: "ms",
	0x33B4: "pV",
	0x33B5: "nV",
	0x33B6: "microvolt",
	0x33B7: "mV",
	0x33B8: "kV",
	0x33B9: "MV",
	0x33BA: "pW",
	0x33BB: "nW",
	0x33BC: "microwatt",
	0x33BD: "mW",
	0x33BE: "kW",
	0x33BF: "MW",
	0x33C0: "kOhm",
	0x33C1: "MOhm",
	0x33C2: "a.m.",
	0x33C3: "Bq",
	0x33C4: "cc",
	0x33C5: "cd",
	0x33C6: "C/kg",
	0x33C7: "Co.",
	0x33C8: "dB",
	0x33C9: "Gy",
	0x33CA: "ha",
	0x33CB: "HP",
	0x33CC: "in",
	0x33CD: "K.K.",
	0x33CE: "KM",
	0x33CF: "kt",
	0x33D0: "lm",
	0x33D1: "ln",
	0x33D2: "log",
	0x33D3: "lx",
	0x33D4: "mb",
	0x33D5: "mil",
	0x33D6: "mol",
	0x33D7: "pH",
	0x33D8: "p.m.",
	0x33D9: "PPM",
	0x33DA: "PR",
	0x33DB: "sr",
	0x33DC: "Sv",
	0x33DD: "Wb",
	0x33E0: "1d",
	0x33E1: "2d",
	0x33E2: "3d",
	0x33E3: "4d",
	0x33E4: "5d",
	0x33E5: "6d",
	0x33E6: "7d",
	0x33E7: "8d",
	0x33E8: "9d",
	0x33E9: "10d",
	0x33EA: "11d",
	0x33EB: "12d",
	0x33EC: "13d",
	0x33ED: "14d",
	0x33EE: "15d",
	0x33EF: "16d",
	0x33F0: "17d",
	0x33F1: "18d",
	0x33F2: "19d",
	0x33F3: "20d",
	0x33F4: "21d",
	0x33F5: "22d",
	0x33F6: "23d",
	0x33F7: "24d",
	0x33F8: "25d",
	0x33F9: "26d",
	0x33FA: "27d",
	0x33FB: "28d",
	0x33FC: "29d",
	0x33FD: "30d",
	0x33FE: "31d",
	0x33FF: "(gal)",
	0xFB00: "ff",
	0xFB01: "fi",
	0xFB02: "fl",
	0xFB03: "ffi",
	0xFB04: "ffl",
	0xFB05: "st",
	0xFB06: "st",
	0xFB13: "mn",
	0xFB14: "me",
	0xFB15: "mi",
	0xFB16: "vn",
	0xFB17: "mkh",
	0xFB1D: "yi",
	0xFB1F: "ay",
	0xFB20: "`",
	0xFB22: "d",
	0xFB23: "h",
	0xFB24: "k",
	0xFB25: "l",
	0xFB26: "m",
	0xFB27: "m",
	0xFB28: "t",
	0xFB29: "+",
	0xFB2A: "sh",
	0xFB2B: "s",
	0xFB2C: "sh",
	0xFB2D: "s",
	0xFB2E: "a",
	0xFB2F: "a",
	0xFB31: "b",
	0xFB32: "g",
	0xFB33: "d",
	0xFB34: "h",
	0xFB35: "v",
	0xFB36: "z",
	0xFB38: "t",
	0xFB39: "y",
	0xFB3A: "k",
	0xFB3B: "k",
	0xFB3C: "l",
	0xFB3E: "l",
	0xFB40: "n",
	0xFB41: "n",
	0xFB43: "p",
	0xFB44: "p",
	0xFB46: "ts",
	0xFB47: "ts",
	0xFB48: "r",
	0xFB49: "sh",
	0xFB4A: "t",
	0xFB4B: "vo",
	0xFB4C: "b",
	0xFB4D: "k",
	0xFB4E: "p",
	0xFB4F: "l",
	0xFE23: "~",
	0xFE30: "..",
	0xFE31: "--",
	0xFE32: "-",
	0xFE33: "_",
	0xFE34: "_",
	0xFE35: "(",
	0xFE36: ") ",
	0xFE37: "{",
	0xFE38: "} ",
	0xFE39: "[",
	0xFE3A: "] ",
	0xFE3B: "[(",
	0xFE3C: ")] ",
	0xFE3D: "<<",
	0xFE3E: ">> ",
	0xFE3F: "<",
	0xFE40: "> ",
	0xFE41: "[",
	0xFE42: "] ",
	0xFE43: "{",
	0xFE44: "}",
	0xFE50: ",",
	0xFE51: ",",
	0xFE52: ".",
	0xFE54: ";",
	0xFE55: ":",
	0xFE56: "?",
	0xFE57: "!",
	0xFE58: "-",
	0xFE59: "(",
	0xFE5A: ")",
	0xFE5B: "{",
	0xFE5C: "}",
	0xFE5D: "{",
	0xFE5E: "}",
	0xFE5F: "#",
	0xFE60: "&",
	0xFE61: "*",
	0xFE62: "+",
	0xFE63: "-",
	0xFE64: "<",
	0xFE65: ">",
	0xFE66: "=",
	0xFE68: "\\",
	0xFE69: "$",
	0xFE6A: "%",
	0xFE6B: "@",
	0xFF01: "!",
	0xFF02: "\"",
	0xFF03: "#",
	0xFF04: "$",
	0xFF05: "%",
	0xFF06: "&",
	0xFF07: "'",
	0xFF08: "(",
	0xFF09: ")",
	0xFF0A: "*",
	0xFF0B: "+",
	0xFF0C: ",",
	0xFF0D: "-",
	0xFF0E: ".",
	0xFF0F: "/",
	0xFF10: "0",
	0xFF11: "1",
	0xFF12: "2",
	0xFF13: "3",
	0xFF14: "4",
	0xFF15: "5",
	0xFF16: "6",
	0xFF17: "7",
	0xFF18: "8",
	0xFF19: "9",
	0xFF1A: ":",
	0xFF1B: ";",
	0xFF1C: "<",
	0xFF1D: "=",
	0xFF1E: ">",
	0xFF1F: "?",
	0xFF20: "@",
	0xFF21: "A",
	0xFF22: "B",
	0xFF23: "C",
	0xFF24: "D",
	0xFF25: "E",
	0xFF26: "F",
	0xFF27: "G",
	0xFF28: "H",
	0xFF29: "I",
	0xFF2A: "J",
	0xFF2B: "K",
	0xFF2C: "L",
	0xFF2D: "M",
	0xFF2E: "N",
	0xFF2F: "O",
	0xFF30: "P",
	0xFF31: "Q",
	0xFF32: "R",
	0xFF33: "S",
	0xFF34: "T",
	0xFF35: "U",
	0xFF36: "V",
	0xFF37: "W",
	0xFF38: "X",
	0xFF39: "Y",
	0xFF3A: "Z",
	0xFF3B: "[",
	0xFF3C: "\\",
	0xFF3D: "]",
	0xFF3E: "^",
	0xFF3F: "_",
	0xFF40: "`",
	0xFF41: "a",
	0xFF42: "b",
	0xFF43: "c",
	0xFF44: "d",
	0xFF45: "e",
	0xFF46: "f",
	0xFF47: "g",
	0xFF48: "h",
	0xFF49: "i",
	0xFF4A: "j",
	0xFF4B: "k",
	0xFF4C: "l",
	0xFF4D: "m",
	0xFF4E: "n",
	0xFF4F: "o",
	0xFF50: "p",
	0xFF51: "q",
	0xFF52: "r",
	0xFF53: "s",
	0xFF54: "t",
	0xFF55: "u",
	0xFF56: "v",
	0xFF57: "w",
	0xFF58: "x",
	0xFF59: "y",
	0xFF5A: "z",
	0xFF5B: "{",
	0xFF5C: "|",
	0xFF5D: "}",
	0xFF5E: "~",
	0xFF5F: "",
	0xFF60: "",
	0xFF61: ".",
	0xFF62: "[",
	0xFF63: "]",
	0xFF64: ",",
	0xFF65: "*",
	0xFF66: "wo",
	0xFF67: "a",
	0xFF68: "i",
	0xFF69: "u",
	0xFF6A: "e",
	0xFF6B: "o",
	0xFF6C: "ya",
	0xFF6D: "yu",
	0xFF6E: "yo",
	0xFF6F: "tu",
	0xFF70: "+",
	0xFF71: "a",
	0xFF72: "i",
	0xFF73: "u",
	0xFF74: "e",
	0xFF75: "o",
	0xFF76: "ka",
	0xFF77: "ki",
	0xFF78: "ku",
	0xFF79: "ke",
	0xFF7A: "ko",
	0xFF7B: "sa",
	0xFF7C: "si",
	0xFF7D: "su",
	0xFF7E: "se",
	0xFF7F: "so",
	0xFF80: "ta",
	0xFF81: "ti",
	0xFF82: "tu",
	0xFF83: "te",
	0xFF84: "to",
	0xFF85: "na",
	0xFF86: "ni",
	0xFF87: "nu",
	0xFF88: "ne",
	0xFF89: "no",
	0xFF8A: "ha",
	0xFF8B: "hi",
	0xFF8C: "hu",
	0xFF8D: "he",
	0xFF8E: "ho",
	0xFF8F: "ma",
	0xFF90: "mi",
	0xFF91: "mu",
	0xFF92: "me",
	0xFF93: "mo",
	0xFF94: "ya",
	0xFF95: "yu",
	0xFF96: "yo",
	0xFF97: "ra",
	0xFF98: "ri",
	0xFF99: "ru",
	0xFF9A: "re",
	0xFF9B: "ro",
	0xFF9C: "wa",
	0xFF9D: "n",
	0xFF9E: ":",
	0xFF9F: ";",
	0xFFA0: "",
	0xFFA1: "g",
	0xFFA2: "gg",
	0xFFA3: "gs",
	0xFFA4: "n",
	0xFFA5: "nj",
	0xFFA6: "nh",
	0xFFA7: "d",
	0xFFA8: "dd",
	0xFFA9: "r",
	0xFFAA: "lg",
	0xFFAB: "lm",
	0xFFAC: "lb",
	0xFFAD: "ls",
	0xFFAE: "lt",
	0xFFAF: "lp",
	0xFFB0: "rh",
	0xFFB1: "m",
	0xFFB2: "b",
	0xFFB3: "bb",
	0xFFB4: "bs",
	0xFFB5: "s",
	0xFFB6: "ss",
	0xFFB7: "",
	0xFFB8: "j",
	0xFFB9: "jj",
	0xFFBA: "c",
	0xFFBB: "k",
	0xFFBC: "t",
	0xFFBD: "p",
	0xFFBE: "h",
	0xFFC2: "a",
	0xFFC3: "ae",
	0xFFC4: "ya",
	0xFFC5: "yae",
	0xFFC6: "eo",
	0xFFC7: "e",
	0xFFCA: "yeo",
	0xFFCB: "ye",
	0xFFCC: "o",
	0xFFCD: "wa",
	0xFFCE: "wae",
	0xFFCF: "oe",
	0xFFD2: "yo",
	0xFFD3: "u",
	0xFFD4: "weo",
	0xFFD5: "we",
	0xFFD6: "wi",
	0xFFD7: "yu",
	0xFFDA: "eu",
	0xFFDB: "yi",
	0xFFDC: "i",
	0xFFE0: "/C",
	0xFFE1: "PS",
	0xFFE2: "!",
	0xFFE3: "-",
	0xFFE4: "|",
	0xFFE5: "Y=",
	0xFFE6: "W=",
	0xFFE8: "|",
	0xFFE9: "-",
	0xFFEA: "|",
	0xFFEB: "-",
	0xFFEC: "|",
	0xFFED: "#",
	0xFFEE: "O",
	0xFFF9: "{",
	0xFFFA: "|",
	0xFFFB: "}",
	0xFFFD: "?",
}

// FixMisusedLetters fixes Greek beta and German sharp s misuse
func FixMisusedLetters(str string, doHomoglyphs, isAuthor, isProse bool) string {

	var arry []string

	isReallyEszett := func(before, after string, mustBeAllCaps bool) bool {

		// trim at closest space before sharp s rune
		idx := strings.LastIndex(before, " ")
		if idx >= 0 {
			before = before[idx+1:]
		}

		// trim at closest space after sharp s rune
		idx = strings.Index(after, " ")
		if idx >= 0 {
			after = after[:idx]
		}

		isAllCaps := true

		// look at characters to the left
		if before == "" {
			// must not be first character
			return false
		}
		last := rune(0)
		for _, ch := range before {
			_, ok := germanRunes[ch]
			if !ok {
				return false
			}
			_, ok = germanCapitals[ch]
			if !ok {
				isAllCaps = false
			}
			last = ch
		}
		_, ok := germanVowels[last]
		if !ok {
			// character immediately to the left must be a vowel (actually, a long vowel or diphthong)
			// though after a consonant, if it really is German, it should become ss
			// perhaps that situation can be added to a future table for handling specific exceptions
			return false
		}

		// look at characters to the right
		for _, ch := range after {
			_, ok := germanRunes[ch]
			if !ok {
				return false
			}
			_, ok = germanCapitals[ch]
			if !ok {
				isAllCaps = false
			}
			last = ch
		}

		if mustBeAllCaps {
			// capital sharp S expects all letters to be capitalized
			if !isAllCaps {
				return false
			}
		} else if isAllCaps {
			// otherwise may be a gene name, should be using beta
			return false
		}

		return true
	}

	for i, ch := range str {

		if ch < 32 {
			// skip ASCII control characters
			continue
		}

		if doHomoglyphs {
			if ch == 976 || ch == 7517 || ch == 7526 {
				// convert curled (U+03D0), modifier (U+1D5D), and subscript (U+1D66) lookalikes
				// to lower-case Greek beta U+03B2)
				ch = 946
			} else if ch == 400 {
				// capital Latin open E (U+0190) to capital Greek Epsilon (U+0395)
				ch = 917
			} else if ch == 603 {
				// lower-case Latin open E (U+025B) to lower-case Greek epsilon (U+03B5)
				ch = 949
			}
		}

		if isAuthor {
			if ch == 946 || ch == 976 || ch == 7517 || ch == 7526 {
				// in author, replace lower-case Greek beta (U+03B2) with German sharp s (U+00DF),
				// also handles curled (U+03D0), modifier (U+1D5D), and subscript (U+1D66) lookalikes
				ch = 223
			} else if ch == 914 {
				// replace upper-case Greek Beta (U+0392) with Latin capital B
				ch = 66
			} else if ch == 34 {
				// and replace double quote by apostrophe
				ch = 39
			}
		}

		if isProse {
			if ch == 223 {
				// in text, German sharp s is occasionally correct
				if !isReallyEszett(str[:i], str[i+utf8.RuneLen(ch):], false) {
					// but in scientific papers usually should be Greek beta
					ch = 946
				}
			} else if ch == 946 || ch == 976 || ch == 7517 || ch == 7526 {
				// sometimes Greek beta should actually be German sharp s
				if isReallyEszett(str[:i], str[i+utf8.RuneLen(ch):], false) {
					ch = 223
				}
			} else if ch == 7838 {
				// also check whether to convert capitalized German sharp S (U+1E9E)
				if !isReallyEszett(str[:i], str[i+utf8.RuneLen(ch):], true) {
					ch = 946
				}
			}
		}

		arry = append(arry, string(ch))
	}

	str = strings.Join(arry, "")

	return str
}

// mutex to protect loading of external Unicode transformation table
var ulock sync.Mutex

// TransformAccents converts accented letters and symbols to closest ASCII equivalent
func TransformAccents(str string, spellGreek, reEncode bool) string {

	var arry []string

	loadExternRunes := func() bool {

		loaded := false

		ex, eerr := os.Executable()
		if eerr != nil {
			return false
		}

		exPath := filepath.Dir(ex)
		fpath := filepath.Join(exPath, "help", "unicode-extras.txt")
		file, ferr := os.Open(fpath)

		if file != nil && ferr == nil {
			scanner := bufio.NewScanner(file)
			for scanner.Scan() {
				str := scanner.Text()
				if str == "" {
					continue
				}
				cols := strings.SplitN(str, "\t", 2)
				if len(cols) != 2 {
					continue
				}
				n, err := strconv.ParseUint(cols[0], 16, 32)
				if err != nil {
					continue
				}
				ch := rune(n)
				st := cols[1]
				externRunes[ch] = st
				loaded = true
			}
		}
		file.Close()

		return loaded
	}

	for _, ch := range str {
		st := ""
		ok := false

		if ch < 128 {
			// add printable 7-bit ASCII character directly
			if ch > 31 {
				arry = append(arry, string(ch))
			}
			continue
		}

		if spellGreek {
			// spells Greek letters (e.g., alpha, beta) for easier searching,
			// handles glyph variants, treats Latin letter open E as Greek epsilon
			st, ok := greekRunes[ch]
			if ok {
				arry = append(arry, st)
				continue
			}
		}

		// lookup remaining characters in asciiRunes table
		st, ok = asciiRunes[ch]
		if !ok {
			// try symbolRunes table next
			st, ok = symbolRunes[ch]
		}
		if !ok {
			st, ok = extraRunes[ch]
		}
		if !ok && ch >= 0x0300 && ch <= 0x036F {
			// absorb combining accents
			continue
		}
		if !ok && ch > 0x33FF && ch < 0xFB00 {
			// load external table within mutex
			ulock.Lock()
			if !extRunesLoaded {
				extRunesLoaded = loadExternRunes()
			}
			ulock.Unlock()
			// may also check external ideograms
			if extRunesLoaded {
				st, ok = externRunes[ch]
			}
		}

		if ok {
			// leading and trailing spaces, if needed, are in maps
			arry = append(arry, st)
		}
	}

	str = strings.Join(arry, "")

	if reEncode && rfix != nil {
		// reencode angle brackets in XML
		for _, ch := range str {
			// check for presence of either angle bracket
			if ch == '<' || ch == '>' {
				// replace all occurrences and return result
				str = rfix.Replace(str)
				return str
			}
		}
	}

	return str
}

// EncodeAngleBrackets reencodes angle brackets in XML
func EncodeAngleBrackets(str string) string {

	if rfix != nil {
		for _, ch := range str {
			if ch == '<' || ch == '>' {
				str = rfix.Replace(str)
				return str
			}
		}
	}

	return str
}

// initialize rfix replacer and empty externRunes map before non-init functions are called
func init() {

	rfix = strings.NewReplacer(
		"<", "&lt;",
		">", "&gt;",
	)

	externRunes = make(map[rune]string)
}
