/**************************************************************************
*   gbftglob.c:
*   -- all the globally variables for gbfeat.c
*   -- all the defined variables in the gbfeat.h
*
***************************************************************************/

#include <stdio.h>
#include <ncbi.h>
#include <gbftdef.h>

static GbFeatName STATIC__ParFlat_GBQual_names[ParFlat_TOTAL_GBQUAL] = {
 {"allele", Class_text}, {"anticodon", Class_pos_aa},
 {"bound_moiety", Class_text}, {"cell_line", Class_text},
 {"cell_type", Class_text}, {"chromosome", Class_text},
 {"chloroplast", Class_none}, {"chromoplast", Class_none},
 {"citation", Class_bracket_int}, {"clone", Class_text},
 {"clone_lib", Class_text}, {"codon", Class_seq_aa},
 {"codon_start", Class_int_or}, {"cons_splice", Class_site},
 {"cultivar", Class_text}, {"cyanelle", Class_none},
 {"db_xref", Class_text}, {"dev_stage", Class_text},
 {"direction", Class_L_R_B}, {"EC_number", Class_ecnum},
 {"evidence", Class_exper}, {"exception", Class_text},
 {"frequency", Class_text}, {"function", Class_text},
 {"gene", Class_text}, {"gdb_xref", Class_text},
 {"germline", Class_none}, {"haplotype", Class_text},
 {"insertion_seq", Class_text}, {"isolate", Class_text},
 {"kinetoplast", Class_none}, {"label", Class_token},
 {"lab_host", Class_text}, {"map", Class_text},
 {"macronuclear", Class_none}, {"mitochondrion", Class_none},
 {"mod_base", Class_token}, {"note", Class_note},
 {"number", Class_number}, {"organism", Class_text},
 {"partial", Class_none}, {"PCR_conditions", Class_text},
 {"pop_variant", Class_text}, {"phenotype", Class_text},
 {"plasmid", Class_text}, {"product", Class_text},
 {"proviral", Class_none}, {"pseudo", Class_none},
 {"rearranged", Class_none}, { "replace", Class_text},
 {"rpt_family", Class_text}, {"rpt_type", Class_rpt},
 {"rpt_unit", Class_text}, { "sex", Class_text},
 {"sequenced_mol", Class_text}, { "serotype", Class_text},
 {"host", Class_text}, {"standard_name", Class_text},
 {"strain", Class_text}, {"sub_clone", Class_text},
 {"sub_species", Class_text}, {"sub_strain", Class_text},
 {"tissue_lib", Class_text},  {"tissue_type", Class_text},
 {"translation", Class_text}, {"transl_except", Class_pos_aa},
 {"transl_table", Class_int}, {"transposon", Class_text},
 {"usedin", Class_token}, {"variety", Class_text}, {"virion", Class_none},
 {"focus", Class_none}, { "specimen_voucher", Class_text},
 {"protein_id", Class_text}, { "country", Class_text},
 {"organelle", Class_text}, {"transcript_id", Class_text},
 {"transgenic", Class_none}, {"environmental_sample", Class_none},
 {"isolation_source", Class_text}, {"serovar", Class_text},
 {"locus_tag", Class_text}, {"mol_type", Class_text},
 {"segment", Class_text},{"ecotype", Class_text},
 {"estimated_length", Class_text}, {"operon", Class_text},
 {"old_locus_tag", Class_text}, {"compare", Class_text},
 {"experiment", Class_text}, { "inference", Class_text},
 {"rpt_unit_seq", Class_text}, {"rpt_unit_range", Class_text},
 {"ribosomal_slippage", Class_none}, {"trans_splicing", Class_none},
 {"collected_by", Class_text}, {"collection_date", Class_text},
 {"identified_by", Class_text}, {"lat_lon", Class_text},
 {"PCR_primers", Class_text}, {"mobile_element", Class_text},
 {"metagenomic", Class_none}, { "culture_collection", Class_text},
 {"bio_material", Class_text}, { "ncRNA_class", Class_text},
 {"tag_peptide", Class_text}, { "mating_type", Class_text},
 {"satellite", Class_text}, { "gene_synonym", Class_text}
};

NLM_EXTERN GbFeatNamePtr x_ParFlat_GBQual_names(void) {
  return STATIC__ParFlat_GBQual_names;
}

CharPtr ParFlat_IntOrString[ParFlat_TOTAL_IntOr] = {"1", "2", "3"};

CharPtr ParFlat_LRBString[ParFlat_TOTAL_LRB] = {"LEFT", "RIGHT", "BOTH"};

CharPtr ParFlat_ExpString[ParFlat_TOTAL_Exp] = {
                    "EXPERIMENTAL", "NOT_EXPERIMENTAL"};

CharPtr ParFlat_RptString[ParFlat_TOTAL_Rpt] = {
       "tandem", "inverted", "flanking", "terminal", "direct",
       "dispersed", "other"};

static SematicFeat STATIC__ParFlat_GBFeat[ParFlat_TOTAL_GBFEAT] = {
   {"allele", 0, {-1, -1, -1, -1, -1}, 19,
     {
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_frequency,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_phenotype,
      GBQUAL_product,
      GBQUAL_replace,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1}},
   {"attenuator", 0, {-1, -1, -1, -1, -1}, 17,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_phenotype,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1}},
   {"C_region", 0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"CAAT_signal", 0, {-1, -1, -1, -1, -1}, 15,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"CDS", 0, {-1, -1, -1, -1, -1}, 32,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_codon_start,
      GBQUAL_codon,
      GBQUAL_db_xref,
      GBQUAL_EC_number,
      GBQUAL_evidence,
      GBQUAL_exception,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gdb_xref,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_number,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_protein_id,
      GBQUAL_pseudo,
      GBQUAL_ribosomal_slippage,
      GBQUAL_standard_name,
      GBQUAL_trans_splicing,
      GBQUAL_transl_except,
      GBQUAL_transl_table,
      GBQUAL_translation,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1}},
   {"conflict",  1, {
      GBQUAL_citation, -1, -1, -1, -1}, 14,
     {
      GBQUAL_allele,
      GBQUAL_compare,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_replace,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1}},
   {"D-loop",  0, {-1, -1, -1, -1, -1}, 15,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"D_segment", 0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"enhancer",  0, {-1, -1, -1, -1, -1}, 17,
     {
      GBQUAL_allele,
      GBQUAL_bound_moiety,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1}},
   {"exon", 0, {-1, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_EC_number,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_number,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
   {"gap",  1, {
      GBQUAL_estimated_length, -1, -1, -1, -1}, 5,
     {
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_inference,
      GBQUAL_map,
      GBQUAL_note,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"GC_signal", 0, {-1, -1, -1, -1, -1}, 15,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"gene", 0, {-1, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_phenotype,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_trans_splicing,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
    {"iDNA", 0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_number,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"intron", 0, {-1, -1, -1, -1, -1}, 20,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_cons_splice,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_number,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1}},
   {"J_segment", 0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"LTR", 0, {-1, -1, -1, -1, -1}, 16,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"mat_peptide",  0, {-1, -1, -1, -1, -1}, 23,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_EC_number,
      GBQUAL_evidence,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1}},
   {"misc_binding",  1, {
      GBQUAL_bound_moiety, -1, -1, -1, -1}, 16,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"misc_difference", 0, {-1, -1, -1, -1, -1}, 20,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_clone,
      GBQUAL_compare,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_phenotype,
      GBQUAL_replace,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1}},
   {"misc_feature",  0, {-1, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_number,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_phenotype,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
   {"misc_recomb", 0, {-1, -1, -1, -1, -1}, 16,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"misc_RNA",  0, {-1, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_trans_splicing,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
   {"misc_signal",  0, {-1, -1, -1, -1, -1}, 19,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_phenotype,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1}},
   {"misc_structure",  0, {-1, -1, -1, -1, -1}, 17,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1}},
   {"modified_base",  1, {
      GBQUAL_mod_base, -1, -1, -1, -1}, 15,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_frequency,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"mRNA",  0, {-1, -1, -1, -1, -1}, 22,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_trans_splicing,
      GBQUAL_transcript_id,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1}},
   {"mutation",  0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_frequency,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_phenotype,
      GBQUAL_product,
      GBQUAL_replace,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"N_region",  0, {-1, -1, -1, -1, -1}, 16,
     {
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"ncRNA",  1, {
      GBQUAL_ncRNA_class, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_trans_splicing,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
   {"old_sequence",   1, {
      GBQUAL_citation, -1, -1, -1, -1}, 15,
     {
      GBQUAL_allele,
      GBQUAL_compare,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_replace,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"operon", 1, {
      GBQUAL_operon, -1, -1, -1, -1}, 14,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_partial,
      GBQUAL_phenotype,
      GBQUAL_pseudo,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1}},
   {"oriT", 0, {-1, -1, -1, -1, -1}, 23,
     {
      GBQUAL_allele,
      GBQUAL_bound_moiety,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_direction,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_rpt_family,
      GBQUAL_rpt_type,
      GBQUAL_rpt_unit,
      GBQUAL_rpt_unit_range,
      GBQUAL_rpt_unit_seq,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1}},
   {"polyA_signal", 0, {-1, -1, -1, -1, -1}, 15,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"polyA_site", 0, {-1, -1, -1, -1, -1}, 14,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1}},
   {"precursor_RNA",  0, {-1, -1, -1, -1, -1}, 20,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_standard_name,
      GBQUAL_trans_splicing,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1}},
   {"prim_transcript",  0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"primer_bind",  0, {-1, -1, -1, -1, -1}, 17,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_PCR_conditions,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1}},
   {"promoter",  0, {-1, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_bound_moiety,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_phenotype,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
   {"protein_bind",  1, {
      GBQUAL_bound_moiety, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"RBS",  0, {-1, -1, -1, -1, -1}, 16,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"repeat_region",  0, {-1, -1, -1, -1, -1}, 26,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_insertion_seq,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_mobile_element,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_rpt_family,
      GBQUAL_rpt_type,
      GBQUAL_rpt_unit,
      GBQUAL_rpt_unit_range,
      GBQUAL_rpt_unit_seq,
      GBQUAL_satellite,
      GBQUAL_standard_name,
      GBQUAL_transposon,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"repeat_unit",  0, {-1, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_rpt_family,
      GBQUAL_rpt_type,
      GBQUAL_rpt_unit,
      GBQUAL_rpt_unit_range,
      GBQUAL_rpt_unit_seq,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
   {"rep_origin",  0, {-1, -1, -1, -1, -1}, 17,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_direction,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1}},
   {"rRNA",  0, {-1, -1, -1, -1, -1}, 20,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1}},
   {"S_region",  0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"satellite",  0, {-1, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_rpt_family,
      GBQUAL_rpt_type,
      GBQUAL_rpt_unit,
      GBQUAL_rpt_unit_range,
      GBQUAL_rpt_unit_seq,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
   {"scRNA",  0, {-1, -1, -1, -1, -1}, 19,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1}},
   {"sig_peptide", 0, {-1, -1, -1, -1, -1}, 19,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1}},
   {"snoRNA",  0, {-1, -1, -1, -1, -1}, 19,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1}},
   {"snRNA",  0, {-1, -1, -1, -1, -1}, 19,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1}},
   {"source", 1, {
      GBQUAL_organism, -1, -1, -1, -1}, 62,
     {
      GBQUAL_bio_material,
      GBQUAL_cell_line,
      GBQUAL_cell_type,
      GBQUAL_chloroplast,
      GBQUAL_chromoplast,
      GBQUAL_chromosome,
      GBQUAL_citation,
      GBQUAL_clone_lib,
      GBQUAL_clone,
      GBQUAL_collected_by,
      GBQUAL_collection_date,
      GBQUAL_country,
      GBQUAL_cultivar,
      GBQUAL_culture_collection,
      GBQUAL_cyanelle,
      GBQUAL_db_xref,
      GBQUAL_dev_stage,
      GBQUAL_ecotype,
      GBQUAL_environmental_sample,
      GBQUAL_focus,
      GBQUAL_frequency,
      GBQUAL_germline,
      GBQUAL_haplotype,
      GBQUAL_identified_by,
      GBQUAL_insertion_seq,
      GBQUAL_isolate,
      GBQUAL_isolation_source,
      GBQUAL_kinetoplast,
      GBQUAL_lab_host,
      GBQUAL_label,
      GBQUAL_lat_lon,
      GBQUAL_macronuclear,
      GBQUAL_map,
      GBQUAL_mating_type,
      GBQUAL_metagenomic,
      GBQUAL_mitochondrion,
      GBQUAL_mol_type,
      GBQUAL_note,
      GBQUAL_organelle,
      GBQUAL_PCR_primers,
      GBQUAL_plasmid,
      GBQUAL_pop_variant,
      GBQUAL_proviral,
      GBQUAL_rearranged,
      GBQUAL_segment,
      GBQUAL_sequenced_mol,
      GBQUAL_serotype,
      GBQUAL_serovar,
      GBQUAL_sex,
      GBQUAL_specific_host,
      GBQUAL_specimen_voucher,
      GBQUAL_strain,
      GBQUAL_sub_clone,
      GBQUAL_sub_species,
      GBQUAL_sub_strain,
      GBQUAL_tissue_lib,
      GBQUAL_tissue_type,
      GBQUAL_transgenic,
      GBQUAL_transposon,
      GBQUAL_usedin,
      GBQUAL_variety,
      GBQUAL_virion,
      -1, -1, -1}},
   {"stem_loop",  0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"STS",  0, {-1, -1, -1, -1, -1}, 16,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"TATA_signal",  0, {-1, -1, -1, -1, -1}, 15,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"terminator",  0, {-1, -1, -1, -1, -1}, 17,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1}},
   {"tmRNA",  0, {-1, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_tag_peptide,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
   {"transit_peptide",  0, {-1, -1, -1, -1, -1}, 19,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1}},
   {"tRNA",  0, {-1, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_anticodon,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_trans_splicing,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
   {"unsure",  0, {-1, -1, -1, -1, -1}, 15,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_replace,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}},
   {"V_region",  0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"V_segment",  0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_product,
      GBQUAL_pseudo,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"variation",  0, {-1, -1, -1, -1, -1}, 21,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_compare,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_frequency,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_phenotype,
      GBQUAL_product,
      GBQUAL_replace,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1}},
   {"3'clip",  0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_trans_splicing,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"3'UTR",  0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_trans_splicing,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"5'clip",  0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_trans_splicing,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"5'UTR",  0, {-1, -1, -1, -1, -1}, 18,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_function,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_trans_splicing,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1}},
   {"-10_signal",  0, {-1, -1, -1, -1, -1}, 17,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1}},
   {"-35_signal",  0, {-1, -1, -1, -1, -1}, 17,
     {
      GBQUAL_allele,
      GBQUAL_citation,
      GBQUAL_db_xref,
      GBQUAL_evidence,
      GBQUAL_experiment,
      GBQUAL_gene,
      GBQUAL_gene_synonym,
      GBQUAL_inference,
      GBQUAL_label,
      GBQUAL_locus_tag,
      GBQUAL_map,
      GBQUAL_note,
      GBQUAL_old_locus_tag,
      GBQUAL_operon,
      GBQUAL_partial,
      GBQUAL_standard_name,
      GBQUAL_usedin,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1}}
};

NLM_EXTERN SematicFeatPtr x_ParFlat_GBFeat(void) {
  return STATIC__ParFlat_GBFeat;
}

NLM_EXTERN ValNodePtr Validate_ParFlat_GBFeat (void)

{
  Char            buf [80];
  ValNodePtr      head = NULL;
  Int2            j, k, cnt;
  SematicFeatPtr  sfp;

  for (j = 0; j < ParFlat_TOTAL_GBFEAT; j++) {
    sfp = &(STATIC__ParFlat_GBFeat [j]);
    cnt = 0;
    for (k = 0; k < 5; k++) {
      if (sfp->mand_qual [k] != -1) {
        cnt++;
      }
    }
    if (cnt != sfp->mand_num) {
      sprintf (buf, "%s has %d mandatory qualifiers but claims %d", sfp->key, (int) cnt, (int) sfp->mand_num);
      ValNodeCopyStr (&head, 0, buf);
    }
    cnt = 0;
    for (k = 0; k < 65; k++) {
      if (sfp->opt_qual [k] != -1) {
        cnt++;
      }
    }
    if (cnt != sfp->opt_num) {
      sprintf (buf, "%s has %d optional qualifiers but claims %d", sfp->key, (int) cnt, (int) sfp->opt_num);
      ValNodeCopyStr (&head, 0, buf);
    }
  }
  return head;
}

