/* terminfo emulation through hardwired ANSI escape sequences.

	Copyright (C) 2001-2005 Todd M. Lewis and Sebastiano Vigna

	This file is part of ne, the nice editor.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2, or (at your option) any
	later version.
	
	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.
	
	You should have received a copy of the GNU General Public License along
	with this program; see the file COPYING.  If not, write to the Free
	Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.  */


#include "ne.h"
#include "info2cap.h"
#include <stdarg.h>


/* This is the number of characters reserved to strings obtained through
	tparam(). They *have* to be enough, because otherwise the capability string
	will be silently truncated. */

#define TPARAM_BUF_LEN 2048



/* These variable declarations match the #define's which access the terminal
	structure under terminfo. */

int generic_type;

int lines;
int columns;

char *column_address;
char *row_address;

char *cursor_address;

char *carriage_return;

char *cursor_home;
char *cursor_to_ll;

char *cursor_right;
char *cursor_down;
char *cursor_left;
char *cursor_up;

int auto_right_margin;
int eat_newline_glitch;

char *clr_eos;
char *clear_screen;

char *bell;
char *flash_screen;

char *scroll_forward;
char *scroll_reverse;

char *enter_delete_mode;
char *exit_delete_mode;
char *enter_insert_mode;
char *exit_insert_mode;

char *enter_standout_mode;
char *exit_standout_mode;
int magic_cookie_glitch;
int move_standout_mode;

char *change_scroll_region;

char *insert_line;
char *parm_insert_line;
char *delete_line;
char *parm_delete_line;

char *insert_character;
char *insert_padding;
char *parm_ich;

char *delete_character;
char *parm_dch;

int move_insert_mode;

char *cursor_invisible;
char *cursor_normal;

char *init_1string;
char *init_2string;
char *init_3string;
char *enter_ca_mode;
char *exit_ca_mode;

char *exit_attribute_mode;
char *exit_alt_charset_mode;

char *repeat_char;

int tilde_glitch;
int memory_below;

int has_meta_key;
char *meta_on;
char *meta_off;

char *set_window;

char *keypad_local;
char *keypad_xmit;

char *clr_eol;
int transparent_underline;

char *key_up;
char *key_down;
char *key_left;
char *key_right;

char *key_home;
char *key_end;

char *key_npage;
char *key_ppage;

char *key_sf;
char *key_sr;

char *key_eol;
char *key_eos;
char *key_backspace;
char *key_dl;
char *key_il;
char *key_dc;
char *key_ic;
char *key_eic;
char *key_clear;

char *key_a1;
char *key_a3;
char *key_b2;
char *key_c1;
char *key_c3;

char *key_catab;
char *key_ctab;
char *key_stab;

char *key_f0;
char *key_f1;
char *key_f2;
char *key_f3;
char *key_f4;
char *key_f5;
char *key_f6;
char *key_f7;
char *key_f8;
char *key_f9;
char *key_f10;

char *key_f11;
char *key_f12;
char *key_f13;
char *key_f14;
char *key_f15;
char *key_f16;
char *key_f17;
char *key_f18;
char *key_f19;
char *key_f20;
char *key_f21;
char *key_f22;
char *key_f23;
char *key_f24;
char *key_f25;
char *key_f26;
char *key_f27;
char *key_f28;
char *key_f29;
char *key_f30;
char *key_f31;
char *key_f32;
char *key_f33;
char *key_f34;
char *key_f35;
char *key_f36;
char *key_f37;
char *key_f38;
char *key_f39;
char *key_f40;
char *key_f41;
char *key_f42;
char *key_f43;
char *key_f44;
char *key_f45;
char *key_f46;
char *key_f47;
char *key_f48;
char *key_f49;
char *key_f50;
char *key_f51;
char *key_f52;
char *key_f53;
char *key_f54;
char *key_f55;
char *key_f56;
char *key_f57;
char *key_f58;
char *key_f59;
char *key_f60;
char *key_f61;
char *key_f62;
char *key_f63;



/* The tparm() emulation. Note that we have to use a static buffer (because
	tparm() does it). Thus, instantiated strings longer than TPARAM_BUF_LEN will
	be copied in tparam_buffer and silently truncated. It should never happen
	with reasonable values for TPARAM_BUF_LEN, though. */

char *tparm(const char *cap_string,...) {

	static char tparam_buffer[TPARAM_BUF_LEN];

	va_list ap;
	char *p;
	int i, arg[4];

	va_start(ap, cap_string);
	for(i = 0; i < 4; i++) arg[i] = va_arg(ap, int);
	va_end(ap);

	p = tparam(cap_string, tparam_buffer, TPARAM_BUF_LEN, arg[0], arg[1], arg[2], arg[3]);

	if (p != tparam_buffer) {
		memcpy(tparam_buffer, p, TPARAM_BUF_LEN - 1);
		free(p);
	}

	return tparam_buffer;
}


/* This is a real fake. We already know all the parameters. */

int setupterm(const char *dummy1, int dunmmy2, int *dummy3) {

	int l,c;
	char *s;
	struct termios termios;

	tcgetattr(0, &termios);

	switch(cfgetospeed(&termios)) {

		case B50:
			ospeed = 1;
			break;

		case B75:
			ospeed = 2;
			break;

		case B110:
			ospeed = 3;
			break;

		case B134:
			ospeed = 4;
			break;

		case B150:
			ospeed = 5;
			break;

		case B200:
			ospeed = 6;
			break;

		case B300:
			ospeed = 7;
			break;

		case B600:
			ospeed = 8;
			break;

		case B1200:
			ospeed = 9;
			break;

		case B1800:
			ospeed = 10;
			break;

		case B2400:
			ospeed = 11;
			break;

		case B4800:
			ospeed = 12;
			break;

		case B9600:
			ospeed = 13;
			break;

		case B19200:
			ospeed = 14;
			break;
	}

	if (ospeed == 0) ospeed = 15;

	lines = 25;
	columns = 80;

	l = c = 0;
	if (s = getenv("LINES")) l = atoi(s);
	if (s = getenv("COLUMNS")) c = atoi(s);
	if (l > 0 && c > 0) {
		lines = l;
		columns = c;
	}

	cursor_address = "\x1b[%i%d;%dH";
	carriage_return = "\xd";
	cursor_home = "\x1b[H";
	cursor_right = "\x1b[C";
	cursor_down = "\x1b[B";
	cursor_left = "\x1b[D";
	cursor_up = "\x1b[A";
	auto_right_margin = 1;
	eat_newline_glitch = 0;
	clr_eos = "\x1b[J";
	clear_screen = "\x1b[H\x1b[J";
	bell = "\x7";
	scroll_forward = "\xa";
	enter_standout_mode = "\x1b[7m";
	exit_standout_mode = "\x1b[m";
	magic_cookie_glitch = 0;
	move_standout_mode = 1;
	insert_line = "\x1b[L";
	delete_line = "\x1b[M";
	delete_character = "\x1b[P";
	move_insert_mode = 1;
	exit_attribute_mode = "\x1b[0;10m";
	exit_alt_charset_mode = "\x1b[10m";
	tilde_glitch = 0;
	memory_below = 0;
	has_meta_key = 0;
	clr_eol = "\x1b[K";
	transparent_underline = 0;
	key_up = "\x1b[A";
	key_down = "\x1b[B";
	key_left = "\x1b[D";
	key_right = "\x1b[C";
	key_home = "\x1b[H";
	key_backspace = "\x8";
}
