/* Input class, key bindings and upper casing vector definitions.

	Copyright (C) 1993-1998 Sebastiano Vigna 
	Copyright (C) 1999-2006 Todd M. Lewis and Sebastiano Vigna

	This file is part of ne, the nice editor.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2, or (at your option) any
	later version.
	
	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.
	
	You should have received a copy of the GNU General Public License along
	with this program; see the file COPYING.  If not, write to the Free
	Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.  */


#include "ne.h"


/* This vector contains all key bindings. Each entry points to a command line
	to be executed when the corresponding keystroke is input. The index
	correspond to the ASCII code, and to the codes defined in keycodes.h for the
	special keys. Note that it is nonsense to specify a binding for a key whose
	class is not COMMAND. */

#ifndef SHELLKEYS
  #define PICK(A,B) A
#else
  #define PICK(A,B) B
#endif

const char *key_binding[NUM_KEYS] = {

	/* Control-letter bindings */

	/* @ a b c d e f g */
	/* ^@ */      MARKVERT_ABBREV,
	/* ^a */      MOVESOL_ABBREV,
	/* ^b */      MARK_ABBREV,
	/* ^c */      COPY_ABBREV,
	/* ^d */ PICK(NEWDOC_ABBREV,       NULL),
	/* ^e */      MOVEEOL_ABBREV,
	/* ^f */      FIND_ABBREV,
	/* ^g */      REPEATLAST_ABBREV,

	/* h i j k l m n o */
	/* ^h */      BACKSPACE_ABBREV,
	/* ^i */      NULL,
	/* ^j */      GOTOLINE_ABBREV,
	/* ^k */      EXEC_ABBREV,
	/* ^l */      REFRESH_ABBREV,
	/* ^m */      NULL,
	/* ^n */ PICK(NEXTPAGE_ABBREV,     PAGEDOWN_ABBREV),
	/* ^o */      OPEN_ABBREV,

	/* p q r s t u v w */
	/* ^p */ PICK(PREVPAGE_ABBREV,     PAGEUP_ABBREV),
	/* ^q */      CLOSEDOC_ABBREV,
	/* ^r */      REPLACE_ABBREV,
	/* ^s */      SAVE_ABBREV,
	/* ^t */      RECORD_ABBREV,
	/* ^u */      UNDELLINE_ABBREV,
	/* ^v */      PASTE_ABBREV,
	/* ^w */      PASTEVERT_ABBREV,

	/* x y z [ \ ] ^ _ */
	/* ^x */      CUT_ABBREV,
	/* ^y */      DELETELINE_ABBREV,
	/* ^z */      SUSPEND_ABBREV,
	/* ^[ */      ESCAPE_ABBREV,
	/* ^\ */      NULL,
	/* ^] */      MATCHBRACKET_ABBREV,
	/* ^^ */      ADJUSTVIEW_ABBREV,
	/* ^_ */      FINDREGEXP_ABBREV,

	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,

	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, DELETECHAR_ABBREV,

	/* Control-meta-letter bindings */

	/* @ a b c d e f g h i j k l m n o */
	NULL, MOVESOF_ABBREV, PREVWORD_ABBREV, CENTERVIEW_ABBREV, NEXTDOC_ABBREV, MOVEEOF_ABBREV, NEXTWORD_ABBREV, GOTOBOOKMARK_ABBREV, NULL, AUTOINDENT_ABBREV, GOTOCOLUMN_ABBREV, SETBOOKMARK_ABBREV, TOLOWER_ABBREV, PLAYONCE_ABBREV, OPENNEW_ABBREV, OPENCLIP_ABBREV,

	/* p q r s t u v w x y z [ \ ] ^  _*/
	PARAGRAPH_ABBREV, QUIT_ABBREV, REDO_ABBREV, SAVECLIP_ABBREV, THROUGH_ABBREV, UNDO_ABBREV, TOUPPER_ABBREV, WORDWRAP_ABBREV, EXIT_ABBREV, DELETEEOL_ABBREV, CRLF_ABBREV, NULL, NULL, NULL, NULL, NULL,

	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,

	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,


	/* The following bindings are for the terminfo extended codes (see keycodes.h). */

	/* Cursor movement keys */
	NULL, LINEUP_ABBREV, LINEDOWN_ABBREV, MOVELEFT_ABBREV, MOVERIGHT_ABBREV, MOVEINCUP_ABBREV, MOVEINCDOWN_ABBREV, NEXTPAGE_ABBREV,
	PREVPAGE_ABBREV, LINEDOWN_ABBREV, LINEUP_ABBREV, NULL, NULL, NULL, NULL, NULL,

	/* Editing keys */
	DELETEEOL_ABBREV, NULL, BACKSPACE_ABBREV, DELETELINE_ABBREV, UNDELLINE_ABBREV, DELETECHAR_ABBREV, INSERT_ABBREV, NULL,
	CLEAR_ABBREV, NULL, NULL, NULL, NULL, NULL, NULL, NULL,

	/* Keypad keys and fake (simulated) menu key */
	MOVESOF_ABBREV, PREVPAGE_ABBREV, TOGGLESEOL_ABBREV, MOVEEOF_ABBREV, NEXTPAGE_ABBREV, EXEC_ABBREV, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,

	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,

	/* Function keys */
	ESCAPE_ABBREV, ESCAPE_ABBREV, NEXTDOC_ABBREV, PREVDOC_ABBREV, SELECTDOC_ABBREV, UNDO_ABBREV, REDO_ABBREV, PREVWORD_ABBREV,
	NEXTWORD_ABBREV, PLAYONCE_ABBREV, HELP_ABBREV, NULL, NULL, NULL, NULL, NULL,

	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,

	/* Prefix-simulated META */

	/* ^- @ a b c d e f g h i j k l m n o */
	NULL, MOVESOF_ABBREV, PREVWORD_ABBREV, CENTERVIEW_ABBREV, NEXTDOC_ABBREV, MOVEEOF_ABBREV, NEXTWORD_ABBREV, GOTOBOOKMARK_ABBREV, NULL, AUTOINDENT_ABBREV, GOTOCOLUMN_ABBREV, SETBOOKMARK_ABBREV, TOLOWER_ABBREV, PLAYONCE_ABBREV, OPENNEW_ABBREV, OPENCLIP_ABBREV,
	
	/* ^- p q r s t u v w x y z [ \ ] ^  _*/
	PARAGRAPH_ABBREV, QUIT_ABBREV, REDO_ABBREV, SAVECLIP_ABBREV, THROUGH_ABBREV, UNDO_ABBREV, TOUPPER_ABBREV, WORDWRAP_ABBREV, EXIT_ABBREV, DELETEEOL_ABBREV, CRLF_ABBREV, NULL, NULL, NULL, NULL, NULL,

	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,

	/* @ A B C D E F G H I J K L M N O */
	NULL, MOVESOF_ABBREV, PREVWORD_ABBREV, CENTERVIEW_ABBREV, NEXTDOC_ABBREV, MOVEEOF_ABBREV, NEXTWORD_ABBREV, GOTOBOOKMARK_ABBREV, NULL, AUTOINDENT_ABBREV, GOTOCOLUMN_ABBREV, SETBOOKMARK_ABBREV, TOLOWER_ABBREV, PLAYONCE_ABBREV, OPENNEW_ABBREV, OPENCLIP_ABBREV,

	/* P Q R S T U V W X Y Z [ \ ] ^  _*/
	PARAGRAPH_ABBREV, QUIT_ABBREV, REDO_ABBREV, SAVECLIP_ABBREV, THROUGH_ABBREV, UNDO_ABBREV, TOUPPER_ABBREV, WORDWRAP_ABBREV, EXIT_ABBREV, DELETEEOL_ABBREV, CRLF_ABBREV, NULL, NULL, NULL, NULL, NULL,

	/* @ a b c d e f g h i j k l m n o */
	NULL, MOVESOF_ABBREV, PREVWORD_ABBREV, CENTERVIEW_ABBREV, NEXTDOC_ABBREV, MOVEEOF_ABBREV, NEXTWORD_ABBREV, GOTOBOOKMARK_ABBREV, NULL, AUTOINDENT_ABBREV, GOTOCOLUMN_ABBREV, SETBOOKMARK_ABBREV, TOLOWER_ABBREV, PLAYONCE_ABBREV, OPENNEW_ABBREV, OPENCLIP_ABBREV,

	/* p q r s t u v w x y z [ \ ] ^  _*/
	PARAGRAPH_ABBREV, QUIT_ABBREV, REDO_ABBREV, SAVECLIP_ABBREV, THROUGH_ABBREV, UNDO_ABBREV, TOUPPER_ABBREV, WORDWRAP_ABBREV, EXIT_ABBREV, DELETEEOL_ABBREV, CRLF_ABBREV, NULL, NULL, NULL, NULL, NULL


};



/* This vector holds, for each ISO-8859-1 key code, its input class. */

const input_class char_class[256] = {

	/* Control-letter classes */

	/* @ a b c d e f g h i j k l m n o */
	COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, TAB, COMMAND, COMMAND, COMMAND, RETURN, COMMAND, COMMAND,

	/* p q r s t u v w x y z [ \ ] ^ _ */
	COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND,

	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA,
	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA,

	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA,
	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA,
	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA,
	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, COMMAND,

	/* Control-meta-letter classes
	PORTABILITY PROBLEM: on some systems, these characters are printable. In this case,
	it is a good idea to define their type as ALPHA, so that you can type them in the
	text. They are COMMAND by default because this is what happens in ISO Latin 1. */

	/* @ a b c d e f g h i j k l m n o */
	COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND,

	/* p q r s t u v w x y z [ \ ] ^ _ */
	COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND, COMMAND,

	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA,
	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA,

	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA,
	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA,
	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA,
	ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA, ALPHA
};


const char meta_prefixed[128][3] = {
	{ '\x1b', 0 },
	{ '\x1b', 1 },
	{ '\x1b', 2 },
	{ '\x1b', 3 },
	{ '\x1b', 4 },
	{ '\x1b', 5 },
	{ '\x1b', 6 },
	{ '\x1b', 7 },
	{ '\x1b', 8 },
	{ '\x1b', 9 },
	{ '\x1b', 10 },
	{ '\x1b', 11 },
	{ '\x1b', 12 },
	{ '\x1b', 13 },
	{ '\x1b', 14 },
	{ '\x1b', 15 },
	{ '\x1b', 16 },
	{ '\x1b', 17 },
	{ '\x1b', 18 },
	{ '\x1b', 19 },
	{ '\x1b', 20 },
	{ '\x1b', 21 },
	{ '\x1b', 22 },
	{ '\x1b', 23 },
	{ '\x1b', 24 },
	{ '\x1b', 25 },
	{ '\x1b', 26 },
	{ '\x1b', 27 },
	{ '\x1b', 28 },
	{ '\x1b', 29 },
	{ '\x1b', 30 },
	{ '\x1b', 31 },
	{ '\x1b', 32 },
	{ '\x1b', 33 },
	{ '\x1b', 34 },
	{ '\x1b', 35 },
	{ '\x1b', 36 },
	{ '\x1b', 37 },
	{ '\x1b', 38 },
	{ '\x1b', 39 },
	{ '\x1b', 40 },
	{ '\x1b', 41 },
	{ '\x1b', 42 },
	{ '\x1b', 43 },
	{ '\x1b', 44 },
	{ '\x1b', 45 },
	{ '\x1b', 46 },
	{ '\x1b', 47 },
	{ '\x1b', 48 },
	{ '\x1b', 49 },
	{ '\x1b', 50 },
	{ '\x1b', 51 },
	{ '\x1b', 52 },
	{ '\x1b', 53 },
	{ '\x1b', 54 },
	{ '\x1b', 55 },
	{ '\x1b', 56 },
	{ '\x1b', 57 },
	{ '\x1b', 58 },
	{ '\x1b', 59 },
	{ '\x1b', 60 },
	{ '\x1b', 61 },
	{ '\x1b', 62 },
	{ '\x1b', 63 },
	{ '\x1b', 64 },
	{ '\x1b', 65 },
	{ '\x1b', 66 },
	{ '\x1b', 67 },
	{ '\x1b', 68 },
	{ '\x1b', 69 },
	{ '\x1b', 70 },
	{ '\x1b', 71 },
	{ '\x1b', 72 },
	{ '\x1b', 73 },
	{ '\x1b', 74 },
	{ '\x1b', 75 },
	{ '\x1b', 76 },
	{ '\x1b', 77 },
	{ '\x1b', 78 },
	{ '\x1b', 79 },
	{ '\x1b', 80 },
	{ '\x1b', 81 },
	{ '\x1b', 82 },
	{ '\x1b', 83 },
	{ '\x1b', 84 },
	{ '\x1b', 85 },
	{ '\x1b', 86 },
	{ '\x1b', 87 },
	{ '\x1b', 88 },
	{ '\x1b', 89 },
	{ '\x1b', 90 },
	{ '\x1b', 91 },
	{ '\x1b', 92 },
	{ '\x1b', 93 },
	{ '\x1b', 94 },
	{ '\x1b', 95 },
	{ '\x1b', 96 },
	{ '\x1b', 97 },
	{ '\x1b', 98 },
	{ '\x1b', 99 },
	{ '\x1b', 100 },
	{ '\x1b', 101 },
	{ '\x1b', 102 },
	{ '\x1b', 103 },
	{ '\x1b', 104 },
	{ '\x1b', 105 },
	{ '\x1b', 106 },
	{ '\x1b', 107 },
	{ '\x1b', 108 },
	{ '\x1b', 109 },
	{ '\x1b', 110 },
	{ '\x1b', 111 },
	{ '\x1b', 112 },
	{ '\x1b', 113 },
	{ '\x1b', 114 },
	{ '\x1b', 115 },
	{ '\x1b', 116 },
	{ '\x1b', 117 },
	{ '\x1b', 118 },
	{ '\x1b', 119 },
	{ '\x1b', 120 },
	{ '\x1b', 121 },
	{ '\x1b', 122 },
	{ '\x1b', 123 },
	{ '\x1b', 124 },
	{ '\x1b', 125 },
	{ '\x1b', 126 },
	{ '\x1b', 127 }
};
