/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: cli.h,v 1.56 2009-08-01 09:23:55 anton Exp $ */

/////////////////////////////////////////////////////////////////////////////////////////
extern struct cli_def *CLI;
////////////////////////////////////////////////////////////////////////////////////////
void aInitCli();
void aReleaseCli();
void InitCliCommands(const struct CMD_DB *cmddb);
////////////////////////////////////////////////////////////////////////////////////////
#define CLI_CHECK_NO(cmd)           (!strncmp(cmd, "no", 2))
/////////////////////////////////////////////////////////////////////////////////////////
#define MODE_ANY                -1
#define MODE_EXEC               0
#define MODE_CONFIG             1

#define MODE_ACL_SERVER		2
#define MODE_ALERTER		3
#define MODE_BILLING		4
#define MODE_DATASOURCE		5
#define MODE_HTML		6
#define MODE_LOGIN		7
#define MODE_MONITOR		8
#define MODE_PROCESSOR		9
#define MODE_QUOTA		11
#define MODE_QUOTACTL		12
#define MODE_SCHEDULER		13
#define MODE_SERVER		14
#define MODE_STORAGE		15
/////////////////////////////////////////////////////////////////////////////////////////
struct CMD_DB {
	int id;   //number of command that has subcommand, others are zero
	int pid;  //parent command id
	int no_pid; //command have "no" prefix
	const char *command;  //command word we recognize
	int priv;
	int mode;    //MODE_EXEC, MODE_ANY, MODE_CONFIG
	int (*callback)(struct cli_def *, const char *, char **, int);
	const char *help;
};
/////////////////////////////////////////////////////////////////////////////////////////
////commands
int cShowUsers		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cShowUnits		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cShowProcessor	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cShowVersion	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cShowPolicy		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cShowConfig		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cShowPerf		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cShowUnitsList	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cSave		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cAutoSave		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cAutoSaveRun	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cDebug		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cRotate		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cLang		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cUser		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cLoad		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cTermination	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cHtml		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cMac		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cShowDebugMemory	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cShowDebugMutex	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cServiceProcessCfg	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cServiceStart	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cServiceStop	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cShowSystemHealth	(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cRawData		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cRadius		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cEnable		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cSchedule		(struct cli_def *cli, const char *cmd, char **argv, int argc);
int cPam		(struct cli_def *cli, const char *cmd, char **argv, int argc);
///////////////////////////////////////////////////////////////////////////////////////////
