/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: flow.h,v 1.61 2008-02-23 08:35:02 anton Exp $ */

#ifndef NA_FLOW_H
#define NA_FLOW_H

//#include "config.h"

#define ATTR_FLOW_INFO	0
struct	flow_info_value {
	u_long		packets;
	u_int64_t	octets;
	time_t		flow_first;
	time_t		flow_last;
	u_char		direction;
} __attribute__((packed));

#define	ATTR_IPV4_INFO	1
struct	ipv4_info_value {
    struct in_addr	ip_src, ip_dst;
    u_char		ip_p;
    u_char		ip_tos;
} __attribute__((packed));

#define ATTR_TCP_INFO	2
struct tcp_info_value {
    u_short	src_port;
    u_short	dst_port;
} __attribute__((packed));


#define	ATTR_MAC_INFO	3
struct mac_info_value {
	u_char		src[ETHER_ADDR_LEN];
	u_char		dst[ETHER_ADDR_LEN];
} __attribute__((packed));

#define	ATTR_VLAN_INFO	4
#define DOT1X_VLAN_MASK	0x0FFF
#define DOT1X_GET_VLAN(value) ((value) & DOT1X_VLAN_MASK)
#define DOT1X_GET_CFI(value) (((value) >> 12) & 1)
#define DOT1X_GET_PRI(value) (((value) >> 13) & 7)
struct vlan_info_value {
	u_int16_t	dot1x;
} __attribute__((packed));

#define	ATTR_AS_INFO	5
struct	as_info_value {
    u_short	as_src;
    u_short	as_dst;
} __attribute__((packed));

#define	ATTR_IFINDEX_INFO	6
struct	ifindex_info_value {
    u_short	if_in;
    u_short	if_out;
} __attribute__((packed));

#define ATTR_MULTICAST_INFO	7
struct multicast_info_value {
    u_int64_t	dst_packets;
    u_int64_t	dst_bytes;
    u_char	igmp_type;
} __attribute__((packed));

#define ATTR_NEXTHOP_INFO	8
struct nexthop_info_value {
    struct in_addr	ipv4_nexthop;
    struct in_addr	bgpv4_nexthop;
} __attribute__((packed));

#define ATTR_LAYER7_INFO	9
struct layer7_info_value {
    u_char type;
    char* value;
} __attribute__((packed));

union attribute_value {
	struct flow_info_value		flow_info;
	struct ipv4_info_value		ipv4_info;
	struct tcp_info_value		tcp_info;
	struct mac_info_value		mac_info;
	struct vlan_info_value		vlan_info;
	struct as_info_value		as_info;
	struct ifindex_info_value	ifindex_info;
	struct multicast_info_value	multicast_info;
	struct nexthop_info_value	nexthop_info;
} __attribute__((packed));

struct	attribute {
	u_short			id;
	union attribute_value	value;
} __attribute__((packed));

class Flow {

	private:
		u_char			totalSlots;
					
		struct attribute	*list;

		const int	grow_list(u_char size=0);
		void		lock();
		void		unlock();

	protected:
		void	init();

	public:
		u_char			ds_id;
		u_char			freeSlot;

		Flow();
		Flow(u_char instance, const u_char, const struct attribute * = NULL);
		~Flow();
		void* put(const u_char, const union attribute_value *attr=NULL);
		const union attribute_value *get(const u_char);
		const int contains(const u_char);
		const unsigned int elements();
		void removeAll();
		void reuse();
		void copy(Flow *src);
#ifdef DEBUG
		void Debug(u_char debug_type);
#endif
		const int index(const u_char);
} __attribute__((packed));

#endif
