#!/usr/bin/perl
#
# $Id: snmp2netams.pl,v 1.2 2006-05-09 11:59:58 anton Exp $
# This script will poll a specified Cisco device(s) using SNMP protocol.
# Interface counters will be send to NeTAMS ds_raw data-source service.
# This script requires net-snmp with Perl support installed, and Net::Telnet module
#
# snmp2netams.pl is a part of NeTAMS project, see http://www.netams.com
# (c) 2006 Anton Vinokurov
#
# --- configuration parameters, you need to change them -------------------- 
#

@devices=("catalyst"); # array of Cisco routers/switches host names
$community="public"; # read-only community

$netams_host="localhost"; # NeTAMS connection parameters
$netams_port=20001;
$netams_login="admin";
$netams_password="aaa";

$policy_name="ip"; #accounting policy name forwarded to ds_raw

#
# --- you don't need to modify anyting below this line ---------------------
#
use SNMP;
use Net::Telnet;

$session = new Net::Telnet(Host => $netams_host, Port => $netams_port, Errmode => "return", Timeout => 3);
$ok = $session->login($netams_login, $netams_password);
if ($ok != 1) { die("NeTAMS connect failed: ".$session->errmsg."\n"); }

foreach $device (@devices){
	$sess = new SNMP::Session(DestHost => $device, Community => $community, Version => 2);
	$numInts = $sess->get('ifNumber.0');
	#print "device: $device, sess: $sess, numints: $numInts\n";
	($name, $in, $out) = $sess->bulkwalk(0, $numInts+1, [['ifName'], ['ifHCInOctets'],['ifHCOutOctets']]);

	for $i (0..($numInts-1)) {
		if (defined $$in[$i]) {
			#printf "Interface %4s[%d]: %s inOctets, %s outOctets\n", $$name[$i]->val, $i, $$in[$i]->val, $$out[$i]->val;
			$str= "rawdata unit name $device-".$$name[$i]->val." policy $policy_name in ".$$in[$i]->val." out ".$$out[$i]->val." incremental\n";
			@res=$session->cmd($str);
			#foreach $a (@res) { print $a; }
			}
		}
	
	}

$session->cmd("exit");
