/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: cli.c,v 1.80 2008-02-23 08:35:02 anton Exp $ */

#include "netams.h"

struct cli_def *CLI;
/////////////////////////////////////////////////////////////////////////////////////////
const struct CMD_DB no_cmd = 
{ 1, 0, 0, "no",        PRIVILEGE_UNPRIVILEGED, MODE_ANY, NULL, "Negate a command or set its defaults" };

static const struct CMD_DB cmd_db[] = {
{ 2, 0, 0, "show",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL, 		"shows various system parameters" },
{ 0, 2, 0, "users", 	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowUsers, 		"users list" },
{ 0, 2, 0, "units",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowUnits,		"units list" },
{ 0, 2, 0, "processor",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowProcessor,	"processor service status" },
{ 0, 2, 0, "version",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowVersion,	"software version and current status" },
{ 0, 2, 0, "policy",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowPolicy,		"policy list" },

{ 3, 2, 0, "config", 	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowConfig,		"running configuration" },
{ 0, 3, 0, "unsecure",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowConfig,		NULL },
{ 0, 3, 0, "oids",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowConfig,		NULL },
{ 0, 3, 0, "billing",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowConfig,		NULL },
{ 0, 3, 0, "brief",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowConfig,		"show config without NetUnits" },

{ 0, 2, 0, "perfomance",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowPerf,		"system perfomance" },
{ 14, 2, 0, "list",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowUnitsList,	"NetUnits list with applied policy list" },
{ 0, 14, 0, "full",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowUnitsList,	NULL },
{ 0, 2, 0, "memory", 	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowDebugMemory,	NULL },
{ 0, 2, 0, "mutex",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowDebugMutex,	NULL },
{ 0, 2, 0, "health",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cShowSystemHealth,	NULL },
	
{ 0, 0, 0, "save",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cSave,		"write the running config to a file" },
{ 0, 0, 1, "autosave",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cAutoSave,		"enable autosave function" },
{ 0, 0, 0, "autosave-run",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cAutoSaveRun,		"execute autosave function" },
{ 0, 0, 1, "debug", 	PRIVILEGE_UNPRIVILEGED, MODE_ANY, cDebug,		"turning on or off debugging on some action" },
{ 0, 0, 1, "schedule",	PRIVILEGE_UNPRIVILEGED, MODE_ANY, cSchedule,			NULL },

{ 4, 0, 0, "rotate",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL, 		"rotate files and logs" },
{ 0, 4, 0, "log",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cRotate,		NULL },

{ 0, 0, 0, "language",  PRIVILEGE_UNPRIVILEGED, MODE_CONFIG, cLang,		NULL },
{ 0, 0, 1, "user",	PRIVILEGE_UNPRIVILEGED, MODE_CONFIG, cUser,		"users management" },
{ 0, 0, 0, "load",	PRIVILEGE_UNPRIVILEGED, MODE_CONFIG, cLoad,		"load config from file" },
{ 0, 0, 0, "include",	PRIVILEGE_UNPRIVILEGED, MODE_CONFIG, cLoad,		"load config from file" },
{ 0, 0, 0, "shutdown",  PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cTermination,	"gracefully shut down the daemon" },
{ 0, 0, 0, "reload", 	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cTermination,	"gracefully reload the daemon" },
{ 0, 0, 0, "kill", 	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cTermination,	"kill the daemon very quickly, with last data loss" },

{ 0, 0, 0, "html",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cHtml,		NULL },

{ 5, 0, 0, "radius", 	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL,		NULL },
{ 0, 5, 0, "auth",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cRadius,		NULL },
{ 0, 5, 0, "acct",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cRadius,		NULL },
	
{ 6, 0, 0, "mac",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL,		NULL },
{ 0, 6, 0, "control",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cMac,		NULL },
{ 0, 6, 0, "fixate", 	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cMac,		NULL },

{ 44, 0, 0, "rawdata", 	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL,		NULL },
{ 0, 44, 0, "unit",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cRawData,		NULL },
{ 0, 44, 0, "policy",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cRawData,		NULL },
{ 0, 44, 0, "in",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cRawData,		NULL },
{ 0, 44, 0, "out",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cRawData,		NULL },
{ 0, 44, 0, "as-is",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cRawData,		NULL },
{ 0, 44, 0, "incremental",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cRawData,		NULL },

//HTML
{ 0, 0, 0, "path",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 0, 0, "url",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 0, 0, "servlet-url", PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,	NULL },
{ 0, 0, 0, "run",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 16, 0, 0, "htaccess", PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 16, 0, "yes",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 16, 0, "no",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 16, 0, "radius",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 17, 0, 0, "graphs",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 17, 0, "yes",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 17, 0, "no",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 18, 0, 0, "client-pages", PRIVILEGE_UNPRIVILEGED, MODE_HTML, NULL,			NULL },
{ 0, 18, 0, "all",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 18, 0, "groups",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 18, 0, "group",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 18, 0, "none",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 19, 0, 0, "account-pages", PRIVILEGE_UNPRIVILEGED, MODE_HTML, NULL,			NULL },
{ 0, 19, 0, "all",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 19, 0, "none",	PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,		NULL },
{ 0, 0, 0, "display-top", PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceProcessCfg,	NULL },
{ 0, 0, 0, "start",     PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceStart,               NULL },
{ 0, 0, 0, "stop",      PRIVILEGE_UNPRIVILEGED, MODE_HTML, cServiceStop,                NULL },
//PROCESSOR
{ 0, 0, 0, "lookup-delay", PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 0, 0, "flow-lifetime", PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 0, 0, "access-script", PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg, NULL },
{ 0, 0, 1, "auto-assign", PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 33, 0, 1, "auto-units", PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 34, 33, 0, "type", 	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, NULL,			NULL },
{ 0, 34, 0, "host",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 34, 0, "user",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 35, 33, 0, "naming",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, NULL,			NULL },
{ 36, 35, 0, "by-dns",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 36, 0, "prefix1",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 36, 0, "prefix2",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 33, 0, "group", 	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 37, 0, 1, "default",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, NULL, 			NULL },
{ 0, 37, 37, "acct-policy", PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 37, 37, "fw-policy", PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 38, 0, 0, "restrict",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, NULL,			NULL },
{ 39, 38, 0, "all",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, NULL,			NULL },
{ 0, 39, 0, "drop",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 39, 0, "pass", 	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 40, 38, 0, "local",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, NULL,			NULL },
{ 0, 40, 0, "drop",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 40, 0, "pass",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 41, 0, 1, "unit",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, NULL,			NULL },
{ 0, 41, 41, "host",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 41, 41, "user",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 41, 41, "net",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 41, 41, "group",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 41, 41, "cluster",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 42, 0, 1, "policy", 	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, NULL,			NULL },
{ 0, 42, 42, "oid",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 42, 42, "name",	PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceProcessCfg,	NULL },
{ 0, 0, 0, "start",     PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceStart,          NULL },
{ 0, 0, 0, "stop",      PRIVILEGE_UNPRIVILEGED, MODE_PROCESSOR, cServiceStop,           NULL },
{ 45, 0, 1, "enable",	PRIVILEGE_PRIVILEGED, MODE_CONFIG, NULL, 			NULL },
{ 0, 45, 45, "password", PRIVILEGE_PRIVILEGED, MODE_CONFIG, cEnable,		NULL },
{ 0, 45, 45, "crypted", PRIVILEGE_PRIVILEGED, MODE_CONFIG, cEnable,		NULL },
//PAM
{ 46, 0, 0, "pam", 	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL,		NULL },
{ 47, 46, 0, "auth",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cPam,		NULL },
{ 48, 46, 0, "acct",	PRIVILEGE_UNPRIVILEGED, MODE_EXEC, cPam,		NULL },


//last num 48
{ -1, 0, 0, NULL,  0, 0, NULL, NULL }
};
/////////////////////////////////////////////////////////////////////////////////////////
void aInitCli() {
	CLI = cli_init();
	cli_set_privilege(CLI, PRIVILEGE_PRIVILEGED);
	InitCliCommands(cmd_db);
}

void aReleaseCli() {
	cli_done(CLI);
}
/////////////////////////////////////////////////////////////////////////////////////////
void InitCliCommands(const struct CMD_DB *cmddb) {
	struct cli_def *cli = CLI;	
	struct cli_command *cmd;
	struct cli_command **idx=NULL;
	struct cli_command **noidx=NULL;
	const struct CMD_DB *cdb;

	//allocate just enough
	u_short max_idx=100;

	idx=(cli_command**)calloc(max_idx, sizeof(cli_command*));
	noidx=(cli_command**)calloc(max_idx, sizeof(cli_command*));

	//register "no"
	cdb=&no_cmd;
	noidx[1] = cli_register_command(cli, NULL, cdb->command, cdb->callback, cdb->priv, cdb->mode, cdb->help);

	for(unsigned i=0; cmddb[i].id >= 0; i++) {
		cdb=&cmddb[i];
		cmd =  cli_register_command(cli, cdb->pid?idx[cdb->pid]:NULL, cdb->command, cdb->callback, cdb->priv, cdb->mode, cdb->help);	
		idx[cdb->id] = cmd;
		
		//register with "no" prefix
		if(cdb->no_pid)  {
			cmd = cli_register_command(cli, noidx[cdb->no_pid], cdb->command, cdb->callback, cdb->priv, cdb->mode, cdb->help);
			if(cdb->id) noidx[cdb->id] = cmd;
		}
	}

	free(idx);
	free(noidx);
}
/////////////////////////////////////////////////////////////////////////////////////////
