/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: lang.c,v 1.12 2009-08-01 09:23:55 anton Exp $ */

#include "netams.h"
//////////////////////////////////////////////////////////////////////////////////////////
const char *language_str[LANGUAGES_DEFINED]= { "en", "ru" };
const char *language_charset_str[LANGUAGES_DEFINED]= { "en", "windows-1251" };

//////////////////////////////////////////////////////////////////////////////////////////
int cLang(struct cli_def *cli, const char *cmd, char **argv, int argc){
	if(argc==1) return CLI_ERROR;

	for (u_char i=0; i<LANGUAGES_DEFINED; i++){
		if (STREQ(argv[1], language_str[i])) {
			lang=(language)i;
			cli_error(cli, "output language is %s", language_str[i]);
			if (is_running) gettimeofday(&when_config_changed, NULL);
			return CLI_OK;
		}
	}
	cli_error(cli, "output language %s unsupported\n", argv[1]);
	return CLI_OK;
}
//////////////////////////////////////////////////////////////////////////////////////////
const char *Locale(unsigned key, int force_english){
	locale_item *i = &locale_data[key];
	
	const char *res;
	if (force_english) res=i->data[LANG_EN]; 
	else res=i->data[lang];
	
	if (res) return res; else {
		aLog(D_WARN, "Localization problem, lang=%s, key=%u\n", language_str[lang], key);
		return "<\?\?\?>";
	}
}
//////////////////////////////////////////////////////////////////////////////////////////
locale_item locale_data[] = {
	{ LC_H_TRAFINFO, {
		"Traffic information from %02d.%02d.%04d %02d:00 to %02d.%02d.%04d %02d:00", 
		"    %02d.%02d.%04d %02d:00  %02d.%02d.%04d %02d:00" }, },
	{ LC_H_RUNTIME, { 
		"Runtime information page", 
		"   " }, },
	{ LC_H_TIMEDERIVED, { 
		"Time period-derived statistics for", 
		"    , " }, },
	{ LC_H_OBJSTAT, { 
		"Objects statistics", 
		"  " }, },
	{ LC_H_GROUPS, { 
		"Groups", 
		"" }, },
	{ LC_H_UNITS, { 
		"Units", 
		"" }, },
	{ LC_H_SYSTAT, { 
		"System status", 
		" " }, },
	{ LC_H_SYSTAT_LOAD, { 
		"Current system load", 
		"  " }, },
	{ LC_H_SYSTAT_HTML_ST, { 
		"HTML files folder free disk space", 
		"   ,   HTML-" }, },
	{ LC_H_SYSTAT_PRI_ST, { 
		"primary storage folder free disk space", 
		"   ,    " }, },
	{ LC_H_SYSTAT_WRONG, { 
		"WARNING! Your system is in wrong state!", 
		"!      !" }, },
	{ LC_H_TOPUSERS, { 
		"Top network users", 
		"   " }, },
	{ LC_H_TOPUSERS_STR, { 
		"top users for this <A href=\"top.html\">hour</a>, <A href=\"../top.html\">day</a>, <A href=\"../top-week.html\">week</a> and <A href=\"../../top.html\">month</a>", 
		"     <A href=\"top.html\"></a>, <A href=\"../top.html\"></a>, <A href=\"../top-week.html\"></a>  <A href=\"../../top.html\"></a>" }, },
	{ LC_H_SERVICES, { 
		"Status of services", 
		"  " }, },
	{ LC_H_SERV_OUTPUTOF, { 
		"Output of", 
		" " }, },
	{ LC_H_SERV_STATE, { 
		"State of", 
		"" }, },
	{ LC_H_SERV_QUOTA, { 
		"quota service", 
		" " }, },
	{ LC_H_SERV_LOGIN, { 
		"login service", 
		" " }, },
	{ LC_H_SERV_BILLING, { 
		"billing service", 
		" " }, },
	{ LC_H_SW_VERSION, { 
		"Software version", 
		" " }, },
	{ LC_H_REPORT, { 
		"This is the automatic report built by", 
		"  " }, },
	{ LC_H_CR_TIME, { 
		"Time of creation", 
		" " }, },
	{ LC_H_BACK, { 
		"back", 
		"" }, },
	{ LC_H_THIS_MONTH, { 
		"This month", 
		" " }, },
	{ LC_H_THIS_DAY, { 
		"This day", 
		" " }, },
	{ LC_H_RUNNING_CONFIG, { 
		"Running config", 
		" " }, },
	{ LC_H_CURRENT, { 
		"for current", 
		" " }, },
	{ LC_H_CURRENT2, { 
		"for current", 
		" " }, },
	{ LC_H_CHOUR, { 
		"HOUR", 
		"" }, },
	{ LC_H_CDAY, { 
		"DAY", 
		"" }, },
	{ LC_H_CWEEK, { 
		"WEEK", 
		"" }, },
	{ LC_H_CWEEK2, { 
		"WEEK", 
		"" }, },
	{ LC_H_CMONTH, { 
		"MONTH", 
		"" }, },
	{ LC_H_INDEX_MONTH, { 
		"Index pages for month", 
		"  " }, },
	{ LC_H_TRAFINFO_SELECTED, { 
		"Traffic information for selected unit", 
		"     " }, },
	{ LC_H_CALENDAR, {
		"Calendar", 
		"" }, },
	{ LC_H_TRAFINFO_FOR, {
		"Traffic statistics for", 
		"   " }, },
	{ LC_H_TRAFINFO_ACTUAL, {
		"actual for creation time ONLY!", 
		"    !" }, },
	{ LC_H_ALL_ZERO, {
		"all counter values are zero", 
		"    " }, },
	{ LC_H_ACCT_POLICY, {
		"accounting policy", 
		" " }, },
	{ LC_H_IN, {
		" in", 
		"" }, },
	{ LC_H_OUT, {
		"out", 
		"" }, },
	{ LC_H_TYPE, {
		"TYPE", 
		"" }, },
	{ LC_H_NAME, {
		"NAME", 
		"" }, },
	{ LC_H_DESCR, {
		"DESCRIPTION", 
		"" }, },
	{ LC_H_IP, {
		"IP", 
		"IP-" }, },
	{ LC_H_POLICY, {
		"POLICY", 
		"" }, },
	{ LC_H_PREINCLUDED_LEFT, {
		"Preincluded traffic left for", 
		"   " }, },
	{ LC_H_SUBPLAN_ID, {
		"subplan-id", 
		" " }, },
	{ LC_H_B_ACNAME, {
		"Account name", 
		" " }, },
	{ LC_H_B_BALANCE, {
		"Balance", 
		"" }, }, 
	{ LC_H_B_STATUS, {
		"Status", 
		"" }, }, 
	{ LC_H_B_PLAN, {
		"Plan", 
		" " }, }, 
	{ LC_H_B_UNITS, {
		"Units", 
		"" }, }, 
	{ LC_H_B_BLOCKED, {
		"BLOCKED", 
		"" }, }, 
	{ LC_H_B_BEBLOCKED, {
		"BEBLOCKED", 
		" " }, }, 
	{ LC_H_B_UNBLOCKED, {
		"UNBLOCKED", 
		"" }, }, 
	{ LC_H_B_BALANCE_FOR, {
		"Balance for selected account", 
		"" }, }, 
/*	{ , {
		"", 
		"" }, }, 
	{ , {
		"", 
		"" }, }, 
	{ , {
		"", 
		"" }, }, 
	{ , {
		"", 
		"" }, }, 
*/		
};

	

